/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense;

import com.dooji.craftsense.CraftSense;
import com.dooji.craftsense.CraftSenseKeyBindings;
import com.dooji.craftsense.manager.CategoryGenerator;
import com.dooji.craftsense.manager.ConfigurationManager;
import com.dooji.craftsense.manager.CraftSenseTracker;
import com.dooji.craftsense.network.CraftSenseClientNetworking;
import com.dooji.craftsense.omnilib.OmniButton;
import com.dooji.craftsense.omnilib.OmniToast;
import com.dooji.craftsense.omnilib.OmniTooltip;
import com.dooji.craftsense.ui.CraftSenseStatsScreen;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class CraftSenseClient
implements ClientModInitializer {
    private static boolean hasEnteredWorld = false;

    public void onInitializeClient() {
        CraftSenseKeyBindings.register();
        CategoryGenerator.generateCategories();
        CraftSenseClientNetworking.init();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ConfigurationManager configManager;
            if (client.field_1724 != null && !hasEnteredWorld) {
                hasEnteredWorld = true;
                configManager = CraftSense.configManager;
                CraftSenseTracker.checkPlayerConditions();
                if (configManager.isFirstTime()) {
                    String toggleKeyText = CraftSenseKeyBindings.toggleKey.method_16007().getString();
                    CraftSenseClient.createToast("Welcome to CraftSense", "Toggle CraftSense with " + toggleKeyText);
                }
            }
            while (CraftSenseKeyBindings.toggleKey.method_1436()) {
                configManager = CraftSense.configManager;
                configManager.toggleEnabled();
                boolean enabled = configManager.isEnabled();
                CraftSenseClient.createToast("CraftSense " + (enabled ? "Enabled" : "Disabled"), "CraftSense has been " + (enabled ? "enabled" : "disabled"));
                client.field_1724.method_5783(enabled ? class_3417.field_14962 : class_3417.field_15105, 1.0f, 1.0f);
            }
            while (CraftSenseKeyBindings.openStatsKey.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)new CraftSenseStatsScreen());
            }
        });
    }

    public static void createToast(String titleKey, String messageKey) {
        class_5250 title = class_2561.method_43471((String)titleKey);
        class_5250 description = class_2561.method_43471((String)messageKey);
        class_2960 iconTexture = CraftSense.configManager.isEnabled() ? class_2960.method_43902((String)"minecraft", (String)"textures/block/redstone_lamp_on.png") : class_2960.method_43902((String)"minecraft", (String)"textures/block/redstone_lamp.png");
        CraftSenseClient.showToast((class_2561)title, (class_2561)description, 5000L, 0xFFFFFF, 0xAAAAAA, null, iconTexture, null, 16, 170, 32);
    }

    public static void showTooltip(class_4587 matrices, class_327 textRenderer, String categoryTitle, List<class_1799> itemStacks, List<class_2561> textList, int backgroundColor, class_2960 backgroundTexture, int textColor, class_2960 customTexture, int x, int y) {
        OmniTooltip tooltip = new OmniTooltip(categoryTitle, itemStacks, textList, 16, 8, 4, backgroundColor, backgroundTexture, textColor, customTexture, 16, 16);
        tooltip.render(matrices, textRenderer, x, y);
    }

    public static void showToast(class_2561 title, class_2561 description, long duration, int titleColor, int descriptionColor, class_2960 backgroundTexture, class_2960 iconTexture, class_1799 iconItemStack, int iconSize, int textureWidth, int textureHeight) {
        OmniToast toast = new OmniToast(title, description, duration, titleColor, descriptionColor, backgroundTexture, iconTexture, iconItemStack, iconSize, textureWidth, textureHeight);
        class_310.method_1551().method_1566().method_1999((class_368)toast);
    }

    public static OmniButton createOmniButton(int x, int y, int width, int height, class_2561 message, int color, int hoverColor, int textColor, int textHoverColor, Runnable onPress) {
        return new OmniButton(x, y, width, height, message, color, hoverColor, textColor, textHoverColor, onPress);
    }
}

