/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense;

import com.dooji.craftsense.CraftSense;
import com.dooji.craftsense.manager.CategoryHabitsTracker;
import com.dooji.craftsense.manager.CategoryManager;
import com.dooji.craftsense.manager.CraftSenseTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CraftingPredictor {
    private static CraftingPredictor instance;
    private final class_1863 recipeManager;
    private final CategoryHabitsTracker habitsConfig;
    private final Map<String, Optional<class_3955>> recipeCache = new HashMap<String, Optional<class_3955>>();

    public CraftingPredictor(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
        this.habitsConfig = CategoryHabitsTracker.getInstance();
    }

    public static CraftingPredictor getInstance(class_1863 recipeManager) {
        if (instance == null || CraftingPredictor.instance.recipeManager != recipeManager) {
            instance = new CraftingPredictor(recipeManager);
        }
        return instance;
    }

    public List<class_1799> getAvailableItems(class_1661 playerInventory, class_1799 cursorStack, class_1715 craftingGrid) {
        ArrayList<class_1799> availableItems = new ArrayList<class_1799>((Collection<class_1799>)playerInventory.field_7547);
        if (!cursorStack.method_7960()) {
            availableItems.add(cursorStack.method_7972());
        }
        for (int i = 0; i < craftingGrid.method_5439(); ++i) {
            class_1799 stack = craftingGrid.method_5438(i);
            if (stack.method_7960()) continue;
            availableItems.add(stack.method_7972());
        }
        return availableItems;
    }

    private boolean isGridEmpty(class_1715 input) {
        for (int i = 0; i < input.method_5439(); ++i) {
            if (input.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private List<class_1799> copyItemStacks(List<class_1799> original) {
        ArrayList<class_1799> copy = new ArrayList<class_1799>();
        for (class_1799 stack : original) {
            copy.add(stack.method_7972());
        }
        return copy;
    }

    private boolean decrementAvailableItemCount(List<class_1799> availableItems, class_1799 itemToMatch) {
        for (class_1799 stack : availableItems) {
            if (!this.itemsAndComponentsMatch(stack, itemToMatch) || stack.method_7947() <= 0) continue;
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    private boolean itemsAndComponentsMatch(class_1799 stack, class_1799 itemToMatch) {
        if (!class_1799.method_7987((class_1799)stack, (class_1799)itemToMatch)) {
            return false;
        }
        if (stack.method_7985() && itemToMatch.method_7985()) {
            return Objects.equals(stack.method_7969(), itemToMatch.method_7969());
        }
        return !stack.method_7985() && !itemToMatch.method_7985();
    }

    public Optional<class_3955> suggestRecipe(class_1715 input, class_1661 playerInventory, class_1799 cursorStack, class_1937 world) {
        if (!CraftSense.configManager.isEnabled() || this.isGridEmpty(input) || this.recipeManager.method_8132(class_3956.field_17545, (class_1263)input, world).isPresent()) {
            return Optional.empty();
        }
        String inputHash = this.calculateInputHash(input, playerInventory, cursorStack);
        if (this.recipeCache.containsKey(inputHash)) {
            return this.recipeCache.get(inputHash);
        }
        List recipes = this.recipeManager.method_30027(class_3956.field_17545);
        class_3955 bestRecipe = null;
        int bestScore = -1;
        String bestCategory = null;
        int highestCategoryCount = -1;
        for (Map.Entry<String, Integer> entry : this.habitsConfig.categoryCraftCount.entrySet()) {
            if (entry.getValue() <= highestCategoryCount) continue;
            bestCategory = entry.getKey();
            highestCategoryCount = entry.getValue();
        }
        String mostCraftedItem = null;
        int highestItemCount = -1;
        for (Map.Entry<String, Integer> entry : this.habitsConfig.itemCraftCount.entrySet()) {
            int itemCount;
            String itemName = entry.getKey();
            if (!CategoryManager.getCategory((class_1792)class_2378.field_11142.method_10223(new class_2960(itemName))).equals(bestCategory) || (itemCount = entry.getValue().intValue()) <= highestItemCount) continue;
            mostCraftedItem = itemName;
            highestItemCount = itemCount;
        }
        List<class_1799> availableItems = this.getAvailableItems(playerInventory, cursorStack, input);
        List<class_3955> filteredRecipes = recipes.stream().filter(recipe -> this.hasRequiredIngredients((class_3955)recipe, availableItems)).toList();
        for (class_3955 recipe2 : filteredRecipes) {
            String category = CategoryManager.getCategory(recipe2.method_8110().method_7909());
            String itemName = recipe2.method_8110().method_7922();
            int score = this.calculateMatchScore(recipe2, input, playerInventory, cursorStack);
            if (score <= 0) continue;
            if (category.equals(bestCategory)) {
                int itemCount = this.habitsConfig.getItemCraftCount(itemName);
                int categoryCount = this.habitsConfig.getCraftCount(category);
                score = itemName.equals(mostCraftedItem) ? (score += itemCount * 5 + categoryCount * 2) : (score += itemCount * 3 + categoryCount * 2);
            } else {
                ++score;
            }
            if (score <= bestScore) continue;
            bestScore = score;
            bestRecipe = recipe2;
        }
        if (bestRecipe != null && CategoryManager.getCategory(bestRecipe.method_8110().method_7909()).equals("TOOL")) {
            Optional<class_3955> combatRecipe;
            boolean hasWeapon = this.playerInventoryContainsWeapon(playerInventory);
            if (CraftSenseTracker.isPrioritizingCombatItems() && !hasWeapon && (combatRecipe = this.suggestCombatRecipe(filteredRecipes, input, playerInventory, cursorStack, world)).isPresent()) {
                this.recipeCache.put(inputHash, combatRecipe);
                return combatRecipe;
            }
        }
        Optional<class_3955> result = bestRecipe != null ? Optional.of(bestRecipe) : Optional.empty();
        this.recipeCache.put(inputHash, result);
        return result;
    }

    public boolean hasRequiredIngredients(class_3955 recipe, List<class_1799> availableItems) {
        List<class_1799> tempAvailableItems = this.copyItemStacks(availableItems);
        for (class_1856 ingredient : recipe.method_8117()) {
            if (ingredient.method_8103()) continue;
            boolean found = false;
            for (class_1799 matchingStack : ingredient.method_8105()) {
                if (!this.decrementAvailableItemCount(tempAvailableItems, matchingStack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private int calculateMatchScore(class_3955 recipe, class_1715 input, class_1661 playerInventory, class_1799 cursorStack) {
        int score = -1;
        ArrayList<class_1799> availableItems = new ArrayList<class_1799>();
        for (class_1799 stack : playerInventory.field_7547) {
            availableItems.add(stack.method_7972());
        }
        if (!cursorStack.method_7960()) {
            availableItems.add(cursorStack.method_7972());
        }
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            int recipeWidth = shapedRecipe.method_8150();
            int recipeHeight = shapedRecipe.method_8158();
            int maxOffsetX = 3 - recipeWidth;
            int maxOffsetY = 3 - recipeHeight;
            for (int offsetX = 0; offsetX <= maxOffsetX; ++offsetX) {
                for (int offsetY = 0; offsetY <= maxOffsetY; ++offsetY) {
                    class_3545<Integer, Boolean> matchResult = this.matchShapedRecipe(shapedRecipe, input, this.getAvailableItems(playerInventory, cursorStack, input), offsetX, offsetY);
                    int alignmentScore = (Integer)matchResult.method_15442();
                    if (alignmentScore <= score || (score = alignmentScore) != Integer.MAX_VALUE) continue;
                    return score;
                }
            }
        } else {
            int alignmentScore = this.matchShapelessRecipe(recipe, input, availableItems);
            if (alignmentScore > score) {
                score = alignmentScore;
            }
        }
        return score;
    }

    public String calculateInputHash(class_1715 input, class_1661 playerInventory, class_1799 cursorStack) {
        StringBuilder hashBuilder = new StringBuilder();
        for (int i = 0; i < input.method_5439(); ++i) {
            class_1799 stack = input.method_5438(i);
            hashBuilder.append((String)(stack.method_7960() ? "-" : stack.method_7922() + ":" + stack.method_7947())).append(",");
        }
        for (class_1799 stack : playerInventory.field_7547) {
            hashBuilder.append((String)(stack.method_7960() ? "-" : stack.method_7922() + ":" + stack.method_7947())).append(",");
        }
        if (!cursorStack.method_7960()) {
            hashBuilder.append(cursorStack.method_7922()).append(":").append(cursorStack.method_7947());
        }
        return hashBuilder.toString();
    }

    public class_3545<Integer, Boolean> matchShapedRecipe(class_1869 recipe, class_1715 input, List<class_1799> availableItems, int offsetX, int offsetY) {
        int bestScore = -1;
        boolean bestMirrored = false;
        for (boolean mirrored : new boolean[]{false, true}) {
            int score = 0;
            List<class_1799> tempAvailableItems = this.copyItemStacks(availableItems);
            int recipeWidth = recipe.method_8150();
            int recipeHeight = recipe.method_8158();
            class_2371 ingredients = recipe.method_8117();
            boolean mismatch = false;
            for (int gridY = 0; gridY < 3; ++gridY) {
                for (int gridX = 0; gridX < 3; ++gridX) {
                    boolean isWithinRecipe;
                    int gridIndex = gridY * 3 + gridX;
                    class_1799 placedItem = input.method_5438(gridIndex);
                    boolean bl = isWithinRecipe = gridX >= offsetX && gridX < offsetX + recipeWidth && gridY >= offsetY && gridY < offsetY + recipeHeight;
                    if (isWithinRecipe || placedItem.method_7960()) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) break;
            }
            if (mismatch) continue;
            for (int recipeY = 0; recipeY < recipeHeight; ++recipeY) {
                for (int recipeX = 0; recipeX < recipeWidth; ++recipeX) {
                    int index = recipeY * recipeWidth + recipeX;
                    class_1856 ingredient2 = (class_1856)ingredients.get(mirrored ? recipeWidth - recipeX - 1 + recipeY * recipeWidth : index);
                    int gridX = offsetX + recipeX;
                    int gridY = offsetY + recipeY;
                    int gridIndex = gridY * 3 + gridX;
                    class_1799 placedItem = input.method_5438(gridIndex);
                    if (ingredient2.method_8103()) {
                        if (placedItem.method_7960()) continue;
                        mismatch = true;
                        break;
                    }
                    if (!placedItem.method_7960()) {
                        if (ingredient2.method_8093(placedItem)) {
                            score += 2;
                            this.decrementAvailableItemCount(tempAvailableItems, placedItem);
                            continue;
                        }
                        mismatch = true;
                        break;
                    }
                    boolean found = false;
                    for (class_1799 matchingStack : ingredient2.method_8105()) {
                        if (!this.decrementAvailableItemCount(tempAvailableItems, matchingStack)) continue;
                        ++score;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) break;
            }
            if (mismatch) continue;
            long nonEmptyIngredientCount = ingredients.stream().filter(ingredient -> !ingredient.method_8103()).count();
            if ((long)score == nonEmptyIngredientCount * 2L) {
                return new class_3545((Object)Integer.MAX_VALUE, (Object)mirrored);
            }
            if (score <= bestScore) continue;
            bestScore = score;
            bestMirrored = mirrored;
        }
        return new class_3545((Object)bestScore, (Object)bestMirrored);
    }

    private int matchShapelessRecipe(class_3955 recipe, class_1715 input, List<class_1799> availableItems) {
        int score = 0;
        List<class_1799> tempAvailableItems = this.copyItemStacks(availableItems);
        class_2371 ingredients = recipe.method_8117();
        ArrayList ingredientsToMatch = new ArrayList(ingredients);
        for (int i = 0; i < input.method_5439(); ++i) {
            class_1799 placedItem = input.method_5438(i);
            if (placedItem.method_7960()) continue;
            boolean matched = false;
            Iterator iterator = ingredientsToMatch.iterator();
            while (iterator.hasNext()) {
                class_1856 ingredient = (class_1856)iterator.next();
                if (!ingredient.method_8093(placedItem)) continue;
                score += 2;
                iterator.remove();
                this.decrementAvailableItemCount(tempAvailableItems, placedItem);
                matched = true;
                break;
            }
            if (matched) continue;
            return -1;
        }
        for (class_1856 ingredient : ingredientsToMatch) {
            boolean found = false;
            for (class_1799 matchingStack : ingredient.method_8105()) {
                if (!this.decrementAvailableItemCount(tempAvailableItems, matchingStack)) continue;
                ++score;
                found = true;
                break;
            }
            if (found) continue;
            return -1;
        }
        if (score == recipe.method_8117().size() * 2) {
            return Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean playerInventoryContainsWeapon(class_1661 playerInventory) {
        for (class_1799 stack : playerInventory.field_7547) {
            if (stack.method_7960() || !stack.method_7909().method_7876().toUpperCase().contains("SWORD") && !stack.method_7909().method_7876().toUpperCase().contains("_AXE")) continue;
            return true;
        }
        return false;
    }

    private Optional<class_3955> suggestCombatRecipe(List<class_3955> recipes, class_1715 input, class_1661 playerInventory, class_1799 cursorStack, class_1937 world) {
        for (class_3955 recipe : recipes) {
            int score;
            class_1799 resultStack = recipe.method_8116((class_1263)input);
            String resultName = resultStack.method_7922().toUpperCase();
            if (!resultName.contains("SWORD") && !resultName.contains("_AXE") && !resultName.contains("SHIELD") || (score = this.calculateMatchScore(recipe, input, playerInventory, cursorStack)) <= 0) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public Optional<class_3955> suggestLastCraftedItem(class_1715 input, class_1661 playerInventory, class_1799 cursorStack, class_1937 world) {
        String lastCraftedItem = CategoryHabitsTracker.getInstance().getLastCraftedItem();
        if (lastCraftedItem == null || !this.isGridEmpty(input)) {
            return Optional.empty();
        }
        List recipes = this.recipeManager.method_30027(class_3956.field_17545);
        for (class_3955 recipe : recipes) {
            int score;
            class_1799 result = recipe.method_8110();
            String resultTranslationKey = result.method_7922();
            if (!resultTranslationKey.equals(lastCraftedItem) || (score = this.calculateMatchScore(recipe, input, playerInventory, cursorStack)) <= 0) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }
}

