/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryGenerator {
    public static final String MOD_ID = "craftsense";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"craftsense");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CATEGORIES_PATH = Path.of("config/CraftSense/categories.json", new String[0]);
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[_\\s]+");
    private static final double POSITION_THRESHOLD = 0.5;
    private static final List<String> UNCOUNTABLE = Arrays.asList("WOOL", "DIRT", "SAND", "WATER", "MILK", "LAVA", "FLESH", "ICE");
    private static final double DYNAMIC_BONUS = 0.1;

    public static void generateCategories() {
        ArrayList<ItemData> items = new ArrayList<ItemData>();
        for (Object item : class_2378.field_11142) {
            ArrayList<String> tokens;
            class_2960 itemId = class_2378.field_11142.method_10221(item);
            String itemName = itemId.method_12832().toUpperCase();
            if (itemName.equals("AIR")) continue;
            if (itemName.startsWith("MUSIC_DISC") || itemName.startsWith("DISC_")) {
                tokens = new ArrayList<String>();
                tokens.add("MUSIC_DISC");
            } else {
                tokens = Arrays.stream(SPLIT_PATTERN.split(itemName)).filter(s -> s.length() > 2).collect(Collectors.toList());
            }
            items.add(new ItemData(itemName, tokens));
        }
        HashMap<String, GlobalStat> globalStats = new HashMap<String, GlobalStat>();
        for (ItemData item : items) {
            item.generateNGrams();
            for (NGramCandidate ng : item.ngrams) {
                globalStats.computeIfAbsent(ng.phrase, k -> new GlobalStat()).add(ng.normalizedPosition);
            }
        }
        double maxCount = globalStats.values().stream().mapToDouble(gs -> gs.count).max().orElse(1.0);
        HashMap<String, String> itemCategoryMap = new HashMap<String, String>();
        Map<String, List<String>> existingCategories = CategoryGenerator.loadExistingCategories();
        List knownCategories = existingCategories.keySet().stream().map(String::toUpperCase).collect(Collectors.toList());
        for (ItemData item : items) {
            NGramCandidate bestCandidate = null;
            double bestScore = -1.0;
            for (NGramCandidate ng : item.ngrams) {
                GlobalStat stat = globalStats.getOrDefault(ng.phrase, new GlobalStat());
                double globalAvg = stat.getAverage();
                double bonus = 0.0;
                String formattedCandidate = CategoryGenerator.formatCategoryName(ng.phrase);
                if (knownCategories.contains(formattedCandidate.toUpperCase())) {
                    bonus += 0.1;
                }
                double frequencyFactor = (double)stat.count / maxCount * 0.2;
                double d = globalAvg >= 0.5 ? ng.normalizedPosition + bonus + frequencyFactor : ng.normalizedPosition * 0.5;
                double candidateScore = d;
                if (!(candidateScore > bestScore)) continue;
                bestScore = candidateScore;
                bestCandidate = ng;
            }
            if (bestCandidate == null && !item.ngrams.isEmpty()) {
                bestCandidate = item.ngrams.get(item.ngrams.size() - 1);
            }
            if (bestCandidate == null) continue;
            itemCategoryMap.put(item.name, bestCandidate.phrase);
        }
        Map<String, List<String>> categorizedItems = CategoryGenerator.loadExistingCategories();
        for (Map.Entry entry : itemCategoryMap.entrySet()) {
            String itemName = (String)entry.getKey();
            String label = CategoryGenerator.formatCategoryName((String)entry.getValue());
            categorizedItems.computeIfAbsent(label, k -> new ArrayList()).add(itemName);
        }
        CategoryGenerator.saveCategoriesToFile(categorizedItems);
    }

    private static String formatCategoryName(String candidate) {
        CharSequence[] words = candidate.toLowerCase().split("[_\\s]+");
        if (words.length == 0) {
            return "";
        }
        for (int i = 0; i < words.length - 1; ++i) {
            words[i] = CategoryGenerator.capitalize(words[i]);
        }
        String last = words[words.length - 1];
        if (!UNCOUNTABLE.contains(last.toUpperCase())) {
            last = CategoryGenerator.pluralize(last);
        }
        words[words.length - 1] = CategoryGenerator.capitalize(last);
        return String.join((CharSequence)" ", words);
    }

    private static String capitalize(String word) {
        if (word.isEmpty()) {
            return word;
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
    }

    private static String pluralize(String word) {
        if (word.endsWith("s")) {
            return word;
        }
        if (word.endsWith("oo")) {
            return word + "s";
        }
        if (word.endsWith("ch") || word.endsWith("sh") || word.endsWith("x") || word.endsWith("z")) {
            return word + "es";
        }
        if (word.endsWith("o")) {
            char before = word.charAt(word.length() - 2);
            if (!CategoryGenerator.isVowel(before)) {
                return word + "es";
            }
            return word + "s";
        }
        if (word.endsWith("y") && word.length() > 1 && !CategoryGenerator.isVowel(word.charAt(word.length() - 2))) {
            return word.substring(0, word.length() - 1) + "ies";
        }
        return word + "s";
    }

    private static boolean isVowel(char c) {
        return "aeiou".indexOf(Character.toLowerCase(c)) != -1;
    }

    private static Map<String, List<String>> loadExistingCategories() {
        Map<String, List<String>> map;
        block8: {
            map = new HashMap<String, List<String>>();
            try {
                Files.createDirectories(CATEGORIES_PATH.getParent(), new FileAttribute[0]);
                if (!Files.exists(CATEGORIES_PATH, new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(CATEGORIES_PATH.toFile());){
                    Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                    map = (Map)GSON.fromJson((Reader)reader, type);
                    if (map == null) {
                        map = new HashMap();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load existing categories", (Throwable)e);
            }
        }
        return map;
    }

    private static void saveCategoriesToFile(Map<String, List<String>> categorizedItems) {
        try {
            Files.createDirectories(CATEGORIES_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CATEGORIES_PATH.toFile());){
                GSON.toJson(categorizedItems, (Appendable)writer);
                LOGGER.info("Categories successfully saved to {}", (Object)CATEGORIES_PATH);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save categories to file", (Throwable)e);
        }
    }

    private static class ItemData {
        String name;
        List<String> tokens;
        List<NGramCandidate> ngrams;

        ItemData(String name, List<String> tokens) {
            this.name = name;
            this.tokens = tokens;
            this.ngrams = new ArrayList<NGramCandidate>();
        }

        void generateNGrams() {
            int len = this.tokens.size();
            for (int n = 1; n <= 3 && n <= len; ++n) {
                for (int i = 0; i <= len - n; ++i) {
                    double norm = ((double)i + (double)(n + 1) / 2.0) / (double)len;
                    String phrase = String.join((CharSequence)"_", this.tokens.subList(i, i + n));
                    this.ngrams.add(new NGramCandidate(phrase, norm));
                }
            }
        }
    }

    private static class NGramCandidate {
        String phrase;
        double normalizedPosition;

        NGramCandidate(String phrase, double normalizedPosition) {
            this.phrase = phrase;
            this.normalizedPosition = normalizedPosition;
        }
    }

    private static class GlobalStat {
        double sum = 0.0;
        int count = 0;

        private GlobalStat() {
        }

        void add(double value) {
            this.sum += value;
            ++this.count;
        }

        double getAverage() {
            return this.count == 0 ? 0.0 : this.sum / (double)this.count;
        }
    }
}

