/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class CategoryHabitsTracker {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path HABITS_PATH = Path.of("config/CraftSense/habits.json", new String[0]);
    private static CategoryHabitsTracker instance;
    public Map<String, Integer> categoryCraftCount = new HashMap<String, Integer>();
    public Map<String, Integer> itemCraftCount = new HashMap<String, Integer>();
    public String lastCraftedItem = null;

    public CategoryHabitsTracker() {
        this.load();
    }

    public static CategoryHabitsTracker getInstance() {
        if (instance == null) {
            instance = new CategoryHabitsTracker();
        }
        return instance;
    }

    private void load() {
        block21: {
            try {
                Files.createDirectories(HABITS_PATH.getParent(), new FileAttribute[0]);
                if (Files.exists(HABITS_PATH, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(HABITS_PATH.toFile());){
                        Map data = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                        if (data != null) {
                            Map rawCategoryCraftCount = data.getOrDefault("categoryCraftCount", new HashMap());
                            this.categoryCraftCount = new HashMap<String, Integer>();
                            for (Map.Entry entry : rawCategoryCraftCount.entrySet()) {
                                this.categoryCraftCount.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                            }
                            Map rawItemCraftCount = data.getOrDefault("itemCraftCount", new HashMap());
                            this.itemCraftCount = new HashMap<String, Integer>();
                            for (Map.Entry entry : rawItemCraftCount.entrySet()) {
                                this.itemCraftCount.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                            }
                            this.lastCraftedItem = data.getOrDefault("lastCraftedItem", null);
                        }
                        break block21;
                    }
                    catch (JsonSyntaxException | ClassCastException e) {
                        try (FileReader legacyReader = new FileReader(HABITS_PATH.toFile());){
                            Map rawCategoryCraftCount = (Map)GSON.fromJson((Reader)legacyReader, new TypeToken<Map<String, Number>>(){}.getType());
                            this.categoryCraftCount = new HashMap<String, Integer>();
                            for (Map.Entry entry : rawCategoryCraftCount.entrySet()) {
                                this.categoryCraftCount.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
                            }
                            this.itemCraftCount = new HashMap<String, Integer>();
                            this.lastCraftedItem = null;
                            break block21;
                        }
                        catch (IOException innerException) {
                            innerException.printStackTrace();
                            this.categoryCraftCount = new HashMap<String, Integer>();
                            this.itemCraftCount = new HashMap<String, Integer>();
                            this.lastCraftedItem = null;
                        }
                    }
                    break block21;
                }
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(HABITS_PATH.toFile());){
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("categoryCraftCount", this.categoryCraftCount);
            data.put("itemCraftCount", this.itemCraftCount);
            data.put("lastCraftedItem", this.lastCraftedItem);
            GSON.toJson(data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void recordCraft(String itemCategory, String itemName) {
        this.categoryCraftCount.put(itemCategory, this.categoryCraftCount.getOrDefault(itemCategory, 0) + 1);
        this.itemCraftCount.put(itemName, this.itemCraftCount.getOrDefault(itemName, 0) + 1);
        this.lastCraftedItem = itemName;
        this.save();
    }

    public int getCraftCount(String category) {
        return this.categoryCraftCount.getOrDefault(category, 0);
    }

    public int getItemCraftCount(String itemName) {
        return this.itemCraftCount.getOrDefault(itemName, 0);
    }

    public String getLastCraftedItem() {
        return this.lastCraftedItem;
    }
}

