/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Path.of("config/CraftSense/config.json", new String[0]);
    private static final String ENABLE_KEY = "enabled";
    private static final String FIRST_TIME_KEY = "firstTime";
    private boolean enabled;
    private boolean firstTime;

    public ConfigurationManager() {
        this.loadConfig();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void toggleFirstTime() {
        this.firstTime = false;
        this.saveConfig();
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
        this.saveConfig();
    }

    private void loadConfig() {
        block8: {
            try {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                        Map config = (Map)GSON.fromJson((Reader)reader, HashMap.class);
                        this.enabled = config.getOrDefault(ENABLE_KEY, true);
                        this.firstTime = config.getOrDefault(FIRST_TIME_KEY, true);
                        break block8;
                    }
                }
                this.enabled = true;
                this.firstTime = true;
                this.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.enabled = true;
                this.firstTime = true;
            }
        }
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put(ENABLE_KEY, this.enabled);
            config.put(FIRST_TIME_KEY, this.firstTime);
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

