/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.mixin;

import com.dooji.craftsense.CraftSense;
import com.dooji.craftsense.CraftSenseKeyBindings;
import com.dooji.craftsense.CraftingPredictor;
import com.dooji.craftsense.manager.CategoryHabitsTracker;
import com.dooji.craftsense.manager.CategoryManager;
import com.dooji.craftsense.mixin.CraftingScreenHandlerAccessor;
import com.dooji.craftsense.mixin.HandledScreenAccessor;
import com.dooji.craftsense.network.payloads.CraftItemPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class CraftingScreenMixin {
    @Unique
    private int resultSlotX;
    @Unique
    private int resultSlotY;
    @Unique
    private String lastGridHash = "";
    @Unique
    private Optional<class_3955> cachedLastCraftedRecipe = Optional.empty();
    @Unique
    private Optional<class_3955> cachedSuggestedRecipe = Optional.empty();
    @Unique
    private boolean showFirstTimeTooltips = CraftSense.configManager.isFirstTime();
    @Unique
    private int progress = 0;
    @Unique
    private long lastMouseClickTime = 0L;
    @Unique
    private long lastKeyPressTime = 0L;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderCraftingPrediction(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_3955 recipe;
        class_479 craftingScreen;
        class_310 client;
        block15: {
            block14: {
                client = class_310.method_1551();
                class_437 class_4372 = client.field_1755;
                if (!(class_4372 instanceof class_479)) break block14;
                craftingScreen = (class_479)class_4372;
                if (CraftSense.configManager.isEnabled()) break block15;
            }
            return;
        }
        if (craftingScreen.method_2659().method_2605()) {
            return;
        }
        class_1661 playerInventory = client.field_1724.method_31548();
        class_638 world = client.field_1687;
        class_1714 handler = (class_1714)craftingScreen.method_17577();
        class_1715 input = ((CraftingScreenHandlerAccessor)handler).getInput();
        class_1799 cursorStack = handler.method_34255();
        CraftingPredictor predictor = CraftingPredictor.getInstance(world.method_8433());
        String currentStateHash = predictor.calculateInputHash(input, playerInventory, cursorStack);
        if (!currentStateHash.equals(this.lastGridHash)) {
            this.lastGridHash = currentStateHash;
            this.cachedLastCraftedRecipe = predictor.suggestLastCraftedItem(input, playerInventory, cursorStack, (class_1937)world);
            this.cachedSuggestedRecipe = this.cachedLastCraftedRecipe.isEmpty() ? predictor.suggestRecipe(input, playerInventory, cursorStack, (class_1937)world) : Optional.empty();
        }
        int screenX = ((HandledScreenAccessor)((Object)this)).getX();
        int screenY = ((HandledScreenAccessor)((Object)this)).getY();
        this.resultSlotX = screenX + 124;
        this.resultSlotY = screenY + 35;
        if (this.cachedLastCraftedRecipe.isPresent()) {
            if (this.showFirstTimeTooltips) {
                this.renderTooltip(matrices, class_2561.method_43471((String)"tooltip.craftsense.click_here").getString(), class_2561.method_43471((String)"tooltip.craftsense.lastCraftedSuggest").getString(), this.resultSlotX, this.resultSlotY);
            }
            if (predictor.hasRequiredIngredients(recipe = this.cachedLastCraftedRecipe.get(), predictor.getAvailableItems(playerInventory, cursorStack, input))) {
                class_1799 resultStack = recipe.method_8110();
                this.renderGhostItem(matrices, resultStack, this.resultSlotX, this.resultSlotY, 0.2f, mouseX, mouseY, true);
                return;
            }
        }
        if (this.cachedSuggestedRecipe.isPresent()) {
            if (this.showFirstTimeTooltips) {
                this.renderTooltip(matrices, class_2561.method_43471((String)"tooltip.craftsense.click_here").getString(), class_2561.method_43471((String)"tooltip.craftsense.suggest").getString(), this.resultSlotX, this.resultSlotY);
            }
            if (predictor.hasRequiredIngredients(recipe = this.cachedSuggestedRecipe.get(), predictor.getAvailableItems(playerInventory, cursorStack, input))) {
                class_1799 resultStack = recipe.method_8110();
                this.renderGhostItem(matrices, resultStack, this.resultSlotX, this.resultSlotY, 0.2f, mouseX, mouseY, false);
                if (recipe instanceof class_1869) {
                    this.renderShapedRecipeIngredients(matrices, recipe, input, handler, screenX, screenY, mouseX, mouseY, playerInventory, cursorStack, (class_1937)world, predictor);
                } else if (recipe instanceof class_1867) {
                    this.renderShapelessRecipeIngredients(matrices, recipe, input, handler, screenX, screenY, mouseX, mouseY);
                }
            }
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSuggestedRecipeClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        class_479 craftingScreen;
        boolean isShiftPressed;
        class_310 client;
        block12: {
            block11: {
                client = class_310.method_1551();
                isShiftPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340);
                class_437 class_4372 = client.field_1755;
                if (!(class_4372 instanceof class_479)) break block11;
                craftingScreen = (class_479)class_4372;
                if (CraftSense.configManager.isEnabled()) break block12;
            }
            return;
        }
        if (craftingScreen.method_2659().method_2605()) {
            return;
        }
        long cooldownDuration = 100L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMouseClickTime < cooldownDuration) {
            cir.setReturnValue((Object)false);
            return;
        }
        this.lastMouseClickTime = currentTime;
        if (this.isMouseOverSlot((int)mouseX, (int)mouseY, this.resultSlotX, this.resultSlotY)) {
            Optional<class_3955> optionalRecipe;
            if (this.showFirstTimeTooltips) {
                ++this.progress;
                if (this.progress >= 2) {
                    this.showFirstTimeTooltips = false;
                    CraftSense.configManager.toggleFirstTime();
                }
            }
            class_1661 playerInventory = client.field_1724.method_31548();
            class_638 world = client.field_1687;
            class_1714 handler = (class_1714)((class_479)this).method_17577();
            class_1799 cursorStack = handler.method_34255();
            class_1715 input = ((CraftingScreenHandlerAccessor)handler).getInput();
            CraftingPredictor predictor = CraftingPredictor.getInstance(world.method_8433());
            Optional<class_3955> lastCraftedRecipe = predictor.suggestLastCraftedItem(input, playerInventory, handler.method_34255(), (class_1937)world);
            Optional<class_3955> optional = optionalRecipe = lastCraftedRecipe.isPresent() ? lastCraftedRecipe : predictor.suggestRecipe(input, playerInventory, handler.method_34255(), (class_1937)world);
            if (optionalRecipe.isPresent()) {
                class_3955 recipe = optionalRecipe.get();
                class_2960 recipeId = this.findRecipeId(world.method_8433(), recipe);
                if (recipeId != null) {
                    class_1799 resultStack = recipe.method_8110().method_7972();
                    if (!((cursorStack.method_7960() || isShiftPressed || cursorStack.method_7946() && this.areStacksEqualWithComponents(cursorStack, resultStack)) && resultStack.method_7909() != class_1802.field_8162)) {
                        return;
                    }
                    CategoryHabitsTracker habitsConfig = CategoryHabitsTracker.getInstance();
                    String category = CategoryManager.getCategory(resultStack.method_7909());
                    habitsConfig.recordCraft(category, resultStack.method_7909().method_7876());
                    class_2960 channelId = new class_2960("craftsense", "craft_item");
                    class_2540 packetBuffer = CraftItemPayload.createPacket(recipeId.toString(), isShiftPressed);
                    ClientPlayNetworking.send((class_2960)channelId, (class_2540)packetBuffer);
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        class_479 craftingScreen;
        block9: {
            block8: {
                class_437 class_4372 = class_310.method_1551().field_1755;
                if (!(class_4372 instanceof class_479)) break block8;
                craftingScreen = (class_479)class_4372;
                if (CraftSense.configManager.isEnabled()) break block9;
            }
            return;
        }
        if (craftingScreen.method_2659().method_2605()) {
            return;
        }
        long cooldownDuration = 100L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastKeyPressTime < cooldownDuration) {
            cir.setReturnValue((Object)false);
            return;
        }
        this.lastKeyPressTime = currentTime;
        if (CraftSenseKeyBindings.quickCraftKey.method_1417(keyCode, scanCode)) {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (client.field_1724 != null && client.field_1687 != null) {
                class_1714 handler = (class_1714)((class_479)this).method_17577();
                class_1661 inventory = client.field_1724.method_31548();
                class_1715 input = ((CraftingScreenHandlerAccessor)handler).getInput();
                class_1799 cursorStack = handler.method_34255();
                CraftingPredictor predictor = CraftingPredictor.getInstance(world.method_8433());
                String currentStateHash = predictor.calculateInputHash(input, inventory, cursorStack);
                if (!currentStateHash.equals(this.lastGridHash)) {
                    this.lastGridHash = currentStateHash;
                    this.cachedLastCraftedRecipe = predictor.suggestLastCraftedItem(input, inventory, cursorStack, (class_1937)client.field_1687);
                    this.cachedSuggestedRecipe = this.cachedLastCraftedRecipe.isEmpty() ? predictor.suggestRecipe(input, inventory, cursorStack, (class_1937)client.field_1687) : Optional.empty();
                }
                Optional<class_3955> recipe = this.cachedSuggestedRecipe.isPresent() ? this.cachedSuggestedRecipe : this.cachedLastCraftedRecipe;
                recipe.ifPresent(arg_0 -> this.lambda$onKeyPressed$0((class_1937)world, arg_0));
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Unique
    private void renderShapedRecipeIngredients(class_4587 matrices, class_3955 recipe, class_1715 input, class_1714 handler, int screenX, int screenY, int mouseX, int mouseY, class_1661 playerInventory, class_1799 cursorStack, class_1937 world, CraftingPredictor predictor) {
        class_1869 shapedRecipe = (class_1869)recipe;
        class_1799 resultStack = recipe.method_8110();
        this.renderGhostItem(matrices, resultStack, this.resultSlotX, this.resultSlotY, 0.2f, mouseX, mouseY, false);
        int recipeWidth = shapedRecipe.method_8150();
        int recipeHeight = shapedRecipe.method_8158();
        class_2371 ingredients = shapedRecipe.method_8117();
        int bestOffsetX = -1;
        int bestOffsetY = -1;
        boolean bestMirrored = false;
        int bestScore = -1;
        for (int offsetX = 0; offsetX <= 3 - recipeWidth; ++offsetX) {
            for (int offsetY = 0; offsetY <= 3 - recipeHeight; ++offsetY) {
                class_3545<Integer, Boolean> matchResult = predictor.matchShapedRecipe(shapedRecipe, input, predictor.getAvailableItems(playerInventory, cursorStack, input), offsetX, offsetY);
                int alignmentScore = (Integer)matchResult.method_15442();
                boolean mirrored = (Boolean)matchResult.method_15441();
                if (alignmentScore <= bestScore) continue;
                bestScore = alignmentScore;
                bestOffsetX = offsetX;
                bestOffsetY = offsetY;
                bestMirrored = mirrored;
            }
        }
        if (bestOffsetX != -1 && bestOffsetY != -1) {
            for (int recipeY = 0; recipeHeight > recipeY; ++recipeY) {
                for (int recipeX = 0; recipeWidth > recipeX; ++recipeX) {
                    int index = recipeY * recipeWidth + recipeX;
                    class_1856 ingredient = (class_1856)ingredients.get(bestMirrored ? recipeWidth - recipeX - 1 + recipeY * recipeWidth : index);
                    int gridX = bestOffsetX + recipeX;
                    int gridY = bestOffsetY + recipeY;
                    int gridIndex = gridY * 3 + gridX;
                    class_1735 slot = (class_1735)handler.field_7761.get(gridIndex + 1);
                    int slotX = screenX + slot.field_7873;
                    int slotY = screenY + slot.field_7872;
                    class_1799[] matchingStacks = ingredient.method_8105();
                    if (matchingStacks.length <= 0) continue;
                    class_1799 ghostStack = matchingStacks[0];
                    this.renderGhostItem(matrices, ghostStack, slotX, slotY, 0.2f, mouseX, mouseY, false);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private void renderShapelessRecipeIngredients(class_4587 matrices, class_3955 recipe, class_1715 input, class_1714 handler, int screenX, int screenY, int mouseX, int mouseY) {
        void var14_20;
        class_2371 ingredients = recipe.method_8117();
        boolean[][] usedGrid = new boolean[3][3];
        HashMap<Integer, Integer> placedItemCounts = new HashMap<Integer, Integer>();
        for (int i = 0; i < input.method_5439(); ++i) {
            class_1799 stack = input.method_5438(i);
            if (stack.method_7960()) continue;
            placedItemCounts.put(i, stack.method_7947());
            int n = i % 3;
            int gridY = i / 3;
            usedGrid[gridY][n] = true;
        }
        ArrayList<class_1799> remainingIngredients = new ArrayList<class_1799>();
        for (class_1856 class_18562 : ingredients) {
            boolean matched = false;
            for (Map.Entry entry : placedItemCounts.entrySet()) {
                int slotIndex = (Integer)entry.getKey();
                int count = (Integer)entry.getValue();
                class_1799 placedItem = input.method_5438(slotIndex);
                if (!class_18562.method_8093(placedItem)) continue;
                matched = true;
                if (count > 1) {
                    placedItemCounts.put(slotIndex, count - 1);
                    break;
                }
                placedItemCounts.remove(slotIndex);
                break;
            }
            if (matched) continue;
            remainingIngredients.add(class_18562.method_8105()[0]);
        }
        for (Map.Entry entry : placedItemCounts.entrySet()) {
            int slotIndex = (Integer)entry.getKey();
            class_1735 slot = (class_1735)handler.field_7761.get(slotIndex + 1);
            int slotX = screenX + slot.field_7873;
            int slotY = screenY + slot.field_7872;
            this.renderGhostItem(matrices, input.method_5438(slotIndex), slotX, slotY, 0.2f, mouseX, mouseY, false);
        }
        int ingredientIndex = 0;
        boolean bl = false;
        while (var14_20 < 3) {
            for (int gridX = 0; gridX < 3; ++gridX) {
                if (usedGrid[var14_20][gridX] || ingredientIndex >= remainingIngredients.size()) continue;
                void gridIndex = var14_20 * 3 + gridX;
                class_1735 slot = (class_1735)handler.field_7761.get((int)(gridIndex + true));
                int slotX = screenX + slot.field_7873;
                int slotY = screenY + slot.field_7872;
                class_1799 ingredientStack = (class_1799)remainingIngredients.get(ingredientIndex++);
                this.renderGhostItem(matrices, ingredientStack, slotX, slotY, 0.2f, mouseX, mouseY, false);
            }
            ++var14_20;
        }
    }

    @Unique
    private void renderGhostItem(class_4587 matrices, class_1799 stack, int x, int y, float opacity, int mouseX, int mouseY, boolean isLastCrafted) {
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, -100.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawItem(stack, x, y);
        this.drawTransparentRectangle(matrices, x, y, x + 16, y + 16, 300, opacity);
        if (mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(stack.method_7964());
            if (isLastCrafted) {
                tooltip.add(class_2561.method_43471((String)"tooltip.craftsense.last_crafted_item").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            }
            ((class_465)this).method_30901(matrices, tooltip, mouseX, mouseY);
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    @Unique
    private void drawTransparentRectangle(class_4587 matrices, int x1, int y1, int x2, int y2, int z, float alpha) {
        class_1159 matrix = matrices.method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)z).method_1336(255, 255, 255, (int)(alpha * 255.0f)).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y2, (float)z).method_1336(255, 255, 255, (int)(alpha * 255.0f)).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_1336(255, 255, 255, (int)(alpha * 255.0f)).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y1, (float)z).method_1336(255, 255, 255, (int)(alpha * 255.0f)).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
        RenderSystem.disableBlend();
    }

    @Unique
    private boolean areStacksEqualWithComponents(class_1799 stack1, class_1799 stack2) {
        if (!class_1799.method_7987((class_1799)stack1, (class_1799)stack2)) {
            return false;
        }
        if (stack1.method_7985() && stack2.method_7985()) {
            return Objects.equals(stack1.method_7969(), stack2.method_7969());
        }
        return !stack1.method_7985() && !stack2.method_7985();
    }

    @Unique
    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
        return mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
    }

    @Unique
    @Nullable
    private class_2960 findRecipeId(class_1863 recipeManager, class_3955 targetRecipe) {
        List craftingRecipes = recipeManager.method_30027(class_3956.field_17545);
        for (class_1860 recipe : craftingRecipes) {
            if (!(recipe instanceof class_3955) || !recipe.equals((Object)targetRecipe)) continue;
            return recipe.method_8114();
        }
        return null;
    }

    @Unique
    private void renderTooltip(class_4587 matrices, String title, String description, int x, int y) {
        String[] descriptionLines;
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
        tooltip.add(class_2561.method_43470((String)title).method_27692(class_124.field_1068));
        for (String line : descriptionLines = description.split("\n")) {
            tooltip.add(class_2561.method_43470((String)line).method_27692(class_124.field_1080));
        }
        ((class_465)this).method_30901(matrices, tooltip, x + 20, y + 3);
    }

    @Unique
    private void drawItem(class_1799 itemStack, int x, int y) {
        class_310 client = class_310.method_1551();
        client.method_1480().method_27953(itemStack, x, y);
    }

    private /* synthetic */ void lambda$onKeyPressed$0(class_1937 world, class_3955 r) {
        class_2960 recipeId = this.findRecipeId(world.method_8433(), r);
        if (recipeId != null) {
            class_1799 resultStack = r.method_8110().method_7972();
            if (resultStack.method_7909() == class_1802.field_8162) {
                return;
            }
            String category = CategoryManager.getCategory(resultStack.method_7909());
            CategoryHabitsTracker habitsConfig = CategoryHabitsTracker.getInstance();
            habitsConfig.recordCraft(category, resultStack.method_7909().method_7876());
            class_2960 channelId = new class_2960("craftsense", "craft_item");
            class_2540 packetBuffer = CraftItemPayload.createPacket(recipeId.toString(), true);
            ClientPlayNetworking.send((class_2960)channelId, (class_2540)packetBuffer);
        }
    }
}

