/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.network;

import com.dooji.craftsense.mixin.CraftingScreenHandlerAccessor;
import com.dooji.craftsense.network.payloads.CraftItemPayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CraftSenseNetworking {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("craftsense", "craft_item"), (server, player, handler, buf, responseSender) -> {
            CraftItemPayload payload = CraftItemPayload.read(buf);
            server.execute(() -> CraftSenseNetworking.handleCraftItemPayload(payload, player));
        });
    }

    private static void handleCraftItemPayload(CraftItemPayload payload, class_3222 player) {
        class_2960 recipeId;
        class_1863 recipeManager = player.method_5682().method_3772();
        Optional<class_3955> recipeOptional = recipeManager.method_8130(recipeId = new class_2960(payload.recipeId())).filter(recipe -> recipe instanceof class_3955).map(recipe -> (class_3955)recipe);
        if (recipeOptional.isPresent()) {
            class_3955 recipe2 = recipeOptional.get();
            class_1661 inventory = player.method_31548();
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof class_1714) {
                class_1799 cursorStack;
                class_1714 handler = (class_1714)class_17032;
                class_1715 gridInventory = ((CraftingScreenHandlerAccessor)handler).getInput();
                class_1799 resultStack = recipe2.method_8110().method_7972();
                class_3955 recipeToUse = CraftSenseNetworking.selectCraftableVariant(recipeManager, recipe2, resultStack, inventory, gridInventory, cursorStack = handler.method_34255());
                if (recipeToUse == null) {
                    return;
                }
                if (payload.isShiftPressed().booleanValue()) {
                    if (!CraftSenseNetworking.placeInInventoryOrCursor(inventory, resultStack, player)) {
                        return;
                    }
                } else if (cursorStack.method_7960()) {
                    handler.method_34254(resultStack);
                } else if (CraftSenseNetworking.areStacksEqualWithComponents(cursorStack, resultStack)) {
                    cursorStack.method_7933(resultStack.method_7947());
                    handler.method_34254(cursorStack);
                } else {
                    return;
                }
                if (CraftSenseNetworking.hasAllIngredients(inventory, gridInventory, recipeToUse, cursorStack)) {
                    CraftSenseNetworking.consumeIngredients(recipeToUse, gridInventory, inventory, cursorStack);
                    CraftSenseNetworking.clearGridAndSync(handler, player);
                }
            }
        }
    }

    private static class_3955 selectCraftableVariant(class_1863 recipeManager, class_3955 requestedRecipe, class_1799 desiredResult, class_1661 inventory, class_1715 gridInventory, class_1799 cursorStack) {
        if (desiredResult.method_7960()) {
            return null;
        }
        List<class_3955> candidates = recipeManager.method_30027(class_3956.field_17545).stream().filter(r -> CraftSenseNetworking.areStacksEqualWithComponents(r.method_8110().method_7972(), desiredResult)).toList();
        for (class_3955 candidate : candidates) {
            boolean ok = CraftSenseNetworking.hasAllIngredients(inventory, gridInventory, candidate, cursorStack);
            if (!ok) continue;
            return candidate;
        }
        return null;
    }

    private static boolean areStacksEqualWithComponents(class_1799 stack1, class_1799 stack2) {
        if (!class_1799.method_7987((class_1799)stack1, (class_1799)stack2)) {
            return false;
        }
        if (stack1.method_7985() && stack2.method_7985()) {
            return Objects.equals(stack1.method_7969(), stack2.method_7969());
        }
        return !stack1.method_7985() && !stack2.method_7985();
    }

    private static boolean hasAllIngredients(class_1661 inventory, class_1715 gridInventory, class_3955 recipe, class_1799 cursorStack) {
        for (class_1856 ingredient : recipe.method_8117()) {
            boolean found = false;
            for (int i = 0; i < gridInventory.method_5439(); ++i) {
                if (!ingredient.method_8093(gridInventory.method_5438(i))) continue;
                found = true;
                break;
            }
            if (!found && ingredient.method_8093(cursorStack)) {
                found = true;
            }
            if (found || CraftSenseNetworking.findInInventory(inventory, ingredient)) continue;
            return false;
        }
        return true;
    }

    private static boolean findInInventory(class_1661 inventory, class_1856 ingredient) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!ingredient.method_8093(inventory.method_5438(i))) continue;
            return true;
        }
        return false;
    }

    private static void consumeIngredients(class_3955 recipe, class_1715 gridInventory, class_1661 inventory, class_1799 cursorStack) {
        HashMap<class_1856, Integer> ingredientsNeeded = new HashMap<class_1856, Integer>();
        for (class_1856 ingredient : recipe.method_8117()) {
            ingredientsNeeded.put(ingredient, ingredientsNeeded.getOrDefault(ingredient, 0) + 1);
        }
        for (Map.Entry entry : ingredientsNeeded.entrySet()) {
            int consumedFromGrid;
            class_1856 ingredient = (class_1856)entry.getKey();
            int requiredAmount = (Integer)entry.getValue();
            if ((requiredAmount -= (consumedFromGrid = CraftSenseNetworking.consumeFromGrid(ingredient, gridInventory, requiredAmount))) > 0 && ingredient.method_8093(cursorStack)) {
                int toConsume = Math.min(requiredAmount, cursorStack.method_7947());
                cursorStack.method_7934(toConsume);
                requiredAmount -= toConsume;
            }
            if (requiredAmount <= 0) continue;
            CraftSenseNetworking.consumeFromInventory(ingredient, inventory, requiredAmount);
        }
    }

    private static int consumeFromGrid(class_1856 ingredient, class_1715 gridInventory, int requiredAmount) {
        int amountConsumed = 0;
        for (int i = 0; i < gridInventory.method_5439(); ++i) {
            class_1799 stack = gridInventory.method_5438(i);
            if (!ingredient.method_8093(stack) || stack.method_7960()) continue;
            int toConsume = Math.min(requiredAmount, stack.method_7947());
            stack.method_7934(toConsume);
            amountConsumed += toConsume;
            if ((requiredAmount -= toConsume) <= 0) break;
        }
        return amountConsumed;
    }

    private static void consumeFromInventory(class_1856 ingredient, class_1661 inventory, int requiredAmount) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!ingredient.method_8093(stack) || stack.method_7960()) continue;
            int toConsume = Math.min(requiredAmount, stack.method_7947());
            stack.method_7934(toConsume);
            if ((requiredAmount -= toConsume) <= 0) break;
        }
    }

    private static void clearGridAndSync(class_1714 handler, class_3222 player) {
        class_1715 gridInventory = ((CraftingScreenHandlerAccessor)handler).getInput();
        for (int i = 0; i < gridInventory.method_5439(); ++i) {
            class_1799 currentStack = gridInventory.method_5438(i);
            if (currentStack.method_7960()) continue;
            player.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, 0, i + 1, currentStack));
        }
    }

    private static boolean placeInInventoryOrCursor(class_1661 inventory, class_1799 stack, class_3222 player) {
        class_1799 slotStack;
        int i;
        for (i = 0; i < 36; ++i) {
            slotStack = inventory.method_5438(i);
            if (!class_1799.method_7987((class_1799)slotStack, (class_1799)stack) || slotStack.method_7947() >= slotStack.method_7914()) continue;
            int transferable = Math.min(stack.method_7947(), slotStack.method_7914() - slotStack.method_7947());
            slotStack.method_7933(transferable);
            stack.method_7934(transferable);
            CraftSenseNetworking.sendSlotUpdate(player, 0, i, slotStack);
            if (!stack.method_7960()) continue;
            return true;
        }
        for (i = 0; i < 36; ++i) {
            slotStack = inventory.method_5438(i);
            if (!slotStack.method_7960()) continue;
            inventory.method_5447(i, stack);
            CraftSenseNetworking.sendSlotUpdate(player, 0, i, stack);
            return true;
        }
        return false;
    }

    private static void sendSlotUpdate(class_3222 player, int syncId, int slot, class_1799 stack) {
        if (slot == -1) {
            player.field_13987.method_14364((class_2596)new class_2653(syncId, -1, 0, stack));
        } else {
            player.field_13987.method_14364((class_2596)new class_2653(syncId, 0, slot, stack));
        }
    }
}

