/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.omnilib;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;

public class OmniToast
implements class_368 {
    private static final class_2960 DEFAULT_BACKGROUND_TEXTURE = class_2960.method_43902((String)"omnilib", (String)"textures/gui/toast.png");
    private static final class_2960 DEFAULT_ICON_TEXTURE = class_2960.method_43902((String)"minecraft", (String)"icon.png");
    private static final int DEFAULT_ICON_SIZE = 16;
    private static final int DEFAULT_TEXTURE_WIDTH = 160;
    private static final int DEFAULT_TEXTURE_HEIGHT = 32;
    private static final long DEFAULT_DURATION = 5000L;
    private static final int DEFAULT_TITLE_COLOR = 0xFFFFFF;
    private static final int DEFAULT_DESCRIPTION_COLOR = 0xAAAAAA;
    private final class_2960 backgroundTexture;
    private final class_2960 iconTexture;
    private final class_1799 iconItemStack;
    private final int iconSize;
    private int textureWidth;
    private final int configTextureWidth;
    private final int textureHeight;
    private class_2561 title;
    private class_2561 description;
    private long duration;
    private long time;
    private boolean hidden;
    private long lastElapsed = System.currentTimeMillis();
    private final int titleColor;
    private final int descriptionColor;

    public OmniToast(class_2561 title, class_2561 description, long duration, int titleColor, int descriptionColor, class_2960 backgroundTexture, class_2960 iconTexture, class_1799 iconItemStack, int iconSize, int textureWidth, int textureHeight) {
        this.title = title;
        this.description = description;
        this.duration = duration;
        this.titleColor = titleColor;
        this.descriptionColor = descriptionColor;
        this.backgroundTexture = backgroundTexture != null ? backgroundTexture : DEFAULT_BACKGROUND_TEXTURE;
        this.iconTexture = iconTexture != null ? iconTexture : DEFAULT_ICON_TEXTURE;
        this.iconItemStack = iconItemStack;
        this.iconSize = iconSize > 0 ? iconSize : 16;
        this.textureWidth = this.configTextureWidth = textureWidth > 0 ? textureWidth : 160;
        this.textureHeight = textureHeight > 0 ? textureHeight : 32;
        this.time = 0L;
        this.hidden = false;
    }

    public OmniToast(class_2561 title, class_2561 description) {
        this(title, description, 5000L, 0xFFFFFF, 0xAAAAAA, DEFAULT_BACKGROUND_TEXTURE, DEFAULT_ICON_TEXTURE, null, 16, 160, 32);
    }

    public void setTitle(class_2561 title) {
        this.title = title;
    }

    public void setDescription(class_2561 description) {
        this.description = description;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public class_368.class_369 method_1986(class_4587 matrices, class_374 manager, long currentTime) {
        this.updateWidth();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.backgroundTexture);
        class_332.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.method_29049(), (int)this.method_29050(), (int)this.textureWidth, (int)this.textureHeight);
        if (this.iconItemStack != null) {
            this.drawItem(this.iconItemStack, 10, (this.textureHeight - this.iconSize) / 2);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.iconTexture);
            class_332.method_25290((class_4587)matrices, (int)10, (int)((this.textureHeight - this.iconSize) / 2), (float)0.0f, (float)0.0f, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize);
        }
        manager.method_1995().field_1772.method_30883(matrices, this.title, 38.0f, 7.0f, this.titleColor);
        manager.method_1995().field_1772.method_30883(matrices, this.description, 38.0f, 19.0f, this.descriptionColor);
        if (!this.hidden) {
            this.time += System.currentTimeMillis() - this.lastElapsed;
            this.lastElapsed = System.currentTimeMillis();
        }
        if (this.time >= this.duration) {
            this.hidden = true;
            return class_368.class_369.field_2209;
        }
        return class_368.class_369.field_2210;
    }

    public int method_29049() {
        return this.textureWidth;
    }

    public int method_29050() {
        return this.textureHeight;
    }

    public int method_45072() {
        return 1;
    }

    private void updateWidth() {
        int descriptionLength;
        int titleLength = this.countCharacters(this.title);
        int contentLength = Math.max(titleLength, descriptionLength = this.countCharacters(this.description));
        if (contentLength > 22 && this.textureWidth < (contentLength - 22) * 5 + this.configTextureWidth) {
            int extraWidth = contentLength - 22;
            this.textureWidth += extraWidth * 5;
        }
    }

    private int countCharacters(class_2561 text) {
        int count = 0;
        String string = text.getString();
        for (int i = 0; i < string.length(); ++i) {
            if (string.codePointAt(i) >= 128) continue;
            ++count;
        }
        return count;
    }

    private void drawItem(class_1799 itemStack, int x, int y) {
        class_310 client = class_310.method_1551();
        client.method_1480().method_27953(itemStack, x, y);
    }
}

