/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.omnilib;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class OmniTooltip {
    private final String categoryTitle;
    private final List<class_1799> itemStacks;
    private final List<class_2561> textList;
    private static final int DEFAULT_ICON_SIZE = 16;
    private static final int DEFAULT_PADDING = 8;
    private static final int DEFAULT_LINE_SPACING = 4;
    private static final int DEFAULT_BACKGROUND_COLOR = class_5253.class_5254.method_27764((int)150, (int)60, (int)60, (int)60);
    private static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    private static final int DEFAULT_MAX_HEIGHT = 140;
    private static final double DEFAULT_SCROLL_SPEED = 25.0;
    private final int iconSize;
    private final int padding;
    private final int lineSpacing;
    private final int backgroundColor;
    private final class_2960 backgroundTexture;
    private final int textColor;
    private final class_2960 customIconTexture;
    private final int customIconWidth;
    private final int customIconHeight;
    private final int maxHeight;
    private final double scrollSpeed;

    public OmniTooltip(String categoryTitle, List<class_1799> itemStacks, List<class_2561> textList, int iconSize, int padding, int lineSpacing, int backgroundColor, class_2960 backgroundTexture, int textColor, class_2960 customIconTexture, int customIconWidth, int customIconHeight, Integer maxHeight, Double scrollSpeed) {
        if (backgroundColor == 0 && backgroundTexture == null) {
            throw new IllegalArgumentException("Either backgroundColor or backgroundTexture must be specified.");
        }
        this.categoryTitle = categoryTitle;
        this.itemStacks = itemStacks != null ? itemStacks : Collections.emptyList();
        this.textList = textList != null ? textList : Collections.emptyList();
        this.iconSize = iconSize > 0 ? iconSize : 16;
        this.padding = padding > 0 ? padding : 8;
        this.lineSpacing = lineSpacing > 0 ? lineSpacing : 4;
        this.backgroundColor = backgroundColor > 0 ? backgroundColor : DEFAULT_BACKGROUND_COLOR;
        this.backgroundTexture = backgroundTexture;
        this.textColor = textColor > 0 ? textColor : 0xFFFFFF;
        this.customIconTexture = customIconTexture;
        this.customIconWidth = customIconWidth > 0 ? customIconWidth : iconSize;
        this.customIconHeight = customIconHeight > 0 ? customIconHeight : iconSize;
        this.maxHeight = maxHeight != null && maxHeight > 0 ? maxHeight : 140;
        this.scrollSpeed = scrollSpeed != null && scrollSpeed > 0.0 ? scrollSpeed : 25.0;
    }

    public OmniTooltip(String categoryTitle, List<class_1799> itemStacks, List<class_2561> textList, int iconSize, int padding, int lineSpacing, int backgroundColor, class_2960 backgroundTexture, int textColor, class_2960 customIconTexture, int customIconWidth, int customIconHeight) {
        this(categoryTitle, itemStacks, textList, iconSize, padding, lineSpacing, backgroundColor, backgroundTexture, textColor, customIconTexture, customIconWidth, customIconHeight, null, null);
    }

    public void render(class_4587 matrices, class_327 textRenderer, int x, int y) {
        int tooltipWidth = this.getTooltipWidth(textRenderer);
        int tooltipHeight = this.getTooltipHeight();
        boolean requiresScrolling = tooltipHeight > this.maxHeight;
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 1.0);
        int displayHeight = requiresScrolling ? this.maxHeight : tooltipHeight;
        this.drawBackground(matrices, x, y, tooltipWidth, displayHeight);
        int yOffset = this.padding;
        class_332.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)class_2561.method_43470((String)this.categoryTitle).method_27694(style -> style.method_10982(Boolean.valueOf(true))), (int)(x + this.padding), (int)(y + yOffset), (int)this.textColor);
        yOffset += this.iconSize + this.lineSpacing;
        if (requiresScrolling) {
            this.renderScrollableContent(matrices, textRenderer, x, y + yOffset, tooltipWidth, displayHeight - yOffset);
        } else {
            this.renderContent(matrices, textRenderer, x, y + yOffset);
        }
        matrices.method_22909();
    }

    private void renderScrollableContent(class_4587 matrices, class_327 textRenderer, int x, int y, int width, int height) {
        int contentHeight = this.getTooltipHeight() - this.padding;
        if (contentHeight <= 0) {
            return;
        }
        double time = (double)class_156.method_658() / 1000.0;
        double scrollAmount = time * this.scrollSpeed % (double)(contentHeight + 4);
        int yOffset = -((int)scrollAmount);
        class_332.method_44379((int)x, (int)y, (int)(x + width), (int)(y + height - this.padding));
        this.renderContent(matrices, textRenderer, x, y + yOffset);
        int dividerY = y + yOffset + contentHeight + 2;
        this.renderDivider(matrices, x, dividerY, width);
        this.renderContent(matrices, textRenderer, x, y + yOffset + contentHeight + 4);
        class_332.method_44380();
    }

    private void renderDivider(class_4587 matrices, int x, int y, int width) {
        int lineWidth = (int)((double)width * 0.75);
        int lineStartX = x + (width - lineWidth) / 2;
        int adjustedY = y - (this.iconSize + this.lineSpacing * 4) / 2;
        class_332.method_25294((class_4587)matrices, (int)lineStartX, (int)adjustedY, (int)(lineStartX + lineWidth), (int)(adjustedY + 1), (int)-1);
    }

    private void renderContent(class_4587 matrices, class_327 textRenderer, int x, int y) {
        int yOffset = 0;
        for (int i = 0; i < this.textList.size(); ++i) {
            if (this.customIconTexture != null) {
                this.drawCustomIcon(matrices, x + this.padding, y + yOffset);
            } else if (i < this.itemStacks.size()) {
                class_1799 itemStack = this.itemStacks.get(i);
                this.drawItem(itemStack, x + this.padding, y + yOffset);
            }
            int n = this.iconSize / 2;
            Objects.requireNonNull(textRenderer);
            class_332.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)this.textList.get(i), (int)(x + this.iconSize + this.padding * 2), (int)(y + yOffset + (n - 9 / 2)), (int)this.textColor);
            yOffset += this.iconSize + this.lineSpacing;
        }
    }

    private int getTooltipWidth(class_327 textRenderer) {
        int maxWidth = textRenderer.method_27525((class_5348)class_2561.method_43470((String)this.categoryTitle).method_27694(style -> style.method_10982(Boolean.valueOf(true))));
        for (class_2561 text : this.textList) {
            int textWidth = textRenderer.method_27525((class_5348)text);
            if (textWidth <= maxWidth) continue;
            maxWidth = textWidth;
        }
        return maxWidth + this.iconSize + this.padding * 3;
    }

    private int getTooltipHeight() {
        return (this.textList.size() + 1) * (this.iconSize + this.lineSpacing) - this.lineSpacing + this.padding * 2;
    }

    private void drawBackground(class_4587 matrices, int x, int y, int width, int height) {
        if (this.backgroundTexture != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.backgroundTexture);
            class_332.method_25290((class_4587)matrices, (int)(x - this.padding), (int)(y - this.padding), (float)0.0f, (float)0.0f, (int)(width + this.padding * 2), (int)(height + this.padding * 2), (int)(width + this.padding * 2), (int)(height + this.padding * 2));
        } else {
            class_332.method_25294((class_4587)matrices, (int)(x - this.padding), (int)(y - this.padding), (int)(x + width + this.padding), (int)(y + height + this.padding), (int)this.backgroundColor);
        }
    }

    private void drawCustomIcon(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.customIconTexture);
        class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.customIconWidth, (int)this.customIconHeight, (int)this.customIconWidth, (int)this.customIconHeight);
    }

    private void drawItem(class_1799 itemStack, int x, int y) {
        class_310 client = class_310.method_1551();
        client.method_1480().method_27953(itemStack, x, y);
    }
}

