/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.craftsense.ui;

import com.dooji.craftsense.CraftSenseClient;
import com.dooji.craftsense.manager.CategoryHabitsTracker;
import com.dooji.craftsense.manager.CategoryManager;
import com.dooji.craftsense.omnilib.OmniButton;
import com.dooji.craftsense.ui.SliceInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class CraftSenseStatsScreen
extends class_437 {
    private final CategoryHabitsTracker tracker = CategoryHabitsTracker.getInstance();
    private Map<String, Integer> categoryTotals;
    private Map<String, List<Map.Entry<String, Integer>>> categoryItemsMap;
    private final Set<String> hiddenCategories = new HashSet<String>();
    private List<String> visibleCategories;
    private final Map<String, Integer> categoryColors = new HashMap<String, Integer>();
    private class_1011 pieImage;
    private class_1043 pieTexture;
    private class_2960 pieTextureId;
    private int pieTextureWidth;
    private int pieTextureHeight;
    private boolean pieNeedsUpdate = true;
    private OmniButton legendPrevBtn;
    private OmniButton legendNextBtn;
    private OmniButton closeButton;
    private int legendPage = 0;
    private int legendPages = 1;

    public CraftSenseStatsScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.craftsense.stats"));
        this.categoryTotals = new LinkedHashMap<String, Integer>();
        this.tracker.categoryCraftCount.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(entry -> this.categoryTotals.put((String)entry.getKey(), (Integer)entry.getValue()));
        this.categoryItemsMap = this.createCategoryItemsMap();
    }

    private Map<String, List<Map.Entry<String, Integer>>> createCategoryItemsMap() {
        HashMap<String, List<Map.Entry<String, Integer>>> categoryMap = new HashMap<String, List<Map.Entry<String, Integer>>>();
        for (String category : this.tracker.categoryCraftCount.keySet()) {
            ArrayList<Map.Entry<String, Integer>> items = new ArrayList<Map.Entry<String, Integer>>();
            for (Map.Entry<String, Integer> entry : this.tracker.itemCraftCount.entrySet()) {
                String translationKey = entry.getKey();
                Optional<class_1792> optionalItem = class_2378.field_11142.method_10220().filter(item -> item.method_7876().equals(translationKey)).findFirst();
                if (!optionalItem.isPresent() || !category.equals(CategoryManager.getCategory(optionalItem.get()))) continue;
                items.add(entry);
            }
            items.sort((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue()));
            categoryMap.put(category, items);
        }
        return categoryMap;
    }

    protected void method_25426() {
        this.recalculateStats();
        this.closeButton = CraftSenseClient.createOmniButton(this.field_22789 / 2 - 40, this.field_22790 - 40, 80, 20, (class_2561)class_2561.method_43471((String)"screen.craftsense.stats.done"), -1728053248, -1157627904, -1, -1052689, () -> ((CraftSenseStatsScreen)this).method_25419());
        this.method_37063((class_364)this.closeButton);
        if (!this.categoryTotals.isEmpty()) {
            this.legendPrevBtn = CraftSenseClient.createOmniButton(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"<"), -1728053248, -1157627904, -1, -1052689, () -> {
                if (this.legendPage > 0) {
                    --this.legendPage;
                }
            });
            this.method_37063((class_364)this.legendPrevBtn);
            this.legendNextBtn = CraftSenseClient.createOmniButton(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)">"), -1728053248, -1157627904, -1, -1052689, () -> {
                if (this.legendPage < this.legendPages - 1) {
                    ++this.legendPage;
                }
            });
            this.method_37063((class_364)this.legendNextBtn);
        }
    }

    private void recalculateStats() {
        this.categoryTotals = new LinkedHashMap<String, Integer>();
        this.tracker.categoryCraftCount.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(entry -> this.categoryTotals.put((String)entry.getKey(), (Integer)entry.getValue()));
        this.categoryItemsMap = new HashMap<String, List<Map.Entry<String, Integer>>>();
        for (String category : this.tracker.categoryCraftCount.keySet()) {
            ArrayList<Map.Entry<String, Integer>> items = new ArrayList<Map.Entry<String, Integer>>();
            for (Map.Entry<String, Integer> entry2 : this.tracker.itemCraftCount.entrySet()) {
                String translationKey = entry2.getKey();
                Optional<class_1792> optionalItem = class_2378.field_11142.method_10220().filter(item -> item.method_7876().equals(translationKey)).findFirst();
                if (!optionalItem.isPresent() || !category.equals(CategoryManager.getCategory(optionalItem.get()))) continue;
                items.add(entry2);
            }
            items.sort((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue()));
            this.categoryItemsMap.put(category, items);
        }
        this.visibleCategories = new ArrayList<String>(this.categoryTotals.keySet());
        for (String category : this.categoryTotals.keySet()) {
            if (this.categoryColors.containsKey(category)) continue;
            this.categoryColors.put(category, this.generateColorFromString(category));
        }
        int catsPerPage = 8;
        this.legendPages = (int)Math.ceil((double)this.visibleCategories.size() / (double)catsPerPage);
        if (this.legendPage >= this.legendPages && this.legendPages > 0) {
            this.legendPage = this.legendPages - 1;
        }
        this.pieNeedsUpdate = true;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        class_332.method_35719((class_4587)matrices, (class_327)this.field_22793, (class_5481)this.field_22785.method_30937(), (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        if (this.pieNeedsUpdate) {
            this.generatePieTexture();
            this.pieNeedsUpdate = false;
        }
        int titleBottom = 30;
        int doneButtonTop = this.field_22790 - 40;
        int areaHeight = doneButtonTop - titleBottom;
        int areaCenterY = titleBottom + areaHeight / 2;
        this.renderPieChart(matrices, mouseX, mouseY, areaCenterY);
        this.renderLegend(matrices, areaCenterY);
        if (this.categoryTotals.isEmpty()) {
            class_332.method_35719((class_4587)matrices, (class_327)this.field_22793, (class_5481)class_2561.method_30163((String)class_2561.method_43471((String)"screen.craftsense.no_history").getString()).method_30937(), (int)(this.field_22789 / 2), (int)areaCenterY, (int)0xAAAAAA);
        }
    }

    private void renderPieChart(class_4587 matrices, int mouseX, int mouseY, int areaCenterY) {
        if (this.pieTexture == null) {
            return;
        }
        int drawY = areaCenterY - this.pieTextureHeight / 2;
        int totalWidth = this.pieTextureWidth + 100;
        int cx = (this.field_22789 - totalWidth) / 2;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.pieTextureId);
        class_332.method_25290((class_4587)matrices, (int)cx, (int)drawY, (float)0.0f, (float)0.0f, (int)this.pieTextureWidth, (int)this.pieTextureHeight, (int)this.pieTextureWidth, (int)this.pieTextureHeight);
        int radius = Math.min(100, (this.pieTextureHeight - 40) / 2);
        int centerX = cx + (radius + 20);
        int centerY = drawY + (radius + 20);
        this.handlePieHover(matrices, mouseX, mouseY, centerX, centerY, radius);
    }

    private void renderLegend(class_4587 matrices, int areaCenterY) {
        if (this.categoryTotals.isEmpty()) {
            return;
        }
        int catsPerPage = 8;
        int startIndex = this.legendPage * catsPerPage;
        int endIndex = Math.min(this.visibleCategories.size(), startIndex + catsPerPage);
        String pageText = this.legendPage + 1 + "/" + this.legendPages;
        int totalWidth = this.pieTextureWidth + 100;
        int cx = (this.field_22789 - totalWidth) / 2 + this.pieTextureWidth + 10;
        int legendWidth = 80;
        int legendBoxHeight = 12 * catsPerPage;
        int paginationHeight = 20;
        int totalLegendHeight = legendBoxHeight + paginationHeight + 5;
        int legendTop = areaCenterY - totalLegendHeight / 2 + paginationHeight + 5;
        int paginationY = legendTop - paginationHeight - 5;
        this.legendPrevBtn.setX(cx);
        this.legendNextBtn.setX(cx + legendWidth - 20);
        this.legendPrevBtn.setY(paginationY);
        this.legendNextBtn.setY(paginationY);
        int midX = cx + legendWidth / 2;
        class_332.method_35719((class_4587)matrices, (class_327)this.field_22793, (class_5481)class_2561.method_30163((String)pageText).method_30937(), (int)midX, (int)(paginationY + 5), (int)0xFFFFFF);
        for (int i = startIndex; i < endIndex; ++i) {
            String category = this.visibleCategories.get(i);
            boolean hidden = this.hiddenCategories.contains(category);
            int color = this.getCategoryColor(category);
            if (hidden) {
                color = this.darken(color, 0.4f);
            }
            int lineY = legendTop + (i - startIndex) * 12;
            class_332.method_25294((class_4587)matrices, (int)cx, (int)lineY, (int)(cx + 10), (int)(lineY + 10), (int)color);
            String displayStr = category.substring(0, 1).toUpperCase() + category.substring(1).toLowerCase();
            class_5250 display = hidden ? class_2561.method_43470((String)displayStr).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_36139(-5592406)) : class_2561.method_43470((String)displayStr).method_27694(style -> style.method_36139(-1));
            int textStartX = cx + 12;
            int textEndX = cx + legendWidth;
            int textStartY = lineY + 2;
            int textEndY = lineY + 12;
            class_332.method_44379((int)textStartX, (int)textStartY, (int)textEndX, (int)textEndY);
            CraftSenseStatsScreen.renderScrollableText(matrices, this.field_22793, (class_2561)display, textStartX, textStartY, textEndX, textEndY, 0xFFFFFF);
            class_332.method_44380();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        int catsPerPage = 8;
        int startIndex = this.legendPage * catsPerPage;
        int endIndex = Math.min(this.visibleCategories.size(), startIndex + catsPerPage);
        int totalWidth = this.pieTextureWidth + 100;
        int cx = (this.field_22789 - totalWidth) / 2 + this.pieTextureWidth + 10;
        int legendWidth = 80;
        int legendBoxHeight = 12 * catsPerPage;
        int paginationHeight = 20;
        int totalLegendHeight = legendBoxHeight + paginationHeight + 5;
        int legendTop = (this.field_22790 - totalLegendHeight) / 2 + paginationHeight + 5;
        for (int i = startIndex; i < endIndex; ++i) {
            int lineY = legendTop + (i - startIndex) * 12;
            if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + legendWidth)) || !(mouseY >= (double)lineY) || !(mouseY < (double)(lineY + 10))) continue;
            String category = this.visibleCategories.get(i);
            if (this.hiddenCategories.contains(category)) {
                this.hiddenCategories.remove(category);
            } else {
                this.hiddenCategories.add(category);
            }
            this.pieNeedsUpdate = true;
            break;
        }
        return true;
    }

    private int getCategoryColor(String category) {
        return this.categoryColors.getOrDefault(category, this.generateColorFromString(category));
    }

    private int generateColorFromString(String str) {
        int hash = str.hashCode();
        float hue = (float)(Math.abs(hash) % 360) / 360.0f;
        float saturation = 0.7f;
        float brightness = 0.9f;
        int rgb = Color.HSBtoRGB(hue, saturation, brightness);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    private void generatePieTexture() {
        if (this.pieTexture != null) {
            class_310.method_1551().method_1531().method_4615(this.pieTextureId);
            this.pieTexture.close();
            this.pieTexture = null;
        }
        int radius = 80;
        int margin = 20;
        this.pieTextureWidth = radius * 2 + margin * 2;
        this.pieTextureHeight = radius * 2 + margin * 2;
        this.pieImage = new class_1011(class_1011.class_1012.field_4997, this.pieTextureWidth, this.pieTextureHeight, false);
        this.pieImage.method_4326(0, 0, this.pieTextureWidth, this.pieTextureHeight, 0);
        class_1159 transform = new class_1159();
        transform.method_22668();
        transform.method_22672(class_1159.method_24021((float)(radius + margin), (float)(radius + margin), (float)0.0f));
        class_1158 rotation = new class_1158(45.0f, 0.0f, 0.0f, true);
        transform.method_22670(rotation);
        transform.method_22672(class_1159.method_24021((float)(-(radius + margin)), (float)(-(radius + margin)), (float)0.0f));
        int total = 0;
        for (Map.Entry<String, Integer> e : this.categoryTotals.entrySet()) {
            if (this.hiddenCategories.contains(e.getKey())) continue;
            total += e.getValue().intValue();
        }
        ArrayList<SliceInfo> slices = new ArrayList<SliceInfo>();
        float accumulatedAngle = 0.0f;
        for (Map.Entry<String, Integer> e : this.categoryTotals.entrySet()) {
            if (this.hiddenCategories.contains(e.getKey())) continue;
            float fraction = total == 0 ? 0.0f : (float)e.getValue().intValue() / (float)total;
            float angle = 360.0f * fraction;
            slices.add(new SliceInfo(e.getKey(), accumulatedAngle, accumulatedAngle + angle));
            accumulatedAngle += angle;
        }
        if (slices.size() == 1) {
            SliceInfo singleSlice = (SliceInfo)slices.get(0);
            int color = this.getCategoryColor(singleSlice.category);
            this.fillCircleWithThickness(this.pieImage, radius + margin, radius + margin, radius, color, transform, 6);
        } else {
            int thickness = 6;
            int centerX = radius + margin;
            int centerY = radius + margin;
            int minX = centerX - radius;
            int maxX = centerX + radius;
            int minY = centerY - radius;
            int maxY = centerY + radius;
            for (int px = minX; px <= maxX; ++px) {
                float dx = px - centerX;
                for (int py = minY; py <= maxY; ++py) {
                    float dy = py - centerY;
                    if (!(dx * dx + dy * dy <= (float)(radius * radius))) continue;
                    float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
                    if (angle < 0.0f) {
                        angle += 360.0f;
                    }
                    int colorArgb = 0;
                    for (SliceInfo slice : slices) {
                        if (!this.isAngleInSlice(angle, slice.startAngle, slice.endAngle)) continue;
                        colorArgb = this.getCategoryColor(slice.category);
                        break;
                    }
                    if (colorArgb == 0) continue;
                    int color = colorArgb & 0xFF00FF00 | (colorArgb & 0xFF0000) >> 16 | (colorArgb & 0xFF) << 16;
                    class_1162 pos = new class_1162((float)px, (float)py, 0.0f, 1.0f);
                    pos.method_22674(transform);
                    int rx = (int)pos.method_4953();
                    int ry = (int)pos.method_4956();
                    if (rx >= 0 && rx < this.pieImage.method_4307() && ry >= 0 && ry < this.pieImage.method_4323()) {
                        this.pieImage.method_4305(rx, ry, color);
                    }
                    int darkColor = this.darken(colorArgb, 0.5f);
                    color = darkColor & 0xFF00FF00 | (darkColor & 0xFF0000) >> 16 | (darkColor & 0xFF) << 16;
                    for (int t = 1; t <= thickness; ++t) {
                        int wallY = ry + t;
                        if (wallY < 0 || wallY >= this.pieImage.method_4323()) continue;
                        this.pieImage.method_4305(rx, wallY, color);
                    }
                }
            }
        }
        this.pieTexture = new class_1043(this.pieImage);
        this.pieTextureId = class_310.method_1551().method_1531().method_4617("craftsense_pie", this.pieTexture);
    }

    private void fillCircleWithThickness(class_1011 image, int centerX, int centerY, int radius, int colorArgb, class_1159 transform, int thickness) {
        int minX = centerX - radius;
        int maxX = centerX + radius;
        int minY = centerY - radius;
        int maxY = centerY + radius;
        for (int px = minX; px <= maxX; ++px) {
            float dx = px - centerX;
            for (int py = minY; py <= maxY; ++py) {
                float dy = py - centerY;
                if (!(dx * dx + dy * dy <= (float)(radius * radius))) continue;
                class_1162 pos = new class_1162((float)px, (float)py, 0.0f, 1.0f);
                pos.method_22674(transform);
                int rx = (int)pos.method_4953();
                int ry = (int)pos.method_4956();
                int color = colorArgb & 0xFF00FF00 | (colorArgb & 0xFF0000) >> 16 | (colorArgb & 0xFF) << 16;
                if (rx >= 0 && rx < image.method_4307() && ry >= 0 && ry < image.method_4323()) {
                    image.method_4305(rx, ry, color);
                }
                int darkColor = this.darken(colorArgb, 0.5f);
                color = darkColor & 0xFF00FF00 | (darkColor & 0xFF0000) >> 16 | (darkColor & 0xFF) << 16;
                for (int t = 1; t <= thickness; ++t) {
                    int wallY = ry + t;
                    if (wallY < 0 || wallY >= image.method_4323()) continue;
                    image.method_4305(rx, wallY, color);
                }
            }
        }
    }

    private boolean isAngleInSlice(float angle, float startDeg, float endDeg) {
        if ((startDeg %= 360.0f) < 0.0f) {
            startDeg += 360.0f;
        }
        if ((endDeg %= 360.0f) < 0.0f) {
            endDeg += 360.0f;
        }
        if (endDeg >= startDeg) {
            return angle >= startDeg && angle <= endDeg;
        }
        return angle >= startDeg && angle < 360.0f || angle >= 0.0f && angle <= endDeg;
    }

    private int darken(int color, float factor) {
        int a = color >>> 24 & 0xFF;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((float)r * factor);
        g = (int)((float)g * factor);
        b = (int)((float)b * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void handlePieHover(class_4587 matrices, int mouseX, int mouseY, int cx, int cy, int radius) {
        float dx = mouseX - cx;
        float dy = mouseY - cy;
        if (dx * dx + dy * dy <= (float)(radius * radius)) {
            List<Map.Entry> visibleSlices = this.categoryTotals.entrySet().stream().filter(e -> !this.hiddenCategories.contains(e.getKey())).toList();
            if (visibleSlices.size() == 1) {
                String category = (String)visibleSlices.get(0).getKey();
                this.showTooltipForCategory(matrices, category, mouseX, mouseY);
            } else {
                float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
                if (angle < 0.0f) {
                    angle += 360.0f;
                }
                int total = 0;
                ArrayList<Map.Entry<String, Integer>> slices = new ArrayList<Map.Entry<String, Integer>>();
                for (Map.Entry<String, Integer> e2 : this.categoryTotals.entrySet()) {
                    if (this.hiddenCategories.contains(e2.getKey())) continue;
                    total += e2.getValue().intValue();
                    slices.add(e2);
                }
                float accum = 0.0f;
                for (Map.Entry entry : slices) {
                    float start = accum;
                    float fraction = total == 0 ? 0.0f : (float)((Integer)entry.getValue()).intValue() / (float)total;
                    float sliceAngle = 360.0f * fraction;
                    float end = accum + sliceAngle;
                    if (this.isAngleInSlice(angle, start, end)) {
                        String category = (String)entry.getKey();
                        this.showTooltipForCategory(matrices, category, mouseX, mouseY);
                        break;
                    }
                    accum += sliceAngle;
                }
            }
        }
    }

    private void showTooltipForCategory(class_4587 matrices, String category, int mouseX, int mouseY) {
        List items = this.categoryItemsMap.getOrDefault(category, List.of());
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        ArrayList lines = new ArrayList();
        for (Map.Entry itE : items) {
            class_2378.field_11142.method_10220().filter(it -> it.method_7876().equals(itE.getKey())).findFirst().ifPresent(it -> {
                stacks.add(it.method_7854());
                lines.add(class_2561.method_43470((String)(it.method_7848().getString() + " - " + this.formatNumberShorthand((Integer)itE.getValue()))));
            });
        }
        CraftSenseClient.showTooltip(matrices, this.field_22793, category, stacks, lines.isEmpty() ? List.of(class_2561.method_43471((String)"tooltip.craftsense.no_items_found")) : lines, -1728053248, null, 0xFFFFFF, null, mouseX + 10, mouseY + 10);
    }

    private String formatNumberShorthand(int number) {
        if (number >= 1000000000) {
            return String.format("%.1fB", (double)number / 1.0E9);
        }
        if (number >= 1000000) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.valueOf(number);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private static void renderScrollableText(class_4587 matrices, class_327 textRenderer, class_2561 text, int startX, int startY, int endX, int endY, int color) {
        int textWidth = textRenderer.method_27525((class_5348)text);
        int availableWidth = endX - startX;
        int pauseTime = 1000;
        double scrollSpeed = 5.0;
        if (textWidth > availableWidth) {
            int scrollOffset;
            long totalCycleTime;
            int overflowWidth = textWidth - availableWidth;
            long currentTime = System.currentTimeMillis();
            long timeInCycle = currentTime % (totalCycleTime = (long)((double)overflowWidth / scrollSpeed * 1000.0) * 2L + (long)(pauseTime * 2));
            if (timeInCycle < (long)pauseTime) {
                scrollOffset = 0;
            } else if ((double)timeInCycle < (double)pauseTime + (double)overflowWidth / scrollSpeed * 1000.0) {
                double elapsed = timeInCycle - (long)pauseTime;
                scrollOffset = (int)(elapsed * scrollSpeed / 1000.0);
            } else if ((double)timeInCycle < (double)pauseTime + (double)overflowWidth / scrollSpeed * 1000.0 + (double)pauseTime) {
                scrollOffset = overflowWidth;
            } else {
                double elapsed = (double)(timeInCycle - (long)pauseTime) - (double)overflowWidth / scrollSpeed * 1000.0 - (double)pauseTime;
                scrollOffset = overflowWidth - (int)(elapsed * scrollSpeed / 1000.0);
            }
            class_332.method_44379((int)startX, (int)startY, (int)endX, (int)endY);
            class_332.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)text, (int)(startX - scrollOffset), (int)(startY + (endY - startY - 9) / 2), (int)color);
            class_332.method_44380();
        } else {
            class_332.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)text, (int)startX, (int)(startY + (endY - startY - 9) / 2), (int)color);
        }
    }
}

