/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.brewinandchewin.recipe;

import com.google.common.cache.CacheBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.stream.Stream;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.recipe.RecipeConverter;
import umpaz.brewinandchewin.common.crafting.CreatePotionPouringRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;

public class KegPouringRecipeConverters {
    public static final RecipeConverter<KegPouringRecipe, FillingRecipe> FILLING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        KegPouringRecipe recipe = (KegPouringRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_as_filling");
        ItemStack container = recipe.getContainer();
        ItemStack output = recipe.getOutput();
        FluidStack fluid = (FluidStack)recipe.getFluid(output).loaderSpecific();
        StandardProcessingRecipe.Builder builder = (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(FillingRecipe::new, id).require(Ingredient.of((ItemStack[])new ItemStack[]{container}))).require(FluidIngredient.fromFluidStack((FluidStack)fluid))).output(output);
        return new RecipeHolder(id, (Recipe)((FillingRecipe)builder.build()));
    });
    public static final RecipeConverter<KegPouringRecipe, EmptyingRecipe> EMPTYING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        KegPouringRecipe recipe = (KegPouringRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_as_emptying");
        ItemStack container = recipe.getContainer();
        ItemStack output = recipe.getOutput();
        FluidStack fluid = (FluidStack)recipe.getFluid(output).loaderSpecific();
        StandardProcessingRecipe.Builder builder = (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(EmptyingRecipe::new, id).require(Ingredient.of((ItemStack[])new ItemStack[]{output}))).output(fluid);
        if (!container.isEmpty()) {
            builder.output(container);
        }
        return new RecipeHolder(id, (Recipe)((EmptyingRecipe)builder.build()));
    });

    public static Stream<RecipeHolder<FillingRecipe>> getKegFillingRecipes(Level level) {
        return RecipeFinder.get(FILLING, (Level)level, holder -> holder.value() instanceof KegPouringRecipe && KegPouringRecipeConverters.canConvertToFilling((RecipeHolder<KegPouringRecipe>)holder)).stream().map(holder -> holder).map(FILLING);
    }

    public static Stream<RecipeHolder<EmptyingRecipe>> getKegEmptyingRecipes(Level level) {
        return RecipeFinder.get(EMPTYING, (Level)level, holder -> holder.value() instanceof KegPouringRecipe && KegPouringRecipeConverters.canConvertToEmptying((RecipeHolder<KegPouringRecipe>)holder)).stream().map(holder -> holder).map(EMPTYING);
    }

    private static boolean canConvertToFilling(RecipeHolder<KegPouringRecipe> holder) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(holder)) {
            return false;
        }
        KegPouringRecipe recipe = (KegPouringRecipe)holder.value();
        if (recipe instanceof CreatePotionPouringRecipe) {
            return false;
        }
        ItemStack filled = recipe.getOutput();
        if (filled.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            return false;
        }
        return holder.id().getNamespace().equals(RegisteredObjectsHelper.getKeyOrThrow((Item)filled.getItem()).getNamespace());
    }

    private static boolean canConvertToEmptying(RecipeHolder<KegPouringRecipe> holder) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(holder)) {
            return false;
        }
        KegPouringRecipe recipe = (KegPouringRecipe)holder.value();
        if (recipe instanceof CreatePotionPouringRecipe || !recipe.canFill()) {
            return false;
        }
        ItemStack filled = recipe.getOutput();
        if (filled.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            return false;
        }
        return holder.id().getNamespace().equals(RegisteredObjectsHelper.getKeyOrThrow((Item)filled.getItem()).getNamespace());
    }
}

