/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.mojang.brigadier.context.CommandContext;
import com.tiers.InventoryChecker;
import com.tiers.PlayerProfileQueue;
import com.tiers.misc.CommandRegister;
import com.tiers.misc.ConfigManager;
import com.tiers.misc.Modes;
import com.tiers.profile.GameMode;
import com.tiers.profile.PlayerProfile;
import com.tiers.profile.Status;
import com.tiers.profile.types.SuperProfile;
import com.tiers.screens.ConfigScreen;
import com.tiers.screens.PlayerSearchResultScreen;
import com.tiers.textures.ColorControl;
import com.tiers.textures.ColorLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TiersClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(TiersClient.class);
    public static String userAgent = "Tiers";
    private static final ArrayList<PlayerProfile> playerProfiles = new ArrayList();
    private static final HashMap<String, class_2561> playerTexts = new HashMap();
    public static boolean toggleMod = true;
    public static boolean showIcons = true;
    public static boolean isSeparatorAdaptive = true;
    public static ModesTierDisplay displayMode = ModesTierDisplay.ADAPTIVE_HIGHEST;
    public static DisplayStatus mcTiersCOMPosition = DisplayStatus.LEFT;
    public static Modes activeMCTiersCOMMode = Modes.MCTIERSCOM_VANILLA;
    public static DisplayStatus mcTiersIOPosition = DisplayStatus.RIGHT;
    public static Modes activeMCTiersIOMode = Modes.MCTIERSIO_CRYSTAL;
    public static DisplayStatus subtiersNETPosition = DisplayStatus.OFF;
    public static Modes activeSubtiersNETMode = Modes.SUBTIERSNET_MINECART;
    private static class_304 autoDetectKey;
    private static class_304 cycleRightKey;
    private static class_304 cycleLeftKey;
    private static boolean seenMainMenu;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        TiersClient.clearCache(true);
        CommandRegister.registerCommands();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!seenMainMenu && screen instanceof class_442) {
                seenMainMenu = true;
                CompletableFuture.delayedExecutor(2000L, TimeUnit.MILLISECONDS).execute(() -> {
                    ConfigScreen.ownProfile = new PlayerProfile(client.method_1548().method_1677().getName(), false);
                    PlayerProfileQueue.enqueue(ConfigScreen.ownProfile);
                    ConfigScreen.defaultProfile = new PlayerProfile("{\"id\":\"3b653c04f2d9422a87e7ccf8b146c350\",\"name\":\"TheRandomizer\"}", "{\"uuid\":\"3b653c04f2d9422a87e7ccf8b146c350\",\"name\":\"TheRandomizer\",\"rankings\":{\"axe\":{\"tier\":1,\"pos\":0,\"peak_tier\":1,\"peak_pos\":0,\"attained\":1701927844,\"retired\":true},\"smp\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1712888458,\"retired\":false},\"sword\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1733880489,\"retired\":false},\"uhc\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1709746421,\"retired\":false},\"vanilla\":{\"tier\":4,\"pos\":0,\"peak_tier\":4,\"peak_pos\":0,\"attained\":1713570014,\"retired\":false},\"nethop\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1710301241,\"retired\":false},\"pot\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1723349754,\"retired\":false},\"mace\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1737168704,\"retired\":false}},\"region\":\"NA\",\"points\":116,\"overall\":28,\"badges\":[{\"title\":\"Axe Champion\",\"desc\":\"Attained T1+ in Axe for any amount of time\"},{\"title\":\"Axe Expert\",\"desc\":\"Attained T2+ in Axe for any amount of time\"},{\"title\":\"Adventurous\",\"desc\":\"Attained a tier on every present current gamemode\"},{\"title\":\"Holding The Crown\",\"desc\":\"T1 category of 1 gamemode for 30 days or more\"}],\"combat_master\":false}", "{\"uuid\":\"3b653c04f2d9422a87e7ccf8b146c350\",\"name\":\"TheRandomizer\",\"rankings\":{\"pot\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1723349754,\"retired\":false},\"crystal\":{\"tier\":4,\"pos\":0,\"peak_tier\":4,\"peak_pos\":0,\"attained\":1713570014,\"retired\":false},\"uhc\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1709746421,\"retired\":false},\"sword\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1733880489,\"retired\":false},\"smp\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1712888458,\"retired\":false},\"neth_pot\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1710301241,\"retired\":false},\"axe\":{\"tier\":1,\"pos\":1,\"peak_tier\":1,\"peak_pos\":1,\"attained\":1744884400,\"retired\":true}},\"region\":\"EU\",\"points\":90,\"overall\":44,\"badges\":[{\"title\":\"Axe Champion\",\"desc\":\"Attained T1+ in Axe for any amount of time\"},{\"title\":\"Axe Expert\",\"desc\":\"Attained T2+ in Axe for any amount of time\"},{\"title\":\"Adventurous\",\"desc\":\"Attained a tier on every present current gamemode\"},{\"title\":\"Holding The Crown\",\"desc\":\"T1 category of 1 gamemode for 30 days or more\"}]}", "{\"uuid\":\"3b653c04f2d9422a87e7ccf8b146c350\",\"name\":\"TheRandomizer\",\"rankings\":{\"bed\":{\"tier\":4,\"pos\":0,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1748753398,\"retired\":false},\"speed\":{\"tier\":1,\"pos\":1,\"peak_tier\":1,\"peak_pos\":1,\"attained\":1747584669,\"retired\":false},\"dia_smp\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1734383100,\"retired\":false},\"og_vanilla\":{\"tier\":2,\"pos\":0,\"peak_tier\":2,\"peak_pos\":0,\"attained\":1746316718,\"retired\":true},\"bow\":{\"tier\":4,\"pos\":1,\"peak_tier\":4,\"peak_pos\":1,\"attained\":1747630846,\"retired\":false},\"debuff\":{\"tier\":2,\"pos\":1,\"peak_tier\":2,\"peak_pos\":1,\"attained\":1746668477,\"retired\":false},\"manhunt\":{\"tier\":2,\"pos\":1,\"peak_tier\":2,\"peak_pos\":1,\"attained\":1736014926,\"retired\":true},\"trident\":{\"tier\":3,\"pos\":0,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1741136796,\"retired\":false},\"elytra\":{\"tier\":2,\"pos\":1,\"peak_tier\":2,\"peak_pos\":1,\"attained\":1747112500,\"retired\":false},\"dia_crystal\":{\"tier\":3,\"pos\":1,\"peak_tier\":3,\"peak_pos\":1,\"attained\":1747589669,\"retired\":false},\"minecart\":{\"tier\":3,\"pos\":0,\"peak_tier\":3,\"peak_pos\":0,\"attained\":1747032612,\"retired\":false},\"creeper\":{\"tier\":1,\"pos\":0,\"peak_tier\":1,\"peak_pos\":0,\"attained\":1748398520,\"retired\":false}},\"region\":\"NA\",\"points\":236,\"overall\":1,\"badges\":[{\"title\":\"Speed Expert\",\"desc\":\"Attained T2+ in Speed for any amount of time\"},{\"title\":\"Creeper Expert\",\"desc\":\"Attained T2+ in Creeper for any amount of time\"},{\"title\":\"OG Vanilla Expert\",\"desc\":\"Attained T2+ in OG Vanilla for any amount of time\"},{\"title\":\"Manhunt Expert\",\"desc\":\"Attained T2+ in Manhunt for any amount of time\"},{\"title\":\"Adventurous\",\"desc\":\"Attained a tier on every present current gamemode\"},{\"title\":\"Creeper Champion\",\"desc\":\"Attained T1+ in Creeper for any amount of time\"},{\"title\":\"DeBuff Expert\",\"desc\":\"Attained T2+ in DeBuff for any amount of time\"},{\"title\":\"Holding The Crown\",\"desc\":\"T1 category of 1 gamemode for 30 days or more\"},{\"title\":\"Elytra Expert\",\"desc\":\"Attained T2+ in Elytra for any amount of time\"},{\"title\":\"Speed Champion\",\"desc\":\"Attained T1+ in Speed for any amount of time\"}],\"combat_master\":false}");
                });
            }
        });
        Optional fabricLoader = FabricLoader.getInstance().getModContainer("tiers");
        if (fabricLoader.isPresent()) {
            fabricLoader.ifPresent(tiers -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_43902((String)"tiers", (String)"modern"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
            fabricLoader.ifPresent(tiers -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_43902((String)"tiers", (String)"classic"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
            userAgent = "Tiers " + ((ModContainer)fabricLoader.get()).getMetadata().getVersion().getFriendlyString() + " on " + class_310.method_1551().method_1515() + " played by " + class_310.method_1551().method_1548().method_1677().getName();
        } else {
            LOGGER.warn("Error initializing Tiers. Please report this issue: https://github.com/Flavio6561/Tiers/issues");
        }
        autoDetectKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Auto Detect Kit", 89, "Tiers"));
        cycleRightKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Right Gamemodes", 73, "Tiers"));
        cycleLeftKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Left Gamemodes", 85, "Tiers"));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ColorLoader());
        ClientTickEvents.END_CLIENT_TICK.register(TiersClient::tickUtils);
        LOGGER.info("Tiers initialized | User agent: {}", (Object)userAgent);
    }

    public static class_2561 getModifiedNametag(String originalName, class_2561 originalNameText) {
        PlayerProfile profile = TiersClient.addGetPlayer(originalName, false);
        if (profile.status == Status.READY && (profile.originalNameText == null || profile.originalNameText != originalNameText)) {
            TiersClient.updatePlayerNametag(originalNameText, profile);
        }
        if (playerTexts.containsKey(originalName)) {
            return playerTexts.get(originalName);
        }
        return originalNameText;
    }

    public static class_2561 getNametag(PlayerProfile profile) {
        if (!toggleMod || profile.status != Status.READY) {
            return profile.originalNameText;
        }
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        if (mcTiersCOMPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        } else if (mcTiersCOMPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        }
        if (mcTiersIOPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersIOProfile, activeMCTiersIOMode);
        } else if (mcTiersIOPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersIOProfile, activeMCTiersIOMode);
        }
        if (subtiersNETPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.subtiersNETProfile, activeSubtiersNETMode);
        } else if (subtiersNETPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.subtiersNETProfile, activeSubtiersNETMode);
        }
        return class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(profile.originalNameText).method_10852((class_2561)rightText);
    }

    private static void updateAllTags() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY || profile.originalNameText == null) continue;
            TiersClient.updatePlayerNametag(profile.originalNameText, profile);
        }
        if (ConfigScreen.ownProfile.status == Status.READY) {
            TiersClient.updatePlayerNametag(ConfigScreen.ownProfile.originalNameText, ConfigScreen.ownProfile);
        }
        TiersClient.updatePlayerNametag(ConfigScreen.defaultProfile.originalNameText, ConfigScreen.defaultProfile);
    }

    private static void updatePlayerNametag(class_2561 originalNameText, PlayerProfile profile) {
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        if (mcTiersCOMPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        } else if (mcTiersCOMPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        }
        if (mcTiersIOPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersIOProfile, activeMCTiersIOMode);
        } else if (mcTiersIOPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersIOProfile, activeMCTiersIOMode);
        }
        if (subtiersNETPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.subtiersNETProfile, activeSubtiersNETMode);
        } else if (subtiersNETPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.subtiersNETProfile, activeSubtiersNETMode);
        }
        playerTexts.put(profile.name, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(originalNameText).method_10852((class_2561)rightText));
        profile.originalNameText = originalNameText;
    }

    private static class_2561 updateProfileNameTagRight(SuperProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)separator).method_10852(shown.displayedTier));
            if (showIcons) {
                returnValue.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852(shown.name.iconTag));
            }
        }
        return returnValue;
    }

    private static class_2561 updateProfileNameTagLeft(SuperProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            if (showIcons) {
                returnValue = class_2561.method_43470((String)"").method_10852(shown.name.iconTag).method_27693(" ");
            }
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852(shown.displayedTier).method_10852((class_2561)separator));
        }
        return returnValue;
    }

    public static void restyleAllTexts() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY) continue;
            if (profile.mcTiersCOMProfile.status == Status.READY) {
                profile.mcTiersCOMProfile.parseJson(profile.mcTiersCOMProfile.originalJson);
            }
            if (profile.mcTiersIOProfile.status == Status.READY) {
                profile.mcTiersIOProfile.parseJson(profile.mcTiersIOProfile.originalJson);
            }
            if (profile.subtiersNETProfile.status != Status.READY) continue;
            profile.subtiersNETProfile.parseJson(profile.subtiersNETProfile.originalJson);
        }
    }

    private static void tickUtils(class_310 client) {
        class_2561 message;
        if (autoDetectKey.method_1436()) {
            InventoryChecker.checkInventory(client);
        }
        if (cycleRightKey.method_1436()) {
            message = TiersClient.cycleRightMode();
            if (message != null) {
                TiersClient.sendMessageToPlayer(message, true);
            } else {
                TiersClient.sendMessageToPlayer((class_2561)class_2561.method_43470((String)"There's nothing on the right display").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("red"))), true);
            }
        }
        if (cycleLeftKey.method_1436()) {
            message = TiersClient.cycleLeftMode();
            if (message != null) {
                TiersClient.sendMessageToPlayer(message, true);
            } else {
                TiersClient.sendMessageToPlayer((class_2561)class_2561.method_43470((String)"There's nothing on the left display").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("red"))), true);
            }
        }
    }

    public static class_2561 cycleRightMode() {
        if (mcTiersCOMPosition.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (MCTiersCOM) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersCOMMode());
        }
        if (mcTiersIOPosition.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (MCTiersIO) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersIOMode());
        }
        if (subtiersNETPosition.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (SubtiersNET) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleSubtiersNETMode());
        }
        return null;
    }

    public static class_2561 cycleLeftMode() {
        if (mcTiersCOMPosition.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (MCTiersCOM) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersCOMMode());
        }
        if (mcTiersIOPosition.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (MCTiersIO) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersIOMode());
        }
        if (subtiersNETPosition.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (SubtiersNET) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleSubtiersNETMode());
        }
        return null;
    }

    public static class_2561 getRightIcon() {
        if (mcTiersCOMPosition.toString().equalsIgnoreCase("RIGHT")) {
            return TiersClient.activeMCTiersCOMMode.icon;
        }
        if (mcTiersIOPosition.toString().equalsIgnoreCase("RIGHT")) {
            return TiersClient.activeMCTiersIOMode.icon;
        }
        if (subtiersNETPosition.toString().equalsIgnoreCase("RIGHT")) {
            return TiersClient.activeSubtiersNETMode.icon;
        }
        return class_2561.method_30163((String)"");
    }

    public static class_2561 getLeftIcon() {
        if (mcTiersCOMPosition.toString().equalsIgnoreCase("LEFT")) {
            return TiersClient.activeMCTiersCOMMode.icon;
        }
        if (mcTiersIOPosition.toString().equalsIgnoreCase("LEFT")) {
            return TiersClient.activeMCTiersIOMode.icon;
        }
        if (subtiersNETPosition.toString().equalsIgnoreCase("LEFT")) {
            return TiersClient.activeSubtiersNETMode.icon;
        }
        return class_2561.method_30163((String)"");
    }

    public static void sendMessageToPlayer(String message, int color, boolean overlay) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_36139(color)), overlay);
        }
    }

    public static void sendMessageToPlayer(class_2561 message, boolean overlay) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353(message, overlay);
        }
    }

    public static int toggleMod(CommandContext<FabricClientCommandSource> ignoredFabricClientCommandSourceCommandContext) {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
        TiersClient.sendMessageToPlayer("Tiers is now " + (toggleMod ? "enabled" : "disabled"), toggleMod ? ColorControl.getColor("green") : ColorControl.getColor("red"), true);
        return 1;
    }

    public static void toggleMod() {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
    }

    private static PlayerProfile addGetPlayer(String name, boolean priority) {
        for (PlayerProfile profile : playerProfiles) {
            if (!profile.name.equalsIgnoreCase(name)) continue;
            if (priority) {
                PlayerProfileQueue.changeToFirstInQueue(profile);
            }
            return profile;
        }
        PlayerProfile newProfile = new PlayerProfile(name, true);
        if (priority) {
            PlayerProfileQueue.putFirstInQueue(newProfile);
        } else {
            PlayerProfileQueue.enqueue(newProfile);
        }
        playerProfiles.add(newProfile);
        return newProfile;
    }

    private static void openPlayerSearchResultScreen(PlayerProfile profile) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new PlayerSearchResultScreen(profile)));
    }

    private static void openConfigScreen() {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(ConfigScreen.getConfigScreen(null)));
    }

    public static int searchPlayer(String name) {
        if (name.equalsIgnoreCase("toggle")) {
            TiersClient.toggleMod(null);
        } else if (name.equalsIgnoreCase("config")) {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(TiersClient::openConfigScreen);
        } else {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> TiersClient.openPlayerSearchResultScreen(TiersClient.addGetPlayer(name, true)));
        }
        return 1;
    }

    public static void clearCache(boolean start) {
        playerProfiles.clear();
        playerTexts.clear();
        PlayerProfileQueue.clearQueue();
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(FabricLoader.getInstance().getGameDir()) + (start ? "/cache/tiers" : "/cache/tiers/players")));
        }
        catch (IOException e) {
            LOGGER.warn("Error deleting cache folder: {}", (Object)e.getMessage());
        }
    }

    public static void toggleSeparatorAdaptive() {
        isSeparatorAdaptive = !isSeparatorAdaptive;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void toggleShowIcons() {
        showIcons = !showIcons;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static class_2561 cycleMCTiersCOMMode() {
        activeMCTiersCOMMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersCOMMode, (Enum[])Modes.getMCTiersCOMValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeMCTiersCOMMode.label;
    }

    public static class_2561 cycleMCTiersIOMode() {
        activeMCTiersIOMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersIOMode, (Enum[])Modes.getMCTiersIOValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeMCTiersIOMode.label;
    }

    public static class_2561 cycleSubtiersNETMode() {
        activeSubtiersNETMode = (Modes)TiersClient.cycleEnum((Enum)activeSubtiersNETMode, (Enum[])Modes.getSubtiersNETValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeSubtiersNETMode.label;
    }

    public static void cycleMCTiersCOMPosition() {
        mcTiersCOMPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersCOMPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersIOPosition() {
        mcTiersIOPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersIOPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleSubtiersNETPosition() {
        subtiersNETPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)subtiersNETPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleDisplayMode() {
        displayMode = (ModesTierDisplay)TiersClient.cycleEnum((Enum)displayMode, (Enum[])ModesTierDisplay.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    private static <T extends Enum<T>> T cycleEnum(T current, T[] values) {
        return values[(current.ordinal() + 1) % values.length];
    }

    static {
        seenMainMenu = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DisplayStatus {
        RIGHT,
        LEFT,
        OFF;


        public String getStatus() {
            if (this.toString().equalsIgnoreCase("RIGHT")) {
                return "Right";
            }
            if (this.toString().equalsIgnoreCase("LEFT")) {
                return "Left";
            }
            return "Off";
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ModesTierDisplay {
        HIGHEST,
        SELECTED,
        ADAPTIVE_HIGHEST;


        public String getCurrentMode() {
            if (this.toString().equalsIgnoreCase("HIGHEST")) {
                return "Displayed Tiers: Highest";
            }
            if (this.toString().equalsIgnoreCase("SELECTED")) {
                return "Displayed Tiers: Selected";
            }
            return "Displayed Tiers: Adaptive Highest";
        }
    }
}

