/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profiles;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tiers.profiles.GameMode;
import com.tiers.profiles.Status;
import com.tiers.profiles.types.MCTiersCOMProfile;
import com.tiers.profiles.types.MCTiersIOProfile;
import com.tiers.profiles.types.SubtiersNETProfile;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class PlayerProfile {
    public Status status = Status.SEARCHING;
    public String name;
    public String uuid;
    public MCTiersCOMProfile mcTiersCOMProfile;
    public MCTiersIOProfile mcTiersIOProfile;
    public SubtiersNETProfile subtiersNETProfile;
    public class_2561 originalNameText;
    public boolean imageSaved = false;
    private int numberOfRequests = 0;
    public int numberOfImageRequests = 0;

    public PlayerProfile(String name) {
        this.name = name;
        this.originalNameText = class_2561.method_30163((String)name);
    }

    public void buildRequest(String name) {
        if (this.numberOfRequests == 12 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name)).header("User-Agent", "Tiers").GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                int statusCode = response.statusCode();
                if (statusCode != 200 && statusCode != 404) {
                    long delay = switch (this.numberOfRequests) {
                        case 1 -> 50L;
                        case 2 -> 100L;
                        case 3 -> 200L;
                        case 4 -> 400L;
                        case 5 -> 700L;
                        case 6 -> 1100L;
                        default -> 1500L;
                    };
                    CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(name));
                    return;
                }
                if (statusCode == 404) {
                    this.status = Status.NOT_EXISTING;
                    return;
                }
                this.parseUUID((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(name));
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    private void parseUUID(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (!jsonObject.has("name") || !jsonObject.has("id")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.name = jsonObject.get("name").getAsString();
        this.uuid = jsonObject.get("id").getAsString();
        this.savePlayerImage();
        this.fetchProfiles();
    }

    private void savePlayerImage() {
        if (this.numberOfImageRequests == 5) {
            return;
        }
        ++this.numberOfImageRequests;
        String imageUrl = "https://mc-heads.net/body/" + this.uuid;
        String savePath = String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/tiers-cache/" + this.uuid + ".png";
        try {
            Files.createDirectories(Paths.get(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/tiers-cache/", new String[0]), new FileAttribute[0]);
            ImageIO.write((RenderedImage)ImageIO.read(URI.create(imageUrl).toURL()), "png", new File(savePath));
            this.imageSaved = true;
        }
        catch (IOException ignored) {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(this::savePlayerImage);
        }
    }

    private void fetchProfiles() {
        this.mcTiersCOMProfile = new MCTiersCOMProfile(this.uuid);
        this.mcTiersIOProfile = new MCTiersIOProfile(this.uuid);
        this.subtiersNETProfile = new SubtiersNETProfile(this.uuid);
        this.status = Status.READY;
    }

    public void resetDrawnStatus() {
        if (this.mcTiersCOMProfile == null || this.mcTiersIOProfile == null || this.subtiersNETProfile == null) {
            return;
        }
        this.mcTiersCOMProfile.drawn = false;
        this.mcTiersIOProfile.drawn = false;
        this.subtiersNETProfile.drawn = false;
        for (GameMode mode : this.mcTiersCOMProfile.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.mcTiersIOProfile.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.subtiersNETProfile.gameModes) {
            mode.drawn = false;
        }
    }
}

