/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.tiers.profile.PlayerProfile;
import com.tiers.profile.Status;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PlayerProfileQueue {
    private static final ConcurrentLinkedDeque<PlayerProfile> queue = new ConcurrentLinkedDeque();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static PlayerProfile currentProfile = null;

    public static void enqueue(PlayerProfile playerProfile) {
        queue.add(playerProfile);
    }

    private static void processNext() {
        if (currentProfile != null && PlayerProfileQueue.currentProfile.status == Status.SEARCHING) {
            return;
        }
        currentProfile = queue.poll();
        if (currentProfile != null) {
            currentProfile.buildRequest();
        }
    }

    public static void putFirstInQueue(PlayerProfile playerProfile) {
        if (currentProfile == playerProfile) {
            return;
        }
        queue.remove(playerProfile);
        queue.addFirst(playerProfile);
    }

    public static void changeToFirstInQueue(PlayerProfile playerProfile) {
        if (currentProfile == playerProfile) {
            return;
        }
        if (queue.contains(playerProfile)) {
            queue.remove(playerProfile);
            queue.addFirst(playerProfile);
        }
    }

    public static void clearQueue() {
        queue.clear();
        currentProfile = null;
    }

    public static void removeFromQueue(PlayerProfile playerProfile) {
        if (currentProfile == playerProfile) {
            currentProfile = null;
        }
        queue.remove(playerProfile);
    }

    static {
        scheduler.scheduleAtFixedRate(PlayerProfileQueue::processNext, 0L, 50L, TimeUnit.MILLISECONDS);
    }
}

