/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tiers.TiersClient;
import com.tiers.misc.Mode;
import com.tiers.profile.GameMode;
import com.tiers.profile.Status;
import com.tiers.profile.types.MCTiersProfile;
import com.tiers.profile.types.PvPTiersProfile;
import com.tiers.profile.types.SubtiersProfile;
import com.tiers.profile.types.SuperProfile;
import com.tiers.textures.ColorControl;
import com.tiers.textures.Icons;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class PlayerProfile {
    public Status status;
    public int imageSaved;
    public int numberOfImageRequests;
    public String originalName;
    public boolean nameChanged;
    public String name = "";
    public String uuid = "";
    public MCTiersProfile profileMCTiers;
    public PvPTiersProfile profilePvPTiers;
    public SubtiersProfile profileSubtiers;
    public class_2561 toAppendLeft;
    public class_2561 toAppendRight;
    private int numberOfRequests;
    private final boolean regular;

    public PlayerProfile(String name, boolean regular) {
        this.regular = regular;
        this.name = name;
        this.originalName = name;
        this.status = !name.matches("^[a-zA-Z0-9_]{3,16}$") || name.contains(".") || name.length() < 3 || name.length() > 16 ? Status.NOT_PLAYER : Status.SEARCHING;
    }

    public PlayerProfile(String mojangJson, String jsonMCTiers, String jsonPvPTiers, String jsonSubtiers) {
        this.regular = false;
        if (JsonParser.parseString((String)mojangJson).isJsonNull()) {
            this.status = Status.API_ISSUE;
            return;
        }
        JsonObject jsonObject = JsonParser.parseString((String)mojangJson).getAsJsonObject();
        if (!jsonObject.has("name") || !jsonObject.has("id")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.name = jsonObject.get("name").getAsString();
        this.uuid = jsonObject.get("id").getAsString();
        Path path = FabricLoader.getInstance().getGameDir().resolve("cache/tiers/06ec3577329945fabbdf613b1f86c8ab.png");
        try (InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(class_2960.method_43902((String)"minecraft", (String)"textures/default.png")).orElseThrow()).method_14482();){
            if (inputStream == null) {
                throw new IOException();
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ignored) {
            TiersClient.LOGGER.warn("Error copying default skin");
        }
        this.profileMCTiers = new MCTiersProfile(jsonMCTiers);
        this.profilePvPTiers = new PvPTiersProfile(jsonPvPTiers);
        this.profileSubtiers = new SubtiersProfile(jsonSubtiers);
        this.updateAppendingText();
        this.status = Status.READY;
    }

    public void buildRequest() {
        if (this.status != Status.SEARCHING) {
            return;
        }
        if (this.numberOfRequests == 3) {
            this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
            return;
        }
        ++this.numberOfRequests;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create("https://playerdb.co/api/player/minecraft/" + this.name)).header("User-Agent", TiersClient.userAgent).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        ((CompletableFuture)httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            int statusCode = response.statusCode();
            if (statusCode == 400 || statusCode == 500) {
                this.status = Status.NOT_EXISTING;
                return;
            }
            if (statusCode != 200) {
                this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
                return;
            }
            this.parseJson((String)response.body());
        })).exceptionally(ignored -> {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(this::buildRequest);
            return null;
        });
    }

    public void buildRequest(String apiUrl) {
        if (this.numberOfRequests == 12 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(apiUrl + this.name)).header("User-Agent", TiersClient.userAgent).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        ((CompletableFuture)httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            if (((String)response.body()).contains("minecraft/profile/lookup")) {
                this.status = Status.API_ISSUE;
                return;
            }
            int statusCode = response.statusCode();
            if (statusCode == 404 || statusCode == 400) {
                this.status = Status.NOT_EXISTING;
                return;
            }
            if (statusCode == 403) {
                CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest("https://api.minecraftservices.com/minecraft/profile/lookup/name/"));
                return;
            }
            if (statusCode != 200) {
                long delay = switch (this.numberOfRequests) {
                    case 1 -> 50L;
                    case 2, 3 -> 100L;
                    case 4, 5 -> 400L;
                    case 6, 7 -> 900L;
                    default -> 1500L;
                };
                CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(apiUrl));
                return;
            }
            this.parseJson((String)response.body());
        })).exceptionally(ignored -> {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(apiUrl));
            return null;
        });
    }

    public void savePlayerImage() {
        String apiUrl = "https://mc-heads.net/body/";
        if (this.numberOfImageRequests == 2) {
            apiUrl = "https://visage.surgeplay.com/full/432/";
        } else if (this.numberOfImageRequests == 4) {
            apiUrl = "https://render.crafty.gg/3d/full/";
        } else if (this.numberOfImageRequests == 6) {
            return;
        }
        String finalApiUrl = apiUrl + this.uuid;
        ++this.numberOfImageRequests;
        String path = String.valueOf(FabricLoader.getInstance().getGameDir()) + "/cache/tiers/" + (this.regular ? "players/" : "");
        CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
                URL uri = new URI(finalApiUrl).toURL();
                HttpURLConnection httpURLConnection = (HttpURLConnection)uri.openConnection();
                httpURLConnection.setRequestProperty("User-Agent", TiersClient.userAgent);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setReadTimeout(5000);
                try (InputStream inputStream = httpURLConnection.getInputStream();){
                    ImageIO.write((RenderedImage)ImageIO.read(inputStream), "png", new File(path + this.uuid + ".png"));
                    this.imageSaved = this.numberOfImageRequests;
                }
            }
            catch (IOException | URISyntaxException ignored) {
                CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(this::savePlayerImage);
            }
        });
    }

    private void parseJson(String json) {
        if (JsonParser.parseString((String)json).isJsonNull()) {
            this.status = Status.API_ISSUE;
            return;
        }
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.has("code") && jsonObject.has("data") && jsonObject.has("success")) {
            JsonObject player;
            if (!jsonObject.get("success").getAsString().contains("true")) {
                this.buildRequest("https://api.mojang.com/users/profiles/minecraft/");
                return;
            }
            JsonObject data = jsonObject.getAsJsonObject("data");
            if (data.has("player") && (player = data.getAsJsonObject("player")).has("username") && player.has("raw_id") && player.has("id")) {
                this.name = player.get("username").getAsString();
                this.uuid = player.get("raw_id").getAsString();
            }
        } else if (jsonObject.has("name") && jsonObject.has("id")) {
            this.name = jsonObject.get("name").getAsString();
            this.uuid = jsonObject.get("id").getAsString();
        }
        if (this.uuid.isEmpty()) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        if (!this.regular) {
            this.savePlayerImage();
        }
        this.profileMCTiers = new MCTiersProfile(this.uuid, "https://mctiers.com/api/profile/");
        this.profilePvPTiers = new PvPTiersProfile(this.uuid, "https://pvptiers.com/api/profile/");
        this.profileSubtiers = new SubtiersProfile(this.uuid, "https://subtiers.net/api/profile/");
        this.updateAppendingText();
        if (!this.originalName.equalsIgnoreCase(this.name)) {
            this.nameChanged = true;
        }
        this.status = Status.READY;
    }

    public void updateAppendingText() {
        this.toAppendRight = class_2561.method_43473();
        this.toAppendLeft = class_2561.method_43473();
        if (TiersClient.positionMCTiers == TiersClient.DisplayStatus.RIGHT) {
            this.toAppendRight = this.updateProfileNameRight(this.profileMCTiers, TiersClient.activeMCTiersMode);
        } else if (TiersClient.positionMCTiers == TiersClient.DisplayStatus.LEFT) {
            this.toAppendLeft = this.updateProfileNameLeft(this.profileMCTiers, TiersClient.activeMCTiersMode);
        }
        if (TiersClient.positionPvPTiers == TiersClient.DisplayStatus.RIGHT) {
            this.toAppendRight = this.updateProfileNameRight(this.profilePvPTiers, TiersClient.activePvPTiersMode);
        } else if (TiersClient.positionPvPTiers == TiersClient.DisplayStatus.LEFT) {
            this.toAppendLeft = this.updateProfileNameLeft(this.profilePvPTiers, TiersClient.activePvPTiersMode);
        }
        if (TiersClient.positionSubtiers == TiersClient.DisplayStatus.RIGHT) {
            this.toAppendRight = this.updateProfileNameRight(this.profileSubtiers, TiersClient.activeSubtiersMode);
        } else if (TiersClient.positionSubtiers == TiersClient.DisplayStatus.LEFT) {
            this.toAppendLeft = this.updateProfileNameLeft(this.profileSubtiers, TiersClient.activeSubtiersMode);
        }
        TiersClient.updateTextDisplayEntities();
    }

    public class_2561 getFullName() {
        class_2561 playerText;
        class_2561 class_25612 = playerText = this.nameChanged ? class_2561.method_30163((String)(this.originalName + " (AKA " + this.name + ")")) : class_2561.method_30163((String)this.name);
        if (!TiersClient.toggleMod) {
            return playerText;
        }
        this.updateAppendingText();
        return class_2561.method_43473().method_10852(this.toAppendLeft).method_10852(playerText).method_10852(this.toAppendRight);
    }

    public class_2561 getFullName(class_2561 original) {
        if (this.status != Status.READY) {
            return original;
        }
        return class_2561.method_43473().method_10852(this.toAppendLeft).method_10852(original).method_10852(this.toAppendRight);
    }

    private class_2561 updateProfileNameRight(SuperProfile superProfile, Mode activeMode) {
        class_5250 returnValue = class_2561.method_43473();
        if (superProfile != null && superProfile.status == Status.READY) {
            GameMode shown = superProfile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && TiersClient.displayMode == TiersClient.ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (TiersClient.displayMode == TiersClient.ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && superProfile.highest != null) {
                shown = superProfile.highest;
            }
            if (TiersClient.displayMode == TiersClient.ModesTierDisplay.HIGHEST && superProfile.highest != null && superProfile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = superProfile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(TiersClient.isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            returnValue.method_10852((class_2561)class_2561.method_43473().method_10852((class_2561)separator).method_10852(shown.displayedTier));
            if (TiersClient.showIcons) {
                returnValue.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852(shown.gamemode.getIconTag()));
            }
        }
        return returnValue;
    }

    private class_2561 updateProfileNameLeft(SuperProfile superProfile, Mode activeMode) {
        class_5250 returnValue = class_2561.method_43473();
        if (superProfile != null && superProfile.status == Status.READY) {
            GameMode shown = superProfile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && TiersClient.displayMode == TiersClient.ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (TiersClient.displayMode == TiersClient.ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && superProfile.highest != null) {
                shown = superProfile.highest;
            }
            if (TiersClient.displayMode == TiersClient.ModesTierDisplay.HIGHEST && superProfile.highest != null && superProfile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = superProfile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(TiersClient.isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            if (TiersClient.showIcons) {
                returnValue = class_2561.method_43473().method_10852(shown.gamemode.getIconTag()).method_27693(" ");
            }
            returnValue.method_10852((class_2561)class_2561.method_43473().method_10852(shown.displayedTier).method_10852((class_2561)separator));
        }
        return returnValue;
    }

    public void resetDrawnStatus() {
        if (this.profileMCTiers == null || this.profilePvPTiers == null || this.profileSubtiers == null) {
            return;
        }
        this.profileMCTiers.drawn = false;
        this.profilePvPTiers.drawn = false;
        this.profileSubtiers.drawn = false;
        for (GameMode mode : this.profileMCTiers.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.profilePvPTiers.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.profileSubtiers.gameModes) {
            mode.drawn = false;
        }
    }

    public boolean isPlayerValid() {
        if (this.status == Status.NOT_EXISTING) {
            TiersClient.sendMessageToPlayer(Icons.colorText(this.name + " was not found or isn't a premium account", "red"), false);
            return false;
        }
        if (this.status == Status.NOT_PLAYER) {
            TiersClient.sendMessageToPlayer(Icons.colorText("Not a valid player name", "red"), false);
            return false;
        }
        if (this.status == Status.TIMEOUTED) {
            TiersClient.sendMessageToPlayer(Icons.colorText(this.name + "'s search was timeouted. Clear cache and retry", "red"), false);
            return false;
        }
        if (this.status == Status.API_ISSUE) {
            TiersClient.sendMessageToPlayer(Icons.colorText(this.name + "'s search failed: API Issue. Update Tiers or retry in a while", "red"), false);
            return false;
        }
        return true;
    }
}

