/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.screens;

import com.tiers.TiersClient;
import com.tiers.profile.GameMode;
import com.tiers.profile.PlayerProfile;
import com.tiers.profile.Status;
import com.tiers.profile.types.MCTiersProfile;
import com.tiers.profile.types.PvPTiersProfile;
import com.tiers.profile.types.SubtiersProfile;
import com.tiers.profile.types.SuperProfile;
import com.tiers.textures.ColorControl;
import com.tiers.textures.Icons;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class PlayerSearchResultScreen
extends class_437 {
    private final PlayerProfile playerProfile;
    private final class_2960 playerAvatarTexture = class_2960.method_60654((String)"");
    class_4185 dimensionsWarning;
    private int separator;
    private boolean small;
    private boolean tooSmall;
    private boolean imageReady;
    private boolean toastShown;

    public PlayerSearchResultScreen(PlayerProfile playerProfile) {
        super(class_2561.method_30163((String)playerProfile.name));
        this.playerProfile = playerProfile;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.playerProfile.isPlayerValid()) {
            this.method_25419();
            return;
        }
        if (this.playerProfile.nameChanged && !this.toastShown) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)this.field_22787, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_30163((String)("Possible name change (" + this.playerProfile.name + " to " + this.playerProfile.originalName + ")")), (class_2561)class_2561.method_30163((String)"The data shown should be accurate")));
            this.toastShown = true;
        }
        int centerX = this.field_22789 / 2;
        int listY = (int)((double)this.field_22790 / 2.65);
        this.separator = this.field_22790 / 23;
        this.small = this.field_22789 < 575 || this.field_22790 < 420;
        this.tooSmall = this.field_22789 < 430 || this.field_22790 < 262;
        int firstListX = (int)((double)centerX - (double)this.field_22789 / 3.5) - 25;
        int thirdListX = (int)((double)centerX + (double)this.field_22789 / 3.5) + 25;
        int avatarY = this.field_22790 / 55 + 12;
        super.method_25394(context, mouseX, mouseY, delta);
        this.dimensionsWarning.field_22764 = this.small;
        if (this.tooSmall) {
            this.dimensionsWarning.method_25355(class_2561.method_30163((String)"\u26a0"));
            this.dimensionsWarning.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)("Your window dimensions (" + this.field_22789 + "x" + this.field_22790 + ") are too small\nLower the GUI scale or make the window bigger! (min: 430x262)"))));
        }
        if (this.playerProfile.status == Status.SEARCHING) {
            context.method_27534(this.field_22793, class_2561.method_30163((String)("Searching for " + this.playerProfile.name + "...")), centerX, listY, ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (this.playerProfile.numberOfImageRequests == 0) {
            this.playerProfile.savePlayerImage();
        }
        this.drawPlayerAvatar(context, centerX, avatarY);
        if (!this.imageReady) {
            context.method_27534(this.field_22793, class_2561.method_30163((String)("Loading " + this.playerProfile.name + "'s skin")), centerX, avatarY + 50, ColorControl.getColorMinecraftStandard("green"));
        }
        context.method_27534(this.field_22793, this.playerProfile.getFullNametag(), centerX, this.field_22790 / 55, -1);
        this.drawCategoryList(context, MCTiersProfile.MCTIERS_IMAGE, this.playerProfile.profileMCTiers, firstListX, listY);
        this.drawCategoryList(context, PvPTiersProfile.PVPTIERS_IMAGE, this.playerProfile.profilePvPTiers, centerX, listY);
        this.drawCategoryList(context, SubtiersProfile.SUBTIERS_IMAGE, this.playerProfile.profileSubtiers, thirdListX, listY);
    }

    private void drawCategoryList(class_332 context, class_2960 image, SuperProfile superProfile, int x, int y) {
        if (superProfile == null) {
            context.method_25300(this.field_22793, "Loading from API...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (image == MCTiersProfile.MCTIERS_IMAGE) {
            context.method_25290(class_10799.field_56883, image, x - 64, (int)((double)y + 2.4 * (double)this.separator) + 4 - 38, 0.0f, 0.0f, 128, 24, 128, 24);
        } else if (image == PvPTiersProfile.PVPTIERS_IMAGE) {
            context.method_25290(class_10799.field_56883, image, x - 12, (int)((double)y + 2.4 * (double)this.separator) + 4 - 38, 0.0f, 0.0f, 24, 24, 24, 24);
        } else {
            context.method_25290(class_10799.field_56883, image, (int)((double)x - 15.5), (int)((double)y + 2.4 * (double)this.separator) - 38, 0.0f, 0.0f, 31, 31, 31, 31);
        }
        if (superProfile.status == Status.SEARCHING) {
            context.method_25300(this.field_22793, "Searching...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("green"));
            return;
        }
        if (superProfile.status == Status.NOT_EXISTING) {
            context.method_25300(this.field_22793, "Unranked", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (superProfile.status == Status.TIMEOUTED) {
            context.method_25300(this.field_22793, "Search timeouted. Clear cache and retry", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (superProfile.status == Status.API_ISSUE) {
            context.method_25300(this.field_22793, "Search failed: API issue", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColorMinecraftStandard("red"));
            context.method_25300(this.field_22793, "Update Tiers or retry in a while", x, (int)((double)y + 2.8 * (double)this.separator + 15.0), ColorControl.getColorMinecraftStandard("red"));
            return;
        }
        if (!superProfile.drawn) {
            class_7842 regionLabel = new class_7842(Icons.colorText("Region", "region"), this.field_22793);
            regionLabel.method_48229(x - 44, (int)((double)y + 2.4 * (double)this.separator));
            this.method_37063((class_364)regionLabel);
            class_7842 overallLabel = new class_7842(Icons.colorText("Overall", "overall"), this.field_22793);
            overallLabel.method_48229(x - 44, (int)((double)y + 2.4 * (double)this.separator) + 16);
            this.method_37063((class_364)overallLabel);
            class_7842 regionIcon = new class_7842(Icons.GLOBE, this.field_22793);
            regionIcon.method_48229(x - 64, (int)((double)y + 2.4 * (double)this.separator + 2.0));
            regionIcon.method_46438(ColorControl.getColor("region"));
            regionIcon.method_47400(class_7919.method_47407((class_2561)regionLabel.method_25369()));
            this.method_37063((class_364)regionIcon);
            class_7842 overallIcon = new class_7842(Icons.OVERALL, this.field_22793);
            overallIcon.method_48229(x - 64, (int)((double)y + 2.4 * (double)this.separator + 2.0) + 16);
            overallIcon.method_46438(ColorControl.getColor("overall"));
            overallIcon.method_47400(class_7919.method_47407((class_2561)overallLabel.method_25369()));
            this.method_37063((class_364)overallIcon);
            class_7842 region = new class_7842(superProfile.displayedRegion, this.field_22793);
            region.method_48229(x + 52 - (superProfile.displayedRegion.getString().length() - 2) * 3, (int)((double)y + 2.4 * (double)this.separator));
            region.method_47400(class_7919.method_47407((class_2561)superProfile.regionTooltip));
            this.method_37063((class_364)region);
            class_7842 overall = new class_7842(superProfile.displayedOverall, this.field_22793);
            overall.method_48229(x + 52 - (superProfile.displayedOverall.getString().length() - 2) * 3, (int)((double)y + 2.4 * (double)this.separator) + 16);
            overall.method_47400(class_7919.method_47407((class_2561)superProfile.overallTooltip));
            this.method_37063((class_364)overall);
            this.drawTierList(superProfile, x - 64, (int)((double)y + 2.4 * (double)this.separator) + 40);
            superProfile.drawn = true;
        }
    }

    private void drawTierList(SuperProfile superProfile, int x, int y) {
        int originalX = x;
        if (this.small) {
            y -= 7;
            int count = 1;
            int stage = 0;
            for (GameMode gameMode : superProfile.gameModes) {
                if (!this.drawGameModeTiers(gameMode, x + 5, y + stage * 36)) continue;
                x += 35;
                if (count % 4 == 0) {
                    ++stage;
                    x = originalX;
                }
                ++count;
            }
        } else {
            for (GameMode gameMode : superProfile.gameModes) {
                if (!this.drawGameModeTiers(gameMode, x, y)) continue;
                y += 15;
            }
        }
    }

    private boolean drawGameModeTiers(GameMode mode, int x, int y) {
        if (mode.drawn || mode.status != Status.READY) {
            return false;
        }
        class_7842 icon = new class_7842(mode.gamemode.getIcon(), this.field_22793);
        icon.method_48229(x, y + 3);
        if (this.small) {
            icon.method_48229(x, y + 3);
        }
        icon.method_47400(class_7919.method_47407((class_2561)mode.gamemode.getTextLabel()));
        this.method_37063((class_364)icon);
        class_7842 label = new class_7842(mode.gamemode.getTextLabel(), this.field_22793);
        label.method_48229(x + 20, y);
        if (!this.small) {
            this.method_37063((class_364)label);
        }
        class_7842 tier = new class_7842(mode.displayedTier, this.field_22793);
        tier.method_48229(x + 114 - (mode.displayedTier.getString().length() - 3) * 3, y);
        if (this.small) {
            tier.method_48229(x - 2 - (mode.displayedTier.getString().length() - 3) * 2, y + 14);
        }
        tier.method_47400(class_7919.method_47407((class_2561)mode.tierTooltip));
        this.method_37063((class_364)tier);
        if (mode.hasPeak && mode.peakTierTooltip.method_10866().method_10973() != null) {
            class_7842 peakTier = new class_7842(mode.displayedPeakTier, this.field_22793);
            peakTier.method_48229(x + 136, y);
            if (this.small) {
                peakTier.method_48229(x - 6, y + 24);
            }
            peakTier.method_47400(class_7919.method_47407((class_2561)mode.peakTierTooltip));
            this.method_37063((class_364)peakTier);
        }
        mode.drawn = true;
        return true;
    }

    private void drawPlayerAvatar(class_332 context, int x, int y) {
        if (this.imageReady) {
            if (this.playerProfile.imageSaved == 1 || this.playerProfile.imageSaved == 2) {
                context.method_25290(class_10799.field_56883, this.playerAvatarTexture, x - this.field_22789 / 32, y, 0.0f, 0.0f, this.field_22789 / 16, (int)((double)this.field_22789 / 6.666), this.field_22789 / 16, (int)((double)this.field_22789 / 6.666));
            } else if (this.playerProfile.imageSaved < 6 && this.playerProfile.imageSaved > 2) {
                context.method_25290(class_10799.field_56883, this.playerAvatarTexture, (int)((double)x - (double)this.field_22789 / 22.5), y, 0.0f, 0.0f, (int)((double)this.field_22789 / 11.25), (int)((double)this.field_22789 / 6.666), (int)((double)this.field_22789 / 11.25), (int)((double)this.field_22789 / 6.666));
            }
        } else if (this.playerProfile.imageSaved != 0) {
            this.loadPlayerAvatar();
        } else if (this.playerProfile.numberOfImageRequests == 6) {
            context.method_27534(this.field_22793, class_2561.method_30163((String)(this.playerProfile.name + "'s skin failed to load. Clear cache and retry")), x, y + 50, ColorControl.getColorMinecraftStandard("red"));
        }
    }

    private void loadPlayerAvatar() {
        if (this.imageReady) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(FabricLoader.getInstance().getGameDir().resolve("cache/tiers/players/" + this.playerProfile.uuid + ".png").toFile());){
            class_310.method_1551().method_1531().method_4616(this.playerAvatarTexture, (class_1044)new class_1043(null, class_1011.method_4309((InputStream)fileInputStream)));
            this.imageReady = true;
        }
        catch (IOException ignored) {
            TiersClient.LOGGER.warn("Error loading player skin");
        }
    }

    protected void method_25426() {
        this.playerProfile.resetDrawnStatus();
        this.dimensionsWarning = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2139"), buttonWidget -> {}).method_46434(this.field_22789 - 20 - 5, 5, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_30163((String)("Your window dimensions (" + this.field_22789 + "x" + this.field_22790 + ") are small\nLower the GUI scale or make the window bigger to have a better experience (min: 575x420)")))).method_46431();
        this.dimensionsWarning.field_22763 = false;
        this.dimensionsWarning.field_22764 = this.small;
        if (this.tooSmall) {
            this.dimensionsWarning.method_25355(class_2561.method_30163((String)"\u26a0"));
            this.dimensionsWarning.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)("Your window dimensions (" + this.field_22789 + "x" + this.field_22790 + ") are too small\nLower the GUI scale or make the window bigger! (min: 430x262)"))));
        }
        this.method_37063((class_364)this.dimensionsWarning);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Update"), buttonWidget -> TiersClient.updatePlayerProfile(this.playerProfile)).method_46434(5, this.field_22790 - 20 - 5, 50, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_30163((String)"Update the player profile"))).method_46431());
    }
}

