/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.mojang.brigadier.context.CommandContext;
import com.tiers.InventoryChecker;
import com.tiers.PlayerProfileQueue;
import com.tiers.misc.CommandRegister;
import com.tiers.misc.ConfigManager;
import com.tiers.misc.Mode;
import com.tiers.profile.PlayerProfile;
import com.tiers.profile.Status;
import com.tiers.screens.ConfigScreen;
import com.tiers.screens.PlayerSearchResultScreen;
import com.tiers.textures.ColorLoader;
import com.tiers.textures.Icons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8113;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TiersClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(TiersClient.class);
    public static String userAgent = "Tiers (modrinth.com/mod/tiers)";
    public static final ArrayList<PlayerProfile> playerProfiles = new ArrayList();
    public static boolean toggleMod = true;
    public static boolean toggleTab = false;
    public static boolean showIcons = true;
    public static boolean isSeparatorAdaptive = true;
    public static boolean autoKitDetect = false;
    public static ModesTierDisplay displayMode = ModesTierDisplay.ADAPTIVE_HIGHEST;
    public static Icons.Type activeIcons = Icons.Type.PVPTIERS;
    public static DisplayStatus positionMCTiers = DisplayStatus.OFF;
    public static Mode activeMCTiersMode = Mode.MCTIERS_VANILLA;
    public static DisplayStatus positionPvPTiers = DisplayStatus.LEFT;
    public static Mode activePvPTiersMode = Mode.PVPTIERS_CRYSTAL;
    public static DisplayStatus positionSubtiers = DisplayStatus.RIGHT;
    public static Mode activeSubtiersMode = Mode.SUBTIERS_MINECART;
    public static class_304 autoDetectKey;
    public static class_304 openClosestPlayerProfile;
    public static class_304 cycleRightKey;
    public static class_304 cycleLeftKey;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        TiersClient.changeIcons(activeIcons, false);
        TiersClient.clearCache(true);
        CommandRegister.registerCommands();
        Optional modContainer = FabricLoader.getInstance().getModContainer("tiers");
        modContainer.ifPresent(tiers -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"resourcepacks", (String)"tiers-resources"), (ModContainer)tiers, (class_2561)class_2561.method_30163((String)"Resources for Tiers"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            userAgent = userAgent + " v" + tiers.getMetadata().getVersion().getFriendlyString();
        });
        class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"tiers"));
        autoDetectKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Auto Detect Kit", 89, category));
        openClosestPlayerProfile = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open Closest Player Profile", 72, category));
        cycleRightKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Right Gamemodes", 73, category));
        cycleLeftKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Left Gamemodes", 85, category));
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(class_2960.method_60654((String)"tiers"), (class_3302)new ColorLoader());
        ClientTickEvents.END_CLIENT_TICK.register(TiersClient::checkKeys);
        ClientTickEvents.END_CLIENT_TICK.register(minecraftClient -> {
            if (autoKitDetect) {
                InventoryChecker.checkInventory(minecraftClient, false);
            }
        });
        LOGGER.info("Tiers initialized | User agent: {}", (Object)userAgent);
    }

    public static PlayerProfile addGetPlayer(String playerName, boolean priority) {
        for (PlayerProfile playerProfile : playerProfiles) {
            if (!playerProfile.name.equalsIgnoreCase(playerName) && !playerProfile.originalName.equalsIgnoreCase(playerName)) continue;
            if (priority) {
                PlayerProfileQueue.changeToFirstInQueue(playerProfile);
            }
            return playerProfile;
        }
        PlayerProfile newProfile = new PlayerProfile(playerName, true);
        if (priority) {
            PlayerProfileQueue.putFirstInQueue(newProfile);
        } else {
            PlayerProfileQueue.enqueue(newProfile);
        }
        playerProfiles.add(newProfile);
        return newProfile;
    }

    public static void updateAllTags() {
        for (PlayerProfile playerProfile : playerProfiles) {
            playerProfile.updateAppendingText();
        }
        if (ConfigScreen.ownProfile != null && ConfigScreen.defaultProfile != null) {
            ConfigScreen.ownProfile.updateAppendingText();
            ConfigScreen.defaultProfile.updateAppendingText();
        }
    }

    public static void restyleAllTexts(ArrayList<PlayerProfile> playerProfiles) {
        for (PlayerProfile playerProfile : playerProfiles) {
            if (playerProfile.status != Status.READY) continue;
            if (playerProfile.profileMCTiers.status == Status.READY) {
                playerProfile.profileMCTiers.parseJson(playerProfile.profileMCTiers.originalJson);
            }
            if (playerProfile.profilePvPTiers.status == Status.READY) {
                playerProfile.profilePvPTiers.parseJson(playerProfile.profilePvPTiers.originalJson);
            }
            if (playerProfile.profileSubtiers.status != Status.READY) continue;
            playerProfile.profileSubtiers.parseJson(playerProfile.profileSubtiers.originalJson);
        }
    }

    public static String getNearestPlayerName() {
        class_310 minecraftClient = class_310.method_1551();
        class_746 self = minecraftClient.field_1724;
        if (self == null || self.method_73183() == null) {
            return null;
        }
        class_1657 playerEntity = self.method_73183().method_18456().stream().filter(arg_0 -> TiersClient.lambda$getNearestPlayerName$2((class_1657)self, arg_0)).filter(arg_0 -> TiersClient.lambda$getNearestPlayerName$3((class_1657)self, arg_0)).min(Comparator.comparingDouble(arg_0 -> ((class_1657)self).method_5739(arg_0))).orElse(null);
        if (playerEntity != null) {
            return playerEntity.method_5820();
        }
        return null;
    }

    private static void checkKeys(class_310 minecraftClient) {
        class_2561 message;
        if (autoDetectKey.method_1436()) {
            InventoryChecker.checkInventory(minecraftClient, true);
        }
        if (openClosestPlayerProfile.method_1436()) {
            String nearestPlayerName = TiersClient.getNearestPlayerName();
            if (nearestPlayerName != null) {
                TiersClient.searchPlayer(nearestPlayerName);
            } else {
                TiersClient.sendMessageToPlayer(Icons.colorText("No players in render distance", "red"), true);
            }
        }
        if (cycleRightKey.method_1436()) {
            message = TiersClient.cycleRightMode();
            if (message != null) {
                TiersClient.sendMessageToPlayer(message, true);
            } else {
                TiersClient.sendMessageToPlayer(Icons.colorText("There's nothing on the right display", "red"), true);
            }
        }
        if (cycleLeftKey.method_1436()) {
            message = TiersClient.cycleLeftMode();
            if (message != null) {
                TiersClient.sendMessageToPlayer(message, true);
            } else {
                TiersClient.sendMessageToPlayer(Icons.colorText("There's nothing on the left display", "red"), true);
            }
        }
    }

    public static class_2561 cycleRightMode() {
        if (autoKitDetect) {
            autoKitDetect = false;
            TiersClient.sendMessageToPlayer(Icons.colorText("Auto kit detect has been disabled due to manual gamemode changes", "red"), false);
        }
        if (positionMCTiers.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (MCTiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cycleMCTiersMode());
        }
        if (positionPvPTiers.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (PvPTiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cyclePvPTiersMode());
        }
        if (positionSubtiers.toString().equalsIgnoreCase("RIGHT")) {
            return class_2561.method_43470((String)"Right (Subtiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cycleSubtiersMode());
        }
        return null;
    }

    public static class_2561 cycleLeftMode() {
        if (autoKitDetect) {
            autoKitDetect = false;
            TiersClient.sendMessageToPlayer(Icons.colorText("Auto kit detect has been disabled due to manual gamemode changes", "red"), false);
        }
        if (positionMCTiers.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (MCTiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cycleMCTiersMode());
        }
        if (positionPvPTiers.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (PvPTiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cyclePvPTiersMode());
        }
        if (positionSubtiers.toString().equalsIgnoreCase("LEFT")) {
            return class_2561.method_43470((String)"Left (Subtiers) is now displaying ").method_10862(class_2583.field_24360.method_36139(-1)).method_10852(TiersClient.cycleSubtiersMode());
        }
        return null;
    }

    public static class_2561 getRightIcon() {
        if (positionMCTiers.toString().equalsIgnoreCase("RIGHT")) {
            return activeMCTiersMode.getIcon();
        }
        if (positionPvPTiers.toString().equalsIgnoreCase("RIGHT")) {
            return activePvPTiersMode.getIcon();
        }
        if (positionSubtiers.toString().equalsIgnoreCase("RIGHT")) {
            return activeSubtiersMode.getIcon();
        }
        return class_2561.method_43473();
    }

    public static class_2561 getLeftIcon() {
        if (positionMCTiers.toString().equalsIgnoreCase("LEFT")) {
            return activeMCTiersMode.getIcon();
        }
        if (positionPvPTiers.toString().equalsIgnoreCase("LEFT")) {
            return activePvPTiersMode.getIcon();
        }
        if (positionSubtiers.toString().equalsIgnoreCase("LEFT")) {
            return activeSubtiersMode.getIcon();
        }
        return class_2561.method_43473();
    }

    public static void sendMessageToPlayer(class_2561 message, boolean overlay) {
        class_310 minecraftClient = class_310.method_1551();
        if (minecraftClient.field_1724 != null) {
            minecraftClient.field_1724.method_7353(message, overlay);
        }
    }

    public static void toggleMod(CommandContext<FabricClientCommandSource> ignoredFabricClientCommandSourceCommandContext) {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
        TiersClient.sendMessageToPlayer(Icons.colorText("Tiers is now " + (toggleMod ? "enabled" : "disabled"), toggleMod ? "green" : "red"), true);
    }

    public static void toggleMod() {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
    }

    public static void toggleTab() {
        toggleTab = !toggleTab;
        ConfigManager.saveConfig();
    }

    public static void toggleAutoKitDetect() {
        autoKitDetect = !autoKitDetect;
        ConfigManager.saveConfig();
    }

    public static void searchPlayer(String playerName) {
        if (playerName.equalsIgnoreCase("toggle")) {
            TiersClient.toggleMod(null);
        } else if (playerName.equalsIgnoreCase("config")) {
            class_310.method_1551().method_63603(ignored -> class_310.method_1551().method_1507(ConfigScreen.getConfigScreen(null)));
        } else {
            PlayerProfile playerProfile = TiersClient.addGetPlayer(playerName, true);
            if (playerProfile.isPlayerValid()) {
                class_310.method_1551().method_63603(ignored -> class_310.method_1551().method_1507((class_437)new PlayerSearchResultScreen(playerProfile)));
            }
        }
    }

    public static void changeIcons(Icons.Type iconType, boolean reload) {
        Icons.identifierMCTiers = class_2960.method_60655((String)"minecraft", (String)("gamemodes/" + iconType.name().toLowerCase()));
        Icons.identifierPvPTiers = class_2960.method_60655((String)"minecraft", (String)("gamemodes/" + iconType.name().toLowerCase()));
        Icons.identifierMCTiersTags = class_2960.method_60655((String)"minecraft", (String)("gamemodes/" + iconType.name().toLowerCase() + "-tags"));
        Icons.identifierPvPTiersTags = class_2960.method_60655((String)"minecraft", (String)("gamemodes/" + iconType.name().toLowerCase() + "-tags"));
        ColorLoader.identifier = class_2960.method_60655((String)"minecraft", (String)("colors/" + iconType.name().toLowerCase() + ".json"));
        if (reload) {
            class_310.method_1551().method_1521();
        }
        activeIcons = iconType;
        ConfigManager.saveConfig();
    }

    public static void updatePlayerProfile(PlayerProfile playerProfile) {
        playerProfiles.remove(playerProfile);
        PlayerProfileQueue.removeFromQueue(playerProfile);
        TiersClient.searchPlayer(playerProfile.nameChanged ? playerProfile.originalName : playerProfile.name);
    }

    public static void clearCache(boolean start) {
        playerProfiles.clear();
        PlayerProfileQueue.clearQueue();
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(FabricLoader.getInstance().getGameDir()) + (start ? "/cache/tiers" : "/cache/tiers/players")));
        }
        catch (IOException ignored) {
            LOGGER.warn("Error deleting cache folder");
        }
        if (toggleMod && class_310.method_1551().field_1687 != null) {
            for (class_1657 playerEntity : class_310.method_1551().field_1687.method_18456()) {
                TiersClient.addGetPlayer(playerEntity.method_5820(), false);
            }
        }
    }

    public static void updateTextDisplayEntities() {
        class_310 minecraftClient = class_310.method_1551();
        if (minecraftClient.field_1687 == null) {
            return;
        }
        for (class_1297 entity : minecraftClient.field_1687.method_18112()) {
            if (!(entity instanceof class_8113.class_8123)) continue;
            class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
            class_2561 text = textDisplay.method_48915();
            textDisplay.method_48911((class_2561)class_2561.method_43470((String)" ").method_10852(text));
            textDisplay.method_48911(text);
        }
    }

    public static void toggleSeparatorAdaptive() {
        isSeparatorAdaptive = !isSeparatorAdaptive;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void toggleShowIcons() {
        showIcons = !showIcons;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static class_2561 cycleMCTiersMode() {
        activeMCTiersMode = (Mode)TiersClient.cycleEnum((Enum)activeMCTiersMode, (Enum[])Mode.getMCTiersValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return activeMCTiersMode.getTextLabel();
    }

    public static class_2561 cyclePvPTiersMode() {
        activePvPTiersMode = (Mode)TiersClient.cycleEnum((Enum)activePvPTiersMode, (Enum[])Mode.getPvPTiersValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return activePvPTiersMode.getTextLabel();
    }

    public static class_2561 cycleSubtiersMode() {
        activeSubtiersMode = (Mode)TiersClient.cycleEnum((Enum)activeSubtiersMode, (Enum[])Mode.getSubtiersValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return activeSubtiersMode.getTextLabel();
    }

    public static void cycleDisplayMode() {
        displayMode = (ModesTierDisplay)TiersClient.cycleEnum((Enum)displayMode, (Enum[])ModesTierDisplay.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    private static <T extends Enum<T>> T cycleEnum(T current, T[] values) {
        return values[(current.ordinal() + 1) % values.length];
    }

    private static /* synthetic */ boolean lambda$getNearestPlayerName$3(class_1657 self, class_1657 player) {
        return self.method_5739((class_1297)player) < class_310.method_1551().field_1773.method_3193();
    }

    private static /* synthetic */ boolean lambda$getNearestPlayerName$2(class_1657 self, class_1657 player) {
        return player != self;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DisplayStatus {
        RIGHT,
        LEFT,
        OFF;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum ModesTierDisplay {
        HIGHEST,
        SELECTED,
        ADAPTIVE_HIGHEST;


        public String getCurrentMode() {
            if (this.toString().equalsIgnoreCase("HIGHEST")) {
                return "Displayed Tiers: Highest";
            }
            if (this.toString().equalsIgnoreCase("SELECTED")) {
                return "Displayed Tiers: Selected";
            }
            return "Displayed Tiers: Adaptive Highest";
        }
    }
}

