/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.textures;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.tiers.TiersClient;
import com.tiers.profile.PlayerProfile;
import com.tiers.screens.ConfigScreen;
import com.tiers.textures.ColorControl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3302;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class ColorLoader
implements class_3302 {
    public static class_2960 identifier = class_2960.method_60655((String)"minecraft", (String)"colors/pvptiers.json");

    public CompletableFuture<Void> method_25931(class_3302.class_11558 store, Executor prepareExecutor, class_3302.class_4045 reloadSynchronizer, Executor applyExecutor) {
        if (store.method_72361().method_14486(identifier).isPresent()) {
            try {
                ColorControl.updateColors((JsonObject)class_3518.method_15276((Gson)new Gson(), (Reader)new InputStreamReader(((class_3298)store.method_72361().method_14486(identifier).get()).method_14482(), StandardCharsets.UTF_8), JsonObject.class));
                TiersClient.restyleAllTexts(TiersClient.playerProfiles);
                TiersClient.updateAllTags();
            }
            catch (IOException ignored) {
                TiersClient.LOGGER.warn("Error loading colors info");
            }
        }
        if (ConfigScreen.ownProfile == null) {
            ConfigScreen.ownProfile = new PlayerProfile(class_310.method_1551().method_53462().name(), false);
            ConfigScreen.ownProfile.buildRequest();
            String defaultProfileMojang = ColorLoader.loadStringFromResources("json/defaultProfileMojang.json");
            String defaultProfileMCTiers = ColorLoader.loadStringFromResources("json/defaultProfileMCTiers.json");
            String defaultProfilePvPTiers = ColorLoader.loadStringFromResources("json/defaultProfilePvPTiers.json");
            String defaultProfileSubtiers = ColorLoader.loadStringFromResources("json/defaultProfileSubtiers.json");
            ConfigScreen.defaultProfile = new PlayerProfile(defaultProfileMojang, defaultProfileMCTiers, defaultProfilePvPTiers, defaultProfileSubtiers);
        } else {
            ArrayList<PlayerProfile> configProfiles = new ArrayList<PlayerProfile>();
            configProfiles.add(ConfigScreen.defaultProfile);
            configProfiles.add(ConfigScreen.ownProfile);
            TiersClient.restyleAllTexts(configProfiles);
        }
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {}, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)reloadSynchronizer).method_18352(arg_0))).thenRunAsync(() -> {}, applyExecutor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadStringFromResources(String path) {
        block14: {
            try (InputStream inputStream = ColorLoader.class.getClassLoader().getResourceAsStream(path);){
                String string;
                if (inputStream == null) break block14;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(System.lineSeparator());
                    }
                    string = stringBuilder.toString();
                }
                return string;
            }
            catch (IOException ignored) {
                TiersClient.LOGGER.warn("Error loading default jsons");
            }
        }
        return "";
    }
}

