/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.screens;

import com.tiers.TiersClient;
import com.tiers.misc.ColorControl;
import com.tiers.misc.Icons;
import com.tiers.profiles.GameMode;
import com.tiers.profiles.PlayerProfile;
import com.tiers.profiles.Status;
import com.tiers.profiles.types.BaseProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class PlayerSearchResultScreen
extends class_437 {
    private final PlayerProfile playerProfile;
    private class_2960 playerAvatarTexture;
    private final class_2960 MCTIERS_COM_IMAGE = class_2960.method_60655((String)"minecraft", (String)"textures/mctiers_com_logo.png");
    private final class_2960 MCTIERS_IO_IMAGE = class_2960.method_60655((String)"minecraft", (String)"textures/mctiers_io_logo.png");
    private final class_2960 SUBTIERS_NET_IMAGE = class_2960.method_60655((String)"minecraft", (String)"textures/subtiers_net_logo.png");
    private int separator;
    private boolean imageReady = false;

    public PlayerSearchResultScreen(PlayerProfile playerProfile) {
        super((class_2561)class_2561.method_43470((String)playerProfile.name));
        this.playerProfile = playerProfile;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.playerProfile.status == Status.NOT_EXISTING) {
            this.method_25419();
            TiersClient.sendMessageToPlayer(this.playerProfile.name + " was not found or isn't a premium account", ColorControl.getColor("red"));
            return;
        }
        if (this.playerProfile.status == Status.TIMEOUTED) {
            this.method_25419();
            TiersClient.sendMessageToPlayer(this.playerProfile.name + "'s search was timeouted. Clear cache and retry", ColorControl.getColor("red"));
            return;
        }
        int centerX = this.field_22789 / 2;
        int listY = (int)((double)this.field_22790 / 2.8);
        this.separator = this.field_22790 / 23;
        int firstListX = (int)((double)centerX - (double)this.field_22789 / 4.3);
        int thirdListX = (int)((double)centerX + (double)this.field_22789 / 4.3);
        int avatarY = this.field_22790 / 18;
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.playerProfile.status == Status.SEARCHING) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Searching for " + this.playerProfile.name + "...")), centerX, listY, ColorControl.getColor("green"));
            return;
        }
        this.drawPlayerAvatar(context, centerX, avatarY);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(this.playerProfile.name + "'s profile")), centerX, this.field_22790 / 70, ColorControl.getColor("text"));
        this.drawCategoryList(context, this.MCTIERS_COM_IMAGE, this.playerProfile.mcTiersCOMProfile, firstListX, listY);
        this.drawCategoryList(context, this.MCTIERS_IO_IMAGE, this.playerProfile.mcTiersIOProfile, centerX, listY);
        this.drawCategoryList(context, this.SUBTIERS_NET_IMAGE, this.playerProfile.subtiersNETProfile, thirdListX, listY);
    }

    private void drawCategoryList(class_332 context, class_2960 image, BaseProfile profile, int x, int y) {
        if (profile == null) {
            context.method_25300(this.field_22793, "Loading from API...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColor("green"));
            return;
        }
        if (image == this.MCTIERS_COM_IMAGE) {
            context.method_25290(image, x - 56, y + 5, 0.0f, 0.0f, 112, 21, 112, 21);
        } else {
            context.method_25290(image, x - 13, y, 0.0f, 0.0f, 26, 26, 26, 26);
        }
        if (profile.status == Status.SEARCHING) {
            context.method_25300(this.field_22793, "Searching...", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColor("green"));
            return;
        }
        if (profile.status == Status.NOT_EXISTING) {
            context.method_25300(this.field_22793, "Unranked", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColor("red"));
            return;
        }
        if (profile.status == Status.TIMEOUTED) {
            context.method_25300(this.field_22793, "Search timeouted. Clear cache and retry", x, (int)((double)y + 2.8 * (double)this.separator), ColorControl.getColor("red"));
            return;
        }
        if (!profile.drawn) {
            class_7842 regionLabel = new class_7842(class_2561.method_30163((String)"Region"), this.field_22793);
            regionLabel.method_48229(x - 42, (int)((double)y + 2.4 * (double)this.separator));
            regionLabel.method_46438(ColorControl.getColor("region"));
            this.method_37063((class_364)regionLabel);
            class_7842 overallLabel = new class_7842(class_2561.method_30163((String)"Overall"), this.field_22793);
            overallLabel.method_48229(x - 42, (int)((double)y + 3.2 * (double)this.separator));
            overallLabel.method_46438(ColorControl.getColor("overall"));
            this.method_37063((class_364)overallLabel);
            class_7842 regionIcon = new class_7842(Icons.globe, this.field_22793);
            regionIcon.method_48229(x - 62, (int)((double)y + 2.4 * (double)this.separator + 2.0));
            regionIcon.method_46438(ColorControl.getColor("region"));
            this.method_37063((class_364)regionIcon);
            class_7842 overallIcon = new class_7842(Icons.overall, this.field_22793);
            overallIcon.method_48229(x - 62, (int)((double)y + 3.2 * (double)this.separator + 2.0));
            overallIcon.method_46438(ColorControl.getColor("overall"));
            this.method_37063((class_364)overallIcon);
            class_7842 region = new class_7842(profile.displayedRegion, this.field_22793);
            region.method_48229(x + 45 - (profile.displayedRegion.getString().length() - 2) * 3, (int)((double)y + 2.4 * (double)this.separator));
            region.method_47400(class_7919.method_47407((class_2561)profile.regionTooltip));
            this.method_37063((class_364)region);
            class_7842 overall = new class_7842(profile.displayedOverall, this.field_22793);
            overall.method_48229(x + 45 - (profile.displayedOverall.getString().length() - 2) * 3, (int)((double)y + 3.2 * (double)this.separator));
            overall.method_47400(class_7919.method_47407((class_2561)profile.overallTooltip));
            this.method_37063((class_364)overall);
            this.drawTierList(profile, x - 62, (int)((double)y + (double)this.field_22790 / 5.4));
            profile.drawn = true;
        }
    }

    private void drawTierList(BaseProfile profile, int x, int y) {
        for (GameMode gameMode : profile.gameModes) {
            if (!this.drawGameModeTiers(gameMode, x, y)) continue;
            y += 15;
        }
    }

    private boolean drawGameModeTiers(GameMode mode, int x, int y) {
        if (mode.drawn || mode.status != Status.READY) {
            return false;
        }
        class_7842 icon = new class_7842(mode.name.getIcon(), this.field_22793);
        icon.method_48229(x, y + 3);
        this.method_37063((class_364)icon);
        class_7842 label = new class_7842(mode.name.getLabel(), this.field_22793);
        label.method_48229(x + 20, y);
        this.method_37063((class_364)label);
        class_7842 tier = new class_7842(mode.displayedTier, this.field_22793);
        tier.method_48229(x + 105 - (mode.displayedTier.getString().length() - 3) * 3, y);
        tier.method_47400(class_7919.method_47407((class_2561)mode.tierTooltip));
        this.method_37063((class_364)tier);
        if (mode.hasPeak && mode.peakTierTooltip.method_10866().method_10973() != null) {
            class_7842 peakTier = new class_7842(mode.displayedPeakTier, this.field_22793);
            peakTier.method_48229(x + 142, y);
            peakTier.method_47400(class_7919.method_47407((class_2561)mode.peakTierTooltip));
            this.method_37063((class_364)peakTier);
            class_7842 peakIcon = new class_7842(Icons.peak, this.field_22793);
            peakIcon.method_48229(x + 130, y);
            peakIcon.method_47400(class_7919.method_47407((class_2561)mode.peakTierTooltip));
            peakIcon.method_46438(mode.peakTierTooltip.method_10866().method_10973().method_27716());
            this.method_37063((class_364)peakIcon);
        }
        mode.drawn = true;
        return true;
    }

    private void drawPlayerAvatar(class_332 context, int x, int y) {
        if (this.playerAvatarTexture != null && this.imageReady) {
            context.method_25290(this.playerAvatarTexture, x - this.field_22789 / 32, y, 0.0f, 0.0f, this.field_22789 / 16, (int)((double)this.field_22789 / 6.666), this.field_22789 / 16, (int)((double)this.field_22789 / 6.666));
        } else if (this.playerProfile.imageSaved) {
            this.loadPlayerAvatar();
        } else if (this.playerProfile.numberOfImageRequests == 5) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(this.playerProfile.name + "'s image failed to load. Clear cache and retry")), x, y + 20, ColorControl.getColor("red"));
        }
    }

    private void loadPlayerAvatar() {
        File avatarFile = FabricLoader.getInstance().getConfigDir().resolve("tiers-cache/" + this.playerProfile.uuid + ".png").toFile();
        if (!avatarFile.exists()) {
            return;
        }
        try (FileInputStream stream = new FileInputStream(avatarFile);){
            this.playerAvatarTexture = class_2960.method_60655((String)"tiers-cache", (String)this.playerProfile.uuid);
            class_310.method_1551().method_1531().method_4616(this.playerAvatarTexture, (class_1044)new class_1043(class_1011.method_4309((InputStream)stream)));
            this.imageReady = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void method_25426() {
        this.playerProfile.resetDrawnStatus();
    }
}

