/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.tiers.TiersClient;
import com.tiers.misc.ConfigManager;
import com.tiers.misc.Mode;
import com.tiers.textures.Icons;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class InventoryChecker {
    private static final Set<class_1792> SWORD_NON_ALLOWED = Set.of(class_1802.field_8556, class_1802.field_8786, class_1802.field_8255, class_1802.field_8634, class_1802.field_8287, class_1802.field_8436, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> UHC_NON_ALLOWED = Set.of(class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> POT_NON_ALLOWED = Set.of(class_1802.field_8556, class_1802.field_8463, class_1802.field_8255, class_1802.field_8786, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> NETHPOT_NON_ALLOWED = Set.of(class_1802.field_8634, class_1802.field_8255, class_1802.field_22025, class_1802.field_22024, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> SMP_NON_ALLOWED = Set.of(class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22024, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> AXE_NON_ALLOWED = Set.of(class_1802.field_8634, class_1802.field_8786, class_1802.field_8463, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> MACE_NON_ALLOWED = Set.of(class_1802.field_8287, class_1802.field_22024, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> MINECART_NON_ALLOWED = Set.of(class_1802.field_8255, class_1802.field_49814, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> DIAMOND_SURVIVAL_NON_ALLOWED = Set.of(class_1802.field_22022, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030);
    private static final Set<class_1792> DEBUFF_NON_ALLOWED = Set.of(class_1802.field_8255, class_1802.field_8288, class_1802.field_8287, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> SUBTIERS_ELYTRA_NON_ALLOWED = Set.of(class_1802.field_8287, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> SPEED_NON_ALLOWED = Set.of(class_1802.field_8556, class_1802.field_8786, class_1802.field_8255, class_1802.field_8634, class_1802.field_8287, class_1802.field_8436, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> CREEPER_NON_ALLOWED = Set.of(class_1802.field_8833, class_1802.field_49098, class_1802.field_8287, class_1802.field_8436, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> MANHUNT_NON_ALLOWED = Set.of(class_1802.field_8288, class_1802.field_49098, class_1802.field_8287, class_1802.field_8436, class_1802.field_8802, class_1802.field_8556, class_1802.field_8805, class_1802.field_8285, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> DIAMOND_SMP_NON_ALLOWED = Set.of(class_1802.field_49098, class_1802.field_22022, class_1802.field_22025, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> BOW_NON_ALLOWED = Set.of(class_1802.field_8833, class_1802.field_49098, class_1802.field_8287, class_1802.field_8436, class_1802.field_8634, class_1802.field_8255, class_1802.field_8288, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22022, class_1802.field_22025, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> BED_NON_ALLOWED = Set.of(class_1802.field_49098, class_1802.field_49814, class_1802.field_8255, class_1802.field_8301, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> OG_VANILLA_NON_ALLOWED = Set.of(class_1802.field_8833, class_1802.field_49098, class_1802.field_8399, class_1802.field_8786, class_1802.field_8705, class_1802.field_8187, class_1802.field_8255, class_1802.field_8288, class_1802.field_8556, class_1802.field_22022, class_1802.field_22025, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);
    private static final Set<class_1792> TRIDENT_NON_ALLOWED = Set.of(class_1802.field_8833, class_1802.field_49098, class_1802.field_8399, class_1802.field_8187, class_1802.field_8255, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22022, class_1802.field_22025, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8301, class_1802.field_8281, class_1802.field_23141, class_1802.field_8801);

    public static void checkInventory(class_310 minecraftClient, boolean showMessage) {
        if (minecraftClient.field_1724 == null) {
            return;
        }
        if (showMessage && TiersClient.autoKitDetect) {
            TiersClient.sendMessageToPlayer(Icons.colorText("Auto kit detect is enabled. Pressing the keybind won't make a difference", "green"), true);
            return;
        }
        Mode detected = null;
        class_1661 playerInventory = minecraftClient.field_1724.method_31548();
        if (InventoryChecker.checkVanilla(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_VANILLA;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_CRYSTAL;
            detected = Mode.MCTIERS_VANILLA;
        }
        if (InventoryChecker.checkSword(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_SWORD;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_SWORD;
            detected = Mode.MCTIERS_SWORD;
        }
        if (InventoryChecker.checkUhc(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_UHC;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_UHC;
            detected = Mode.MCTIERS_UHC;
        }
        if (InventoryChecker.checkPot(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_POT;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_POT;
            detected = Mode.MCTIERS_POT;
        }
        if (InventoryChecker.checkNethPot(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_NETH_OP;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_NETH_POT;
            detected = Mode.MCTIERS_NETH_OP;
        }
        if (InventoryChecker.checkSmp(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_SMP;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_SMP;
            detected = Mode.MCTIERS_SMP;
        }
        if (InventoryChecker.checkAxe(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_AXE;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_AXE;
            detected = Mode.MCTIERS_AXE;
        }
        if (InventoryChecker.checkMace(playerInventory)) {
            TiersClient.activeMCTiersMode = Mode.MCTIERS_MACE;
            TiersClient.activePvPTiersMode = Mode.PVPTIERS_MACE;
            detected = Mode.MCTIERS_MACE;
        }
        if (InventoryChecker.checkMinecart(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_MINECART;
            detected = Mode.SUBTIERS_MINECART;
        }
        if (InventoryChecker.checkDiamondSurvival(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_DIAMOND_SURVIVAL;
            detected = Mode.SUBTIERS_DIAMOND_SURVIVAL;
        }
        if (InventoryChecker.checkDeBuff(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_DEBUFF;
            detected = Mode.SUBTIERS_DEBUFF;
        }
        if (InventoryChecker.checkSubtiersElytra(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_ELYTRA;
            detected = Mode.SUBTIERS_ELYTRA;
        }
        if (InventoryChecker.checkSpeed(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_SPEED;
            detected = Mode.SUBTIERS_SPEED;
        }
        if (InventoryChecker.checkCreeper(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_CREEPER;
            detected = Mode.SUBTIERS_CREEPER;
        }
        if (InventoryChecker.checkManhunt(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_MANHUNT;
            detected = Mode.SUBTIERS_MANHUNT;
        }
        if (InventoryChecker.checkDiamondSmp(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_DIAMOND_SMP;
            detected = Mode.SUBTIERS_DIAMOND_SMP;
        }
        if (InventoryChecker.checkBow(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_BOW;
            detected = Mode.SUBTIERS_BOW;
        }
        if (InventoryChecker.checkBed(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_BED;
            detected = Mode.SUBTIERS_BED;
        }
        if (InventoryChecker.checkOgVanilla(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_OG_VANILLA;
            detected = Mode.SUBTIERS_OG_VANILLA;
        }
        if (InventoryChecker.checkTrident(playerInventory)) {
            TiersClient.activeSubtiersMode = Mode.SUBTIERS_TRIDENT;
            detected = Mode.SUBTIERS_TRIDENT;
        }
        if (detected != null) {
            if (showMessage) {
                TiersClient.sendMessageToPlayer((class_2561)class_2561.method_43473().method_10852(detected.getTextLabel()).method_10852(class_2561.method_30163((String)" was detected")), true);
            }
            TiersClient.updateAllTags();
        } else if (showMessage) {
            TiersClient.sendMessageToPlayer(Icons.colorText("No gamemode detected", "red"), true);
        }
        ConfigManager.saveConfig();
    }

    private static boolean checkVanilla(class_1661 playerInventory) {
        boolean hasObsidian = false;
        boolean hasCrystal = false;
        boolean hasAnchor = false;
        boolean hasGlowstone = false;
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasObsidian |= InventoryChecker.hasItem(stack, class_1802.field_8281);
            hasCrystal |= InventoryChecker.hasItem(stack, class_1802.field_8301);
            hasAnchor |= InventoryChecker.hasItem(stack, class_1802.field_23141);
            hasGlowstone |= InventoryChecker.hasItem(stack, class_1802.field_8801);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
        }
        return hasObsidian && hasCrystal && hasAnchor && hasGlowstone && hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkSword(class_1661 playerInventory) {
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285);
            if (!SWORD_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkUhc(class_1661 playerInventory) {
        boolean hasShield = false;
        boolean hasGaps = false;
        boolean hasLava = false;
        boolean hasWater = false;
        boolean hasCobwebs = false;
        boolean hasEnchantedBow = false;
        boolean hasEnchantedCrossbow = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasLava |= InventoryChecker.hasItem(stack, class_1802.field_8187);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasCobwebs |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasEnchantedBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasEnchantedCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, true);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_8556, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true) || InventoryChecker.hasItem(stack, class_1802.field_8396, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!UHC_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasShield && hasGaps && hasLava && hasWater && hasCobwebs && hasEnchantedBow && hasEnchantedCrossbow && hasEnchantedSword && hasEnchantedAxe && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkPot(class_1661 playerInventory) {
        boolean hasSteak = false;
        boolean hasPotions = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasSteak |= InventoryChecker.hasItem(stack, class_1802.field_8176);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!POT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSteak && hasPotions && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkNethPot(class_1661 playerInventory) {
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!NETHPOT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasPotions && hasTotem && hasXp && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkSmp(class_1661 playerInventory) {
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasPearls = false;
        boolean hasShield = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_22025, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!SMP_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasPotions && hasTotem && hasXp && hasPearls && hasShield && hasEnchantedAxe && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkAxe(class_1661 playerInventory) {
        boolean hasBow = false;
        boolean hasCrossbow = false;
        boolean hasShield = false;
        boolean hasSword = false;
        boolean hasAxe = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, false);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, false);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255, false);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, false);
            hasAxe |= InventoryChecker.hasItem(stack, class_1802.field_8556, false);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, false);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, false);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, false);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, false);
            if (!AXE_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasBow && hasCrossbow && hasShield && hasSword && hasAxe && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkMace(class_1661 playerInventory) {
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasPearls = false;
        boolean hasWindCharge = false;
        boolean hasElytra = false;
        boolean hasShield = false;
        boolean hasEnchantedMace = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasWindCharge |= InventoryChecker.hasItem(stack, class_1802.field_49098);
            hasElytra |= InventoryChecker.hasItem(stack, class_1802.field_8833);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasEnchantedMace |= InventoryChecker.hasItem(stack, class_1802.field_49814, true);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_22025, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!MACE_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasPotions && hasTotem && hasPearls && hasWindCharge && hasElytra && hasShield && hasEnchantedMace && hasEnchantedSword && hasEnchantedAxe && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkMinecart(class_1661 playerInventory) {
        boolean hasCart = false;
        boolean hasCobwebs = false;
        boolean hasPotions = false;
        boolean hasRails = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasCart |= InventoryChecker.hasItem(stack, class_1802.field_8069);
            hasCobwebs |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasRails |= InventoryChecker.hasItem(stack, class_1802.field_8129);
            hasRails |= InventoryChecker.hasItem(stack, class_1802.field_8848);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_22025, true);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!MINECART_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasCart && hasCobwebs && hasPotions && hasRails && hasEnchantedAxe && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkDiamondSurvival(class_1661 playerInventory) {
        boolean hasObsidian = false;
        boolean hasCrystal = false;
        boolean hasAnchor = false;
        boolean hasGlowstone = false;
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasObsidian |= InventoryChecker.hasItem(stack, class_1802.field_8281);
            hasCrystal |= InventoryChecker.hasItem(stack, class_1802.field_8301);
            hasAnchor |= InventoryChecker.hasItem(stack, class_1802.field_23141);
            hasGlowstone |= InventoryChecker.hasItem(stack, class_1802.field_8801);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!DIAMOND_SURVIVAL_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasObsidian && hasCrystal && hasAnchor && hasGlowstone && hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkDeBuff(class_1661 playerInventory) {
        boolean hasPots = false;
        boolean hasGoldenCarrots = false;
        boolean hasPearls = false;
        boolean hasCrossbow = false;
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasPots |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasGoldenCarrots |= InventoryChecker.hasItem(stack, class_1802.field_8071);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8528, false);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8267, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8577, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8570, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8370, true);
            if (!DEBUFF_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasPots && hasGoldenCarrots && hasPearls && hasCrossbow && hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkSubtiersElytra(class_1661 playerInventory) {
        boolean hasCobweb = false;
        boolean hasPots = false;
        boolean hasGaps = false;
        boolean hasTotem = false;
        boolean hasWindcharge = false;
        boolean hasPearls = false;
        boolean hasCrossbow = false;
        boolean hasBow = false;
        boolean hasElytra = false;
        boolean hasMace = false;
        boolean hasSword = false;
        boolean hasAxe = false;
        boolean hasChestplate = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasCobweb |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasPots |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasWindcharge |= InventoryChecker.hasItem(stack, class_1802.field_49098);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, true);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasElytra |= InventoryChecker.hasItem(stack, class_1802.field_8833);
            hasMace |= InventoryChecker.hasItem(stack, class_1802.field_49814);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasAxe |= InventoryChecker.hasItem(stack, class_1802.field_22025, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8577);
            if (!SUBTIERS_ELYTRA_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasCobweb && hasPots && hasGaps && hasTotem && hasWindcharge && hasPearls && hasCrossbow && hasBow && hasElytra && hasMace && hasSword && hasAxe && hasChestplate;
    }

    private static boolean checkSpeed(class_1661 playerInventory) {
        boolean hasSword = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, false);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8396, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!SPEED_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSword && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkCreeper(class_1661 playerInventory) {
        boolean hasCobweb = false;
        boolean hasCreeper = false;
        boolean hasWater = false;
        boolean hasTnt = false;
        boolean hasGaps = false;
        boolean hasTotem = false;
        boolean hasPearls = false;
        boolean hasCrossbow = false;
        boolean hasBow = false;
        boolean hasShield = false;
        boolean hasSword = false;
        boolean hasAxe = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasCobweb |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasCreeper |= InventoryChecker.hasItem(stack, class_1802.field_8503);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasTnt |= InventoryChecker.hasItem(stack, class_1802.field_8626);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, true);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8528, true);
            hasAxe |= InventoryChecker.hasItem(stack, class_1802.field_8062);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8283, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8873, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8218, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8313, true);
            if (!CREEPER_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasCobweb && hasCreeper && hasWater && hasTnt && hasGaps && hasTotem && hasPearls && hasCrossbow && hasBow && hasShield && hasSword && hasAxe && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkManhunt(class_1661 playerInventory) {
        boolean hasCobweb = false;
        boolean hasWater = false;
        boolean hasLava = false;
        boolean hasSponge = false;
        boolean hasTnt = false;
        boolean hasGaps = false;
        boolean hasSlime = false;
        boolean hasFlint = false;
        boolean hasPearls = false;
        boolean hasCrossbow = false;
        boolean hasBow = false;
        boolean hasShield = false;
        boolean hasSword = false;
        boolean hasAxe = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasCobweb |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasLava |= InventoryChecker.hasItem(stack, class_1802.field_8187);
            hasSponge |= InventoryChecker.hasItem(stack, class_1802.field_8535);
            hasTnt |= InventoryChecker.hasItem(stack, class_1802.field_8626);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasSlime |= InventoryChecker.hasItem(stack, class_1802.field_8828);
            hasFlint |= InventoryChecker.hasItem(stack, class_1802.field_8884);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasCrossbow |= InventoryChecker.hasItem(stack, class_1802.field_8399, false);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, false);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_8371, true);
            hasAxe |= InventoryChecker.hasItem(stack, class_1802.field_8475);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8743, true);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8660, true);
            if (!MANHUNT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasCobweb && hasWater && hasLava && hasSponge && hasTnt && hasGaps && hasSlime && hasFlint && hasPearls && hasCrossbow && hasBow && hasShield && hasSword && hasAxe && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean checkDiamondSmp(class_1661 playerInventory) {
        boolean hasGaps = false;
        boolean hasWater = false;
        boolean hasCobweb = false;
        boolean hasChorus = false;
        boolean hasPotions = false;
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasPearls = false;
        boolean hasShield = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedAxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasCobweb |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasChorus |= InventoryChecker.hasItem(stack, class_1802.field_8233);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasShield |= InventoryChecker.hasItem(stack, class_1802.field_8255);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedAxe |= InventoryChecker.hasItem(stack, class_1802.field_8556, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!DIAMOND_SMP_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasGaps && hasWater && hasCobweb && hasChorus && hasPotions && hasTotem && hasXp && hasPearls && hasShield && hasEnchantedAxe && hasEnchantedSword && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkBow(class_1661 playerInventory) {
        boolean hasBow = false;
        boolean hasArrow = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasArrow |= InventoryChecker.hasItem(stack, class_1802.field_8107);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8743, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8523, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8396, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8660, true);
            if (!BOW_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasBow && hasArrow && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkBed(class_1661 playerInventory) {
        boolean hasTotem = false;
        boolean hasXp = false;
        boolean hasPearls = false;
        boolean hasGaps = false;
        boolean hasBed = false;
        boolean hasObsidian = false;
        boolean hasSword = false;
        boolean hasPickaxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasXp |= InventoryChecker.hasItem(stack, class_1802.field_8287);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasBed |= InventoryChecker.hasItem(stack, class_1802.field_8112) || InventoryChecker.hasItem(stack, class_1802.field_8893) || InventoryChecker.hasItem(stack, class_1802.field_8059) || InventoryChecker.hasItem(stack, class_1802.field_8464) || InventoryChecker.hasItem(stack, class_1802.field_8789) || InventoryChecker.hasItem(stack, class_1802.field_8258) || InventoryChecker.hasItem(stack, class_1802.field_8368) || InventoryChecker.hasItem(stack, class_1802.field_8863);
            hasObsidian |= InventoryChecker.hasItem(stack, class_1802.field_8281);
            hasSword |= InventoryChecker.hasItem(stack, class_1802.field_22022, true);
            hasPickaxe |= InventoryChecker.hasItem(stack, class_1802.field_22024, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_22027, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_22028, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_22029, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_22030, true);
            if (!BED_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasTotem && hasXp && hasPearls && hasGaps && hasBed && hasObsidian && hasSword && hasPickaxe && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkOgVanilla(class_1661 playerInventory) {
        boolean hasSteak = false;
        boolean hasGaps = false;
        boolean hasPotions = false;
        boolean hasPearls = false;
        boolean hasEnchantedBow = false;
        boolean hasEnchantedSword = false;
        boolean hasEnchantedPickaxe = false;
        boolean hasEnchantedHelmet = false;
        boolean hasEnchantedChestplate = false;
        boolean hasEnchantedLeggings = false;
        boolean hasEnchantedBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasSteak |= InventoryChecker.hasItem(stack, class_1802.field_8176);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasPotions |= InventoryChecker.hasItem(stack, class_1802.field_8436);
            hasPearls |= InventoryChecker.hasItem(stack, class_1802.field_8634);
            hasEnchantedBow |= InventoryChecker.hasItem(stack, class_1802.field_8102, true);
            hasEnchantedSword |= InventoryChecker.hasItem(stack, class_1802.field_8802, true);
            hasEnchantedPickaxe |= InventoryChecker.hasItem(stack, class_1802.field_8377, true);
            hasEnchantedHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8805, true);
            hasEnchantedChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8058, true);
            hasEnchantedLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8348, true);
            hasEnchantedBoots |= InventoryChecker.hasItem(stack, class_1802.field_8285, true);
            if (!OG_VANILLA_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasSteak && hasGaps && hasPotions && hasPearls && hasEnchantedBow && hasEnchantedSword && hasEnchantedPickaxe && hasEnchantedHelmet && hasEnchantedChestplate && hasEnchantedLeggings && hasEnchantedBoots;
    }

    private static boolean checkTrident(class_1661 playerInventory) {
        boolean hasCobweb = false;
        boolean hasWater = false;
        boolean hasGaps = false;
        boolean hasSponge = false;
        boolean hasTotem = false;
        boolean hasShears = false;
        boolean hasTrident = false;
        boolean hasHelmet = false;
        boolean hasChestplate = false;
        boolean hasLeggings = false;
        boolean hasBoots = false;
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            class_1799 stack = playerInventory.method_5438(i);
            hasCobweb |= InventoryChecker.hasItem(stack, class_1802.field_8786);
            hasWater |= InventoryChecker.hasItem(stack, class_1802.field_8705);
            hasGaps |= InventoryChecker.hasItem(stack, class_1802.field_8463);
            hasSponge |= InventoryChecker.hasItem(stack, class_1802.field_8535);
            hasTotem |= InventoryChecker.hasItem(stack, class_1802.field_8288);
            hasShears |= InventoryChecker.hasItem(stack, class_1802.field_8868, true);
            hasTrident |= InventoryChecker.hasItem(stack, class_1802.field_8547, true);
            hasHelmet |= InventoryChecker.hasItem(stack, class_1802.field_8090, false);
            hasChestplate |= InventoryChecker.hasItem(stack, class_1802.field_8678, true);
            hasLeggings |= InventoryChecker.hasItem(stack, class_1802.field_8416, true);
            hasBoots |= InventoryChecker.hasItem(stack, class_1802.field_8753, true);
            if (!TRIDENT_NON_ALLOWED.contains(stack.method_7909())) continue;
            return false;
        }
        return hasCobweb && hasWater && hasGaps && hasSponge && hasTotem && hasShears && hasTrident && hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    private static boolean hasItem(class_1799 itemStack, class_1792 item, boolean needEnchant) {
        return itemStack.method_7909() == item && needEnchant == itemStack.method_7942();
    }

    private static boolean hasItem(class_1799 itemStack, class_1792 item) {
        return itemStack.method_7909() == item;
    }
}

