/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.mojang.brigadier.context.CommandContext;
import com.tiers.CommandRegister;
import com.tiers.ConfigManager;
import com.tiers.misc.ColorControl;
import com.tiers.misc.ColorLoader;
import com.tiers.misc.Icons;
import com.tiers.misc.PlayerProfileQueue;
import com.tiers.profiles.GameMode;
import com.tiers.profiles.PlayerProfile;
import com.tiers.profiles.Status;
import com.tiers.profiles.types.BaseProfile;
import com.tiers.screens.PlayerSearchResultScreen;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TiersClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(TiersClient.class);
    protected static final ArrayList<PlayerProfile> playerProfiles = new ArrayList();
    protected static final HashMap<String, class_2561> playerTexts = new HashMap();
    public static boolean toggleMod = true;
    public static boolean showIcons = true;
    public static boolean isSeparatorAdaptive = true;
    public static ModesTierDisplay displayMode = ModesTierDisplay.ADAPTIVE_HIGHEST;
    public static DisplayStatus mcTiersCOMPosition = DisplayStatus.LEFT;
    public static Modes activeMCTiersCOMMode = Modes.MCTIERSCOM_VANILLA;
    public static DisplayStatus mcTiersIOPosition = DisplayStatus.RIGHT;
    public static Modes activeMCTiersIOMode = Modes.MCTIERSIO_CRYSTAL;
    public static DisplayStatus subtiersNETPosition = DisplayStatus.OFF;
    public static Modes activeSubtiersNETMode = Modes.SUBTIERSNET_MINECART;
    private static class_304 cycleRightKey;
    private static class_304 cycleLeftKey;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        TiersClient.clearCache();
        CommandRegister.registerCommands();
        FabricLoader.getInstance().getModContainer("tiers").ifPresent(tiers -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"tiers", (String)"modern"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
        FabricLoader.getInstance().getModContainer("tiers").ifPresent(tiers -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"tiers", (String)"classic"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ColorLoader());
        cycleRightKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Right Gamemodes", 73, "Tiers"));
        cycleLeftKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Cycle Left Gamemodes", 85, "Tiers"));
        ClientTickEvents.END_CLIENT_TICK.register(TiersClient::checkKeys);
        LOGGER.info("Tiers initialized");
    }

    public static class_2561 getFullName(String originalName, class_2561 originalNameText) {
        PlayerProfile profile = TiersClient.addGetPlayer(originalName, false);
        if (profile.status == Status.READY && (profile.originalNameText == null || profile.originalNameText != originalNameText)) {
            TiersClient.updatePlayerNametag(originalNameText, profile);
        }
        if (playerTexts.containsKey(originalName)) {
            return playerTexts.get(originalName);
        }
        return originalNameText;
    }

    public static void updateAllTags() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY || profile.originalNameText == null) continue;
            TiersClient.updatePlayerNametag(profile.originalNameText, profile);
        }
    }

    public static void updatePlayerNametag(class_2561 originalNameText, PlayerProfile profile) {
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        if (mcTiersCOMPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        } else if (mcTiersCOMPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        }
        if (mcTiersIOPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersIOProfile, activeMCTiersIOMode);
        } else if (mcTiersIOPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersIOProfile, activeMCTiersIOMode);
        }
        if (subtiersNETPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.subtiersNETProfile, activeSubtiersNETMode);
        } else if (subtiersNETPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.subtiersNETProfile, activeSubtiersNETMode);
        }
        playerTexts.put(profile.name, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(originalNameText).method_10852((class_2561)rightText));
        profile.originalNameText = originalNameText;
    }

    private static class_2561 updateProfileNameTagRight(BaseProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)separator).method_10852(shown.displayedTier));
            if (showIcons) {
                returnValue.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852(shown.name.getIconTag()));
            }
        }
        return returnValue;
    }

    private static class_2561 updateProfileNameTagLeft(BaseProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            if (showIcons) {
                returnValue = class_2561.method_43470((String)"").method_10852(shown.name.getIconTag()).method_27693(" ");
            }
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852(shown.displayedTier).method_10852((class_2561)separator));
        }
        return returnValue;
    }

    public static void restyleAllTexts() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY) continue;
            if (profile.mcTiersCOMProfile.status == Status.READY) {
                profile.mcTiersCOMProfile.parseInfo(profile.mcTiersCOMProfile.originalJson);
            }
            if (profile.mcTiersIOProfile.status == Status.READY) {
                profile.mcTiersIOProfile.parseInfo(profile.mcTiersIOProfile.originalJson);
            }
            if (profile.subtiersNETProfile.status != Status.READY) continue;
            profile.subtiersNETProfile.parseInfo(profile.subtiersNETProfile.originalJson);
        }
    }

    public static void checkKeys(class_310 client) {
        if (cycleRightKey.method_1436()) {
            if (client.field_1724 == null) {
                return;
            }
            if (mcTiersCOMPosition.toString().equalsIgnoreCase("RIGHT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Right (MCTiersCOM) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersCOMMode()), true);
                return;
            }
            if (mcTiersIOPosition.toString().equalsIgnoreCase("RIGHT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Right (MCTiersIO) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersIOMode()), true);
                return;
            }
            if (subtiersNETPosition.toString().equalsIgnoreCase("RIGHT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Right (SubtiersNET) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleSubtiersNETMode()), true);
                return;
            }
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"There's nothing on the right display").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("red"))), true);
        }
        if (cycleLeftKey.method_1436()) {
            if (client.field_1724 == null) {
                return;
            }
            if (mcTiersCOMPosition.toString().equalsIgnoreCase("LEFT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Left (MCTiersCOM) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersCOMMode()), true);
                return;
            }
            if (mcTiersIOPosition.toString().equalsIgnoreCase("LEFT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Left (MCTiersIO) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleMCTiersIOMode()), true);
                return;
            }
            if (subtiersNETPosition.toString().equalsIgnoreCase("LEFT")) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Left (SubtiersNET) is now displaying ").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("text"))).method_10852(TiersClient.cycleSubtiersNETMode()), true);
                return;
            }
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"There's nothing on the left display").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("red"))), true);
        }
    }

    public static void sendMessageToPlayer(String chat_message, int color) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)chat_message).method_10862(class_2583.field_24360.method_36139(color)), false);
        }
    }

    protected static int toggleMod(CommandContext<FabricClientCommandSource> ignoredFabricClientCommandSourceCommandContext) {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
        TiersClient.sendMessageToPlayer("Tiers is now " + (toggleMod ? "enabled" : "disabled"), toggleMod ? ColorControl.getColor("green") : ColorControl.getColor("red"));
        return 1;
    }

    public static void toggleMod() {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
    }

    public static PlayerProfile addGetPlayer(String name, boolean priority) {
        for (PlayerProfile profile : playerProfiles) {
            if (!profile.name.equalsIgnoreCase(name)) continue;
            if (priority) {
                PlayerProfileQueue.changeToFirstInQueue(profile);
            }
            return profile;
        }
        PlayerProfile newProfile = new PlayerProfile(name);
        if (priority) {
            PlayerProfileQueue.putFirstInQueue(newProfile);
        } else {
            PlayerProfileQueue.enqueue(newProfile);
        }
        playerProfiles.add(newProfile);
        return newProfile;
    }

    private static void openPlayerSearchResultScreen(PlayerProfile profile) {
        class_310.method_1551().method_1507((class_437)new PlayerSearchResultScreen(profile));
    }

    protected static int searchPlayer(String name) {
        CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> class_310.method_1551().execute(() -> TiersClient.openPlayerSearchResultScreen(TiersClient.addGetPlayer(name, true))));
        return 1;
    }

    public static void clearCache() {
        playerProfiles.clear();
        playerTexts.clear();
        PlayerProfileQueue.clearQueue();
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/tiers-cache"));
        }
        catch (IOException e) {
            LOGGER.warn("Error deleting cache folder: {}", (Object)e.getMessage());
        }
    }

    public static void toggleSeparatorAdaptive() {
        isSeparatorAdaptive = !isSeparatorAdaptive;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void toggleShowIcons() {
        showIcons = !showIcons;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static class_2561 cycleMCTiersCOMMode() {
        activeMCTiersCOMMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersCOMMode, (Enum[])Modes.getMCTiersCOMValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeMCTiersCOMMode.label;
    }

    public static class_2561 cycleMCTiersIOMode() {
        activeMCTiersIOMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersIOMode, (Enum[])Modes.getMCTiersIOValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeMCTiersIOMode.label;
    }

    public static class_2561 cycleSubtiersNETMode() {
        activeSubtiersNETMode = (Modes)TiersClient.cycleEnum((Enum)activeSubtiersNETMode, (Enum[])Modes.getSubtiersNETValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
        return TiersClient.activeSubtiersNETMode.label;
    }

    public static void cycleMCTiersCOMPosition() {
        mcTiersCOMPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersCOMPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersIOPosition() {
        mcTiersIOPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersIOPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleSubtiersNETPosition() {
        subtiersNETPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)subtiersNETPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleDisplayMode() {
        displayMode = (ModesTierDisplay)TiersClient.cycleEnum((Enum)displayMode, (Enum[])ModesTierDisplay.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    private static <T extends Enum<T>> T cycleEnum(T current, T[] values) {
        return values[(current.ordinal() + 1) % values.length];
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DisplayStatus {
        RIGHT,
        LEFT,
        OFF;


        public String getIcon() {
            if (this.toString().equalsIgnoreCase("RIGHT")) {
                return "\u2192";
            }
            if (this.toString().equalsIgnoreCase("LEFT")) {
                return "\u2190";
            }
            return "\u25cf";
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Modes {
        MCTIERSCOM_VANILLA(Icons.MCTIERSCOM_VANILLA, Icons.MCTIERSCOM_VANILLA_TAG, "mctierscom_vanilla", "Vanilla"),
        MCTIERSCOM_UHC(Icons.MCTIERSCOM_UHC, Icons.MCTIERSCOM_UHC_TAG, "mctierscom_uhc", "UHC"),
        MCTIERSCOM_POT(Icons.MCTIERSCOM_POT, Icons.MCTIERSCOM_POT_TAG, "mctierscom_pot", "Pot"),
        MCTIERSCOM_NETHERITE_OP(Icons.MCTIERSCOM_NETHERITE_OP, Icons.MCTIERSCOM_NETHERITE_OP_TAG, "mctierscom_netherite_op", "Netherite Op"),
        MCTIERSCOM_SMP(Icons.MCTIERSCOM_SMP, Icons.MCTIERSCOM_SMP_TAG, "mctierscom_smp", "Smp"),
        MCTIERSCOM_SWORD(Icons.MCTIERSCOM_SWORD, Icons.MCTIERSCOM_SWORD_TAG, "mctierscom_sword", "Sword"),
        MCTIERSCOM_AXE(Icons.MCTIERSCOM_AXE, Icons.MCTIERSCOM_AXE_TAG, "mctierscom_axe", "Axe"),
        MCTIERSCOM_MACE(Icons.MCTIERSCOM_MACE, Icons.MCTIERSCOM_MACE_TAG, "mctierscom_mace", "Mace"),
        MCTIERSIO_CRYSTAL(Icons.MCTIERSIO_CRYSTAL, Icons.MCTIERSIO_CRYSTAL_TAG, "mctiersio_crystal", "Crystal"),
        MCTIERSIO_SWORD(Icons.MCTIERSIO_SWORD, Icons.MCTIERSIO_SWORD_TAG, "mctiersio_sword", "Sword"),
        MCTIERSIO_UHC(Icons.MCTIERSIO_UHC, Icons.MCTIERSIO_UHC_TAG, "mctiersio_uhc", "UHC"),
        MCTIERSIO_POT(Icons.MCTIERSIO_POT, Icons.MCTIERSIO_POT_TAG, "mctiersio_pot", "Pot"),
        MCTIERSIO_NETHERITE_POT(Icons.MCTIERSIO_NETHERITE_POT, Icons.MCTIERSIO_NETHERITE_POT_TAG, "mctiersio_netherite_pot", "Netherite Pot"),
        MCTIERSIO_SMP(Icons.MCTIERSIO_SMP, Icons.MCTIERSIO_SMP_TAG, "mctiersio_smp", "Smp"),
        MCTIERSIO_AXE(Icons.MCTIERSIO_AXE, Icons.MCTIERSIO_AXE_TAG, "mctiersio_axe", "Axe"),
        MCTIERSIO_ELYTRA(Icons.MCTIERSIO_ELYTRA, Icons.MCTIERSIO_ELYTRA_TAG, "mctiersio_elytra", "Elytra"),
        SUBTIERSNET_MINECART(Icons.SUBTIERSNET_MINECART, Icons.SUBTIERSNET_MINECART_TAG, "subtiersnet_minecart", "Minecart"),
        SUBTIERSNET_DIAMOND_CRYSTAL(Icons.SUBTIERSNET_DIAMOND_CRYSTAL, Icons.SUBTIERSNET_DIAMOND_CRYSTAL_TAG, "subtiersnet_diamond_crystal", "Diamond Crystal"),
        SUBTIERSNET_DEBUFF(Icons.SUBTIERSNET_DEBUFF, Icons.SUBTIERSNET_DEBUFF_TAG, "subtiersnet_debuff", "DeBuff"),
        SUBTIERSNET_ELYTRA(Icons.SUBTIERSNET_ELYTRA, Icons.SUBTIERSNET_ELYTRA_TAG, "subtiersnet_elytra", "Elytra"),
        SUBTIERSNET_SPEED(Icons.SUBTIERSNET_SPEED, Icons.SUBTIERSNET_SPEED_TAG, "subtiersnet_speed", "Speed"),
        SUBTIERSNET_CREEPER(Icons.SUBTIERSNET_CREEPER, Icons.SUBTIERSNET_CREEPER_TAG, "subtiersnet_creeper", "Creeper"),
        SUBTIERSNET_MANHUNT(Icons.SUBTIERSNET_MANHUNT, Icons.SUBTIERSNET_MANHUNT_TAG, "subtiersnet_manhunt", "Manhunt"),
        SUBTIERSNET_DIAMOND_SMP(Icons.SUBTIERSNET_DIAMOND_SMP, Icons.SUBTIERSNET_DIAMOND_SMP_TAG, "subtiersnet_diamond_smp", "Diamond Smp"),
        SUBTIERSNET_BOW(Icons.SUBTIERSNET_BOW, Icons.SUBTIERSNET_BOW_TAG, "subtiersnet_bow", "Bow"),
        SUBTIERSNET_BED(Icons.SUBTIERSNET_BED, Icons.SUBTIERSNET_BED_TAG, "subtiersnet_bed", "Bed"),
        SUBTIERSNET_OG_VANILLA(Icons.SUBTIERSNET_OG_VANILLA, Icons.SUBTIERSNET_OG_VANILLA_TAG, "subtiersnet_og_vanilla", "OG Vanilla"),
        SUBTIERSNET_TRIDENT(Icons.SUBTIERSNET_TRIDENT, Icons.SUBTIERSNET_TRIDENT_TAG, "subtiersnet_trident", "Trident");

        private final class_2561 icon;
        private final class_2561 iconTag;
        private final String color;
        private final String stringLabel;
        private class_2561 label;

        private Modes(class_2561 icon, class_2561 iconTag, String color, String label) {
            this.icon = icon;
            this.iconTag = iconTag;
            this.color = color;
            this.stringLabel = label;
            this.label = class_2561.method_43470((String)label).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor(color)));
        }

        public static void updateColors() {
            for (Modes mode : Modes.values()) {
                mode.label = class_2561.method_43470((String)mode.stringLabel).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor(mode.color)));
            }
        }

        public class_2561 getIcon() {
            return this.icon;
        }

        public class_2561 getIconTag() {
            return this.iconTag;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public static Modes[] getMCTiersCOMValues() {
            Modes[] modesArray = new Modes[8];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("MCTIERSCOM")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }

        public static Modes[] getMCTiersIOValues() {
            Modes[] modesArray = new Modes[7];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("MCTIERSIO")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }

        public static Modes[] getSubtiersNETValues() {
            Modes[] modesArray = new Modes[9];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("SUBTIERSNET")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ModesTierDisplay {
        HIGHEST,
        SELECTED,
        ADAPTIVE_HIGHEST;


        public String getIcon() {
            if (this.toString().equalsIgnoreCase("HIGHEST")) {
                return "\u2191";
            }
            if (this.toString().equalsIgnoreCase("SELECTED")) {
                return "\u25cf";
            }
            return "\u2193";
        }
    }
}

