/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profiles.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tiers.TiersClient;
import com.tiers.misc.ColorControl;
import com.tiers.profiles.GameMode;
import com.tiers.profiles.Status;
import com.tiers.profiles.types.SubtiersNETProfile;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

@Environment(value=EnvType.CLIENT)
public class BaseProfile {
    public Status status = Status.SEARCHING;
    public String region;
    public int points;
    public int overallPosition;
    public boolean combatMaster;
    public class_2561 displayedRegion;
    public class_2561 displayedOverall;
    public class_2561 overallTooltip;
    public class_2561 regionTooltip;
    public ArrayList<GameMode> gameModes = new ArrayList();
    public GameMode highest;
    public String originalJson;
    public boolean drawn = false;
    private int numberOfRequests = 0;

    protected BaseProfile(String uuid, String apiUrl) {
        this.buildRequest(uuid, apiUrl);
    }

    private void buildRequest(String uuid, String apiUrl) {
        if (this.numberOfRequests == 5 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl + uuid)).header("User-Agent", "Tiers").GET().build();
        ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            if (response.statusCode() != 200) {
                this.status = Status.NOT_EXISTING;
            } else {
                this.parseInfo((String)response.body());
            }
        })).exceptionally(exception -> {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(uuid, apiUrl));
            return null;
        });
    }

    public void parseInfo(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (!(jsonObject.has("name") && jsonObject.has("region") && jsonObject.has("points") && jsonObject.has("overall"))) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.region = !jsonObject.get("region").isJsonNull() ? jsonObject.get("region").getAsString() : "Unknown";
        this.points = jsonObject.get("points").getAsInt();
        this.combatMaster = this.points >= 250;
        this.overallPosition = jsonObject.get("overall").getAsInt();
        this.displayedRegion = this.getRegionText();
        this.regionTooltip = this.getRegionTooltip();
        this.displayedOverall = this.getOverallText();
        this.overallTooltip = this.getOverallTooltip();
        this.parseRankings(jsonObject.getAsJsonObject("rankings"));
        this.status = Status.READY;
        this.originalJson = json;
    }

    private void parseRankings(JsonObject jsonObject) {
        for (GameMode gameMode : this.gameModes) {
            if (jsonObject.has(gameMode.parsingName)) {
                gameMode.parseTiers(jsonObject.getAsJsonObject(gameMode.parsingName));
                continue;
            }
            gameMode.status = Status.NOT_EXISTING;
        }
        this.highest = this.getHighestMode();
    }

    public GameMode getGameMode(TiersClient.Modes gamemode) {
        for (GameMode gameMode : this.gameModes) {
            if (!gameMode.name.toString().equalsIgnoreCase(gamemode.toString())) continue;
            return gameMode;
        }
        this.status = Status.NOT_EXISTING;
        return null;
    }

    private GameMode getHighestMode() {
        GameMode highest = null;
        int highestPoints = 0;
        for (GameMode gameMode : this.gameModes) {
            if (gameMode.status != Status.READY || gameMode.getTierPoints(false) <= highestPoints) continue;
            highest = gameMode;
            highestPoints = gameMode.getTierPoints(false);
        }
        return highest;
    }

    private class_2561 getRegionText() {
        if (this.region.equalsIgnoreCase("EU")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("eu")));
        }
        if (this.region.equalsIgnoreCase("NA")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("na")));
        }
        if (this.region.equalsIgnoreCase("AS")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("as")));
        }
        if (this.region.equalsIgnoreCase("AU")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("au")));
        }
        if (this.region.equalsIgnoreCase("SA")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("sa")));
        }
        if (this.region.equalsIgnoreCase("ME")) {
            return class_2561.method_43470((String)this.region).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("me")));
        }
        return class_2561.method_43470((String)"Unknown").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("unknown")));
    }

    private class_2561 getRegionTooltip() {
        if (this.region.equalsIgnoreCase("EU")) {
            return class_2561.method_43470((String)"Europe").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("eu")));
        }
        if (this.region.equalsIgnoreCase("NA")) {
            return class_2561.method_43470((String)"North America").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("na")));
        }
        if (this.region.equalsIgnoreCase("AS")) {
            return class_2561.method_43470((String)"Asia").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("as")));
        }
        if (this.region.equalsIgnoreCase("AU")) {
            return class_2561.method_43470((String)"Australia").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("au")));
        }
        if (this.region.equalsIgnoreCase("SA")) {
            return class_2561.method_43470((String)"South America").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("sa")));
        }
        if (this.region.equalsIgnoreCase("ME")) {
            return class_2561.method_43470((String)"Middle East").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("me")));
        }
        return class_2561.method_43470((String)"Unknown").method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("unknown")));
    }

    private class_2561 getOverallText() {
        if (this.combatMaster) {
            return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("master")));
        }
        if (this.points >= 100) {
            return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("ace")));
        }
        if (this.points >= 50) {
            return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("specialist")));
        }
        if (this.points >= 20) {
            return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("cadet")));
        }
        if (this.points >= 10) {
            return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("novice")));
        }
        return class_2561.method_43470((String)("#" + this.overallPosition)).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor("rookie")));
    }

    private class_2561 getOverallTooltip() {
        Object overallTooltip = "Combat ";
        if (this instanceof SubtiersNETProfile) {
            overallTooltip = "Subtiers ";
        }
        overallTooltip = this.combatMaster ? (String)overallTooltip + "Master" : (this.points >= 100 ? (String)overallTooltip + "Ace" : (this.points >= 50 ? (String)overallTooltip + "Specialist" : (this.points >= 20 ? (String)overallTooltip + "Cadet" : (this.points >= 10 ? (String)overallTooltip + "Novice" : "Rookie"))));
        overallTooltip = (String)overallTooltip + "\n\nPoints: " + this.points;
        return class_2561.method_43470((String)overallTooltip).method_10862(this.displayedOverall.method_10866());
    }
}

