/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.misc;

import com.google.gson.Gson;
import com.tiers.TiersClient;
import com.tiers.misc.Mode;
import com.tiers.textures.Icons;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static Config config;
    private static final Path CONFIG_PATH;

    public static void loadConfig() {
        Gson gson = new Gson();
        File file = CONFIG_PATH.toFile();
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);){
                config = (Config)gson.fromJson((Reader)fileReader, Config.class);
                if (config == null) {
                    ConfigManager.restoreFromClient();
                }
            }
            catch (IOException ignored) {
                ConfigManager.restoreFromClient();
            }
        } else {
            ConfigManager.restoreFromClient();
        }
        TiersClient.toggleMod = ConfigManager.config.toggleMod;
        TiersClient.showIcons = ConfigManager.config.showIcons;
        TiersClient.isSeparatorAdaptive = ConfigManager.config.isSeparatorAdaptive;
        TiersClient.autoKitDetect = ConfigManager.config.autoKitDetect;
        if (Arrays.stream(TiersClient.ModesTierDisplay.values()).toList().contains((Object)ConfigManager.config.displayMode)) {
            TiersClient.displayMode = ConfigManager.config.displayMode;
        }
        if (Arrays.stream(Icons.Type.values()).toList().contains((Object)ConfigManager.config.activeIcons)) {
            TiersClient.activeIcons = ConfigManager.config.activeIcons;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.positionMCTiers)) {
            TiersClient.positionMCTiers = ConfigManager.config.positionMCTiers;
        }
        if (Arrays.stream(Mode.values()).toList().contains((Object)ConfigManager.config.activeMCTiersMode) && ConfigManager.config.activeMCTiersMode.toString().contains("MCTIERS")) {
            TiersClient.activeMCTiersMode = ConfigManager.config.activeMCTiersMode;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.positionPvPTiers)) {
            TiersClient.positionPvPTiers = ConfigManager.config.positionPvPTiers;
        }
        if (Arrays.stream(Mode.values()).toList().contains((Object)ConfigManager.config.activePvPTiersMode) && ConfigManager.config.activePvPTiersMode.toString().contains("PVPTIERS")) {
            TiersClient.activePvPTiersMode = ConfigManager.config.activePvPTiersMode;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.positionSubtiers)) {
            TiersClient.positionSubtiers = ConfigManager.config.positionSubtiers;
        }
        if (Arrays.stream(Mode.values()).toList().contains((Object)ConfigManager.config.activeSubtiersMode) && ConfigManager.config.activeSubtiersMode.toString().contains("SUBTIERS")) {
            TiersClient.activeSubtiersMode = ConfigManager.config.activeSubtiersMode;
        }
        ConfigManager.saveConfig();
    }

    private static void restoreFromClient() {
        config = new Config();
        ConfigManager.config.toggleMod = TiersClient.toggleMod;
        ConfigManager.config.showIcons = TiersClient.showIcons;
        ConfigManager.config.isSeparatorAdaptive = TiersClient.isSeparatorAdaptive;
        ConfigManager.config.autoKitDetect = TiersClient.autoKitDetect;
        ConfigManager.config.displayMode = TiersClient.displayMode;
        ConfigManager.config.activeIcons = TiersClient.activeIcons;
        ConfigManager.config.positionMCTiers = TiersClient.positionMCTiers;
        ConfigManager.config.activeMCTiersMode = TiersClient.activeMCTiersMode;
        ConfigManager.config.positionPvPTiers = TiersClient.positionPvPTiers;
        ConfigManager.config.activePvPTiersMode = TiersClient.activePvPTiersMode;
        ConfigManager.config.positionSubtiers = TiersClient.positionSubtiers;
        ConfigManager.config.activeSubtiersMode = TiersClient.activeSubtiersMode;
        ConfigManager.saveConfig();
    }

    public static void saveConfig() {
        Gson gson = new Gson();
        File file = CONFIG_PATH.toFile();
        Config config = new Config();
        config.toggleMod = TiersClient.toggleMod;
        config.showIcons = TiersClient.showIcons;
        config.isSeparatorAdaptive = TiersClient.isSeparatorAdaptive;
        config.autoKitDetect = TiersClient.autoKitDetect;
        config.displayMode = TiersClient.displayMode;
        config.activeIcons = TiersClient.activeIcons;
        config.positionMCTiers = TiersClient.positionMCTiers;
        config.activeMCTiersMode = TiersClient.activeMCTiersMode;
        config.positionPvPTiers = TiersClient.positionPvPTiers;
        config.activePvPTiersMode = TiersClient.activePvPTiersMode;
        config.positionSubtiers = TiersClient.positionSubtiers;
        config.activeSubtiersMode = TiersClient.activeSubtiersMode;
        try (FileWriter fileWriter = new FileWriter(file);){
            gson.toJson((Object)config, (Appendable)fileWriter);
        }
        catch (IOException ignored) {
            ConfigManager.restoreFromClient();
        }
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("Tiers.json");
    }

    @Environment(value=EnvType.CLIENT)
    private static class Config {
        boolean toggleMod;
        boolean showIcons;
        boolean isSeparatorAdaptive;
        boolean autoKitDetect;
        TiersClient.ModesTierDisplay displayMode;
        Icons.Type activeIcons;
        TiersClient.DisplayStatus positionMCTiers;
        Mode activeMCTiersMode;
        TiersClient.DisplayStatus positionPvPTiers;
        Mode activePvPTiersMode;
        TiersClient.DisplayStatus positionSubtiers;
        Mode activeSubtiersMode;

        private Config() {
        }
    }
}

