/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profile.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tiers.TiersClient;
import com.tiers.misc.Mode;
import com.tiers.profile.GameMode;
import com.tiers.profile.Status;
import com.tiers.profile.types.PvPTiersProfile;
import com.tiers.profile.types.SubtiersProfile;
import com.tiers.textures.Icons;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SuperProfile {
    public Status status = Status.SEARCHING;
    private int numberOfRequests;
    private String region;
    private int points;
    private int overallPosition;
    public class_2561 displayedRegion;
    public class_2561 displayedOverall;
    public class_2561 overallTooltip;
    public class_2561 regionTooltip;
    public final ArrayList<GameMode> gameModes = new ArrayList();
    public GameMode highest;
    public String originalJson;
    public boolean drawn;

    protected SuperProfile() {
    }

    protected void buildRequest(String uuid, String apiUrl) {
        if (this.numberOfRequests == 5 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(apiUrl + uuid)).header("User-Agent", TiersClient.userAgent).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        ((CompletableFuture)httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            if (response.statusCode() == 404) {
                this.status = Status.NOT_EXISTING;
                return;
            }
            if (response.statusCode() != 200) {
                this.status = Status.API_ISSUE;
                return;
            }
            this.parseJson((String)response.body());
        })).exceptionally(ignored -> {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(uuid, apiUrl));
            return null;
        });
    }

    public void parseJson(String json) {
        if (JsonParser.parseString((String)json).isJsonNull()) {
            this.status = Status.API_ISSUE;
            return;
        }
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (!(jsonObject.has("name") && jsonObject.has("region") && jsonObject.has("points") && jsonObject.has("overall") && jsonObject.has("rankings"))) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.region = !jsonObject.get("region").isJsonNull() ? jsonObject.get("region").getAsString() : "Unknown";
        this.points = jsonObject.get("points").getAsInt();
        this.overallPosition = jsonObject.get("overall").getAsInt();
        this.displayedRegion = this.getRegionText();
        this.regionTooltip = this.getRegionTooltip();
        this.displayedOverall = this.getOverallText();
        this.overallTooltip = this.getOverallTooltip();
        this.parseRankings(jsonObject.getAsJsonObject("rankings"));
        this.status = Status.READY;
        this.originalJson = json;
    }

    private void parseRankings(JsonObject jsonObject) {
        for (GameMode gameMode : this.gameModes) {
            if (jsonObject.has(gameMode.parsingName)) {
                gameMode.parseTiers(jsonObject.getAsJsonObject(gameMode.parsingName));
                continue;
            }
            gameMode.status = Status.NOT_EXISTING;
        }
        this.highest = this.getHighestMode();
    }

    public GameMode getGameMode(Mode gamemode) {
        for (GameMode gameMode : this.gameModes) {
            if (!gameMode.gamemode.toString().equalsIgnoreCase(gamemode.toString())) continue;
            return gameMode;
        }
        this.status = Status.NOT_EXISTING;
        return null;
    }

    private GameMode getHighestMode() {
        GameMode highest = null;
        int highestPoints = 0;
        for (GameMode gameMode : this.gameModes) {
            if (gameMode.status != Status.READY || gameMode.getTierPoints(false) <= highestPoints) continue;
            highest = gameMode;
            highestPoints = gameMode.getTierPoints(false);
        }
        return highest;
    }

    private class_2561 getRegionText() {
        if (this.region.equalsIgnoreCase("EU")) {
            return Icons.colorText(this.region, "eu");
        }
        if (this.region.equalsIgnoreCase("NA")) {
            return Icons.colorText(this.region, "na");
        }
        if (this.region.equalsIgnoreCase("AS")) {
            return Icons.colorText(this.region, "as");
        }
        if (this.region.equalsIgnoreCase("AU")) {
            return Icons.colorText(this.region, "au");
        }
        if (this.region.equalsIgnoreCase("SA")) {
            return Icons.colorText(this.region, "sa");
        }
        if (this.region.equalsIgnoreCase("ME")) {
            return Icons.colorText(this.region, "me");
        }
        if (this.region.equalsIgnoreCase("AF")) {
            return Icons.colorText(this.region, "af");
        }
        if (this.region.equalsIgnoreCase("OC")) {
            return Icons.colorText(this.region, "oc");
        }
        return Icons.colorText("Unknown", "unknown");
    }

    private class_2561 getRegionTooltip() {
        if (this.region.equalsIgnoreCase("EU")) {
            return Icons.colorText("Europe", "eu");
        }
        if (this.region.equalsIgnoreCase("NA")) {
            return Icons.colorText("North America", "na");
        }
        if (this.region.equalsIgnoreCase("AS")) {
            return Icons.colorText("Asia", "as");
        }
        if (this.region.equalsIgnoreCase("AU")) {
            return Icons.colorText("Australia", "au");
        }
        if (this.region.equalsIgnoreCase("SA")) {
            return Icons.colorText("South America", "sa");
        }
        if (this.region.equalsIgnoreCase("ME")) {
            return Icons.colorText("Middle East", "me");
        }
        if (this.region.equalsIgnoreCase("AF")) {
            return Icons.colorText("Africa", "af");
        }
        if (this.region.equalsIgnoreCase("OC")) {
            return Icons.colorText("Oceania", "oc");
        }
        return Icons.colorText("Unknown", "unknown");
    }

    private class_2561 getOverallText() {
        String positionString = "#" + this.overallPosition;
        if (!(this instanceof PvPTiersProfile) && this.points >= 250) {
            return Icons.colorText(positionString, "master");
        }
        if (this instanceof PvPTiersProfile && this.points >= 200) {
            return Icons.colorText(positionString, "master");
        }
        if (this.points >= 100) {
            return Icons.colorText(positionString, "ace");
        }
        if (this.points >= 50) {
            return Icons.colorText(positionString, "specialist");
        }
        if (this.points >= 20) {
            return Icons.colorText(positionString, "cadet");
        }
        if (this.points >= 10) {
            return Icons.colorText(positionString, "novice");
        }
        return Icons.colorText(positionString, "rookie");
    }

    private class_2561 getOverallTooltip() {
        Object overallTooltip = "Combat ";
        if (this instanceof SubtiersProfile) {
            overallTooltip = "Subtiers ";
        }
        overallTooltip = !(this instanceof PvPTiersProfile) && this.points >= 400 ? (String)overallTooltip + "Grandmaster" : (!(this instanceof PvPTiersProfile) && this.points >= 250 ? (String)overallTooltip + "Master" : (this instanceof PvPTiersProfile && this.points >= 200 ? (String)overallTooltip + "Master" : (this.points >= 100 ? (String)overallTooltip + "Ace" : (this.points >= 50 ? (String)overallTooltip + "Specialist" : (this.points >= 20 ? (String)overallTooltip + "Cadet" : (this.points >= 10 ? (String)overallTooltip + "Novice" : "Rookie"))))));
        overallTooltip = (String)overallTooltip + "\n\nPoints: " + this.points;
        return class_2561.method_43470((String)overallTooltip).method_10862(this.displayedOverall.method_10866());
    }
}

