/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.misc;

import com.tiers.textures.Icons;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public enum Mode {
    MCTIERS_VANILLA(Category.MCTIERS, "\uf000", "Vanilla"),
    MCTIERS_UHC(Category.MCTIERS, "\uf001", "UHC"),
    MCTIERS_POT(Category.MCTIERS, "\uf002", "Pot"),
    MCTIERS_NETH_OP(Category.MCTIERS, "\uf003", "Neth Op"),
    MCTIERS_SMP(Category.MCTIERS, "\uf004", "Smp"),
    MCTIERS_SWORD(Category.MCTIERS, "\uf005", "Sword"),
    MCTIERS_AXE(Category.MCTIERS, "\uf006", "Axe"),
    MCTIERS_MACE(Category.MCTIERS, "\uf007", "Mace"),
    PVPTIERS_CRYSTAL(Category.PVPTIERS, "\uf000", "Crystal"),
    PVPTIERS_SWORD(Category.PVPTIERS, "\uf005", "Sword"),
    PVPTIERS_UHC(Category.PVPTIERS, "\uf001", "UHC"),
    PVPTIERS_POT(Category.PVPTIERS, "\uf002", "Pot"),
    PVPTIERS_NETH_POT(Category.PVPTIERS, "\uf003", "Neth Pot"),
    PVPTIERS_SMP(Category.PVPTIERS, "\uf004", "Smp"),
    PVPTIERS_AXE(Category.PVPTIERS, "\uf006", "Axe"),
    PVPTIERS_MACE(Category.PVPTIERS, "\uf007", "Mace"),
    SUBTIERS_MINECART(Category.SUBTIERS, "\uf000", "Minecart"),
    SUBTIERS_DIAMOND_SURVIVAL(Category.SUBTIERS, "\uf001", "Diamond Survival"),
    SUBTIERS_DEBUFF(Category.SUBTIERS, "\uf002", "DeBuff"),
    SUBTIERS_ELYTRA(Category.SUBTIERS, "\uf003", "Elytra"),
    SUBTIERS_SPEED(Category.SUBTIERS, "\uf004", "Speed"),
    SUBTIERS_CREEPER(Category.SUBTIERS, "\uf005", "Creeper"),
    SUBTIERS_MANHUNT(Category.SUBTIERS, "\uf006", "Manhunt"),
    SUBTIERS_DIAMOND_SMP(Category.SUBTIERS, "\uf007", "Diamond Smp"),
    SUBTIERS_BOW(Category.SUBTIERS, "\uf008", "Bow"),
    SUBTIERS_BED(Category.SUBTIERS, "\uf009", "Bed"),
    SUBTIERS_OG_VANILLA(Category.SUBTIERS, "\uf00a", "OG Vanilla"),
    SUBTIERS_TRIDENT(Category.SUBTIERS, "\uf00b", "Trident");

    private final Category category;
    private final String unicode;
    private final String label;

    private Mode(Category category, String unicode, String label) {
        this.category = category;
        this.unicode = unicode;
        this.label = label;
    }

    public class_2561 getIcon() {
        class_2960 identifier = switch (this.category.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Icons.identifierMCTiers;
            case 1 -> Icons.identifierPvPTiers;
            case 2 -> Icons.identifierSubtiers;
        };
        return class_2561.method_43470((String)this.unicode).method_10862(class_2583.field_24360.method_27704(identifier));
    }

    public class_2561 getIconTag() {
        class_2960 identifier = switch (this.category.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Icons.identifierMCTiersTags;
            case 1 -> Icons.identifierPvPTiersTags;
            case 2 -> Icons.identifierSubtiersTags;
        };
        return class_2561.method_43470((String)this.unicode).method_10862(class_2583.field_24360.method_27704(identifier));
    }

    public class_2561 getTextLabel() {
        return Icons.colorText(this.label, this.name().toLowerCase());
    }

    public static Mode[] getMCTiersValues() {
        Mode[] modeArray = new Mode[8];
        ArrayList<Mode> modeArrayList = new ArrayList<Mode>();
        for (Mode mode : Mode.values()) {
            if (!mode.toString().contains("MCTIERS")) continue;
            modeArrayList.add(mode);
        }
        return modeArrayList.toArray(modeArray);
    }

    public static Mode[] getPvPTiersValues() {
        Mode[] modeArray = new Mode[7];
        ArrayList<Mode> modeArrayList = new ArrayList<Mode>();
        for (Mode mode : Mode.values()) {
            if (!mode.toString().contains("PVPTIERS")) continue;
            modeArrayList.add(mode);
        }
        return modeArrayList.toArray(modeArray);
    }

    public static Mode[] getSubtiersValues() {
        Mode[] modeArray = new Mode[9];
        ArrayList<Mode> modeArrayList = new ArrayList<Mode>();
        for (Mode mode : Mode.values()) {
            if (!mode.toString().contains("SUBTIERS")) continue;
            modeArrayList.add(mode);
        }
        return modeArrayList.toArray(modeArray);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Category {
        MCTIERS,
        PVPTIERS,
        SUBTIERS;

    }
}

