/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.tiers.profile.PlayerProfile;
import com.tiers.profile.Status;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PlayerProfileQueue {
    private static final ConcurrentLinkedDeque<PlayerProfile> queue = new ConcurrentLinkedDeque();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static PlayerProfile currentProfile = null;

    public static void enqueue(PlayerProfile profile) {
        queue.add(profile);
    }

    private static void processNext() {
        if (currentProfile != null && PlayerProfileQueue.currentProfile.status == Status.SEARCHING) {
            return;
        }
        currentProfile = queue.poll();
        if (currentProfile != null) {
            currentProfile.buildRequest(PlayerProfileQueue.currentProfile.name);
        }
    }

    public static void putFirstInQueue(PlayerProfile profile) {
        if (currentProfile == profile) {
            return;
        }
        queue.remove(profile);
        queue.addFirst(profile);
    }

    public static void changeToFirstInQueue(PlayerProfile profile) {
        if (currentProfile == profile) {
            return;
        }
        if (queue.contains(profile)) {
            queue.remove(profile);
            queue.addFirst(profile);
        }
    }

    public static void clearQueue() {
        queue.clear();
        currentProfile = null;
    }

    static {
        scheduler.scheduleAtFixedRate(PlayerProfileQueue::processNext, 0L, 100L, TimeUnit.MILLISECONDS);
    }
}

