/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tiers.TiersClient;
import com.tiers.profile.GameMode;
import com.tiers.profile.Status;
import com.tiers.profile.types.MCTiersCOMProfile;
import com.tiers.profile.types.MCTiersIOProfile;
import com.tiers.profile.types.SubtiersNETProfile;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class PlayerProfile {
    public Status status = Status.SEARCHING;
    public String name = "";
    public String uuid = "";
    public MCTiersCOMProfile mcTiersCOMProfile;
    public MCTiersIOProfile mcTiersIOProfile;
    public SubtiersNETProfile subtiersNETProfile;
    public class_2561 originalNameText;
    public boolean imageSaved = false;
    public int numberOfImageRequests = 0;
    private int numberOfRequests = 0;
    private final boolean regular;

    public PlayerProfile(String name, boolean regular) {
        this.regular = regular;
        this.name = name;
        this.originalNameText = class_2561.method_30163((String)name);
    }

    public PlayerProfile(String mojangJson, String mcTiersCOMJson, String mcTiersIOJson, String subtiersNETJson) {
        this.regular = false;
        JsonObject jsonObject = JsonParser.parseString((String)mojangJson).getAsJsonObject();
        if (!jsonObject.has("name") || !jsonObject.has("id")) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.name = jsonObject.get("name").getAsString();
        this.uuid = jsonObject.get("id").getAsString();
        this.originalNameText = class_2561.method_30163((String)this.name);
        Path targetFile = FabricLoader.getInstance().getGameDir().resolve("cache/tiers/3b653c04f2d9422a87e7ccf8b146c350.png");
        try (InputStream inputStream = TiersClient.class.getResourceAsStream("default.png");){
            if (inputStream == null) {
                throw new IOException();
            }
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ignored) {
            TiersClient.LOGGER.warn("Error copying default image");
        }
        this.mcTiersCOMProfile = new MCTiersCOMProfile(mcTiersCOMJson);
        this.mcTiersIOProfile = new MCTiersIOProfile(mcTiersIOJson);
        this.subtiersNETProfile = new SubtiersNETProfile(subtiersNETJson);
        this.status = Status.READY;
    }

    public void buildRequest(String name) {
        if (this.numberOfRequests > 5) {
            this.backupRequest("https://api.mojang.com/users/profiles/minecraft/", name);
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://playerdb.co/api/player/minecraft/" + name)).header("User-Agent", TiersClient.userAgent).GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                int statusCode = response.statusCode();
                if (statusCode == 400 || statusCode == 500) {
                    this.status = Status.NOT_EXISTING;
                    return;
                }
                if (response.statusCode() != 200) {
                    this.backupRequest("https://api.mojang.com/users/profiles/minecraft/", name);
                    return;
                }
                this.parseJson((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.buildRequest(name));
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    public void backupRequest(String apiUrl, String name) {
        if (this.numberOfRequests == 12 || this.status != Status.SEARCHING) {
            this.status = Status.TIMEOUTED;
            return;
        }
        ++this.numberOfRequests;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl + name)).header("User-Agent", TiersClient.userAgent).GET().build();
            ((CompletableFuture)HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
                if (((String)response.body()).contains("minecraft/profile/lookup")) {
                    this.status = Status.API_ISSUE;
                    return;
                }
                int statusCode = response.statusCode();
                if (statusCode == 404 || statusCode == 400) {
                    this.status = Status.NOT_EXISTING;
                    return;
                }
                if (statusCode == 403) {
                    CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> this.backupRequest("https://api.minecraftservices.com/minecraft/profile/lookup/name/", name));
                    return;
                }
                if (statusCode != 200) {
                    long delay = switch (this.numberOfRequests) {
                        case 1 -> 50L;
                        case 2, 3 -> 100L;
                        case 4, 5 -> 400L;
                        case 6, 7 -> 900L;
                        default -> 1500L;
                    };
                    CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS).execute(() -> this.backupRequest(apiUrl, name));
                    return;
                }
                this.parseJson((String)response.body());
            })).exceptionally(exception -> {
                CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS).execute(() -> this.backupRequest(apiUrl, name));
                return null;
            });
        }
        catch (IllegalArgumentException ignored) {
            this.status = Status.NOT_EXISTING;
        }
    }

    private void parseJson(String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.has("code") && jsonObject.has("data") && jsonObject.has("success")) {
            JsonObject player;
            if (!jsonObject.get("success").getAsString().contains("true")) {
                this.backupRequest("https://api.mojang.com/users/profiles/minecraft/", this.name);
                return;
            }
            JsonObject data = jsonObject.getAsJsonObject("data");
            if (data.has("player") && (player = data.getAsJsonObject("player")).has("username") && player.has("raw_id")) {
                this.name = player.get("username").getAsString();
                this.uuid = player.get("raw_id").getAsString();
                this.originalNameText = class_2561.method_30163((String)this.name);
            }
        } else if (jsonObject.has("name") && jsonObject.has("id")) {
            this.name = jsonObject.get("name").getAsString();
            this.uuid = jsonObject.get("id").getAsString();
            this.originalNameText = class_2561.method_30163((String)this.name);
        }
        if (this.uuid.isEmpty()) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.savePlayerImage();
        this.mcTiersCOMProfile = new MCTiersCOMProfile(this.uuid, "https://mctiers.com/api/profile/");
        this.mcTiersIOProfile = new MCTiersIOProfile(this.uuid, "https://mctiers.io/api/profile/");
        this.subtiersNETProfile = new SubtiersNETProfile(this.uuid, "https://subtiers.net/api/profile/");
        this.status = Status.READY;
    }

    private void savePlayerImage() {
        if (this.numberOfImageRequests == 5) {
            return;
        }
        ++this.numberOfImageRequests;
        String imageUrl = "https://mc-heads.net/body/" + this.uuid;
        String savePath = String.valueOf(FabricLoader.getInstance().getGameDir()) + (this.regular ? "/cache/tiers/players/" : "/cache/tiers/") + this.uuid + ".png";
        try {
            Files.createDirectories(Paths.get(String.valueOf(FabricLoader.getInstance().getGameDir()) + (this.regular ? "/cache/tiers/players/" : "/cache/tiers/"), new String[0]), new FileAttribute[0]);
            ImageIO.write((RenderedImage)ImageIO.read(URI.create(imageUrl).toURL()), "png", new File(savePath));
            this.imageSaved = true;
        }
        catch (IOException ignored) {
            CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(this::savePlayerImage);
        }
    }

    public void resetDrawnStatus() {
        if (this.mcTiersCOMProfile == null || this.mcTiersIOProfile == null || this.subtiersNETProfile == null) {
            return;
        }
        this.mcTiersCOMProfile.drawn = false;
        this.mcTiersIOProfile.drawn = false;
        this.subtiersNETProfile.drawn = false;
        for (GameMode mode : this.mcTiersCOMProfile.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.mcTiersIOProfile.gameModes) {
            mode.drawn = false;
        }
        for (GameMode mode : this.subtiersNETProfile.gameModes) {
            mode.drawn = false;
        }
    }
}

