/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.profile;

import com.google.gson.JsonObject;
import com.tiers.misc.Mode;
import com.tiers.profile.Status;
import com.tiers.textures.ColorControl;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

@Environment(value=EnvType.CLIENT)
public class GameMode {
    public Status status = Status.SEARCHING;
    private String tier;
    private String peakTier;
    private String attained;
    public class_2561 displayedTier;
    private String displayedTierUnformatted;
    public class_2561 displayedPeakTier;
    private String displayedPeakTierUnformatted;
    public class_2561 tierTooltip;
    public class_2561 peakTierTooltip;
    public final Mode gamemode;
    public final String parsingName;
    public boolean hasPeak;
    public boolean drawn;

    public GameMode(Mode gamemode, String parsingName) {
        this.gamemode = gamemode;
        this.parsingName = parsingName;
    }

    public void parseTiers(JsonObject jsonObject) {
        if (!(jsonObject.has("tier") && jsonObject.has("pos") && jsonObject.has("attained") && jsonObject.has("retired"))) {
            this.status = Status.NOT_EXISTING;
            return;
        }
        this.tier = jsonObject.get("tier").getAsString();
        String pos = jsonObject.get("pos").getAsString();
        this.peakTier = jsonObject.get("peak_tier").isJsonNull() ? this.tier : jsonObject.get("peak_tier").getAsString();
        String peakPos = jsonObject.get("peak_pos").isJsonNull() ? pos : jsonObject.get("peak_pos").getAsString();
        this.attained = jsonObject.get("attained").getAsString();
        String retired = jsonObject.get("retired").getAsString();
        this.displayedTierUnformatted = "";
        if (retired.equalsIgnoreCase("true")) {
            this.displayedTierUnformatted = "R";
        }
        this.displayedTierUnformatted = this.displayedTierUnformatted + (pos.equalsIgnoreCase("0") ? "HT" : "LT");
        this.displayedTierUnformatted = this.displayedTierUnformatted + this.tier;
        this.displayedTier = class_2561.method_43470((String)this.displayedTierUnformatted).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedTierUnformatted)));
        this.tierTooltip = this.getTierTooltip();
        if (!this.tier.equalsIgnoreCase(this.peakTier) || !pos.equalsIgnoreCase(peakPos)) {
            this.displayedPeakTierUnformatted = peakPos.equalsIgnoreCase("0") ? "HT" : "LT";
            this.displayedPeakTierUnformatted = this.displayedPeakTierUnformatted + this.peakTier;
            this.displayedPeakTier = class_2561.method_43470((String)("(" + this.displayedPeakTierUnformatted + ")")).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedPeakTierUnformatted)));
            this.peakTierTooltip = this.getPeakTierTooltip();
            this.hasPeak = true;
        }
        this.status = Status.READY;
    }

    private class_2561 getTierTooltip() {
        Object tierTooltipString = "";
        if (this.displayedTierUnformatted.contains("R")) {
            tierTooltipString = (String)tierTooltipString + "Retired ";
        }
        tierTooltipString = this.displayedTierUnformatted.contains("H") ? (String)tierTooltipString + "High " : (String)tierTooltipString + "Low ";
        tierTooltipString = (String)tierTooltipString + "Tier " + this.tier + "\n\nPoints: " + this.getTierPoints(false) + "\nAttained: " + LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(this.attained)), ZoneId.systemDefault()).toString().replace("T", " ");
        return class_2561.method_43470((String)tierTooltipString).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedTierUnformatted)));
    }

    private class_2561 getPeakTierTooltip() {
        Object peakTierTooltipString = "Peak: ";
        if (this.displayedPeakTierUnformatted.contains("R")) {
            peakTierTooltipString = (String)peakTierTooltipString + "Retired ";
        }
        peakTierTooltipString = this.displayedPeakTierUnformatted.contains("H") ? (String)peakTierTooltipString + "High " : (String)peakTierTooltipString + "Low ";
        peakTierTooltipString = (String)peakTierTooltipString + "Tier " + this.peakTier + "\n\nPoints: " + this.getTierPoints(true);
        return class_2561.method_43470((String)peakTierTooltipString).method_10862(class_2583.field_24360.method_36139(this.getTierColor(this.displayedPeakTierUnformatted)));
    }

    public int getTierPoints(boolean peak) {
        if (this.status == Status.NOT_EXISTING) {
            return 0;
        }
        String tier = this.displayedTierUnformatted;
        if (peak) {
            tier = this.displayedPeakTierUnformatted;
        }
        if ((tier = tier.replace("R", "")).equalsIgnoreCase("HT1")) {
            return 60;
        }
        if (tier.equalsIgnoreCase("LT1")) {
            if (this.gamemode.toString().contains("PVPTIERS")) {
                return 44;
            }
            return 45;
        }
        if (tier.equalsIgnoreCase("HT2")) {
            if (this.gamemode.toString().contains("PVPTIERS")) {
                return 28;
            }
            return 30;
        }
        if (tier.equalsIgnoreCase("LT2")) {
            if (this.gamemode.toString().contains("PVPTIERS")) {
                return 16;
            }
            return 20;
        }
        if (tier.equalsIgnoreCase("HT3")) {
            return 10;
        }
        if (tier.equalsIgnoreCase("LT3")) {
            return 6;
        }
        if (tier.equalsIgnoreCase("HT4")) {
            return 4;
        }
        if (tier.equalsIgnoreCase("LT4")) {
            return 3;
        }
        if (tier.equalsIgnoreCase("HT5")) {
            return 2;
        }
        if (tier.equalsIgnoreCase("LT5")) {
            return 1;
        }
        return 0;
    }

    private int getTierColor(String tier) {
        if (tier.contains("R")) {
            return ColorControl.getColor("retired");
        }
        return ColorControl.getColor(tier.toLowerCase());
    }
}

