/*
 * Decompiled with CFR 0.152.
 */
package com.tiers.misc;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tiers.TiersClient;
import com.tiers.misc.Modes;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static Config config;
    private static final Path CONFIG_PATH;

    public static void loadConfig() {
        Gson gson = new Gson();
        File configFile = CONFIG_PATH.toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                if (config == null) {
                    ConfigManager.restoreFromClient();
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                ConfigManager.restoreFromClient();
            }
        } else {
            ConfigManager.restoreFromClient();
        }
        TiersClient.toggleMod = ConfigManager.config.toggleMod;
        TiersClient.showIcons = ConfigManager.config.showIcons;
        TiersClient.isSeparatorAdaptive = ConfigManager.config.isSeparatorAdaptive;
        if (Arrays.stream(TiersClient.ModesTierDisplay.values()).toList().contains((Object)ConfigManager.config.displayMode)) {
            TiersClient.displayMode = ConfigManager.config.displayMode;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.mcTiersCOMPosition)) {
            TiersClient.mcTiersCOMPosition = ConfigManager.config.mcTiersCOMPosition;
        }
        if (Arrays.stream(Modes.values()).toList().contains((Object)ConfigManager.config.activeMCTiersCOMMode) && ConfigManager.config.activeMCTiersCOMMode.toString().contains("MCTIERSCOM")) {
            TiersClient.activeMCTiersCOMMode = ConfigManager.config.activeMCTiersCOMMode;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.mcTiersIOPosition)) {
            TiersClient.mcTiersIOPosition = ConfigManager.config.mcTiersIOPosition;
        }
        if (Arrays.stream(Modes.values()).toList().contains((Object)ConfigManager.config.activeMCTiersIOMode) && ConfigManager.config.activeMCTiersIOMode.toString().contains("MCTIERSIO")) {
            TiersClient.activeMCTiersIOMode = ConfigManager.config.activeMCTiersIOMode;
        }
        if (Arrays.stream(TiersClient.DisplayStatus.values()).toList().contains((Object)ConfigManager.config.subtiersNETPosition)) {
            TiersClient.subtiersNETPosition = ConfigManager.config.subtiersNETPosition;
        }
        if (Arrays.stream(Modes.values()).toList().contains((Object)ConfigManager.config.activeSubtiersNETMode) && ConfigManager.config.activeSubtiersNETMode.toString().contains("SUBTIERSNET")) {
            TiersClient.activeSubtiersNETMode = ConfigManager.config.activeSubtiersNETMode;
        }
        ConfigManager.saveConfig();
    }

    private static void restoreFromClient() {
        config = new Config();
        ConfigManager.config.toggleMod = TiersClient.toggleMod;
        ConfigManager.config.showIcons = TiersClient.showIcons;
        ConfigManager.config.isSeparatorAdaptive = TiersClient.isSeparatorAdaptive;
        ConfigManager.config.displayMode = TiersClient.displayMode;
        ConfigManager.config.mcTiersCOMPosition = TiersClient.mcTiersCOMPosition;
        ConfigManager.config.activeMCTiersCOMMode = TiersClient.activeMCTiersCOMMode;
        ConfigManager.config.mcTiersIOPosition = TiersClient.mcTiersIOPosition;
        ConfigManager.config.activeMCTiersIOMode = TiersClient.activeMCTiersIOMode;
        ConfigManager.config.subtiersNETPosition = TiersClient.subtiersNETPosition;
        ConfigManager.config.activeSubtiersNETMode = TiersClient.activeSubtiersNETMode;
        ConfigManager.saveConfig();
    }

    public static void saveConfig() {
        Gson gson = new Gson();
        File configFile = CONFIG_PATH.toFile();
        Config currentConfig = new Config();
        currentConfig.toggleMod = TiersClient.toggleMod;
        currentConfig.showIcons = TiersClient.showIcons;
        currentConfig.isSeparatorAdaptive = TiersClient.isSeparatorAdaptive;
        currentConfig.displayMode = TiersClient.displayMode;
        currentConfig.mcTiersCOMPosition = TiersClient.mcTiersCOMPosition;
        currentConfig.activeMCTiersCOMMode = TiersClient.activeMCTiersCOMMode;
        currentConfig.mcTiersIOPosition = TiersClient.mcTiersIOPosition;
        currentConfig.activeMCTiersIOMode = TiersClient.activeMCTiersIOMode;
        currentConfig.subtiersNETPosition = TiersClient.subtiersNETPosition;
        currentConfig.activeSubtiersNETMode = TiersClient.activeSubtiersNETMode;
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)currentConfig, (Appendable)writer);
        }
        catch (IOException exception) {
            ConfigManager.restoreFromClient();
        }
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("Tiers.json");
    }

    @Environment(value=EnvType.CLIENT)
    private static class Config {
        boolean toggleMod = true;
        boolean showIcons = true;
        boolean isSeparatorAdaptive = true;
        TiersClient.ModesTierDisplay displayMode;
        TiersClient.DisplayStatus mcTiersCOMPosition;
        Modes activeMCTiersCOMMode;
        TiersClient.DisplayStatus mcTiersIOPosition;
        Modes activeMCTiersIOMode;
        TiersClient.DisplayStatus subtiersNETPosition;
        Modes activeSubtiersNETMode;

        private Config() {
        }
    }
}

