/*
 * Decompiled with CFR 0.152.
 */
package com.tiers;

import com.mojang.brigadier.context.CommandContext;
import com.tiers.CommandRegister;
import com.tiers.ConfigManager;
import com.tiers.misc.ColorControl;
import com.tiers.misc.ColorLoader;
import com.tiers.misc.Icons;
import com.tiers.profiles.GameMode;
import com.tiers.profiles.PlayerProfile;
import com.tiers.profiles.Status;
import com.tiers.profiles.types.BaseProfile;
import com.tiers.screens.PlayerSearchResultScreen;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TiersClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(TiersClient.class);
    protected static final ArrayList<PlayerProfile> playerProfiles = new ArrayList();
    protected static final HashMap<String, class_2561> playerTexts = new HashMap();
    public static boolean toggleMod = true;
    public static boolean showIcons = true;
    public static boolean isSeparatorAdaptive = true;
    public static ModesTierDisplay displayMode = ModesTierDisplay.ADAPTIVE_HIGHEST;
    public static DisplayStatus mcTiersCOMPosition = DisplayStatus.LEFT;
    public static Modes activeMCTiersCOMMode = Modes.MCTIERSCOM_VANILLA;
    public static DisplayStatus mcTiersIOPosition = DisplayStatus.RIGHT;
    public static Modes activeMCTiersIOMode = Modes.MCTIERSIO_AXE;
    public static DisplayStatus subtiersNETPosition = DisplayStatus.OFF;
    public static Modes activeSubtiersNETMode = Modes.SUBTIERSNET_MINECART;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        TiersClient.clearCache();
        CommandRegister.registerCommands();
        FabricLoader.getInstance().getModContainer("tiers").ifPresent(tiers -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"tiers", (String)"tiers-resources"), (ModContainer)tiers, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ColorLoader());
        LOGGER.info("Tiers initialized");
    }

    public static class_2561 getFullName(String originalName, class_2561 originalNameText) {
        PlayerProfile profile = TiersClient.addGetPlayer(originalName);
        if (profile.status == Status.READY && (profile.originalNameText == null || profile.originalNameText != originalNameText)) {
            TiersClient.updatePlayerNametag(originalNameText, profile);
        }
        if (playerTexts.containsKey(originalName)) {
            return playerTexts.get(originalName);
        }
        return originalNameText;
    }

    public static void updateAllTags() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY || profile.originalNameText == null) continue;
            TiersClient.updatePlayerNametag(profile.originalNameText, profile);
        }
    }

    public static void updatePlayerNametag(class_2561 originalNameText, PlayerProfile profile) {
        class_5250 rightText = class_2561.method_43470((String)"");
        class_5250 leftText = class_2561.method_43470((String)"");
        if (mcTiersCOMPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        } else if (mcTiersCOMPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersCOMProfile, activeMCTiersCOMMode);
        }
        if (mcTiersIOPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.mcTiersIOProfile, activeMCTiersIOMode);
        } else if (mcTiersIOPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.mcTiersIOProfile, activeMCTiersIOMode);
        }
        if (subtiersNETPosition == DisplayStatus.RIGHT) {
            rightText = TiersClient.updateProfileNameTagRight(profile.subtiersNETProfile, activeSubtiersNETMode);
        } else if (subtiersNETPosition == DisplayStatus.LEFT) {
            leftText = TiersClient.updateProfileNameTagLeft(profile.subtiersNETProfile, activeSubtiersNETMode);
        }
        playerTexts.put(profile.name, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)leftText).method_10852(originalNameText).method_10852((class_2561)rightText));
        profile.originalNameText = originalNameText;
    }

    private static class_2561 updateProfileNameTagRight(BaseProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)separator).method_10852(shown.displayedTier));
            if (showIcons) {
                returnValue.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852(shown.name.getIconTag()));
            }
        }
        return returnValue;
    }

    private static class_2561 updateProfileNameTagLeft(BaseProfile profile, Modes activeMode) {
        class_5250 returnValue = class_2561.method_43470((String)"");
        if (profile.status == Status.READY) {
            GameMode shown = profile.getGameMode(activeMode);
            if (shown == null || shown.status == Status.SEARCHING || shown.status == Status.NOT_EXISTING && displayMode == ModesTierDisplay.SELECTED) {
                return returnValue;
            }
            if (displayMode == ModesTierDisplay.ADAPTIVE_HIGHEST && shown.status == Status.NOT_EXISTING && profile.highest != null) {
                shown = profile.highest;
            }
            if (displayMode == ModesTierDisplay.HIGHEST && profile.highest != null && profile.highest.getTierPoints(false) > shown.getTierPoints(false)) {
                shown = profile.highest;
            }
            if (shown == null || shown.status != Status.READY) {
                return returnValue;
            }
            class_5250 separator = class_2561.method_43470((String)" | ").method_10862(isSeparatorAdaptive ? shown.displayedTier.method_10866() : class_2583.field_24360.method_36139(ColorControl.getColor("static_separator")));
            if (showIcons) {
                returnValue = class_2561.method_43470((String)"").method_10852(shown.name.getIconTag()).method_27693(" ");
            }
            returnValue.method_10852((class_2561)class_2561.method_43470((String)"").method_10852(shown.displayedTier).method_10852((class_2561)separator));
        }
        return returnValue;
    }

    public static void restyleAllTexts() {
        for (PlayerProfile profile : playerProfiles) {
            if (profile.status != Status.READY) continue;
            if (profile.mcTiersCOMProfile.status == Status.READY) {
                profile.mcTiersCOMProfile.parseInfo(profile.mcTiersCOMProfile.originalJson);
            }
            if (profile.mcTiersIOProfile.status == Status.READY) {
                profile.mcTiersIOProfile.parseInfo(profile.mcTiersIOProfile.originalJson);
            }
            if (profile.subtiersNETProfile.status != Status.READY) continue;
            profile.subtiersNETProfile.parseInfo(profile.subtiersNETProfile.originalJson);
        }
    }

    public static void sendMessageToPlayer(String chat_message, int color) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)chat_message).method_10862(class_2583.field_24360.method_36139(color)), false);
        }
    }

    protected static int toggleMod(CommandContext<FabricClientCommandSource> ignoredFabricClientCommandSourceCommandContext) {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
        TiersClient.sendMessageToPlayer("Tiers is now " + (toggleMod ? "enabled" : "disabled"), toggleMod ? ColorControl.getColor("green") : ColorControl.getColor("red"));
        return 1;
    }

    public static void toggleMod() {
        toggleMod = !toggleMod;
        ConfigManager.saveConfig();
    }

    public static PlayerProfile addGetPlayer(String name) {
        for (PlayerProfile profile : playerProfiles) {
            if (!profile.name.equalsIgnoreCase(name)) continue;
            return profile;
        }
        PlayerProfile newProfile = new PlayerProfile(name);
        playerProfiles.add(newProfile);
        return newProfile;
    }

    private static void openPlayerSearchResultScreen(PlayerProfile profile) {
        class_310.method_1551().method_1507((class_437)new PlayerSearchResultScreen(profile));
    }

    protected static int searchPlayer(String name) {
        CompletableFuture.delayedExecutor(50L, TimeUnit.MILLISECONDS).execute(() -> class_310.method_1551().execute(() -> TiersClient.openPlayerSearchResultScreen(TiersClient.addGetPlayer(name))));
        return 1;
    }

    public static void clearCache() {
        playerProfiles.clear();
        playerTexts.clear();
        try {
            FileUtils.deleteDirectory((File)new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/tiers-cache"));
        }
        catch (IOException e) {
            LOGGER.warn("Error deleting cache folder: {}", (Object)e.getMessage());
        }
    }

    public static void toggleSeparatorAdaptive() {
        isSeparatorAdaptive = !isSeparatorAdaptive;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void toggleShowIcons() {
        showIcons = !showIcons;
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersCOMMode() {
        activeMCTiersCOMMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersCOMMode, (Enum[])Modes.getMCTiersCOMValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersIOMode() {
        activeMCTiersIOMode = (Modes)TiersClient.cycleEnum((Enum)activeMCTiersIOMode, (Enum[])Modes.getMCTiersIOValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleSubtiersNETMode() {
        activeSubtiersNETMode = (Modes)TiersClient.cycleEnum((Enum)activeSubtiersNETMode, (Enum[])Modes.getSubtiersNETValues());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersCOMPosition() {
        mcTiersCOMPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersCOMPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleMCTiersIOPosition() {
        mcTiersIOPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)mcTiersIOPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleSubtiersNETPosition() {
        subtiersNETPosition = (DisplayStatus)TiersClient.cycleEnum((Enum)subtiersNETPosition, (Enum[])DisplayStatus.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    public static void cycleDisplayMode() {
        displayMode = (ModesTierDisplay)TiersClient.cycleEnum((Enum)displayMode, (Enum[])ModesTierDisplay.values());
        TiersClient.updateAllTags();
        ConfigManager.saveConfig();
    }

    private static <T extends Enum<T>> T cycleEnum(T current, T[] values) {
        return values[(current.ordinal() + 1) % values.length];
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DisplayStatus {
        RIGHT,
        LEFT,
        OFF;


        public String getIcon() {
            if (this.toString().equalsIgnoreCase("RIGHT")) {
                return "\u2192";
            }
            if (this.toString().equalsIgnoreCase("LEFT")) {
                return "\u2190";
            }
            return "\u25cf";
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Modes {
        MCTIERSCOM_VANILLA(Icons.vanilla, Icons.vanillaTag, "mctierscom_vanilla", "Vanilla"),
        MCTIERSCOM_UHC(Icons.uhc, Icons.uhcTag, "mctierscom_uhc", "UHC"),
        MCTIERSCOM_POT(Icons.pot, Icons.potTag, "mctierscom_pot", "Pot"),
        MCTIERSCOM_NETHERITE_OP(Icons.netherite, Icons.netheriteTag, "mctierscom_netherite_op", "Netherite Op"),
        MCTIERSCOM_SMP(Icons.smp, Icons.smpTag, "mctierscom_smp", "Smp"),
        MCTIERSCOM_SWORD(Icons.sword, Icons.swordTag, "mctierscom_sword", "Sword"),
        MCTIERSCOM_AXE(Icons.axe, Icons.axeTag, "mctierscom_axe", "Axe"),
        MCTIERSCOM_MACE(Icons.mace, Icons.maceTag, "mctierscom_mace", "Mace"),
        MCTIERSIO_VANILLA(Icons.vanilla, Icons.vanillaTag, "mctiersio_vanilla", "Vanilla"),
        MCTIERSIO_UHC(Icons.uhc, Icons.uhcTag, "mctiersio_uhc", "UHC"),
        MCTIERSIO_POT(Icons.pot, Icons.potTag, "mctiersio_pot", "Pot"),
        MCTIERSIO_NETHERITE_POT(Icons.netherite, Icons.netheriteTag, "mctiersio_netherite_pot", "Netherite Pot"),
        MCTIERSIO_SMP(Icons.smp, Icons.smpTag, "mctiersio_smp", "Smp"),
        MCTIERSIO_SWORD(Icons.sword, Icons.swordTag, "mctiersio_sword", "Sword"),
        MCTIERSIO_AXE(Icons.axe, Icons.axeTag, "mctiersio_axe", "Axe"),
        MCTIERSIO_ELYTRA(Icons.elytra, Icons.elytraTag, "mctiersio_elytra", "Elytra"),
        SUBTIERSNET_MINECART(Icons.minecart, Icons.minecartTag, "subtiersnet_minecart", "Minecart"),
        SUBTIERSNET_DIAMOND_CRYSTAL(Icons.diamond_crystal, Icons.diamond_crystalTag, "subtiersnet_diamond_crystal", "Diamond Crystal"),
        SUBTIERSNET_IRON_POT(Icons.iron_pot, Icons.iron_potTag, "subtiersnet_iron_pot", "Iron Pot"),
        SUBTIERSNET_ELYTRA(Icons.subtiers_elytra, Icons.subtiers_elytraTag, "subtiersnet_elytra", "Elytra"),
        SUBTIERSNET_SPEED(Icons.speed, Icons.speedTag, "subtiersnet_speed", "Speed"),
        SUBTIERSNET_CREEPER(Icons.creeper, Icons.creeperTag, "subtiersnet_creeper", "Creeper"),
        SUBTIERSNET_MANHUNT(Icons.manhunt, Icons.manhuntTag, "subtiersnet_manhunt", "Manhunt"),
        SUBTIERSNET_DIAMOND_SMP(Icons.diamond_smp, Icons.diamond_smpTag, "subtiersnet_diamond_smp", "Diamond Smp"),
        SUBTIERSNET_BOW(Icons.bow, Icons.bowTag, "subtiersnet_bow", "Bow"),
        SUBTIERSNET_BED(Icons.bed, Icons.bedTag, "subtiersnet_bed", "Bed"),
        SUBTIERSNET_OG_VANILLA(Icons.og_vanilla, Icons.og_vanillaTag, "subtiersnet_og_vanilla", "OG Vanilla"),
        SUBTIERSNET_TRIDENT(Icons.trident, Icons.tridentTag, "subtiersnet_trident", "Trident");

        private final class_2561 icon;
        private final class_2561 iconTag;
        private final String color;
        private final String stringLabel;
        private class_2561 label;

        private Modes(class_2561 icon, class_2561 iconTag, String color, String label) {
            this.icon = icon;
            this.iconTag = iconTag;
            this.color = color;
            this.stringLabel = label;
            this.label = class_2561.method_43470((String)label).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor(color)));
        }

        public static void updateColors() {
            for (Modes mode : Modes.values()) {
                mode.label = class_2561.method_43470((String)mode.stringLabel).method_10862(class_2583.field_24360.method_36139(ColorControl.getColor(mode.color)));
            }
        }

        public class_2561 getIcon() {
            return this.icon;
        }

        public class_2561 getIconTag() {
            return this.iconTag;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public static Modes[] getMCTiersCOMValues() {
            Modes[] modesArray = new Modes[8];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("MCTIERSCOM")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }

        public static Modes[] getMCTiersIOValues() {
            Modes[] modesArray = new Modes[7];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("MCTIERSIO")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }

        public static Modes[] getSubtiersNETValues() {
            Modes[] modesArray = new Modes[9];
            ArrayList<Modes> modes = new ArrayList<Modes>();
            for (Modes mode : Modes.values()) {
                if (!mode.toString().contains("SUBTIERSNET")) continue;
                modes.add(mode);
            }
            return modes.toArray(modesArray);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ModesTierDisplay {
        HIGHEST,
        SELECTED,
        ADAPTIVE_HIGHEST;


        public String getIcon() {
            if (this.toString().equalsIgnoreCase("HIGHEST")) {
                return "\u2191";
            }
            if (this.toString().equalsIgnoreCase("SELECTED")) {
                return "\u25cf";
            }
            return "\u2193";
        }
    }
}

