#ifndef INCLUDE_techniques_atmospherics_water_Constants_glsl
#define INCLUDE_techniques_atmospherics_water_Constants_glsl a

#include "/util/Colors.glsl"

const float _WATER_SCATTERING_MULTIPLIER = exp2(SETTING_WATER_SCATTERING_MULTIPLIER);
const float _WATER_ABOSORPTION_MULTIPLIER = exp2(SETTING_WATER_ABSORPTION_MULTIPLIER);
const vec3 _WATER_SCATTERING_COEFF = vec3(SETTING_WATER_SCATTERING_R, SETTING_WATER_SCATTERING_G, SETTING_WATER_SCATTERING_B);
const vec3 _WATER_ABOSORPTION_COEFF = vec3(SETTING_WATER_ABSORPTION_R, SETTING_WATER_ABSORPTION_G, SETTING_WATER_ABSORPTION_B);
vec3 WATER_SCATTERING = colors2_colorspaces_convert(COLORS2_COLORSPACES_SRGB, COLORS2_WORKING_COLORSPACE, _WATER_SCATTERING_COEFF * _WATER_SCATTERING_MULTIPLIER);
vec3 WATER_ABOSORPTION = colors2_colorspaces_convert(COLORS2_COLORSPACES_SRGB, COLORS2_WORKING_COLORSPACE, _WATER_ABOSORPTION_COEFF * _WATER_ABOSORPTION_MULTIPLIER);
vec3 WATER_EXTINCTION = WATER_SCATTERING + WATER_ABOSORPTION;

#endif