// This file is auto-generated by /scripts/colorspaces.py
// -------------------------------------------------------- API --------------------------------------------------------
#define COLORS2_COLORSPACES_CIE_XYZ 0
#define COLORS2_COLORSPACES_SRGB 1
#define COLORS2_COLORSPACES_REC709 2
#define COLORS2_COLORSPACES_REC2020 3
#define COLORS2_COLORSPACES_DCI_P3 4
#define COLORS2_COLORSPACES_ADOBE_RGB_1998 5
#define COLORS2_COLORSPACES_ACES_AP0 6
#define COLORS2_COLORSPACES_ACES_AP1 7

#define _colors2_colorspaces_convert(a, b, x) colors2_colorspaces_ ## a ## _to_ ## b ##(x)
#define colors2_colorspaces_convert(a, b, x) _colors2_colorspaces_convert(a, b, x)
#define _colors2_colorspaces_luma(a, x) colors2_colorspaces_ ## a ## _luma(x)
#define colors2_colorspaces_luma(a, x) _colors2_colorspaces_luma(a, x)


// ------------------------------------------------ Conversion Matrices ------------------------------------------------
// --------------------------------------------------- From CIE_XYZ ---------------------------------------------------
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_CIE_XYZ = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_SRGB = mat3(
    3.2406, -1.5372, -0.4986,
    -0.9689, 1.8758, 0.0415,
    0.0557, -0.204, 1.057
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_REC709 = mat3(
    3.2409699419, -1.5373831776, -0.4986107603,
    -0.9692436363, 1.8759675015, 0.0415550574,
    0.0556300797, -0.2039769589, 1.0569715142
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_REC2020 = mat3(
    1.716651188, -0.3556707838, -0.2533662814,
    -0.6666843518, 1.6164812366, 0.0157685458,
    0.0176398574, -0.0427706133, 0.9421031212
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_DCI_P3 = mat3(
    2.7253940305, -1.0180030062, -0.4401631952,
    -0.7951680258, 1.6897320548, 0.0226471906,
    0.0412418914, -0.0876390192, 1.1009293786
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_ADOBE_RGB_1998 = mat3(
    2.04159, -0.56501, -0.34473,
    -0.96924, 1.87597, 0.04156,
    0.01344, -0.11836, 1.01517
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_ACES_AP0 = mat3(
    1.0498110175, 0.0, -9.74845e-05,
    -0.4959030231, 1.3733130458, 0.0982400361,
    0.0, 0.0, 0.9912520182
);
const mat3 _colors2_colorspaces_mat_CIE_XYZ_to_ACES_AP1 = mat3(
    1.6410233797, -0.3248032942, -0.2364246952,
    -0.6636628587, 1.6153315917, 0.0167563477,
    0.0117218943, -0.008284442, 0.9883948585
);

// ----------------------------------------------------- From SRGB -----------------------------------------------------
const mat3 _colors2_colorspaces_mat_SRGB_to_CIE_XYZ = mat3(
    0.4124, 0.3576, 0.1805,
    0.2126, 0.7152, 0.0722,
    0.0193, 0.1192, 0.9505
);
const mat3 _colors2_colorspaces_mat_SRGB_to_SRGB = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_SRGB_to_REC709 = mat3(
    1.0001051528, 0.0, 6.64814e-05,
    -8.33722e-05, 1.0000437956, -5.5407e-06,
    -2.41064e-05, 0.0, 0.9999655172
);
const mat3 _colors2_colorspaces_mat_SRGB_to_REC2020 = mat3(
    0.6274413721, 0.3292974595, 0.0433514584,
    0.0690276171, 0.9195806669, 0.0113614226,
    0.0163642351, 0.0880171625, 0.8955649727
);
const mat3 _colors2_colorspaces_mat_SRGB_to_DCI_P3 = mat3(
    0.8686602648, 0.1289247846, 0.0025580657,
    0.034463766, 0.9618535095, 0.0036450448,
    0.0167452803, 0.071043109, 0.9121578398
);
const mat3 _colors2_colorspaces_mat_SRGB_to_ADOBE_RGB_1998 = mat3(
    0.715177301, 0.284885616, 4.7408e-05,
    -8.1246e-05, 1.000047472, -6e-09,
    -2.7899e-05, 0.041163336, 0.958799413
);
const mat3 _colors2_colorspaces_mat_SRGB_to_ACES_AP0 = mat3(
    0.439643004, 0.3830054714, 0.1773993089,
    0.0897157319, 0.8134750538, 0.0967822524,
    0.0175127205, 0.1115514385, 0.870882793
);
const mat3 _colors2_colorspaces_mat_SRGB_to_ACES_AP1 = mat3(
    0.6131324224, 0.3395380158, 0.047416696,
    0.0701243808, 0.9163940113, 0.013451524,
    0.0205876575, 0.1095745716, 0.869785404
);

// ---------------------------------------------------- From REC709 ----------------------------------------------------
const mat3 _colors2_colorspaces_mat_REC709_to_CIE_XYZ = mat3(
    0.4123907993, 0.3575843394, 0.1804807884,
    0.2126390059, 0.7151686788, 0.0721923154,
    0.0193308187, 0.1191947798, 0.9505321522
);
const mat3 _colors2_colorspaces_mat_REC709_to_SRGB = mat3(
    0.9998865981, 0.0, -4.33154e-05,
    0.0001050308, 0.9999965246, -2.4064e-06,
    2.44857e-05, 1.19195e-05, 1.0000380325
);
const mat3 _colors2_colorspaces_mat_REC709_to_REC709 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_REC709_to_REC2020 = mat3(
    0.6274038959, 0.3292830384, 0.0433130657,
    0.0690972894, 0.9195403951, 0.0113623156,
    0.0163914389, 0.0880133079, 0.8955952532
);
const mat3 _colors2_colorspaces_mat_REC709_to_DCI_P3 = mat3(
    0.8685797397, 0.1289191385, 0.0025011218,
    0.0345404103, 0.9618113864, 0.0036482034,
    0.016771429, 0.0710399978, 0.9121885732
);
const mat3 _colors2_colorspaces_mat_REC709_to_ADOBE_RGB_1998 = mat3(
    0.715125854, 0.2848731398, 1.4438e-06,
    2.1264e-06, 1.0000036763, 5.5347e-06,
    -1.3532e-06, 0.0411615333, 0.9588327043
);
const mat3 _colors2_colorspaces_mat_REC709_to_ACES_AP0 = mat3(
    0.4396329819, 0.3829886982, 0.17737832,
    0.0897764429, 0.8134394287, 0.0967841283,
    0.0175411704, 0.1115465533, 0.8709122763
);
const mat3 _colors2_colorspaces_mat_REC709_to_ACES_AP1 = mat3(
    0.6130974024, 0.3395231462, 0.0473794514,
    0.0701937225, 0.9163538791, 0.0134523985,
    0.0206155929, 0.1095697729, 0.8698146342
);

// --------------------------------------------------- From REC2020 ---------------------------------------------------
const mat3 _colors2_colorspaces_mat_REC2020_to_CIE_XYZ = mat3(
    0.6369580483, 0.1446169036, 0.1688809752,
    0.262700212, 0.6779980715, 0.0593017165,
    0.0, 0.028072693, 1.0609850577
);
const mat3 _colors2_colorspaces_mat_REC2020_to_SRGB = mat3(
    1.6603034854, -0.5875701425, -0.0728900602,
    -0.1243755953, 1.1328344814, -0.0083597372,
    -0.01811228, -0.1005836085, 1.1187703262
);
const mat3 _colors2_colorspaces_mat_REC2020_to_REC709 = mat3(
    1.6604910021, -0.5876411388, -0.0728498633,
    -0.1245504745, 1.1328998971, -0.0083494226,
    -0.0181507634, -0.100578898, 1.1187296614
);
const mat3 _colors2_colorspaces_mat_REC2020_to_REC2020 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_REC2020_to_DCI_P3 = mat3(
    1.4261665053, -0.3646122688, -0.0615542365,
    -0.0625062418, 1.0689717224, -0.0064654806,
    0.0024438227, -0.0211212969, 1.0186774743
);
const mat3 _colors2_colorspaces_mat_REC2020_to_ADOBE_RGB_1998 = mat3(
    1.151978935, -0.0975047657, -0.0544737317,
    -0.124547502, 1.1329022557, -0.0083434163,
    -0.0225324809, -0.0498056448, 1.0723310102
);
const mat3 _colors2_colorspaces_mat_REC2020_to_ACES_AP0 = mat3(
    0.6790856347, 0.1577009146, 0.1632134507,
    0.0460020031, 0.859054673, 0.094943324,
    -0.0005739432, 0.0284677684, 0.9721061748
);
const mat3 _colors2_colorspaces_mat_REC2020_to_ACES_AP1 = mat3(
    0.9748949779, 0.0195991086, 0.0055059134,
    0.0021795628, 0.9955354689, 0.0022849683,
    0.0047972397, 0.0245320166, 0.9706707437
);

// ---------------------------------------------------- From DCI_P3 ----------------------------------------------------
const mat3 _colors2_colorspaces_mat_DCI_P3_to_CIE_XYZ = mat3(
    0.4451698156, 0.2771344092, 0.1722826698,
    0.2094916779, 0.7215952542, 0.0689130679,
    -0.0, 0.0470605601, 0.9073553944
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_SRGB = mat3(
    1.1573859234, -0.1549414014, -0.0026012394,
    -0.041378309, 1.0455482025, -0.0040707446,
    -0.0180228775, -0.0785725929, 1.0966699081
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_REC709 = mat3(
    1.1575164062, -0.1549623781, -0.0025540281,
    -0.0415000715, 1.0455679231, -0.0040678515,
    -0.018050039, -0.0785782727, 1.0966283116
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_REC2020 = mat3(
    0.7117832307, 0.2436603169, 0.0445564524,
    0.0416151636, 0.9498416297, 0.0085432067,
    -0.0008447284, 0.0191095072, 0.9817352212
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_DCI_P3 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_ADOBE_RGB_1998 = mat3(
    0.8159476268, 0.1870365007, -0.0029836898,
    -0.0414978627, 1.0455710024, -0.0040618024,
    -0.0190167405, -0.0323060291, 1.0513156541
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_ACES_AP0 = mat3(
    0.4897866453, 0.3183760433, 0.1918373114,
    0.0684129538, 0.8289890733, 0.1025979728,
    -4.4998e-05, 0.0454764943, 0.9545685037
);
const mat3 _colors2_colorspaces_mat_DCI_P3_to_ACES_AP1 = mat3(
    0.6947248661, 0.2562644839, 0.04901065,
    0.0429788175, 0.9461757697, 0.0108454127,
    0.0036155455, 0.0430194671, 0.9533649873
);

// ------------------------------------------------ From ADOBE_RGB_1998 ------------------------------------------------
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_CIE_XYZ = mat3(
    0.57667, 0.18556, 0.18823,
    0.29734, 0.62736, 0.07529,
    0.02703, 0.07069, 0.99134
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_SRGB = mat3(
    1.398208596, -0.39829809, -3.9774e-05,
    0.000136554, 0.999946439, -6.455e-06,
    3.3869e-05, -0.042926418, 1.042971631
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_REC709 = mat3(
    1.3983671735, -0.3983451225, 5.4016e-06,
    -1.03176e-05, 0.9999916496, -3.9459e-06,
    -3.709e-07, -0.042926951, 1.0429319656
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_REC2020 = mat3(
    0.8773375991, 0.0774977091, 0.0451746704,
    0.0966138895, 0.8915203988, 0.011846867,
    0.0229200098, 0.0430379497, 0.9340446591
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_DCI_P3 = mat3(
    1.2145920645, -0.2171838064, 0.0026126829,
    0.0482902509, 0.9478877447, 0.0038012193,
    0.0234515446, 0.0252011134, 0.9513504319
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ADOBE_RGB_1998 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ACES_AP0 = mat3(
    0.614764313, 0.2002455356, 0.1849943834,
    0.1255320021, 0.7735159805, 0.1009365364,
    0.024527523, 0.0671725736, 0.9083019068
);
const mat3 _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ACES_AP1 = mat3(
    0.857331761, 0.0932620958, 0.0494155164,
    0.0981471377, 0.8878074297, 0.0140266997,
    0.0288267153, 0.0640182469, 0.9071571651
);

// --------------------------------------------------- From ACES_AP0 ---------------------------------------------------
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_CIE_XYZ = mat3(
    0.9525523959, 0.0, 9.36786e-05,
    0.3439664498, 0.7281660966, -0.0721325464,
    0.0, 0.0, 1.0088251844
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_SRGB = mat3(
    2.5214008886, -1.1339957494, -0.3875618568,
    -0.2762140616, 1.3725955663, -0.0962823557,
    -0.0153202001, -0.1529925618, 1.1683871996
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_REC709 = mat3(
    2.5216861866, -1.1341309882, -0.3875551986,
    -0.2764799141, 1.3727190876, -0.0962391734,
    -0.015378065, -0.1529753359, 1.1683534009
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_REC2020 = mat3(
    1.4904095205, -0.2661709193, -0.2242386013,
    -0.0801674998, 1.1821671211, -0.1019996212,
    0.0032276312, -0.0347764757, 1.0315488446
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_DCI_P3 = mat3(
    2.1546035168, -0.8084960464, -0.3461074707,
    -0.1788775564, 1.280565414, -0.1016878576,
    0.0086234533, -0.0610453898, 1.0524219365
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_ADOBE_RGB_1998 = mat3(
    1.7245612643, -0.4199958158, -0.304565011,
    -0.2764756536, 1.3727208758, -0.0962338848,
    -0.0261287411, -0.0901729979, 1.1162946235
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_ACES_AP0 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);
const mat3 _colors2_colorspaces_mat_ACES_AP0_to_ACES_AP1 = mat3(
    1.4514393161, -0.2365107469, -0.2149285693,
    -0.0765537733, 1.1762296998, -0.0996759265,
    0.0083161484, -0.0060324498, 0.9977163014
);

// --------------------------------------------------- From ACES_AP1 ---------------------------------------------------
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_CIE_XYZ = mat3(
    0.6624541811, 0.1340042065, 0.156187687,
    0.2722287168, 0.6740817658, 0.0536895174,
    -0.0055746495, 0.0040607335, 1.0103391003
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_SRGB = mat3(
    1.7048586763, -0.6217160219, -0.0832993717,
    -0.1300768242, 1.1407357748, -0.0105598017,
    -0.0239640729, -0.1289755083, 1.1530140189
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_REC709 = mat3(
    1.7050509927, -0.6217921207, -0.083258872,
    -0.1302564175, 1.1408047366, -0.0105483191,
    -0.0240033568, -0.1289689761, 1.1529723329
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_REC2020 = mat3(
    1.0258247477, -0.0200531908, -0.0057715568,
    -0.0022343695, 1.0045865019, -0.0023521324,
    -0.0050133515, -0.0252900718, 1.0303034233
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_DCI_P3 = mat3(
    1.464120167, -0.3933270416, -0.0707931253,
    -0.0664765138, 1.0752915253, -0.0088150114,
    -0.0025528617, -0.0470296027, 1.0495824644
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_ADOBE_RGB_1998 = mat3(
    1.182219458, -0.1196751803, -0.06254384,
    -0.1302534036, 1.1408068945, -0.0105421535,
    -0.0283790646, -0.0767015586, 1.1050735076
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_ACES_AP0 = mat3(
    0.6954522414, 0.1406786965, 0.1638690622,
    0.0447945634, 0.8596711184, 0.0955343182,
    -0.0055258826, 0.0040252103, 1.0015006723
);
const mat3 _colors2_colorspaces_mat_ACES_AP1_to_ACES_AP1 = mat3(
    1.0, 0.0, 0.0,
    0.0, 1.0, 0.0,
    0.0, 0.0, 1.0
);


// -------------------------------------------------- Luma Functions --------------------------------------------------
#define colors2_colorspaces_SRGB_luma(x) dot(x, _colors2_colorspaces_mat_SRGB_to_CIE_XYZ[1])
#define colors2_colorspaces_1_luma(x) colors2_colorspaces_SRGB_luma(x)

#define colors2_colorspaces_REC709_luma(x) dot(x, _colors2_colorspaces_mat_REC709_to_CIE_XYZ[1])
#define colors2_colorspaces_2_luma(x) colors2_colorspaces_REC709_luma(x)

#define colors2_colorspaces_REC2020_luma(x) dot(x, _colors2_colorspaces_mat_REC2020_to_CIE_XYZ[1])
#define colors2_colorspaces_3_luma(x) colors2_colorspaces_REC2020_luma(x)

#define colors2_colorspaces_DCI_P3_luma(x) dot(x, _colors2_colorspaces_mat_DCI_P3_to_CIE_XYZ[1])
#define colors2_colorspaces_4_luma(x) colors2_colorspaces_DCI_P3_luma(x)

#define colors2_colorspaces_ADOBE_RGB_1998_luma(x) dot(x, _colors2_colorspaces_mat_ADOBE_RGB_1998_to_CIE_XYZ[1])
#define colors2_colorspaces_5_luma(x) colors2_colorspaces_ADOBE_RGB_1998_luma(x)

#define colors2_colorspaces_ACES_AP0_luma(x) dot(x, _colors2_colorspaces_mat_ACES_AP0_to_CIE_XYZ[1])
#define colors2_colorspaces_6_luma(x) colors2_colorspaces_ACES_AP0_luma(x)

#define colors2_colorspaces_ACES_AP1_luma(x) dot(x, _colors2_colorspaces_mat_ACES_AP1_to_CIE_XYZ[1])
#define colors2_colorspaces_7_luma(x) colors2_colorspaces_ACES_AP1_luma(x)


// ------------------------------------------------- Adapter Functions -------------------------------------------------
// --------------------------------------------------- From CIE_XYZ ---------------------------------------------------
#define colors2_colorspaces_CIE_XYZ_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_CIE_XYZ)
#define colors2_colorspaces_0_to_0(x) colors2_colorspaces_CIE_XYZ_to_CIE_XYZ(x)

#define colors2_colorspaces_CIE_XYZ_to_SRGB(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_SRGB)
#define colors2_colorspaces_0_to_1(x) colors2_colorspaces_CIE_XYZ_to_SRGB(x)

#define colors2_colorspaces_CIE_XYZ_to_REC709(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_REC709)
#define colors2_colorspaces_0_to_2(x) colors2_colorspaces_CIE_XYZ_to_REC709(x)

#define colors2_colorspaces_CIE_XYZ_to_REC2020(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_REC2020)
#define colors2_colorspaces_0_to_3(x) colors2_colorspaces_CIE_XYZ_to_REC2020(x)

#define colors2_colorspaces_CIE_XYZ_to_DCI_P3(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_DCI_P3)
#define colors2_colorspaces_0_to_4(x) colors2_colorspaces_CIE_XYZ_to_DCI_P3(x)

#define colors2_colorspaces_CIE_XYZ_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_ADOBE_RGB_1998)
#define colors2_colorspaces_0_to_5(x) colors2_colorspaces_CIE_XYZ_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_CIE_XYZ_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_ACES_AP0)
#define colors2_colorspaces_0_to_6(x) colors2_colorspaces_CIE_XYZ_to_ACES_AP0(x)

#define colors2_colorspaces_CIE_XYZ_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_CIE_XYZ_to_ACES_AP1)
#define colors2_colorspaces_0_to_7(x) colors2_colorspaces_CIE_XYZ_to_ACES_AP1(x)


// ----------------------------------------------------- From SRGB -----------------------------------------------------
#define colors2_colorspaces_SRGB_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_SRGB_to_CIE_XYZ)
#define colors2_colorspaces_1_to_0(x) colors2_colorspaces_SRGB_to_CIE_XYZ(x)

#define colors2_colorspaces_SRGB_to_SRGB(x) (x * _colors2_colorspaces_mat_SRGB_to_SRGB)
#define colors2_colorspaces_1_to_1(x) colors2_colorspaces_SRGB_to_SRGB(x)

#define colors2_colorspaces_SRGB_to_REC709(x) (x * _colors2_colorspaces_mat_SRGB_to_REC709)
#define colors2_colorspaces_1_to_2(x) colors2_colorspaces_SRGB_to_REC709(x)

#define colors2_colorspaces_SRGB_to_REC2020(x) (x * _colors2_colorspaces_mat_SRGB_to_REC2020)
#define colors2_colorspaces_1_to_3(x) colors2_colorspaces_SRGB_to_REC2020(x)

#define colors2_colorspaces_SRGB_to_DCI_P3(x) (x * _colors2_colorspaces_mat_SRGB_to_DCI_P3)
#define colors2_colorspaces_1_to_4(x) colors2_colorspaces_SRGB_to_DCI_P3(x)

#define colors2_colorspaces_SRGB_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_SRGB_to_ADOBE_RGB_1998)
#define colors2_colorspaces_1_to_5(x) colors2_colorspaces_SRGB_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_SRGB_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_SRGB_to_ACES_AP0)
#define colors2_colorspaces_1_to_6(x) colors2_colorspaces_SRGB_to_ACES_AP0(x)

#define colors2_colorspaces_SRGB_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_SRGB_to_ACES_AP1)
#define colors2_colorspaces_1_to_7(x) colors2_colorspaces_SRGB_to_ACES_AP1(x)


// ---------------------------------------------------- From REC709 ----------------------------------------------------
#define colors2_colorspaces_REC709_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_REC709_to_CIE_XYZ)
#define colors2_colorspaces_2_to_0(x) colors2_colorspaces_REC709_to_CIE_XYZ(x)

#define colors2_colorspaces_REC709_to_SRGB(x) (x * _colors2_colorspaces_mat_REC709_to_SRGB)
#define colors2_colorspaces_2_to_1(x) colors2_colorspaces_REC709_to_SRGB(x)

#define colors2_colorspaces_REC709_to_REC709(x) (x * _colors2_colorspaces_mat_REC709_to_REC709)
#define colors2_colorspaces_2_to_2(x) colors2_colorspaces_REC709_to_REC709(x)

#define colors2_colorspaces_REC709_to_REC2020(x) (x * _colors2_colorspaces_mat_REC709_to_REC2020)
#define colors2_colorspaces_2_to_3(x) colors2_colorspaces_REC709_to_REC2020(x)

#define colors2_colorspaces_REC709_to_DCI_P3(x) (x * _colors2_colorspaces_mat_REC709_to_DCI_P3)
#define colors2_colorspaces_2_to_4(x) colors2_colorspaces_REC709_to_DCI_P3(x)

#define colors2_colorspaces_REC709_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_REC709_to_ADOBE_RGB_1998)
#define colors2_colorspaces_2_to_5(x) colors2_colorspaces_REC709_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_REC709_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_REC709_to_ACES_AP0)
#define colors2_colorspaces_2_to_6(x) colors2_colorspaces_REC709_to_ACES_AP0(x)

#define colors2_colorspaces_REC709_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_REC709_to_ACES_AP1)
#define colors2_colorspaces_2_to_7(x) colors2_colorspaces_REC709_to_ACES_AP1(x)


// --------------------------------------------------- From REC2020 ---------------------------------------------------
#define colors2_colorspaces_REC2020_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_REC2020_to_CIE_XYZ)
#define colors2_colorspaces_3_to_0(x) colors2_colorspaces_REC2020_to_CIE_XYZ(x)

#define colors2_colorspaces_REC2020_to_SRGB(x) (x * _colors2_colorspaces_mat_REC2020_to_SRGB)
#define colors2_colorspaces_3_to_1(x) colors2_colorspaces_REC2020_to_SRGB(x)

#define colors2_colorspaces_REC2020_to_REC709(x) (x * _colors2_colorspaces_mat_REC2020_to_REC709)
#define colors2_colorspaces_3_to_2(x) colors2_colorspaces_REC2020_to_REC709(x)

#define colors2_colorspaces_REC2020_to_REC2020(x) (x * _colors2_colorspaces_mat_REC2020_to_REC2020)
#define colors2_colorspaces_3_to_3(x) colors2_colorspaces_REC2020_to_REC2020(x)

#define colors2_colorspaces_REC2020_to_DCI_P3(x) (x * _colors2_colorspaces_mat_REC2020_to_DCI_P3)
#define colors2_colorspaces_3_to_4(x) colors2_colorspaces_REC2020_to_DCI_P3(x)

#define colors2_colorspaces_REC2020_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_REC2020_to_ADOBE_RGB_1998)
#define colors2_colorspaces_3_to_5(x) colors2_colorspaces_REC2020_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_REC2020_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_REC2020_to_ACES_AP0)
#define colors2_colorspaces_3_to_6(x) colors2_colorspaces_REC2020_to_ACES_AP0(x)

#define colors2_colorspaces_REC2020_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_REC2020_to_ACES_AP1)
#define colors2_colorspaces_3_to_7(x) colors2_colorspaces_REC2020_to_ACES_AP1(x)


// ---------------------------------------------------- From DCI_P3 ----------------------------------------------------
#define colors2_colorspaces_DCI_P3_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_DCI_P3_to_CIE_XYZ)
#define colors2_colorspaces_4_to_0(x) colors2_colorspaces_DCI_P3_to_CIE_XYZ(x)

#define colors2_colorspaces_DCI_P3_to_SRGB(x) (x * _colors2_colorspaces_mat_DCI_P3_to_SRGB)
#define colors2_colorspaces_4_to_1(x) colors2_colorspaces_DCI_P3_to_SRGB(x)

#define colors2_colorspaces_DCI_P3_to_REC709(x) (x * _colors2_colorspaces_mat_DCI_P3_to_REC709)
#define colors2_colorspaces_4_to_2(x) colors2_colorspaces_DCI_P3_to_REC709(x)

#define colors2_colorspaces_DCI_P3_to_REC2020(x) (x * _colors2_colorspaces_mat_DCI_P3_to_REC2020)
#define colors2_colorspaces_4_to_3(x) colors2_colorspaces_DCI_P3_to_REC2020(x)

#define colors2_colorspaces_DCI_P3_to_DCI_P3(x) (x * _colors2_colorspaces_mat_DCI_P3_to_DCI_P3)
#define colors2_colorspaces_4_to_4(x) colors2_colorspaces_DCI_P3_to_DCI_P3(x)

#define colors2_colorspaces_DCI_P3_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_DCI_P3_to_ADOBE_RGB_1998)
#define colors2_colorspaces_4_to_5(x) colors2_colorspaces_DCI_P3_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_DCI_P3_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_DCI_P3_to_ACES_AP0)
#define colors2_colorspaces_4_to_6(x) colors2_colorspaces_DCI_P3_to_ACES_AP0(x)

#define colors2_colorspaces_DCI_P3_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_DCI_P3_to_ACES_AP1)
#define colors2_colorspaces_4_to_7(x) colors2_colorspaces_DCI_P3_to_ACES_AP1(x)


// ------------------------------------------------ From ADOBE_RGB_1998 ------------------------------------------------
#define colors2_colorspaces_ADOBE_RGB_1998_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_CIE_XYZ)
#define colors2_colorspaces_5_to_0(x) colors2_colorspaces_ADOBE_RGB_1998_to_CIE_XYZ(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_SRGB(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_SRGB)
#define colors2_colorspaces_5_to_1(x) colors2_colorspaces_ADOBE_RGB_1998_to_SRGB(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_REC709(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_REC709)
#define colors2_colorspaces_5_to_2(x) colors2_colorspaces_ADOBE_RGB_1998_to_REC709(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_REC2020(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_REC2020)
#define colors2_colorspaces_5_to_3(x) colors2_colorspaces_ADOBE_RGB_1998_to_REC2020(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_DCI_P3(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_DCI_P3)
#define colors2_colorspaces_5_to_4(x) colors2_colorspaces_ADOBE_RGB_1998_to_DCI_P3(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ADOBE_RGB_1998)
#define colors2_colorspaces_5_to_5(x) colors2_colorspaces_ADOBE_RGB_1998_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ACES_AP0)
#define colors2_colorspaces_5_to_6(x) colors2_colorspaces_ADOBE_RGB_1998_to_ACES_AP0(x)

#define colors2_colorspaces_ADOBE_RGB_1998_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_ADOBE_RGB_1998_to_ACES_AP1)
#define colors2_colorspaces_5_to_7(x) colors2_colorspaces_ADOBE_RGB_1998_to_ACES_AP1(x)


// --------------------------------------------------- From ACES_AP0 ---------------------------------------------------
#define colors2_colorspaces_ACES_AP0_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_CIE_XYZ)
#define colors2_colorspaces_6_to_0(x) colors2_colorspaces_ACES_AP0_to_CIE_XYZ(x)

#define colors2_colorspaces_ACES_AP0_to_SRGB(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_SRGB)
#define colors2_colorspaces_6_to_1(x) colors2_colorspaces_ACES_AP0_to_SRGB(x)

#define colors2_colorspaces_ACES_AP0_to_REC709(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_REC709)
#define colors2_colorspaces_6_to_2(x) colors2_colorspaces_ACES_AP0_to_REC709(x)

#define colors2_colorspaces_ACES_AP0_to_REC2020(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_REC2020)
#define colors2_colorspaces_6_to_3(x) colors2_colorspaces_ACES_AP0_to_REC2020(x)

#define colors2_colorspaces_ACES_AP0_to_DCI_P3(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_DCI_P3)
#define colors2_colorspaces_6_to_4(x) colors2_colorspaces_ACES_AP0_to_DCI_P3(x)

#define colors2_colorspaces_ACES_AP0_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_ADOBE_RGB_1998)
#define colors2_colorspaces_6_to_5(x) colors2_colorspaces_ACES_AP0_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_ACES_AP0_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_ACES_AP0)
#define colors2_colorspaces_6_to_6(x) colors2_colorspaces_ACES_AP0_to_ACES_AP0(x)

#define colors2_colorspaces_ACES_AP0_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_ACES_AP0_to_ACES_AP1)
#define colors2_colorspaces_6_to_7(x) colors2_colorspaces_ACES_AP0_to_ACES_AP1(x)


// --------------------------------------------------- From ACES_AP1 ---------------------------------------------------
#define colors2_colorspaces_ACES_AP1_to_CIE_XYZ(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_CIE_XYZ)
#define colors2_colorspaces_7_to_0(x) colors2_colorspaces_ACES_AP1_to_CIE_XYZ(x)

#define colors2_colorspaces_ACES_AP1_to_SRGB(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_SRGB)
#define colors2_colorspaces_7_to_1(x) colors2_colorspaces_ACES_AP1_to_SRGB(x)

#define colors2_colorspaces_ACES_AP1_to_REC709(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_REC709)
#define colors2_colorspaces_7_to_2(x) colors2_colorspaces_ACES_AP1_to_REC709(x)

#define colors2_colorspaces_ACES_AP1_to_REC2020(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_REC2020)
#define colors2_colorspaces_7_to_3(x) colors2_colorspaces_ACES_AP1_to_REC2020(x)

#define colors2_colorspaces_ACES_AP1_to_DCI_P3(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_DCI_P3)
#define colors2_colorspaces_7_to_4(x) colors2_colorspaces_ACES_AP1_to_DCI_P3(x)

#define colors2_colorspaces_ACES_AP1_to_ADOBE_RGB_1998(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_ADOBE_RGB_1998)
#define colors2_colorspaces_7_to_5(x) colors2_colorspaces_ACES_AP1_to_ADOBE_RGB_1998(x)

#define colors2_colorspaces_ACES_AP1_to_ACES_AP0(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_ACES_AP0)
#define colors2_colorspaces_7_to_6(x) colors2_colorspaces_ACES_AP1_to_ACES_AP0(x)

#define colors2_colorspaces_ACES_AP1_to_ACES_AP1(x) (x * _colors2_colorspaces_mat_ACES_AP1_to_ACES_AP1)
#define colors2_colorspaces_7_to_7(x) colors2_colorspaces_ACES_AP1_to_ACES_AP1(x)

