/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.cc_vs.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import io.github.techtastic.cc_vs.PlatformUtils;
import io.github.techtastic.cc_vs.mixin.ShipObjectWorldAccessor;
import io.github.techtastic.cc_vs.ship.PhysicsTicksEventHandler;
import io.github.techtastic.cc_vs.util.CCVSUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u00103\u001a\u000202\u0012\u0006\u00108\u001a\u000207\u00a2\u0006\u0004\b<\u0010=J\u0013\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0004J\u001b\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00020\u0002H\u0007\u00a2\u0006\u0004\b\f\u0010\u0004J\u0019\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001b\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000f\u0010\u0017\u001a\u00020\u0016H\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0013J\u001b\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0011H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0013J\u000f\u0010\u001c\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0004J\u001b\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b\u001f\u0010\u0013J\u001b\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0007\u00a2\u0006\u0004\b \u0010\u0013J\u000f\u0010\"\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020'H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020'H\u0016\u00a2\u0006\u0004\b,\u0010+J#\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010.\u001a\u00020-H\u0007\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020'H\u0016\u00a2\u0006\u0004\b1\u0010+R\u0017\u00103\u001a\u0002028\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lio/github/techtastic/cc_vs/apis/ShipAPI;", "Ldan200/computercraft/api/lua/ILuaAPI;", "", "getConstraints", "()Ljava/util/List;", "", "getId", "()J", "", "getMass", "()D", "getMomentOfInertiaTensor", "getMomentOfInertiaTensorToSave", "", "", "getNames", "()[Ljava/lang/String;", "", "getOmega", "()Ljava/util/Map;", "getQuaternion", "getScale", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShipyardPosition", "", "getSize", "getSlug", "()Ljava/lang/String;", "getTransformationMatrix", "getVelocity", "getWorldspacePosition", "", "isStatic", "()Z", "pullPhysicsTicks", "()[Ljava/lang/Object;", "name", "", "setSlug", "(Ljava/lang/String;)V", "shutdown", "()V", "startup", "Ldan200/computercraft/api/lua/IArguments;", "args", "transformPositionToWorld", "(Ldan200/computercraft/api/lua/IArguments;)Ljava/util/Map;", "update", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "cc_vs"})
@SourceDebugExtension(value={"SMAP\nShipAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipAPI.kt\nio/github/techtastic/cc_vs/apis/ShipAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1549#2:160\n1620#2,2:161\n1622#2:164\n1549#2:165\n1620#2,3:166\n1#3:163\n*S KotlinDebug\n*F\n+ 1 ShipAPI.kt\nio/github/techtastic/cc_vs/apis/ShipAPI\n*L\n155#1:160\n155#1:161,2\n155#1:164\n157#1:165\n157#1:166,3\n*E\n"})
public class ShipAPI
implements ILuaAPI {
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final BlockPos pos;

    public ShipAPI(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.level = level;
        this.pos = pos;
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    public void startup() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip());
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.startup();
    }

    public void update() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                Object[] data = PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip()).getData();
                Class<TileComputer> clazz = TileComputer.class;
                Method method = clazz.getMethod("getServerComputer", new Class[0]);
                Object obj = method.invoke((Object)this.level.m_7702_(this.pos), new Object[0]);
                ServerComputer serverComputer = obj instanceof ServerComputer ? (ServerComputer)obj : null;
                if (serverComputer != null) {
                    serverComputer.queueEvent("physics_ticks", data);
                }
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.update();
    }

    public void shutdown() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip());
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.shutdown();
    }

    @Nullable
    public String[] getNames() {
        String[] stringArray = new String[]{"ship"};
        return stringArray;
    }

    @NotNull
    protected final LoadedServerShip getShip() {
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)this.level, (Vec3i)((Vec3i)this.pos));
        if (loadedServerShip == null) {
            throw new LuaException("This computer is not on a Ship!");
        }
        return loadedServerShip;
    }

    @LuaFunction
    @Nullable
    public final Object[] pullPhysicsTicks() {
        if (!PlatformUtils.exposePhysTick()) {
            throw new LuaException("Physics Tick is not exposed! This is a configuration option!");
        }
        return null;
    }

    @LuaFunction
    public final long getId() {
        return this.getShip().getId();
    }

    @LuaFunction
    public final double getMass() {
        return this.getShip().getInertiaData().getMass();
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getMomentOfInertiaTensorToSave() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getInertiaData().getMomentOfInertiaTensorToSave());
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getMomentOfInertiaTensor() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getInertiaData().getMomentOfInertiaTensor());
    }

    @LuaFunction
    @NotNull
    public final String getSlug() {
        String string = this.getShip().getSlug();
        if (string == null) {
            string = "no-name";
        }
        return string;
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getOmega() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getOmega());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getQuaternion() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getShipToWorldRotation());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getScale() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getShipToWorldScaling());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getShipyardPosition() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getPositionInShip());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Object> getSize() {
        AABBic aABBic = this.getShip().getShipAABB();
        if (aABBic == null) {
            aABBic = (AABBic)new AABBi(0, 0, 0, 0, 0, 0);
        }
        AABBic aabb = aABBic;
        Pair[] pairArray = new Pair[]{new Pair((Object)"x", (Object)(aabb.maxX() - aabb.minX())), new Pair((Object)"y", (Object)(aabb.maxY() - aabb.minY())), new Pair((Object)"z", (Object)(aabb.maxZ() - aabb.minZ()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getVelocity() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getVelocity());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getWorldspacePosition() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getPositionInWorld());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> transformPositionToWorld(@NotNull IArguments args) {
        Vector3d vector3d;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.count() == 1) {
            Map map = args.getTable(0);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTable(...)");
            vector3d = new Vector3d(CCVSUtils.INSTANCE.toVector(map));
        } else {
            vector3d = new Vector3d(args.getDouble(0), args.getDouble(1), args.getDouble(2));
        }
        Vector3d pos = vector3d;
        Vector3d vector3d2 = this.getShip().getShipToWorld().transformPosition(pos);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformPosition(...)");
        return CCVSUtils.INSTANCE.toLua((Vector3dc)vector3d2);
    }

    @LuaFunction
    public final boolean isStatic() {
        return this.getShip().isStatic();
    }

    @LuaFunction
    public final void setSlug(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getShip().setSlug(name);
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getTransformationMatrix() {
        Matrix4dc transform = this.getShip().getTransform().getShipToWorld();
        List matrix = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            Vector4d row = transform.getRow(i, new Vector4d());
            Object[] objectArray = new Double[]{row.x, row.y, row.z, row.w};
            matrix.add(i, CollectionsKt.listOf((Object[])objectArray));
        }
        return CollectionsKt.toList((Iterable)matrix);
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final List<?> getConstraints() {
        VSConstraintAndId id;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ServerShipWorldCore serverShipWorldCore = VSGameUtilsKt.getShipObjectWorld((ServerLevel)this.level);
        Intrinsics.checkNotNull((Object)serverShipWorldCore, (String)"null cannot be cast to non-null type io.github.techtastic.cc_vs.mixin.ShipObjectWorldAccessor");
        ShipObjectWorldAccessor accessor = (ShipObjectWorldAccessor)serverShipWorldCore;
        Set<Integer> set = accessor.getShipIdToConstraints().getOrDefault(this.getShip().getId(), SetsKt.emptySet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOrDefault(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VSConstraintAndId vSConstraintAndId;
            Integer n = (Integer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (accessor.getConstraints().get(id) != null) {
                VSConstraint it;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)id);
                vSConstraintAndId = new VSConstraintAndId(id.intValue(), it);
            } else {
                vSConstraintAndId = null;
            }
            collection.add(vSConstraintAndId);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void combo;
            id = (VSConstraintAndId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = combo;
            collection.add(v3 != null ? CCVSUtils.INSTANCE.toLua((VSConstraintAndId)v3) : null);
        }
        return (List)destination$iv$iv;
    }
}

