/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.cc_vs.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import io.github.techtastic.cc_vs.PlatformUtils;
import io.github.techtastic.cc_vs.mixin.ShipObjectWorldAccessor;
import io.github.techtastic.cc_vs.ship.PhysicsTicksEventHandler;
import io.github.techtastic.cc_vs.ship.QueuedForcesApplier;
import io.github.techtastic.cc_vs.util.CCVSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.world.ServerShipWorld;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010[\u001a\u00020Z\u0012\u0006\u0010`\u001a\u00020_\u00a2\u0006\u0004\bd\u0010eJ'\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ?\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0011\u0010\bJ'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\bJ?\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0013\u0010\rJ'\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0013\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0015H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u001b\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0015H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u0019\u0010!\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010$\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b&\u0010%J\u001f\u0010)\u001a\u00020(2\u000e\u0010'\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#H\u0002\u00a2\u0006\u0004\b)\u0010*J\u001b\u0010+\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b+\u0010%J\u000f\u0010-\u001a\u00020,H\u0004\u00a2\u0006\u0004\b-\u0010.J\u001b\u0010/\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b/\u0010%J\u001b\u00101\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002000#H\u0007\u00a2\u0006\u0004\b1\u0010%J\u000f\u00102\u001a\u00020 H\u0007\u00a2\u0006\u0004\b2\u00103J\u001b\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0015H\u0007\u00a2\u0006\u0004\b4\u0010\u0017J'\u00107\u001a\u0002062\u000e\u0010'\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#2\u0006\u00105\u001a\u00020 H\u0002\u00a2\u0006\u0004\b7\u00108J\u001b\u00109\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b9\u0010%J\u001b\u0010:\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#H\u0007\u00a2\u0006\u0004\b:\u0010%J\u000f\u0010<\u001a\u00020;H\u0007\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010>\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u001fH\u0007\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010A\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u00062\u0006\u0010C\u001a\u00020 H\u0007\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010G\u001a\u00020\u00062\u0006\u0010F\u001a\u00020;H\u0007\u00a2\u0006\u0004\bG\u0010HJ\u000f\u0010I\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010K\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bK\u0010JJ\u0017\u0010N\u001a\u00020\u00062\u0006\u0010M\u001a\u00020LH\u0007\u00a2\u0006\u0004\bN\u0010OJ\u001f\u0010R\u001a\u00020Q2\u0006\u00105\u001a\u00020 2\u0006\u0010P\u001a\u00020 H\u0002\u00a2\u0006\u0004\bR\u0010SJ\u0017\u0010T\u001a\u00020Q2\u0006\u00105\u001a\u00020 H\u0002\u00a2\u0006\u0004\bT\u0010UJ#\u0010V\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020#2\u0006\u0010M\u001a\u00020LH\u0007\u00a2\u0006\u0004\bV\u0010WJ\u000f\u0010X\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bX\u0010JJ\u000f\u0010Y\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bY\u0010JR\u0017\u0010[\u001a\u00020Z8\u0006\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^R\u0017\u0010`\u001a\u00020_8\u0006\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\bb\u0010c\u00a8\u0006f"}, d2={"Lio/github/techtastic/cc_vs/apis/ShipAPI;", "Ldan200/computercraft/api/lua/ILuaAPI;", "", "forceX", "forceY", "forceZ", "", "applyInvariantForce", "(DDD)V", "posX", "posY", "posZ", "applyInvariantForceToPos", "(DDDDDD)V", "torqueX", "torqueY", "torqueZ", "applyInvariantTorque", "applyRotDependentForce", "applyRotDependentForceToPos", "applyRotDependentTorque", "", "getConstraints", "()Ljava/util/List;", "", "getId", "()J", "getMass", "()D", "getMomentOfInertiaTensor", "getMomentOfInertiaTensorToSave", "", "", "getNames", "()[Ljava/lang/String;", "", "getOmega", "()Ljava/util/Map;", "getQuaternion", "input", "Lorg/joml/Quaterniondc;", "getQuaternionFromTable", "(Ljava/util/Map;)Lorg/joml/Quaterniondc;", "getScale", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShipyardPosition", "", "getSize", "getSlug", "()Ljava/lang/String;", "getTransformationMatrix", "section", "Lorg/joml/Vector3dc;", "getVectorFromTable", "(Ljava/util/Map;Ljava/lang/String;)Lorg/joml/Vector3dc;", "getVelocity", "getWorldspacePosition", "", "isStatic", "()Z", "pullPhysicsTicks", "()[Ljava/lang/Object;", "scale", "setScale", "(D)V", "name", "setSlug", "(Ljava/lang/String;)V", "b", "setStatic", "(Z)V", "shutdown", "()V", "startup", "Ldan200/computercraft/api/lua/IArguments;", "args", "teleport", "(Ldan200/computercraft/api/lua/IArguments;)V", "field", "", "throwMalformedFieldError", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Void;", "throwMalformedSectionError", "(Ljava/lang/String;)Ljava/lang/Void;", "transformPositionToWorld", "(Ldan200/computercraft/api/lua/IArguments;)Ljava/util/Map;", "update", "verifyAdmin", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "cc_vs"})
@SourceDebugExtension(value={"SMAP\nShipAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipAPI.kt\nio/github/techtastic/cc_vs/apis/ShipAPI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1#2:273\n1549#3:274\n1620#3,3:275\n1549#3:278\n1620#3,3:279\n*S KotlinDebug\n*F\n+ 1 ShipAPI.kt\nio/github/techtastic/cc_vs/apis/ShipAPI\n*L\n159#1:274\n159#1:275,3\n161#1:278\n161#1:279,3\n*E\n"})
public class ShipAPI
implements ILuaAPI {
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final BlockPos pos;

    public ShipAPI(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.level = level;
        this.pos = pos;
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    private final void verifyAdmin() {
        if (PlatformUtils.isCommandOnly()) {
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            TileComputer tileComputer = blockEntity instanceof TileComputer ? (TileComputer)blockEntity : null;
            if ((tileComputer != null ? tileComputer.getFamily() : null) == ComputerFamily.COMMAND) {
                throw new LuaException("This method requires a Command Computer!");
            }
        }
    }

    public void startup() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip());
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.startup();
    }

    public void update() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                Object[] data = PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip()).getData();
                BlockEntity blockEntity = this.level.m_7702_(this.pos);
                TileComputer tileComputer = blockEntity instanceof TileComputer ? (TileComputer)blockEntity : null;
                if (tileComputer != null) {
                    TileComputer computer = tileComputer;
                    boolean bl = false;
                    ServerComputer serverComputer = computer.getServerComputer();
                    if (serverComputer != null) {
                        serverComputer.queueEvent("physics_ticks", data);
                    }
                }
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.update();
    }

    public void shutdown() {
        try {
            if (PlatformUtils.exposePhysTick()) {
                PhysicsTicksEventHandler.Companion.getOrCreateControl((ServerShip)this.getShip());
            }
        }
        catch (LuaException luaException) {
            // empty catch block
        }
        super.shutdown();
    }

    @Nullable
    public String[] getNames() {
        String[] stringArray = new String[]{"ship"};
        return stringArray;
    }

    @NotNull
    protected final LoadedServerShip getShip() {
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)this.level, (Vec3i)((Vec3i)this.pos));
        if (loadedServerShip == null) {
            throw new LuaException("This computer is not on a Ship!");
        }
        return loadedServerShip;
    }

    @LuaFunction
    @Nullable
    public final Object[] pullPhysicsTicks() {
        if (!PlatformUtils.exposePhysTick()) {
            throw new LuaException("Physics Tick is not exposed! This is a configuration option!");
        }
        return null;
    }

    @LuaFunction
    public final long getId() {
        return this.getShip().getId();
    }

    @LuaFunction
    public final double getMass() {
        return this.getShip().getInertiaData().getMass();
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getMomentOfInertiaTensorToSave() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getInertiaData().getMomentOfInertiaTensorToSave());
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getMomentOfInertiaTensor() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getInertiaData().getMomentOfInertiaTensor());
    }

    @LuaFunction
    @NotNull
    public final String getSlug() {
        String string = this.getShip().getSlug();
        if (string == null) {
            string = "no-name";
        }
        return string;
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getOmega() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getOmega());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getQuaternion() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getShipToWorldRotation());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getScale() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getShipToWorldScaling());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getShipyardPosition() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getPositionInShip());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Object> getSize() {
        AABBic aABBic = this.getShip().getShipAABB();
        if (aABBic == null) {
            aABBic = (AABBic)new AABBi(0, 0, 0, 0, 0, 0);
        }
        AABBic aabb = aABBic;
        Pair[] pairArray = new Pair[]{new Pair((Object)"x", (Object)(aabb.maxX() - aabb.minX())), new Pair((Object)"y", (Object)(aabb.maxY() - aabb.minY())), new Pair((Object)"z", (Object)(aabb.maxZ() - aabb.minZ()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getVelocity() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getVelocity());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> getWorldspacePosition() {
        return CCVSUtils.INSTANCE.toLua(this.getShip().getTransform().getPositionInWorld());
    }

    @LuaFunction
    @NotNull
    public final Map<String, Double> transformPositionToWorld(@NotNull IArguments args) {
        Vector3d vector3d;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.count() == 1) {
            Map map = args.getTable(0);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTable(...)");
            vector3d = new Vector3d(CCVSUtils.INSTANCE.toVector(map));
        } else {
            vector3d = new Vector3d(args.getDouble(0), args.getDouble(1), args.getDouble(2));
        }
        Vector3d pos = vector3d;
        Vector3d vector3d2 = this.getShip().getShipToWorld().transformPosition(pos);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transformPosition(...)");
        return CCVSUtils.INSTANCE.toLua((Vector3dc)vector3d2);
    }

    @LuaFunction
    public final boolean isStatic() {
        return this.getShip().isStatic();
    }

    @LuaFunction
    public final void setSlug(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getShip().setSlug(name);
    }

    @LuaFunction
    @NotNull
    public final List<List<Double>> getTransformationMatrix() {
        Matrix4dc transform = this.getShip().getTransform().getShipToWorld();
        List matrix = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            Vector4d row = transform.getRow(i, new Vector4d());
            Object[] objectArray = new Double[]{row.x, row.y, row.z, row.w};
            matrix.add(i, CollectionsKt.listOf((Object[])objectArray));
        }
        return CollectionsKt.toList((Iterable)matrix);
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final List<?> getConstraints() {
        VSConstraintAndId id;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ServerShipWorldCore serverShipWorldCore = VSGameUtilsKt.getShipObjectWorld((ServerLevel)this.level);
        Intrinsics.checkNotNull((Object)serverShipWorldCore, (String)"null cannot be cast to non-null type io.github.techtastic.cc_vs.mixin.ShipObjectWorldAccessor");
        ShipObjectWorldAccessor accessor = (ShipObjectWorldAccessor)serverShipWorldCore;
        Set<Integer> set = accessor.getShipIdToConstraints().getOrDefault(this.getShip().getId(), SetsKt.emptySet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOrDefault(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VSConstraintAndId vSConstraintAndId;
            Integer n = (Integer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (accessor.getConstraints().get(id) != null) {
                VSConstraint it;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)id);
                vSConstraintAndId = new VSConstraintAndId(id.intValue(), it);
            } else {
                vSConstraintAndId = null;
            }
            collection.add(vSConstraintAndId);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void combo;
            id = (VSConstraintAndId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = combo;
            collection.add(v3 != null ? CCVSUtils.INSTANCE.toLua((VSConstraintAndId)v3) : null);
        }
        return (List)destination$iv$iv;
    }

    @LuaFunction
    public final void applyInvariantForce(double forceX, double forceY, double forceZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyInvariantForce((Vector3dc)new Vector3d(forceX, forceY, forceZ));
    }

    @LuaFunction
    public final void applyInvariantTorque(double torqueX, double torqueY, double torqueZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyInvariantTorque((Vector3dc)new Vector3d(torqueX, torqueY, torqueZ));
    }

    @LuaFunction
    public final void applyInvariantForceToPos(double forceX, double forceY, double forceZ, double posX, double posY, double posZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyInvariantForceToPos((Vector3dc)new Vector3d(forceX, forceY, forceZ), (Vector3dc)new Vector3d(posX, posY, posZ));
    }

    @LuaFunction
    public final void applyRotDependentForce(double forceX, double forceY, double forceZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyRotDependentForce((Vector3dc)new Vector3d(forceX, forceY, forceZ));
    }

    @LuaFunction
    public final void applyRotDependentTorque(double torqueX, double torqueY, double torqueZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyRotDependentTorque((Vector3dc)new Vector3d(torqueX, torqueY, torqueZ));
    }

    @LuaFunction
    public final void applyRotDependentForceToPos(double forceX, double forceY, double forceZ, double posX, double posY, double posZ) {
        this.verifyAdmin();
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).applyRotDependentForceToPos((Vector3dc)new Vector3d(forceX, forceY, forceZ), (Vector3dc)new Vector3d(posX, posY, posZ));
    }

    @LuaFunction
    public final void setStatic(boolean b) {
        QueuedForcesApplier.Companion.getOrCreateControl((ServerShip)this.getShip()).setStatic(b);
    }

    @LuaFunction
    public final void setScale(double scale) {
        VSGameUtilsKt.getVsCore().scaleShip((ServerShipWorld)VSGameUtilsKt.getShipObjectWorld((ServerLevel)this.level), (ServerShip)this.getShip(), scale);
    }

    @LuaFunction
    public final void teleport(@NotNull IArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!PlatformUtils.canTeleport()) {
            throw new LuaException("Teleporting is Disabled via CC: VS Config!");
        }
        Map map = args.getTable(0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTable(...)");
        Map input = map;
        Vector3dc pos = this.getShip().getTransform().getPositionInWorld();
        if (input.containsKey("pos")) {
            pos = this.getVectorFromTable(input, "pos");
        }
        Quaterniondc rot = this.getShip().getTransform().getShipToWorldRotation();
        if (input.containsKey("rot")) {
            Quaterniond quaterniond = this.getQuaternionFromTable(input).normalize(new Quaterniond());
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"normalize(...)");
            rot = (Quaterniondc)quaterniond;
        }
        Vector3dc vel = this.getShip().getVelocity();
        if (input.containsKey("vel")) {
            vel = this.getVectorFromTable(input, "vel");
        }
        Vector3dc omega = this.getShip().getOmega();
        if (input.containsKey("omega")) {
            omega = this.getVectorFromTable(input, "omega");
        }
        String dimension = null;
        if (input.containsKey("dimension")) {
            Object v = input.get("dimension");
            if (v == null) {
                this.throwMalformedSectionError("dimension");
                throw new KotlinNothingValueException();
            }
            dimension = (String)v;
        }
        double scale = this.getShip().getTransform().getShipToWorldScaling().x();
        if (input.containsKey("scale")) {
            Object v = input.get("scale");
            if (v == null) {
                this.throwMalformedSectionError("scale");
                throw new KotlinNothingValueException();
            }
            scale = (Double)v;
        }
        ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl(pos, rot, vel, omega, dimension, Double.valueOf(scale));
        System.out.println((Object)("Rot: " + teleportData.getNewRot() + "\n"));
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)this.level).teleportShip((ServerShip)this.getShip(), (ShipTeleportData)teleportData);
    }

    private final Vector3dc getVectorFromTable(Map<?, ?> input, String section) {
        Object obj = input.get(section);
        if (obj == null) {
            this.throwMalformedSectionError(section);
            throw new KotlinNothingValueException();
        }
        Map table = (Map)obj;
        Object v = table.get("x");
        if (v == null) {
            this.throwMalformedFieldError(section, "x");
            throw new KotlinNothingValueException();
        }
        Object v2 = table.get("y");
        if (v2 == null) {
            this.throwMalformedFieldError(section, "y");
            throw new KotlinNothingValueException();
        }
        Object v3 = table.get("z");
        if (v3 == null) {
            this.throwMalformedFieldError(section, "z");
            throw new KotlinNothingValueException();
        }
        return (Vector3dc)new Vector3d(((Double)v).doubleValue(), ((Double)v2).doubleValue(), ((Double)v3).doubleValue());
    }

    private final Quaterniondc getQuaternionFromTable(Map<?, ?> input) {
        Object obj = input.get("rot");
        if (obj == null) {
            this.throwMalformedSectionError("rot");
            throw new KotlinNothingValueException();
        }
        Map table = (Map)obj;
        Object v = table.get("x");
        if (v == null) {
            this.throwMalformedFieldError("rot", "x");
            throw new KotlinNothingValueException();
        }
        Object v2 = table.get("y");
        if (v2 == null) {
            this.throwMalformedFieldError("rot", "y");
            throw new KotlinNothingValueException();
        }
        Object v3 = table.get("z");
        if (v3 == null) {
            this.throwMalformedFieldError("rot", "z");
            throw new KotlinNothingValueException();
        }
        Object v4 = table.get("w");
        if (v4 == null) {
            this.throwMalformedFieldError("rot", "w");
            throw new KotlinNothingValueException();
        }
        return (Quaterniondc)new Quaterniond(((Double)v).doubleValue(), ((Double)v2).doubleValue(), ((Double)v3).doubleValue(), ((Double)v4).doubleValue());
    }

    private final Void throwMalformedSectionError(String section) {
        throw new LuaException("Malformed " + section);
    }

    private final Void throwMalformedFieldError(String section, String field) {
        throw new LuaException("Malformed " + field + " key of " + section);
    }
}

