/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.cc_vs.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.shared.computer.core.ServerComputer;
import io.github.techtastic.cc_vs.CCVSMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3dc;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSForceConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeSwingLimitsConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeTargetAngleConstraint;
import org.valkyrienskies.core.apigame.constraints.VSPosDampingConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRotDampingConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSlideConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSphericalSwingLimitsConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSphericalTwistLimitsConstraint;
import org.valkyrienskies.core.apigame.constraints.VSTorqueConstraint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b*\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r*\u00020\f\u00a2\u0006\u0004\b\n\u0010\u000fJ\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r*\u00020\u0010\u00a2\u0006\u0004\b\n\u0010\u0011J\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r*\u00020\u0012\u00a2\u0006\u0004\b\n\u0010\u0013J\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r*\u00020\u0014\u00a2\u0006\u0004\b\n\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\u0010*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/github/techtastic/cc_vs/util/CCVSUtils;", "", "", "id", "Ldan200/computercraft/shared/computer/core/ServerComputer;", "getComputerByID", "(I)Ldan200/computercraft/shared/computer/core/ServerComputer;", "Lorg/joml/Matrix3dc;", "", "", "toLua", "(Lorg/joml/Matrix3dc;)Ljava/util/List;", "Lorg/joml/Quaterniondc;", "", "", "(Lorg/joml/Quaterniondc;)Ljava/util/Map;", "Lorg/joml/Vector3dc;", "(Lorg/joml/Vector3dc;)Ljava/util/Map;", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;", "(Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;)Ljava/util/Map;", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintAndId;", "(Lorg/valkyrienskies/core/apigame/constraints/VSConstraintAndId;)Ljava/util/Map;", "toVector", "(Ljava/util/Map;)Lorg/joml/Vector3dc;", "<init>", "()V", "cc_vs"})
@SourceDebugExtension(value={"SMAP\nCCVSUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CCVSUtils.kt\nio/github/techtastic/cc_vs/util/CCVSUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class CCVSUtils {
    @NotNull
    public static final CCVSUtils INSTANCE = new CCVSUtils();

    private CCVSUtils() {
    }

    @NotNull
    public final Map<String, Double> toLua(@NotNull Vector3dc $this$toLua) {
        Intrinsics.checkNotNullParameter((Object)$this$toLua, (String)"<this>");
        Pair[] pairArray = new Pair[]{new Pair((Object)"x", (Object)$this$toLua.x()), new Pair((Object)"y", (Object)$this$toLua.y()), new Pair((Object)"z", (Object)$this$toLua.z())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<String, Double> toLua(@NotNull Quaterniondc $this$toLua) {
        Intrinsics.checkNotNullParameter((Object)$this$toLua, (String)"<this>");
        Pair[] pairArray = new Pair[]{new Pair((Object)"x", (Object)$this$toLua.x()), new Pair((Object)"y", (Object)$this$toLua.y()), new Pair((Object)"z", (Object)$this$toLua.z()), new Pair((Object)"w", (Object)$this$toLua.w())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final List<List<Double>> toLua(@NotNull Matrix3dc $this$toLua) {
        Intrinsics.checkNotNullParameter((Object)$this$toLua, (String)"<this>");
        List tensor = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            Vector3d row = $this$toLua.getRow(i, new Vector3d());
            Object[] objectArray = new Double[]{row.x, row.y, row.z};
            tensor.add(i, CollectionsKt.listOf((Object[])objectArray));
        }
        return tensor;
    }

    @Nullable
    public final ServerComputer getComputerByID(int id) {
        Object v1;
        block1: {
            Collection collection = CCVSMod.INSTANCE.getContext().registry().getComputers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getComputers(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                ServerComputer computer = (ServerComputer)t;
                boolean bl = false;
                if (!(computer.getID() == id)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final Map<String, Object> toLua(@NotNull VSConstraintAndId $this$toLua) {
        Intrinsics.checkNotNullParameter((Object)$this$toLua, (String)"<this>");
        Pair[] pairArray = new Pair[]{new Pair((Object)"id", (Object)$this$toLua.getConstraintId()), new Pair((Object)"constraint", this.toLua($this$toLua.getVsConstraint()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<String, Object> toLua(@NotNull VSConstraint $this$toLua) {
        VSConstraint vSConstraint;
        Intrinsics.checkNotNullParameter((Object)$this$toLua, (String)"<this>");
        Map constraint = new LinkedHashMap();
        constraint.put("shipId0", $this$toLua.getShipId0());
        constraint.put("shipId1", $this$toLua.getShipId1());
        constraint.put("type", $this$toLua.getConstraintType().name());
        constraint.put("compliance", $this$toLua.getCompliance());
        if ($this$toLua instanceof VSForceConstraint) {
            constraint.put("localPos0", this.toLua(((VSForceConstraint)$this$toLua).getLocalPos0()));
            constraint.put("localPos1", this.toLua(((VSForceConstraint)$this$toLua).getLocalPos1()));
            constraint.put("maxForce", ((VSForceConstraint)$this$toLua).getMaxForce());
        }
        if ($this$toLua instanceof VSTorqueConstraint) {
            constraint.put("localRot0", this.toLua(((VSTorqueConstraint)$this$toLua).getLocalRot0()));
            constraint.put("localRot1", this.toLua(((VSTorqueConstraint)$this$toLua).getLocalRot1()));
            constraint.put("maxTorque", ((VSTorqueConstraint)$this$toLua).getMaxTorque());
        }
        if ((vSConstraint = $this$toLua) instanceof VSAttachmentConstraint) {
            constraint.put("fixedDistance", ((VSAttachmentConstraint)$this$toLua).getFixedDistance());
        } else if (vSConstraint instanceof VSHingeSwingLimitsConstraint) {
            constraint.put("minSwingAngle", ((VSHingeSwingLimitsConstraint)$this$toLua).getMinSwingAngle());
            constraint.put("maxSwingAngle", ((VSHingeSwingLimitsConstraint)$this$toLua).getMaxSwingAngle());
        } else if (vSConstraint instanceof VSHingeTargetAngleConstraint) {
            constraint.put("targetAngle", ((VSHingeTargetAngleConstraint)$this$toLua).getTargetAngle());
            constraint.put("nextTickTargetAngle", ((VSHingeTargetAngleConstraint)$this$toLua).getNextTickTargetAngle());
        } else if (vSConstraint instanceof VSPosDampingConstraint) {
            constraint.put("posDamping", ((VSPosDampingConstraint)$this$toLua).getPosDamping());
        } else if (vSConstraint instanceof VSRopeConstraint) {
            constraint.put("ropeLength", ((VSRopeConstraint)$this$toLua).getRopeLength());
        } else if (vSConstraint instanceof VSRotDampingConstraint) {
            constraint.put("rotDamping", ((VSRotDampingConstraint)$this$toLua).getRotDamping());
            constraint.put("rotDampingAxes", ((VSRotDampingConstraint)$this$toLua).getRotDampingAxes().name());
        } else if (vSConstraint instanceof VSSlideConstraint) {
            constraint.put("localSlideAxis0", this.toLua(((VSSlideConstraint)$this$toLua).getLocalSlideAxis0()));
            constraint.put("maxDistBetweenPoints", ((VSSlideConstraint)$this$toLua).getMaxDistBetweenPoints());
        } else if (vSConstraint instanceof VSSphericalSwingLimitsConstraint) {
            constraint.put("minSwingAngle", ((VSSphericalSwingLimitsConstraint)$this$toLua).getMinSwingAngle());
            constraint.put("maxSwingAngle", ((VSSphericalSwingLimitsConstraint)$this$toLua).getMaxSwingAngle());
        } else if (vSConstraint instanceof VSSphericalTwistLimitsConstraint) {
            constraint.put("minTwistAngle", ((VSSphericalTwistLimitsConstraint)$this$toLua).getMinTwistAngle());
            constraint.put("maxTwistAngle", ((VSSphericalTwistLimitsConstraint)$this$toLua).getMaxTwistAngle());
        }
        return constraint;
    }

    @NotNull
    public final Vector3dc toVector(@NotNull Map<?, ?> $this$toVector) {
        Intrinsics.checkNotNullParameter($this$toVector, (String)"<this>");
        Map<?, ?> map = $this$toVector;
        if (map == null) {
            throw new LuaException("Invalid Argument! Expects either a vector or a table with x, y, and z keys!");
        }
        Map<?, ?> posTable = map;
        Double d = (Double)posTable.get("x");
        Double d2 = (Double)posTable.get("y");
        Double d3 = (Double)posTable.get("z");
        return (Vector3dc)new Vector3d(d != null ? d : 0.0, d2 != null ? d2 : 0.0, d3 != null ? d3 : 0.0);
    }
}

