/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.block.custom;

import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2464;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.shirojr.nemuelch.block.entity.custom.RottenMeatBlockEntity;
import net.shirojr.nemuelch.compat.cca.component.RottenMeatDigestionComponent;
import net.shirojr.nemuelch.init.NeMuelchBlockEntities;
import net.shirojr.nemuelch.init.NeMuelchParticles;
import net.shirojr.nemuelch.init.NeMuelchProperties;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import org.jetbrains.annotations.Nullable;

public class RottenMeatBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2758 STAGE = NeMuelchProperties.ROTTEN_MEAT_STAGE;

    public RottenMeatBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, STAGE});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = super.method_9605(ctx);
        if (state == null) {
            return null;
        }
        state = (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0));
        return state;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)STAGE) == 0) {
            return null;
        }
        return new RottenMeatBlockEntity(pos, state);
    }

    @Nullable
    public static RottenMeatBlockEntity jumpStartBlockEntity(class_1937 world, class_2338 pos, class_2680 state, class_1799 jumpStartStack, boolean overwriteStage) {
        if (world.method_8321(pos) != null) {
            return null;
        }
        if (overwriteStage) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(1)));
        } else if (!state.method_28498((class_2769)STAGE) || (Integer)state.method_11654((class_2769)STAGE) < 1) {
            return null;
        }
        return new RottenMeatBlockEntity(pos, state, jumpStartStack.method_7972());
    }

    public void method_9536(class_2680 oldState, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (oldState.method_27852((class_2248)this) && !newState.method_27852((class_2248)this) && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            RottenMeatDigestionComponent.get(world, pos).ifPresent(component -> class_1264.method_17349((class_1937)serverWorld, (class_2338)pos, component.getDigestionStacks()));
        }
        super.method_9536(oldState, world, pos, newState, moved);
        if (newState.method_28498((class_2769)STAGE) && oldState.method_28498((class_2769)STAGE)) {
            class_1799 itemStack;
            RottenMeatBlockEntity blockEntity;
            if ((Integer)oldState.method_11654((class_2769)STAGE) == 0 && (Integer)newState.method_11654((class_2769)STAGE) != 0 && (blockEntity = RottenMeatBlock.jumpStartBlockEntity(world, pos, newState, itemStack = RottenMeatDigestionComponent.getFoodOnTop(world, pos, class_238.method_19316((class_3341)new class_3341(pos.method_10084()))).map(class_1542::method_6983).orElse(class_1799.field_8037), false)) != null) {
                world.method_8438((class_2586)blockEntity);
            }
            if ((Integer)oldState.method_11654((class_2769)STAGE) != 0 && (Integer)newState.method_11654((class_2769)STAGE) == 0) {
                world.method_8544(pos);
            }
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return RottenMeatBlock.method_31618(type, NeMuelchBlockEntities.ROTTEN_MEAT, (world1, pos, state1, blockEntity) -> {});
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1542 itemEntity;
        super.method_9591(world, pos, state, entity);
        class_5819 random = world.method_8409();
        double speed = entity.method_18798().method_37268();
        if (entity instanceof class_1657 && world.method_8608() && entity.field_6012 % 10 == 0 && speed > 0.01) {
            float pitch = class_3532.method_16439((float)random.method_43057(), (float)0.6f, (float)0.8f);
            world.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), NeMuelchSounds.SQUIRT, class_3419.field_15245, 1.0f, pitch, true);
            RottenMeatBlock.spawnClientParticles(100, 1, pos, world, random);
        }
        if (world instanceof class_3218) {
            class_1309 livingEntity;
            class_3218 serverWorld = (class_3218)world;
            if (entity.field_6012 % 10 == 0 && speed > 0.01) {
                float pitch = class_3532.method_16439((float)random.method_43057(), (float)0.6f, (float)0.8f);
                serverWorld.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), NeMuelchSounds.SQUIRT, class_3419.field_15245, 1.0f, pitch);
            }
            if (entity instanceof class_1309 && !(livingEntity = (class_1309)entity).method_5999() && entity.field_6012 % 60 < 5 && (double)serverWorld.method_8409().method_43057() < 0.05) {
                livingEntity.method_6092(new class_1293(class_1294.field_5899, 60, 0));
                world.method_8396(null, livingEntity.method_24515(), class_3417.field_14692, class_3419.field_15245, 1.0f, 0.75f);
                RottenMeatBlock.spawnParticles(100, 1, pos, serverWorld);
            }
        }
        if (state.method_28498((class_2769)STAGE) && (Integer)state.method_11654((class_2769)STAGE) == 0 && entity instanceof class_1542 && RottenMeatDigestionComponent.canDigest((itemEntity = (class_1542)entity).method_6983())) {
            RottenMeatBlock.jumpStartBlockEntity(world, pos, state, itemEntity.method_6983(), true);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int outerParticleRange = 5;
        int innerParticleRange = 1;
        int outerParticleAmount = 1;
        int innerParticleAmount = 5;
        int enclosingBlocksAmount = this.enclosingBlocks(world, pos, countableState -> countableState.method_27852((class_2248)this), blockerState -> blockerState.method_26227().method_15767(class_3486.field_15517));
        if (enclosingBlocksAmount > 3) {
            RottenMeatBlock.spawnClientParticles(innerParticleAmount, innerParticleRange, pos, world, random);
        }
        if (enclosingBlocksAmount > 1) {
            RottenMeatBlock.spawnClientParticles(outerParticleAmount, outerParticleRange, pos, world, random);
        }
    }

    public static void spawnClientParticles(int amount, int range, class_2338 pos, class_1937 world, class_5819 random) {
        if (world instanceof class_3218) {
            throw new UnsupportedOperationException("Tried to spawn client particles on logical server side");
        }
        class_2338.class_2339 mutable = pos.method_25503();
        int originX = pos.method_10263();
        int originY = pos.method_10264();
        int originZ = pos.method_10260();
        for (int i = 0; i < amount; ++i) {
            mutable.method_10103(originX + class_3532.method_15395((class_5819)random, (int)(-range), (int)range), originY - random.method_43048(range), originZ + class_3532.method_15395((class_5819)random, (int)(-range), (int)range));
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (blockState.method_26234((class_1922)world, (class_2338)mutable)) continue;
            world.method_8406((class_2394)NeMuelchParticles.ROTTEN_MEAT_AIR, (double)mutable.method_10263() + random.method_43058(), (double)mutable.method_10264() + random.method_43058(), (double)mutable.method_10260() + random.method_43058(), 0.0, 0.8, 0.0);
        }
    }

    public static void spawnParticles(int amount, int range, class_2338 pos, class_3218 world) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(amount);
        buf.method_10804(range);
        buf.writeLong(pos.method_10063());
        for (class_3222 target : PlayerLookup.tracking((class_3218)world, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)target, (class_2960)NetworkIdentifiers.SPAWN_ROTTEN_PARTICLE, (class_2540)PacketByteBufs.copy((ByteBuf)buf));
        }
    }

    private int enclosingBlocks(class_1937 world, class_2338 pos, Predicate<class_2680> stateMatcher, Predicate<class_2680> blocker) {
        int count = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2680 state = world.method_8320(pos.method_10093(direction));
            if (blocker.test(state)) {
                return 0;
            }
            if (!stateMatcher.test(state)) continue;
            ++count;
        }
        return count;
    }
}

