/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.block.custom;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.shirojr.nemuelch.block.custom.RottenMeatBlock;
import net.shirojr.nemuelch.compat.cca.component.RottenMeatDigestionComponent;
import net.shirojr.nemuelch.init.NeMuelchBlocks;
import net.shirojr.nemuelch.item.util.ItemStackUtil;
import net.shirojr.nemuelch.util.helper.BlockPosHelper;
import net.shirojr.nemuelch.util.logger.LoggerUtil;

public class RottenTreeLogBlock
extends class_2465 {
    public static final int MAX_LOG_SEARCH_COUNT = 70;
    public static final int MAX_LEAF_SEARCH_COUNT = 20;

    public RottenTreeLogBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (!state.method_27852((class_2248)this) || !RottenMeatDigestionComponent.canDigest(stack)) {
            return super.method_9534(state, world, pos, player, hand, hit);
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        HashSet<class_2338> logs = RottenTreeLogBlock.collectValidConnected(world, Set.of(pos), (entryWorld, entryPos) -> {
            class_2680 entryState = entryWorld.method_8320(entryPos);
            return entryState.method_27852((class_2248)this);
        }, Set.of(), true, 70);
        HashSet<class_2338> leaves = RottenTreeLogBlock.collectValidConnected(world, logs, (entryWorld, entryPos) -> {
            class_2680 entryState = entryWorld.method_8320(entryPos);
            class_2680 entryStateBelow = entryWorld.method_8320(entryPos.method_10074());
            return entryState.method_27852((class_2248)NeMuelchBlocks.ROTTEN_MEAT) && entryStateBelow.method_26215();
        }, Set.of(), false, 20);
        if (leaves.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.error"), true);
            return class_1269.field_5814;
        }
        ArrayList<class_2338> leavesList = new ArrayList<class_2338>();
        int highestAmount = 0;
        for (class_2338 leafPos : leaves) {
            Optional<RottenMeatDigestionComponent> component = RottenMeatDigestionComponent.get(world, leafPos);
            if (component.isPresent()) {
                int nonEmptyStacksAmount;
                if (component.get().isDigesting() || (nonEmptyStacksAmount = component.get().getNonEmptyDigestionStackSize()) >= 5 || component.get().getIntakeCooldown() > 0) continue;
                if (highestAmount < nonEmptyStacksAmount) {
                    highestAmount = nonEmptyStacksAmount;
                    leavesList.clear();
                }
                LoggerUtil.devLogger("Considering leave %s | non empty slots %s | digestion time %s".formatted(leafPos, nonEmptyStacksAmount, component.get().getDigestionTick()));
            }
            leavesList.add(leafPos);
        }
        if (leavesList.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.error"), true);
            return class_1269.field_5814;
        }
        int randomLeafIndex = world.method_8409().method_43048(leavesList.size());
        class_2338 chosenLeafPos = (class_2338)leavesList.get(randomLeafIndex);
        class_2680 chosenLeafState = world.method_8320(chosenLeafPos);
        if (!chosenLeafState.method_28498((class_2769)RottenMeatBlock.STAGE)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.error"), true);
            return class_1269.field_5814;
        }
        if ((Integer)chosenLeafState.method_11654((class_2769)RottenMeatBlock.STAGE) == 0) {
            RottenMeatBlock.jumpStartBlockEntity(world, chosenLeafPos, chosenLeafState, stack, true);
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.success"), true);
            return class_1269.field_5812;
        }
        Optional<RottenMeatDigestionComponent> component = RottenMeatDigestionComponent.get(world, chosenLeafPos);
        if (component.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.error"), true);
            return class_1269.field_5814;
        }
        boolean success = component.get().addToDigestion(stack.method_7972(), true);
        if (success) {
            ItemStackUtil.decrementUnlessCreative(stack, (class_1309)player, stack.method_7947());
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                RottenMeatBlock.spawnParticles(50, 1, chosenLeafPos.method_10074(), serverWorld);
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.success"), true);
            return class_1269.field_5812;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"block.nemuelch.rotten_tree_log.search.error"), true);
        return class_1269.field_5814;
    }

    private static HashSet<class_2338> collectValidConnected(class_1937 world, Collection<class_2338> startPositions, BiPredicate<class_1937, class_2338> isValid, Collection<class_2338> excluded, boolean checkSelf, int maxSize) {
        HashSet<class_2338> result = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        for (class_2338 startPosEntry : startPositions) {
            if (excluded.contains(startPosEntry) || result.contains(startPosEntry)) continue;
            if (checkSelf) {
                if (!isValid.test(world, startPosEntry)) continue;
                result.add(startPosEntry.method_10062());
            }
            queue.add(startPosEntry.method_10062());
        }
        while (!queue.isEmpty() && result.size() < maxSize) {
            class_2338 currentPos = (class_2338)queue.poll();
            for (class_2338 offset : BlockPosHelper.ALL_NEIGHBORS_CACHED) {
                class_2338 neighborPos = currentPos.method_10081((class_2382)offset);
                if (result.contains(neighborPos) || excluded.contains(neighborPos) || !isValid.test(world, neighborPos)) continue;
                result.add(neighborPos.method_10062());
                queue.add(neighborPos.method_10062());
            }
        }
        return result;
    }
}

