/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.block.entity.custom;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.shirojr.nemuelch.block.custom.StationBlocks.RopeWinchBlock;
import net.shirojr.nemuelch.init.NeMuelchBlockEntities;
import net.shirojr.nemuelch.init.NeMuelchBlocks;
import net.shirojr.nemuelch.init.NeMuelchProperties;
import net.shirojr.nemuelch.screen.handler.RopeWinchScreenHandler;
import net.shirojr.nemuelch.util.ImplementedInventory;
import org.jetbrains.annotations.Nullable;

public class RopeWinchBlockEntity
extends class_2586
implements class_3908,
ImplementedInventory {
    private static int tick = 0;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> RopeWinchBlockEntity.this.storedRopes;
                case 1 -> RopeWinchBlockEntity.this.maxRopeCount;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    RopeWinchBlockEntity.this.storedRopes = value;
                    break;
                }
                case 1: {
                    RopeWinchBlockEntity.this.maxRopeCount = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int storedRopes = 0;
    private int maxRopeCount = 128;

    public RopeWinchBlockEntity(class_2338 pos, class_2680 state) {
        super(NeMuelchBlockEntities.ROPER_STATION, pos, state);
    }

    public int getStoredRopes() {
        return this.storedRopes;
    }

    public void setStoredRopes(int count) {
        this.storedRopes = count;
        this.propertyDelegate.method_17391(0, count);
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, RopeWinchBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        if (!(world.method_8321(blockPos) instanceof RopeWinchBlockEntity)) {
            return;
        }
        if (entity.getStoredRopes() == entity.getCurrentRopeLength(blockPos)) {
            return;
        }
        if (++tick % 30 != 0) {
            return;
        }
        class_2338 ropePos = RopeWinchBlockEntity.getLastRopePos(world, blockPos);
        while (entity.getCurrentRopeLength(blockPos) < entity.getStoredRopes() && RopeWinchBlockEntity.isValidRopeBlockPos(world, ropePos)) {
            if (entity.getCurrentRopeLength(blockPos) == 0) {
                world.method_8652(ropePos, (class_2680)NeMuelchBlocks.ROPE.method_9564().method_11657((class_2769)NeMuelchProperties.ROPE_ANCHOR, (Comparable)Boolean.valueOf(true)), 2);
            } else {
                world.method_8652(ropePos, (class_2680)NeMuelchBlocks.ROPE.method_9564().method_11657((class_2769)NeMuelchProperties.ROPE_ANCHOR, (Comparable)Boolean.valueOf(false)), 2);
            }
            ropePos = ropePos.method_10074();
        }
        ropePos = ropePos.method_10084();
        while (entity.getCurrentRopeLength(blockPos) > entity.getStoredRopes()) {
            world.method_8650(ropePos, false);
            ropePos = ropePos.method_10084();
        }
        tick = 0;
        world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)RopeWinchBlock.ROPED, (Comparable)Boolean.valueOf(entity.getCurrentRopeLength(blockPos) > 0)), 3);
        RopeWinchBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)blockState);
    }

    public static class_2338 getLastRopePos(class_1937 world, class_2338 stationPos) {
        class_2350 stationDirection = (class_2350)world.method_8320(stationPos).method_11654((class_2769)RopeWinchBlock.FACING);
        class_2338 ropePos = stationPos.method_25503().method_10079(stationDirection, 1).method_10074();
        while (world.method_8320(ropePos).method_26204() == NeMuelchBlocks.ROPE) {
            ropePos = ropePos.method_10074();
        }
        return ropePos;
    }

    public static void removeAllRopeBlocks(class_1937 world, class_2338 stationPos) {
        if (world.method_8608()) {
            return;
        }
        class_2350 stationDirection = (class_2350)world.method_8320(stationPos).method_11654((class_2769)RopeWinchBlock.FACING);
        class_2338 ropePos = stationPos.method_25503().method_10079(stationDirection, 1).method_10074();
        while (world.method_8320(ropePos).method_26204() == NeMuelchBlocks.ROPE) {
            world.method_22352(ropePos, false);
            ropePos = ropePos.method_10074();
        }
        world.method_8652(stationPos, (class_2680)world.method_8320(stationPos).method_11657((class_2769)RopeWinchBlock.ROPED, (Comparable)Boolean.valueOf(false)), 2);
    }

    public static int getValidRopeBlockSpace(class_1937 world, class_2338 stationPos) {
        class_2350 stationDirection = (class_2350)world.method_8320(stationPos).method_11654((class_2769)RopeWinchBlock.FACING);
        int ropeCount = 0;
        if (world.method_8320(stationPos).method_26204() != NeMuelchBlocks.ROPER) {
            return ropeCount;
        }
        class_2338 ropePos = stationPos.method_10079(stationDirection, 1).method_10074();
        while (RopeWinchBlockEntity.isValidRopeBlockPos(world, ropePos)) {
            ++ropeCount;
            ropePos = ropePos.method_10074();
        }
        return ropeCount;
    }

    public static boolean isValidRopeBlockPos(class_1937 world, class_2338 ropePos) {
        return world.method_8477(ropePos) && (world.method_8320(ropePos).method_26204() == class_2246.field_10124 || world.method_8320(ropePos).method_26204() == NeMuelchBlocks.ROPE);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.nemuelch.roper_station_gui_title");
    }

    private int getCurrentRopeLength(class_2338 pos) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return 0;
        }
        if (this.field_11863.method_8320(pos).method_26204() == NeMuelchBlocks.ROPER) {
            class_2350 stationDirection = (class_2350)this.field_11863.method_8320(pos).method_11654((class_2769)RopeWinchBlock.FACING);
            pos = pos.method_25503().method_10079(stationDirection, 1).method_10074();
        }
        int length = 0;
        while (this.field_11863.method_8320(pos).method_26204() == NeMuelchBlocks.ROPE) {
            ++length;
            pos = pos.method_10074();
        }
        return length;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new RopeWinchScreenHandler(syncId, inv, (class_1263)this, this.propertyDelegate, class_3914.method_17392((class_1937)this.method_10997(), (class_2338)this.method_11016()), this.storedRopes);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("roper_station.stored", this.storedRopes);
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        super.method_11014(nbt);
        this.storedRopes = nbt.method_10550("roper_station.stored");
    }
}

