/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.camera;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.camera.Displacement;
import net.shirojr.nemuelch.camera.Easing;
import net.shirojr.nemuelch.compat.cca.implementation.DisplacementSequenceRegistryComponent;
import org.jetbrains.annotations.Nullable;

public class DisplacementSequence {
    private final ArrayDeque<Entry> entries = new ArrayDeque();
    private int elapsed;

    public DisplacementSequence() {
        this(new ArrayList<Entry>());
    }

    public DisplacementSequence(List<Entry> entries) {
        this(entries, 0);
    }

    public DisplacementSequence(List<Entry> entries, int elapsed) {
        this.entries.addAll(entries);
        this.elapsed = elapsed;
    }

    public static DisplacementSequence fromRegistry(class_2960 identifier, class_269 scoreboard) {
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get(scoreboard);
        if (!component.getEntryKeys().contains(identifier)) {
            IllegalArgumentException e = new IllegalArgumentException("CCA component registry didn't contain key for : " + identifier.toString());
            NeMuelch.LOGGER.error("No such Camera Displacement Sequence key", (Throwable)e);
            throw e;
        }
        return component.getEntries().get(identifier).copy();
    }

    public void addEntry(Displacement displacement, int activeDuration, int holdDuration, Easing easing) {
        if (!this.entries.isEmpty()) {
            Entry lastEntry = this.entries.peekLast();
            this.entries.offer(new Entry(activeDuration, holdDuration, lastEntry, displacement, easing));
        } else {
            this.entries.offer(new Entry(activeDuration, holdDuration, displacement, easing));
        }
    }

    public List<Entry> getEntries() {
        return List.copyOf(this.entries);
    }

    @Nullable
    public Entry getActive() {
        return this.entries.peek();
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(int elapsed) {
        this.elapsed = Math.max(0, elapsed);
    }

    public int getDurationLeft() {
        int result = 0;
        for (Entry entry : this.entries) {
            result += entry.getFullDuration();
        }
        return Math.max(0, result -= this.getElapsed());
    }

    public boolean isActive() {
        return !this.entries.isEmpty();
    }

    public void clear() {
        this.entries.clear();
        this.setElapsed(0);
    }

    public DisplacementSequence copy() {
        return new DisplacementSequence(new ArrayList<Entry>(this.entries), this.elapsed);
    }

    public void tick() {
        if (this.getActive() == null) {
            if (this.getElapsed() > 0) {
                this.setElapsed(0);
            }
            return;
        }
        if (this.getElapsed() >= this.getActive().getFullDuration()) {
            this.entries.pollFirst();
            this.setElapsed(0);
        } else {
            this.setElapsed(this.getElapsed() + 1);
        }
    }

    public Displacement getInterpolatedDisplacement(float tickDelta) {
        Entry activeEntry = this.getActive();
        if (activeEntry == null) {
            return Displacement.DEFAULT;
        }
        float progress = ((float)this.getElapsed() + tickDelta) / (float)activeEntry.activeDuration;
        progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
        return activeEntry.easing.interpolate(progress, activeEntry.startDisplacement, activeEntry.endDisplacement);
    }

    public static void toNbt(class_2487 nbt, class_2960 key, DisplacementSequence sequence) {
        class_2487 sequenceNbt = new class_2487();
        class_2499 entriesNbt = new class_2499();
        for (Entry entry : sequence.entries) {
            class_2487 entryNbt = new class_2487();
            Entry.toNbt(entryNbt, entry);
            entriesNbt.add((Object)entryNbt);
        }
        sequenceNbt.method_10566("entries", (class_2520)entriesNbt);
        sequenceNbt.method_10569("elapsed", sequence.elapsed);
        nbt.method_10566(key.toString(), (class_2520)sequenceNbt);
    }

    public static DisplacementSequence fromNbt(class_2487 nbt, class_2960 key) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        class_2487 sequenceNbt = nbt.method_10562(key.toString());
        class_2499 entriesNbt = sequenceNbt.method_10554("entries", 10);
        for (class_2520 nbtElement : entriesNbt) {
            class_2487 entryNbt = (class_2487)nbtElement;
            entries.add(Entry.fromNbt(entryNbt));
        }
        int elapsed = sequenceNbt.method_10550("elapsed");
        return new DisplacementSequence(entries, elapsed);
    }

    public record Entry(int activeDuration, int holdEndFrameDuration, Displacement startDisplacement, Displacement endDisplacement, Easing easing) {
        public Entry(int activeDuration, int holdEndFrameDuration, Entry previous, Displacement targetDisplacement, Easing easing) {
            this(activeDuration, holdEndFrameDuration, previous.endDisplacement, targetDisplacement, easing);
        }

        public Entry(int activeDuration, int holdEndFrameDuration, Displacement endDisplacement, Easing easing) {
            this(activeDuration, holdEndFrameDuration, Displacement.DEFAULT, endDisplacement, easing);
        }

        public int getFullDuration() {
            return this.activeDuration + this.holdEndFrameDuration;
        }

        public static void toNbt(class_2487 nbt, Entry entry) {
            class_2487 entryNbt = new class_2487();
            entryNbt.method_10569("activeDuration", entry.activeDuration);
            entryNbt.method_10569("holdDuration", entry.holdEndFrameDuration);
            Displacement.toNbt(entryNbt, "start", entry.startDisplacement);
            Displacement.toNbt(entryNbt, "end", entry.endDisplacement);
            entryNbt.method_10569("easingIndex", entry.easing.ordinal());
            nbt.method_10566("displacementEntry", (class_2520)entryNbt);
        }

        public static Entry fromNbt(class_2487 nbt) {
            class_2487 entryNbt = nbt.method_10562("displacementEntry");
            int activeDuration = entryNbt.method_10550("activeDuration");
            int holdDuration = entryNbt.method_10550("activeDuration");
            Displacement startDisplacement = Displacement.fromNbt(entryNbt, "start");
            Displacement endDisplacement = Displacement.fromNbt(entryNbt, "end");
            Easing easing = Easing.values()[entryNbt.method_10550("easingIndex")];
            return new Entry(activeDuration, holdDuration, startDisplacement, endDisplacement, easing);
        }
    }
}

