/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.HashMap;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.shirojr.nemuelch.camera.Displacement;
import net.shirojr.nemuelch.camera.DisplacementSequence;
import net.shirojr.nemuelch.camera.Easing;
import net.shirojr.nemuelch.command.NeMuelchCommandUtil;
import net.shirojr.nemuelch.command.argument.EasingArgumentType;
import net.shirojr.nemuelch.compat.cca.implementation.DisplacementSequenceRegistryComponent;
import net.shirojr.nemuelch.network.util.NetworkIdentifiers;
import org.joml.Vector3f;

public class CameraShakeServerCommand
implements CommandRegistrationCallback {
    private static final SimpleCommandExceptionType DUPLICATE_ID = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Sequence with this Key already exists"));
    private static final SimpleCommandExceptionType MISSING_ID = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Sequence with this Key does not exist"));

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder subCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shake").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"startSequence").then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)((class_2168)context.getSource()).method_9211().method_3845());
            return class_2172.method_9270(component.getEntryKeys(), (SuggestionsBuilder)builder);
        }).executes(CameraShakeServerCommand::startDisplacementSequence)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stopSequence").executes(CameraShakeServerCommand::stopAllDisplacementSequences)).then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)((class_2168)context.getSource()).method_9211().method_3845());
            return class_2172.method_9270(component.getEntryKeys(), (SuggestionsBuilder)builder);
        }).executes(CameraShakeServerCommand::stopDisplacementSequence))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sequence").then(class_2170.method_9247((String)"register").then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).executes(CameraShakeServerCommand::registerSequence)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)((class_2168)context.getSource()).method_9211().method_3845());
            return class_2172.method_9270(component.getEntryKeys(), (SuggestionsBuilder)builder);
        }).executes(CameraShakeServerCommand::removeSequence))).then(class_2170.method_9247((String)"all").executes(CameraShakeServerCommand::removeAllSequences)))).then(class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)((class_2168)context.getSource()).method_9211().method_3845());
            return class_2172.method_9270(component.getEntryKeys(), (SuggestionsBuilder)builder);
        }).then(class_2170.method_9247((String)"addDisplacement").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"finalHoldDuration", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"easing", EasingArgumentType.easing()).then(class_2170.method_9244((String)"yaw", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"pitch", (ArgumentType)FloatArgumentType.floatArg()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"roll", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CameraShakeServerCommand.addSequence((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"posOffset", (ArgumentType)class_2277.method_9735((boolean)false)).executes(context -> CameraShakeServerCommand.addSequence((CommandContext<class_2168>)context, true)))))))))))));
        NeMuelchCommandUtil.getOrCreateNeMuelchNode(dispatcher).addChild((CommandNode)subCommand.build());
    }

    private static int registerSequence(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        class_2960 identifier = class_2232.method_9443(context, (String)"identifier");
        if (component.getEntryKeys().contains(identifier)) {
            throw DUPLICATE_ID.create();
        }
        component.modifyEntries(true, registry -> registry.put(identifier, new DisplacementSequence()));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Created new Displacement Sequence: " + identifier.toString())), true);
        return 1;
    }

    private static int removeSequence(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        class_2960 identifier = class_2232.method_9443(context, (String)"identifier");
        if (!component.getEntryKeys().contains(identifier)) {
            throw MISSING_ID.create();
        }
        component.modifyEntries(true, registry -> registry.remove(identifier));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed Displacement Sequence: " + identifier.toString())), true);
        return 1;
    }

    private static int removeAllSequences(CommandContext<class_2168> context) {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        component.modifyEntries(true, HashMap::clear);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Removed all Displacement Sequences"), true);
        return 1;
    }

    private static int addSequence(CommandContext<class_2168> context, boolean includePositionDisplacement) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        class_2960 identifier = class_2232.method_9443(context, (String)"identifier");
        if (!component.getEntryKeys().contains(identifier)) {
            throw MISSING_ID.create();
        }
        int duration = IntegerArgumentType.getInteger(context, (String)"duration");
        int finalHoldDuration = IntegerArgumentType.getInteger(context, (String)"finalHoldDuration");
        Easing easing = EasingArgumentType.getEasing(context, "easing");
        Vector3f rotations = new Vector3f(FloatArgumentType.getFloat(context, (String)"yaw"), FloatArgumentType.getFloat(context, (String)"pitch"), FloatArgumentType.getFloat(context, (String)"roll"));
        Displacement targetDisplacement = includePositionDisplacement ? new Displacement(class_2277.method_9736(context, (String)"posOffset"), rotations) : new Displacement(rotations);
        component.modifyEntries(true, registry -> {
            DisplacementSequence sequence = (DisplacementSequence)registry.get(identifier);
            sequence.addEntry(targetDisplacement, duration, finalHoldDuration, easing);
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Added Displacement to \"%s\" Sequence".formatted(identifier.toString())), true);
        return 1;
    }

    private static int startDisplacementSequence(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        class_2960 identifier = class_2232.method_9443(context, (String)"identifier");
        if (!component.getEntryKeys().contains(identifier)) {
            throw MISSING_ID.create();
        }
        Collection targets = class_2186.method_9312(context, (String)"targets");
        for (class_3222 target : targets) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(identifier);
            ServerPlayNetworking.send((class_3222)target, (class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_START_PACKET, (class_2540)buf);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Camera Displacement Sequence started for targets"), true);
        return 1;
    }

    private static int stopDisplacementSequence(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        DisplacementSequenceRegistryComponent component = DisplacementSequenceRegistryComponent.get((class_269)scoreboard);
        class_2960 identifier = class_2232.method_9443(context, (String)"identifier");
        if (!component.getEntryKeys().contains(identifier)) {
            throw MISSING_ID.create();
        }
        Collection targets = class_2186.method_9312(context, (String)"targets");
        for (class_3222 target : targets) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(identifier);
            ServerPlayNetworking.send((class_3222)target, (class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_STOP_PACKET, (class_2540)buf);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Camera Displacement Sequence stopped for targets"), true);
        return 1;
    }

    private static int stopAllDisplacementSequences(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        for (class_3222 target : targets) {
            ServerPlayNetworking.send((class_3222)target, (class_2960)NetworkIdentifiers.CAMERA_DISPLACEMENT_SEQUENCE_STOP_ALL_PACKET, (class_2540)PacketByteBufs.empty());
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"All Camera Displacement Sequences stopped for targets"), true);
        return 1;
    }
}

