/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.shirojr.nemuelch.command.NeMuelchCommandUtil;
import net.shirojr.nemuelch.compat.cca.component.RespawnLocationsComponent;
import net.shirojr.nemuelch.compat.cca.util.RespawnLocation;
import org.jetbrains.annotations.Nullable;

public class RespawnCommands
implements CommandRegistrationCallback {
    private static final SimpleCommandExceptionType LOCATION_NAME_NOT_USABLE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Invalid location name | Example: namespace:location_name"));
    private static final SimpleCommandExceptionType LOCATION_ALREADY_PRESENT = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Location already exists"));
    private static final SimpleCommandExceptionType LOCATION_NOT_PRESENT = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Location was not registered"));
    private static final SimpleCommandExceptionType INVALID_COMMAND_SOURCE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Command only executable by player entities"));

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder respawnCommandNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"respawn").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"location").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"identifier", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(RespawnCommands::addNewLocation)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(RespawnCommands::addNewLocationWithDimension)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").executes(RespawnCommands::clearLocations)).then(class_2170.method_9244((String)"identifier", (ArgumentType)StringArgumentType.string()).executes(RespawnCommands::removeLocation)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"print").executes(RespawnCommands::printLocations)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(RespawnCommands::printLocationsOfDimension))))).then(class_2170.method_9247((String)"entity").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"locationIdentifier", (ArgumentType)StringArgumentType.string()).suggests(RespawnCommands::suggestPossibleLocations).executes(RespawnCommands::assignLocationToPlayers)))).then(class_2170.method_9247((String)"print").executes(RespawnCommands::printAssignedLocationsOfPlayer))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"locationIdentifier", (ArgumentType)StringArgumentType.string()).suggests(RespawnCommands::suggestPossibleLocations).executes(RespawnCommands::removeLocationFromPlayers)))));
        NeMuelchCommandUtil.getOrCreateNeMuelchNode(dispatcher).addChild((CommandNode)respawnCommandNode.build());
    }

    private static CompletableFuture<Suggestions> suggestPossibleLocations(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining().toLowerCase();
        RespawnLocationsComponent respawnLocationsComponent = RespawnLocationsComponent.get((class_1937)((class_2168)context.getSource()).method_9225());
        for (class_2960 identifier : respawnLocationsComponent.getLocations().keySet()) {
            String entry = identifier.toString();
            if (!entry.contains(input)) continue;
            builder.suggest("\"%s\"".formatted(entry));
        }
        return builder.buildFuture();
    }

    private static int addNewLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 identifier = RespawnCommands.formatAsIdentifier(StringArgumentType.getString(context, (String)"identifier"));
        if (identifier == null) {
            throw LOCATION_NAME_NOT_USABLE.create();
        }
        class_2338 position = class_2262.method_48299(context, (String)"position");
        RespawnCommands.addNewLocation(((class_2168)context.getSource()).method_9225(), identifier, position, null);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Added %s as a respawn location at %s".formatted(identifier.toString(), position)), true);
        return 1;
    }

    private static int addNewLocationWithDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 identifier = RespawnCommands.formatAsIdentifier(StringArgumentType.getString(context, (String)"identifier"));
        if (identifier == null) {
            throw LOCATION_NAME_NOT_USABLE.create();
        }
        class_2338 position = class_2262.method_48299(context, (String)"position");
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        RespawnCommands.addNewLocation(((class_2168)context.getSource()).method_9225(), identifier, position, (class_5321<class_1937>)dimension.method_27983());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Added %s as a respawn location at %s in %s".formatted(identifier.toString(), position, dimension.method_27983())), true);
        return 1;
    }

    private static int clearLocations(CommandContext<class_2168> context) {
        RespawnCommands.removeLocations(((class_2168)context.getSource()).method_9225(), null);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all respawn locations and their assigned players"), true);
        return 1;
    }

    private static int removeLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 identifier = RespawnCommands.formatAsIdentifier(StringArgumentType.getString(context, (String)"identifier"));
        if (identifier == null) {
            throw LOCATION_NAME_NOT_USABLE.create();
        }
        if (!RespawnLocationsComponent.get((class_1937)((class_2168)context.getSource()).method_9225()).getLocations().containsKey(identifier)) {
            throw LOCATION_NOT_PRESENT.create();
        }
        RespawnCommands.removeLocations(((class_2168)context.getSource()).method_9225(), identifier);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Removed %s and its assigned players".formatted(identifier.toString())), true);
        return 1;
    }

    private static int printLocations(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw INVALID_COMMAND_SOURCE.create();
        }
        RespawnCommands.printLocations(((class_2168)context.getSource()).method_9225(), null, player);
        return 1;
    }

    private static int printLocationsOfDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw INVALID_COMMAND_SOURCE.create();
        }
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        RespawnCommands.printLocations(((class_2168)context.getSource()).method_9225(), (class_5321<class_1937>)dimension.method_27983(), player);
        return 1;
    }

    private static int assignLocationToPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targetList = class_2186.method_9312(context, (String)"targets");
        class_2960 identifier = RespawnCommands.formatAsIdentifier(StringArgumentType.getString(context, (String)"locationIdentifier"));
        if (identifier == null) {
            throw LOCATION_NAME_NOT_USABLE.create();
        }
        RespawnLocationsComponent respawnComponent = RespawnLocationsComponent.get((class_1937)((class_2168)context.getSource()).method_9225());
        if (!respawnComponent.getLocations().containsKey(identifier)) {
            throw LOCATION_NOT_PRESENT.create();
        }
        for (class_3222 serverPlayerEntity : targetList) {
            respawnComponent.assign(identifier, serverPlayerEntity.method_5667());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Assigned %s to ".formatted(identifier.toString())).method_10852(serverPlayerEntity.method_5476()), true);
        }
        return 1;
    }

    private static int removeLocationFromPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targetList = class_2186.method_9312(context, (String)"targets");
        class_2960 identifier = RespawnCommands.formatAsIdentifier(StringArgumentType.getString(context, (String)"locationIdentifier"));
        if (identifier == null) {
            throw LOCATION_NAME_NOT_USABLE.create();
        }
        RespawnLocationsComponent respawnComponent = RespawnLocationsComponent.get((class_1937)((class_2168)context.getSource()).method_9225());
        if (!respawnComponent.getLocations().containsKey(identifier)) {
            throw LOCATION_NOT_PRESENT.create();
        }
        for (class_3222 serverPlayerEntity : targetList) {
            respawnComponent.unassign(identifier, serverPlayerEntity.method_5667());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Removed %s from ".formatted(identifier.toString())).method_10852(serverPlayerEntity.method_5476()), true);
        }
        return 1;
    }

    private static int printAssignedLocationsOfPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            throw INVALID_COMMAND_SOURCE.create();
        }
        for (class_3222 target : class_2186.method_9312(context, (String)"targets")) {
            RespawnLocationsComponent respawnComponent = RespawnLocationsComponent.get((class_1937)((class_2168)context.getSource()).method_9225());
            player.method_43496((class_2561)class_2561.method_43470((String)"Possible Respawn Locations for ").method_10852(target.method_5476()).method_27693(":"));
            StringBuilder locationsStringBuilder = new StringBuilder();
            for (RespawnLocation respawnLocation : respawnComponent.getAssigned(target.method_5667())) {
                if (!locationsStringBuilder.isEmpty()) {
                    locationsStringBuilder.append(", ");
                }
                locationsStringBuilder.append(respawnLocation.identifier().toString());
            }
            player.method_43496((class_2561)class_2561.method_43470((String)locationsStringBuilder.toString()));
        }
        return 1;
    }

    private static class_2960 formatAsIdentifier(String name) {
        if (!((String)name).contains(":")) {
            name = "nemuelch:" + (String)name;
        }
        if (((String)(name = ((String)name).replaceAll("([A-Z])", "_$1").replaceAll("[./]", "_"))).charAt(0) == '_') {
            name = ((String)name).substring(1);
        }
        name = ((String)name).toLowerCase(Locale.ROOT);
        return class_2960.method_12829((String)name);
    }

    private static void addNewLocation(class_3218 world, class_2960 identifier, class_2338 position, @Nullable class_5321<class_1937> dimension) throws CommandSyntaxException {
        RespawnLocationsComponent respawnComponent = RespawnLocationsComponent.get((class_1937)world);
        if (respawnComponent.getLocations().containsKey(identifier)) {
            throw LOCATION_ALREADY_PRESENT.create();
        }
        if (dimension == null) {
            dimension = world.method_27983();
        }
        respawnComponent.add(new RespawnLocation(identifier, position, (class_5321<class_1937>)dimension));
    }

    private static void removeLocations(class_3218 world, @Nullable class_2960 identifier) {
        RespawnLocationsComponent respawnComponent = RespawnLocationsComponent.get((class_1937)world);
        if (identifier == null) {
            respawnComponent.remove(new RespawnLocation[0]);
            return;
        }
        respawnComponent.remove(List.of(identifier));
    }

    private static void printLocations(class_3218 world, @Nullable class_5321<class_1937> targetDimension, class_3222 target) {
        Map<class_2960, RespawnLocation> allLocations = RespawnLocationsComponent.get((class_1937)world).getLocations();
        ArrayList<RespawnLocation> filteredLocations = new ArrayList<RespawnLocation>();
        if (targetDimension == null) {
            filteredLocations.addAll(allLocations.values());
        } else {
            for (RespawnLocation entry : allLocations.values()) {
                if (!entry.dimension().equals(targetDimension)) continue;
                filteredLocations.add(entry);
            }
        }
        target.method_43496((class_2561)class_2561.method_43470((String)"Available Respawn Locations:"));
        for (RespawnLocation entry : filteredLocations) {
            class_5250 result = class_2561.method_43470((String)entry.identifier().toString());
            class_2338 pos = entry.position();
            result.method_27693(" | X:%s Y:%s Z:%s | %s".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260(), entry.dimension().method_29177().method_12832()));
            target.method_43496((class_2561)result);
        }
    }
}

