/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.shirojr.nemuelch.util.helper.SleepEventHelper;
import net.shirojr.nemuelch.world.PersistentWorldData;

public class SpecialSleepEventCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        CommandNode nemuelchNode = dispatcher.getRoot().getChild("nemuelch");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nemuelch").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9247((String)"world").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"persistentData").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(SpecialSleepEventCommand::runResetAll)).then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SpecialSleepEventCommand.runResetSpecific((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))))).then(class_2170.method_9247((String)"display").executes(SpecialSleepEventCommand::runListEntries)))));
    }

    private static int runResetAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PersistentWorldData persistentWorldData = PersistentWorldData.getServerState(server);
        persistentWorldData.usedSleepEventEntries.clear();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"feedback.nemuelch.world_data.reset"), true);
        return 1;
    }

    private static int runResetSpecific(CommandContext<class_2168> context, int commandInputId) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PersistentWorldData persistentWorldData = PersistentWorldData.getServerState(server);
        for (int i = 0; i < persistentWorldData.usedSleepEventEntries.size(); ++i) {
            SleepEventHelper.SleepEventDataEntry entry = persistentWorldData.usedSleepEventEntries.get(i);
            if (entry.sleepEventIndex() != commandInputId) continue;
            persistentWorldData.usedSleepEventEntries.remove(i);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"feedback.nemuelch.world_data.reset_specific", (Object[])new Object[]{commandInputId}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"feedback.nemuelch.world_data.reset_specific_error", (Object[])new Object[]{commandInputId}));
        return 0;
    }

    private static int runListEntries(CommandContext<class_2168> context) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PersistentWorldData persistentWorldData = PersistentWorldData.getServerState(server);
        for (SleepEventHelper.SleepEventDataEntry entry : persistentWorldData.usedSleepEventEntries) {
            class_5250 playerText = class_2561.method_43470((String)entry.playerName()).method_27694(style -> style.method_10977(class_124.field_1075));
            class_5250 entryInformation = playerText.method_10852((class_2561)class_2561.method_43470((String)(" activated entry Index: " + entry.sleepEventIndex())));
            ((class_2168)context.getSource()).method_9226(() -> SpecialSleepEventCommand.lambda$runListEntries$5((class_2561)entryInformation), true);
            ArrayList<class_2561> lines = SleepEventHelper.getEntry(entry.sleepEventIndex());
            for (class_2561 line : lines) {
                if (line.getString().isBlank()) continue;
                ((class_2168)context.getSource()).method_9226(() -> line, true);
            }
        }
        String leftOverEntries = !persistentWorldData.usedSleepEventEntries.isEmpty() ? String.format("%s entries have been used, and won't appear again.", persistentWorldData.usedSleepEventEntries.size()) : "No entries have been used in this world.";
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)leftOverEntries).method_27694(style -> style.method_10977(class_124.field_1060)), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$runListEntries$5(class_2561 entryInformation) {
        return entryInformation;
    }
}

