/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.component;

import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import org.jetbrains.annotations.Nullable;

public class BlightChunkTrackerComponent
implements Component {
    public static final class_2960 KEY = NeMuelch.getId("blight_chunk_tracker");
    private final class_269 scoreboard;
    @Nullable
    private final MinecraftServer server;
    private final HashSet<class_1923> blightedChunks;

    public BlightChunkTrackerComponent(class_269 scoreboard, @Nullable MinecraftServer server) {
        this.scoreboard = scoreboard;
        this.server = server;
        this.blightedChunks = new HashSet();
    }

    public class_269 getProvider() {
        return this.scoreboard;
    }

    public static BlightChunkTrackerComponent get(class_3218 world) {
        return (BlightChunkTrackerComponent)NeMuelchComponents.BLIGHT_CHUNK_TRACKER.get((Object)world.method_14170());
    }

    public Set<class_1923> getAllBlightedChunks() {
        return Collections.unmodifiableSet(this.blightedChunks);
    }

    public void addBlightedChunk(class_1923 chunk) {
        this.blightedChunks.add(chunk);
    }

    public void removeBlightedChunk(class_1923 chunk) {
        this.blightedChunks.remove(chunk);
    }

    public void clearBlightedChunks(class_3218 world) {
        HashSet<class_1923> entries = new HashSet<class_1923>(this.getAllBlightedChunks());
        for (class_1923 entry : entries) {
            class_2818 chunk = world.method_8497(entry.field_9181, entry.field_9180);
            Optional<BlightChunkComponent> blightChunkComponent = BlightChunkComponent.maybeGet((class_2791)chunk);
            if (blightChunkComponent.isEmpty()) continue;
            BlightChunkComponent component = blightChunkComponent.get();
            component.clear(true, true, true);
        }
        this.blightedChunks.clear();
    }

    public void readFromNbt(class_2487 tag) {
        this.blightedChunks.clear();
        if (tag.method_10545("TrackedBlightedChunks")) {
            for (class_2520 nbtElement : tag.method_10554("TrackedBlightedChunks", 4)) {
                this.blightedChunks.add(new class_1923(((class_2503)nbtElement).method_10699()));
            }
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 nbtList = new class_2499();
        for (class_1923 blightedChunk : this.blightedChunks) {
            nbtList.add((Object)class_2503.method_23251((long)blightedChunk.method_8324()));
        }
        tag.method_10566("TrackedBlightedChunks", (class_2520)nbtList);
    }
}

