/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.component;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_52;
import net.minecraft.class_5575;
import net.minecraft.class_8567;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.block.custom.RottenMeatBlock;
import net.shirojr.nemuelch.block.entity.custom.RottenMeatBlockEntity;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import net.shirojr.nemuelch.init.NemuelchGameRules;
import net.shirojr.nemuelch.util.logger.LoggerUtil;
import org.jetbrains.annotations.Nullable;

public class RottenMeatDigestionComponent
implements Component,
ServerTickingComponent,
AutoSyncedComponent {
    public static final class_2960 KEY = NeMuelch.getId("rotten_meat_digestion");
    public final RottenMeatBlockEntity provider;
    public final class_238 digestionArea;
    public static final int MAX_INTAKE_COOLDOWN = 80;
    public static final int MAX_DIGESTION_SIZE = 5;
    public static final String JUMP_START_NBT_KEY = "JumpStartCompleted";
    public static final String DIGESTION_STACKS_NBT_KEY = "DigestionStacks";
    public static final String DIGESTION_TICK_NBT_KEY = "DigestionTick";
    public static final String INTAKE_COOLDOWN_NBT_KEY = "IntakeCooldown";
    public static final String REWARD_SCORE_NBT_KEY = "RewardScore";
    public static final String LOOT_TABLE_FILE_BASE_NAME = "custom/rotten_meat_digestion";
    private boolean jumpStartComplete;
    private final class_2371<class_1799> digestionStacks;
    private int digestionTick;
    private int intakeCooldown;
    private float digestionRewardTier;

    public RottenMeatDigestionComponent(RottenMeatBlockEntity blockEntity) {
        this.provider = blockEntity;
        this.jumpStartComplete = false;
        this.digestionArea = class_238.method_19316((class_3341)new class_3341(this.getProvider().method_11016().method_10084()));
        this.digestionStacks = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        this.digestionTick = 0;
        this.intakeCooldown = 0;
        this.digestionRewardTier = 0.0f;
    }

    public static RottenMeatDigestionComponent get(RottenMeatBlockEntity blockEntity) {
        return (RottenMeatDigestionComponent)NeMuelchComponents.ROTTEN_MEAT_DIGESTION.get((Object)blockEntity);
    }

    public static Optional<RottenMeatDigestionComponent> get(class_1937 world, class_2338 pos) {
        return NeMuelchComponents.ROTTEN_MEAT_DIGESTION.maybeGet((Object)world.method_8321(pos));
    }

    public RottenMeatBlockEntity getProvider() {
        return this.provider;
    }

    public class_1937 getWorld() {
        return this.provider.method_10997();
    }

    public static boolean canDigest(class_1799 stack) {
        return ((Float)CompostingChanceRegistry.INSTANCE.get((class_1935)stack.method_7909())).floatValue() > 0.0f;
    }

    public int getNonEmptyDigestionStackSize() {
        int count = 0;
        for (class_1799 digestionStack : this.digestionStacks) {
            if (digestionStack.method_7960()) continue;
            ++count;
        }
        return count;
    }

    public boolean isDigestionFull() {
        for (class_1799 digestionStack : this.digestionStacks) {
            if (!digestionStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2371<class_1799> getDigestionStacks() {
        return this.digestionStacks;
    }

    public boolean addToDigestion(class_1799 newStack, boolean considerCooldown) {
        if (this.isIntakeCoolingDown() && considerCooldown) {
            return false;
        }
        if (this.isDigesting() || this.getDigestionRewardTier() > 0.0f) {
            return false;
        }
        boolean modified = false;
        class_1799 remainingStack = newStack.method_7972();
        for (class_1799 entry : this.digestionStacks) {
            int spaceAvailable;
            int transferAmount;
            if (entry.method_7960() || !class_1799.method_31577((class_1799)entry, (class_1799)remainingStack) || (transferAmount = Math.min(spaceAvailable = entry.method_7914() - entry.method_7947(), remainingStack.method_7947())) <= 0) continue;
            entry.method_7933(transferAmount);
            remainingStack.method_7934(transferAmount);
            modified = true;
            if (!remainingStack.method_7960()) continue;
            break;
        }
        if (!remainingStack.method_7960()) {
            for (int i = 0; i < this.digestionStacks.size(); ++i) {
                class_1799 entryStack = (class_1799)this.digestionStacks.get(i);
                if (!entryStack.method_7960()) continue;
                this.digestionStacks.set(i, (Object)remainingStack.method_7972());
                modified = true;
                break;
            }
        }
        if (modified) {
            this.setIntakeCooldown(80);
            class_1937 class_19372 = this.getWorld();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_8396(null, this.provider.method_11016(), NeMuelchSounds.EATING_CRUNCHY, class_3419.field_15245, 2.0f, 0.8f);
            }
            if (this.isDigestionFull()) {
                this.setDigestionTick(this.getMaxDigestionDuration(), true);
            }
            return true;
        }
        return false;
    }

    public class_1799 digestLatestStack() {
        class_1799 removedStack = null;
        for (int i = 0; i < this.digestionStacks.size(); ++i) {
            class_1799 stack = (class_1799)this.digestionStacks.get(i);
            if (stack.method_7960()) continue;
            removedStack = stack.method_7972();
            this.digestionStacks.set(i, (Object)class_1799.field_8037);
            break;
        }
        if (removedStack == null) {
            return class_1799.field_8037;
        }
        class_1937 class_19372 = this.getWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8396(null, this.provider.method_11016(), NeMuelchSounds.EATING_DIGESTION, class_3419.field_15245, 2.0f, 0.8f);
            RottenMeatBlock.spawnParticles(10, 1, this.provider.method_11016(), serverWorld);
        }
        this.sync();
        return removedStack;
    }

    public int getMaxDigestionDuration() {
        if (this.getWorld() == null || this.getWorld().method_8450() == null) {
            return 3000;
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return 100;
        }
        return this.getWorld().method_8450().method_8356(NemuelchGameRules.MEAT_BLOCK_DIGESTION_DURATION);
    }

    public int getDigestionTick() {
        return this.digestionTick;
    }

    public boolean isDigesting() {
        return this.digestionTick > 0;
    }

    public void setDigestionTick(int digesting, boolean shouldSync) {
        this.digestionTick = class_3532.method_15340((int)digesting, (int)0, (int)this.getMaxDigestionDuration());
        if (shouldSync) {
            this.sync();
        }
    }

    public int getIntakeCooldown() {
        return this.intakeCooldown;
    }

    public void setIntakeCooldown(int intakeCooldown) {
        this.intakeCooldown = Math.min(intakeCooldown, 80);
        if (this.intakeCooldown <= 0 || this.intakeCooldown == 80) {
            this.sync();
        }
    }

    public boolean isIntakeCoolingDown() {
        return this.getIntakeCooldown() > 0;
    }

    public float getDigestionRewardTier() {
        return this.digestionRewardTier;
    }

    public void setDigestionRewardTier(float digestionRewardTier) {
        this.digestionRewardTier = digestionRewardTier;
        this.sync();
    }

    public static Optional<class_1542> getFoodOnTop(class_1937 world, class_2338 pos, class_238 searchArea) {
        if (world.method_8320(pos.method_10084()).method_26234((class_1922)world, pos)) {
            return Optional.empty();
        }
        ArrayList resultList = new ArrayList();
        world.method_47575(class_5575.method_31795(class_1542.class), searchArea, itemEntity -> RottenMeatDigestionComponent.canDigest(itemEntity.method_6983()), resultList, 1);
        return resultList.isEmpty() ? Optional.empty() : Optional.of((class_1542)resultList.get(0));
    }

    public static int getDigestionRewardTier(class_1935 item) {
        float chance = ((Float)CompostingChanceRegistry.INSTANCE.get(item)).floatValue();
        if (chance >= 1.0f) {
            return 4;
        }
        if (chance >= 0.85f) {
            return 3;
        }
        if (chance >= 0.65f) {
            return 2;
        }
        if (chance >= 0.5f) {
            return 1;
        }
        return 0;
    }

    public static List<class_1799> getRewards(class_3218 serverWorld, float tier, RottenMeatBlockEntity blockEntity, @Nullable class_1309 entity) {
        int maxedTier = 20;
        float rewardQuality = class_3532.method_16439((float)(tier / (float)maxedTier), (float)0.0f, (float)3.0f);
        Object lootDataName = LOOT_TABLE_FILE_BASE_NAME;
        if (rewardQuality >= 2.0f) {
            lootDataName = (String)lootDataName + "_high";
        } else if (rewardQuality >= 1.0f) {
            lootDataName = (String)lootDataName + "_mid";
        } else if (rewardQuality >= 0.5f) {
            lootDataName = (String)lootDataName + "_low";
        } else {
            return List.of();
        }
        class_2960 identifier = NeMuelch.getId((String)lootDataName);
        class_52 lootTable = serverWorld.method_8503().method_3857().getLootTable(identifier);
        LoggerUtil.devLogger("Generating loot for: " + String.valueOf(identifier) + " [%s / %s]".formatted(Float.valueOf(tier), maxedTier));
        class_8567.class_8568 builder = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)blockEntity.method_11016().method_46558());
        if (entity != null) {
            builder = builder.method_51874(class_181.field_1226, (Object)entity);
        }
        return lootTable.method_51878(builder.method_51875(class_173.field_1179));
    }

    private boolean dropRewards(class_3218 serverWorld) {
        class_2338 dropPos = this.getProvider().method_11016().method_10084();
        List<class_1799> rewards = RottenMeatDigestionComponent.getRewards(serverWorld, this.getDigestionRewardTier(), this.getProvider(), null);
        for (class_1799 rewardStack : rewards) {
            class_1264.method_5449((class_1937)serverWorld, (double)dropPos.method_10263(), (double)dropPos.method_10264(), (double)dropPos.method_10260(), (class_1799)rewardStack.method_7972());
        }
        if (!rewards.isEmpty()) {
            serverWorld.method_8396(null, dropPos, class_3417.field_15197, class_3419.field_15245, 1.0f, 0.7f);
            return true;
        }
        serverWorld.method_8396(null, dropPos, class_3417.field_15139, class_3419.field_15245, 1.0f, 0.5f);
        return false;
    }

    private void resetDigestion() {
        this.setDigestionRewardTier(0.0f);
        this.setDigestionTick(0, true);
        if (this.getNonEmptyDigestionStackSize() > 0) {
            class_2371<class_1799> stacks = this.getDigestionStacks();
            for (int i = 0; i < stacks.size(); ++i) {
                class_1799 stack = (class_1799)stacks.get(i);
                if (stack.method_7960()) continue;
                stacks.set(i, (Object)class_1799.field_8037);
            }
        }
        this.getWorld().method_8652(this.getProvider().method_11016(), (class_2680)this.getProvider().method_11010().method_11657((class_2769)RottenMeatBlock.STAGE, (Comparable)Integer.valueOf(0)), 2);
    }

    public boolean finishProcessAndReset(class_3218 serverWorld) {
        if (this.dropRewards(serverWorld)) {
            serverWorld.method_8396(null, this.provider.method_11016(), NeMuelchSounds.SQUIRT, class_3419.field_15245, 1.0f, 0.5f);
            this.resetDigestion();
            return true;
        }
        return false;
    }

    private void updateBlockState() {
        class_2680 currentState = this.getProvider().method_11010();
        if (!currentState.method_28498((class_2769)RottenMeatBlock.STAGE)) {
            return;
        }
        int currentStage = (Integer)currentState.method_11654((class_2769)RottenMeatBlock.STAGE);
        float progress = 1.0f - (float)this.getDigestionTick() / (float)this.getMaxDigestionDuration();
        float stageFloat = 1.0f + (progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f)) * 3.0f;
        int targetStage = Math.min(class_3532.method_15375((float)stageFloat), 4);
        if (targetStage != currentStage) {
            class_2680 newState = (class_2680)currentState.method_11657((class_2769)RottenMeatBlock.STAGE, (Comparable)Integer.valueOf(targetStage));
            this.getWorld().method_8652(this.getProvider().method_11016(), newState, 2);
        }
    }

    public void serverTick() {
        class_1937 class_19372;
        class_1542 itemEntity;
        if (!this.jumpStartComplete && !this.getProvider().getJumpStartStack().method_7960() && this.addToDigestion(this.provider.clearJumpStartStack(), false)) {
            this.getProvider().clearJumpStartStack();
            this.jumpStartComplete = true;
        }
        Supplier cachedFoodOnTop = Suppliers.memoize(() -> RottenMeatDigestionComponent.getFoodOnTop(this.getWorld(), this.provider.method_11016(), this.digestionArea));
        if (this.isIntakeCoolingDown()) {
            this.setIntakeCooldown(this.getIntakeCooldown() - 1);
        } else if (!this.isDigestionFull() && ((Optional)cachedFoodOnTop.get()).isPresent() && this.addToDigestion((itemEntity = (class_1542)((Optional)cachedFoodOnTop.get()).get()).method_6983(), true) && (class_19372 = this.getWorld()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float pitch = class_3532.method_16439((float)serverWorld.method_8409().method_43057(), (float)0.7f, (float)0.9f);
            serverWorld.method_8396(null, this.provider.method_11016(), class_3417.field_20614, class_3419.field_15245, 1.0f, pitch);
            RottenMeatBlock.spawnParticles(10, 1, this.provider.method_11016(), serverWorld);
            itemEntity.method_31472();
        }
        if (this.isDigesting()) {
            float digestionStackProgress;
            float digestionTimeProgress = (float)this.getDigestionTick() / (float)this.getMaxDigestionDuration();
            if (digestionTimeProgress < (digestionStackProgress = (float)this.getNonEmptyDigestionStackSize() / 5.0f)) {
                class_1799 digestedStack = this.digestLatestStack();
                int rewardTier = RottenMeatDigestionComponent.getDigestionRewardTier((class_1935)digestedStack.method_7909());
                float normalizedStackSize = (float)digestedStack.method_7947() / (float)digestedStack.method_7914();
                this.setDigestionRewardTier(this.getDigestionRewardTier() + (float)rewardTier * normalizedStackSize);
            }
            this.setDigestionTick(this.getDigestionTick() - 1, false);
            this.updateBlockState();
            if (!this.isDigesting()) {
                this.sync();
            }
        }
    }

    public void readFromNbt(class_2487 nbt) {
        boolean jumpStartCompleted;
        if (nbt.method_10545(JUMP_START_NBT_KEY) && (jumpStartCompleted = nbt.method_10577(JUMP_START_NBT_KEY))) {
            this.jumpStartComplete = true;
        }
        if (nbt.method_10545(DIGESTION_STACKS_NBT_KEY)) {
            class_1262.method_5429((class_2487)nbt.method_10562(DIGESTION_STACKS_NBT_KEY), this.digestionStacks);
        }
        if (nbt.method_10545(DIGESTION_TICK_NBT_KEY)) {
            this.setDigestionTick(nbt.method_10550(DIGESTION_TICK_NBT_KEY), false);
        }
        if (nbt.method_10545(INTAKE_COOLDOWN_NBT_KEY)) {
            this.setIntakeCooldown(nbt.method_10550(INTAKE_COOLDOWN_NBT_KEY));
        }
        if (nbt.method_10545(REWARD_SCORE_NBT_KEY)) {
            this.digestionRewardTier = nbt.method_10583(REWARD_SCORE_NBT_KEY);
        }
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 stacksNbt = new class_2487();
        nbt.method_10556(JUMP_START_NBT_KEY, this.jumpStartComplete);
        class_1262.method_5426((class_2487)stacksNbt, this.digestionStacks);
        nbt.method_10566(DIGESTION_STACKS_NBT_KEY, (class_2520)stacksNbt);
        nbt.method_10569(DIGESTION_TICK_NBT_KEY, this.getDigestionTick());
        nbt.method_10569(INTAKE_COOLDOWN_NBT_KEY, this.getIntakeCooldown());
        nbt.method_10548(REWARD_SCORE_NBT_KEY, this.digestionRewardTier);
    }

    public void sync() {
        this.getProvider().method_5431();
        NeMuelchComponents.ROTTEN_MEAT_DIGESTION.sync((Object)this.getProvider());
    }
}

