/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.implementation;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkComponent;
import net.shirojr.nemuelch.compat.cca.component.BlightChunkTrackerComponent;
import net.shirojr.nemuelch.compat.cca.util.BlightChunkSpreader;
import net.shirojr.nemuelch.compat.cca.util.BlightType;
import net.shirojr.nemuelch.init.NemuelchGameRules;

public class BlightChunkComponentImpl
implements BlightChunkComponent {
    private final class_2791 provider;
    private final HashMap<class_2338, EnumSet<BlightType>> blightedPositions;
    private final EnumMap<BlightType, Integer> blightAmount;
    private final EnumSet<BlightType> completeBlights;
    private double completeBlightThreshold;
    private long tick;
    private long timeOfFirstBlight;
    private final BlightChunkSpreader spreader;

    public BlightChunkComponentImpl(class_2791 chunk) {
        this.provider = chunk;
        this.blightedPositions = new HashMap();
        this.blightAmount = new EnumMap(BlightType.class);
        for (BlightType cachedValue : BlightType.CACHED_VALUES) {
            this.blightAmount.put(cachedValue, 0);
        }
        this.completeBlights = EnumSet.noneOf(BlightType.class);
        this.completeBlightThreshold = BlightChunkComponent.getNormalizedPortionOfChunk(this.provider, 256);
        this.tick = Long.MIN_VALUE;
        this.timeOfFirstBlight = -1L;
        this.spreader = new BlightChunkSpreader(this);
    }

    @Override
    public class_2791 getProvider() {
        return this.provider;
    }

    @Override
    public double getCompleteBlightThreshold() {
        return this.completeBlightThreshold;
    }

    @Override
    public void setCompleteBlightThreshold(double normalizedValue) {
        this.completeBlightThreshold = class_3532.method_15350((double)normalizedValue, (double)0.0, (double)1.0);
        this.markDirty();
    }

    @Override
    public long getTimeOfFirstInitializedBlight() {
        return this.timeOfFirstBlight;
    }

    @Override
    public long getTick() {
        return this.tick;
    }

    @Override
    public void setTick(long tick) {
        this.tick = tick;
    }

    @Override
    public void stopTicking() {
        this.setTick(-1L);
    }

    public void initializeTickRandomness() {
        class_2818 worldChunk;
        class_2791 class_27912;
        if (this.tick != Long.MIN_VALUE || !((class_27912 = this.provider) instanceof class_2818) || (worldChunk = (class_2818)class_27912).method_12200() == null) {
            return;
        }
        this.setTick(Math.abs((worldChunk.method_12004().field_9181 * 31 + worldChunk.method_12004().field_9180) % 20));
    }

    @Override
    public EnumSet<BlightType> getBlightsOfPos(class_2338 pos) {
        EnumSet<BlightType> blights = EnumSet.noneOf(BlightType.class);
        blights.addAll(this.completeBlights);
        if (blights.size() == BlightType.CACHED_VALUES.length) {
            return blights;
        }
        EnumSet<BlightType> blightTypesOfPos = this.blightedPositions.get(pos);
        if (blightTypesOfPos == null) {
            return blights;
        }
        blights.addAll(blightTypesOfPos);
        return blights;
    }

    @Override
    public HashSet<class_2338> getPosWithBlights(BlightType ... types) {
        EnumSet<BlightType> targetTypes = BlightType.typesToEnumSet(types);
        HashSet<class_2338> result = new HashSet<class_2338>();
        if (types.length == 0) {
            result.addAll(this.blightedPositions.keySet());
            return result;
        }
        for (Map.Entry<class_2338, EnumSet<BlightType>> entry : this.blightedPositions.entrySet()) {
            if (Collections.disjoint((Collection)entry.getValue(), targetTypes)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public boolean addBlightsToPos(class_2338 pos, Set<BlightType> types) {
        class_2791 class_27912;
        if (types.isEmpty()) {
            return false;
        }
        pos = pos.method_10062();
        class_2680 state = this.provider.method_8320(pos);
        class_3218 serverWorld = this.getServerWorld();
        boolean initiallyBlight = this.isBlighted(pos, new BlightType[0]);
        boolean blightedAnything = false;
        AbstractCollection set = null;
        for (BlightType type : types) {
            if (this.completeBlights.contains((Object)type) || !type.getActions().get().canBlight(serverWorld, pos, state, types)) continue;
            if (set == null) {
                set = this.blightedPositions.computeIfAbsent(pos, entryPos -> EnumSet.noneOf(BlightType.class));
            }
            if (!set.add(type)) continue;
            Integer currentAmount = this.blightAmount.get((Object)type);
            boolean resultsInFullChunk = false;
            if (currentAmount != null && currentAmount >= 0) {
                this.blightAmount.put(type, currentAmount + 1);
            } else {
                this.getBlightPosCount(type);
            }
            if (BlightChunkComponent.getNormalizedPortionOfChunk(this.provider, this.getBlightPosCount(type)) >= this.getCompleteBlightThreshold()) {
                this.clearAndConvertToCompleteBlight(type);
                resultsInFullChunk = true;
            }
            if (serverWorld == null) continue;
            type.getActions().get().onApplied(serverWorld, resultsInFullChunk ? null : pos, null);
            blightedAnything = true;
        }
        if (set != null && set.isEmpty()) {
            this.blightedPositions.remove(pos);
        }
        if (!initiallyBlight && this.isBlighted(pos, new BlightType[0]) && (class_27912 = this.provider) instanceof class_2818) {
            class_2818 worldChunk = (class_2818)class_27912;
            this.timeOfFirstBlight = worldChunk.method_12200().method_8510();
        }
        this.markDirty();
        return blightedAnything;
    }

    @Override
    public void clearAndConvertToCompleteBlight(BlightType type) {
        this.completeBlights.add(type);
        this.blightedPositions.entrySet().removeIf(entry -> {
            ((EnumSet)entry.getValue()).remove((Object)type);
            return ((EnumSet)entry.getValue()).isEmpty();
        });
        this.markDirty();
    }

    @Override
    public int getBlightPosCount(BlightType type) {
        if (this.completeBlights.contains((Object)type)) {
            return -1;
        }
        Integer amount = this.blightAmount.get((Object)type);
        if (amount == null) {
            return -1;
        }
        if (amount >= 0) {
            return amount;
        }
        int count = 0;
        for (EnumSet<BlightType> entry : this.blightedPositions.values()) {
            if (!entry.contains((Object)type)) continue;
            ++count;
        }
        this.blightAmount.put(type, count);
        return count;
    }

    public void decrementBlightPosCount(BlightType type) {
        Integer amount = this.blightAmount.get((Object)type);
        if (amount == null || amount <= 0) {
            this.blightAmount.put(type, -1);
        } else {
            this.blightAmount.put(type, amount - 1);
        }
    }

    @Override
    public boolean isChunkCompletelyBlighted(BlightType ... types) {
        if (types.length == 0) {
            for (BlightType cachedValue : BlightType.CACHED_VALUES) {
                if (this.completeBlights.contains((Object)cachedValue)) continue;
                return false;
            }
        } else {
            for (BlightType type : types) {
                if (this.completeBlights.contains((Object)type)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(BlightType ... types) {
        for (BlightType type : types) {
            if (this.completeBlights.contains((Object)type) || this.getBlightPosCount(type) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public EnumSet<BlightType> getCompleteChunkBlights() {
        return this.completeBlights;
    }

    @Override
    public void clear(boolean blightPositions, boolean completeChunkBlights, boolean markDirty) {
        class_3218 serverWorld = this.getServerWorld();
        if (blightPositions) {
            if (serverWorld != null) {
                for (Map.Entry entry : this.blightedPositions.entrySet()) {
                    ((EnumSet)entry.getValue()).forEach(type -> type.getActions().get().onRemoved(serverWorld, (class_2338)entry.getKey(), this.getTimeOfFirstInitializedBlight(), null));
                }
            }
            this.blightedPositions.clear();
            for (BlightType blightType : BlightType.CACHED_VALUES) {
                if (this.completeBlights.contains((Object)blightType)) continue;
                this.blightAmount.put(blightType, -1);
            }
        }
        if (completeChunkBlights) {
            if (serverWorld != null) {
                for (BlightType blightType : this.completeBlights) {
                    blightType.getActions().get().onRemoved(serverWorld, null, this.getTimeOfFirstInitializedBlight(), null);
                }
            }
            this.completeBlights.clear();
            for (BlightType blightType : BlightType.CACHED_VALUES) {
                this.blightAmount.put(blightType, -1);
            }
        }
        if (this.blightedPositions.isEmpty() && this.completeBlights.isEmpty()) {
            this.timeOfFirstBlight = -1L;
        }
        if (markDirty) {
            this.markDirty();
        }
    }

    @Override
    public void clear(BlightType ... types) {
        class_3218 serverWorld = this.getServerWorld();
        for (BlightType type : types.length == 0 ? BlightType.CACHED_VALUES : types) {
            this.blightedPositions.entrySet().removeIf(entry -> {
                boolean shouldBeRemoved = ((EnumSet)entry.getValue()).contains((Object)type);
                if (!shouldBeRemoved) {
                    return false;
                }
                if (serverWorld != null) {
                    ((EnumSet)entry.getValue()).forEach(entryType -> entryType.getActions().get().onRemoved(serverWorld, (class_2338)entry.getKey(), this.getTimeOfFirstInitializedBlight(), null));
                }
                return true;
            });
            boolean removeCompleteBlight = this.completeBlights.remove((Object)type);
            if (removeCompleteBlight && serverWorld != null) {
                type.getActions().get().onRemoved(serverWorld, null, this.getTimeOfFirstInitializedBlight(), null);
            }
            this.blightAmount.put(type, -1);
        }
        if (this.blightedPositions.isEmpty() && this.completeBlights.isEmpty()) {
            this.timeOfFirstBlight = -1L;
        }
        this.markDirty();
    }

    @Override
    public void clearPos(class_2338 pos, Set<BlightType> types) {
        class_3218 serverWorld = this.getServerWorld();
        EnumSet<BlightType> posBlights = this.blightedPositions.get(pos);
        if (posBlights == null) {
            return;
        }
        if (types.isEmpty()) {
            this.blightedPositions.remove(pos);
            for (BlightType removedBlight : posBlights) {
                if (this.completeBlights.contains((Object)removedBlight)) continue;
                if (serverWorld != null) {
                    removedBlight.getActions().get().onRemoved(serverWorld, pos, this.getTimeOfFirstInitializedBlight(), null);
                }
                this.decrementBlightPosCount(removedBlight);
            }
        } else {
            boolean anyRemoved = false;
            for (BlightType type : types) {
                if (this.completeBlights.contains((Object)type) || !posBlights.remove((Object)type)) continue;
                anyRemoved = true;
                if (serverWorld != null) {
                    type.getActions().get().onRemoved(serverWorld, pos, this.getTimeOfFirstInitializedBlight(), null);
                }
                this.decrementBlightPosCount(type);
            }
            if (anyRemoved && posBlights.isEmpty()) {
                this.blightedPositions.remove(pos);
            }
        }
        if (this.blightedPositions.isEmpty() && this.completeBlights.isEmpty()) {
            this.timeOfFirstBlight = -1L;
        }
        this.markDirty();
    }

    @Override
    public boolean isEmpty() {
        return this.blightedPositions.isEmpty() && this.completeBlights.isEmpty();
    }

    public void serverTick() {
        if (this.getTick() == -1L) {
            return;
        }
        class_3218 world = this.getServerWorld();
        if (world == null) {
            return;
        }
        if (!world.method_8450().method_8355(NemuelchGameRules.BLIGHT_SPREADING)) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (!this.contains(BlightType.SPREADING)) {
            return;
        }
        this.initializeTickRandomness();
        world.method_16107().method_15396("nemuelch_blight_server_tick");
        ++this.tick;
        if (this.tick % (long)world.method_8450().method_8356(NemuelchGameRules.BLIGHT_TICK_SPEED) != 0L) {
            return;
        }
        if (this.getCompleteChunkBlights().contains((Object)BlightType.SPREADING) && world.method_8450().method_8355(NemuelchGameRules.BLIGHT_SPREADING_CHUNKS)) {
            world.method_16107().method_15396("nemuelch_blight_server_tick_spread_full_chunk");
            this.spreader.spreadFromCompleteChunk(world);
            world.method_16107().method_15407();
        } else {
            world.method_16107().method_15396("nemuelch_blight_server_tick_spread_partial_chunk");
            this.spreader.spreadFromPartialChunk(world);
            world.method_16107().method_15407();
        }
        world.method_16107().method_15407();
    }

    public void readFromNbt(class_2487 tag) {
        boolean containsCompleteChunkBlight = tag.method_10545("CompleteChunkBlights");
        boolean containsChunkBlight = tag.method_10545("ChunkBlights");
        this.clear(containsChunkBlight, containsCompleteChunkBlight, false);
        if (containsCompleteChunkBlight) {
            for (class_2520 entryNbt : tag.method_10554("CompleteChunkBlights", 8)) {
                this.completeBlights.add(BlightType.fromString(entryNbt.method_10714()));
            }
        }
        if (containsChunkBlight) {
            class_2499 nbtList = tag.method_10554("ChunkBlights", 10);
            for (class_2520 listEntry : nbtList) {
                class_2487 entryNbt = (class_2487)listEntry;
                class_2338 entryPos = class_2338.method_10092((long)entryNbt.method_10537("BlockPos"));
                EnumSet<BlightType> blightTypes = EnumSet.noneOf(BlightType.class);
                class_2499 entryBlightNbtList = entryNbt.method_10554("BlightTypes", 8);
                for (class_2520 entry : entryBlightNbtList) {
                    blightTypes.add(BlightType.fromString(entry.method_10714()));
                }
                this.blightedPositions.compute(entryPos, (key, value) -> {
                    if (value == null) {
                        value = EnumSet.noneOf(BlightType.class);
                    }
                    value.addAll(blightTypes);
                    return value;
                });
            }
        }
        if (tag.method_10545("Threshold")) {
            this.completeBlightThreshold = tag.method_10574("Threshold");
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 completeBlightsNbtList = new class_2499();
        for (BlightType completeBlight : this.completeBlights) {
            completeBlightsNbtList.add((Object)class_2519.method_23256((String)completeBlight.method_15434()));
        }
        tag.method_10566("CompleteChunkBlights", (class_2520)completeBlightsNbtList);
        class_2499 blightsNbtList = new class_2499();
        for (Map.Entry<class_2338, EnumSet<BlightType>> entry : this.blightedPositions.entrySet()) {
            class_2487 entryNbt = new class_2487();
            entryNbt.method_10544("BlockPos", entry.getKey().method_10063());
            class_2499 blightTypesNbtList = new class_2499();
            for (BlightType blightType : entry.getValue()) {
                blightTypesNbtList.add((Object)class_2519.method_23256((String)blightType.method_15434()));
            }
            entryNbt.method_10566("BlightTypes", (class_2520)blightTypesNbtList);
            blightsNbtList.add((Object)entryNbt);
        }
        tag.method_10566("ChunkBlights", (class_2520)blightsNbtList);
        tag.method_10549("Threshold", this.completeBlightThreshold);
    }

    public boolean shouldSyncWith(class_3222 player) {
        return PlayerLookup.tracking((class_3218)player.method_51469(), (class_1923)this.provider.method_12004()).contains(player);
    }

    @Override
    public void markDirty() {
        class_3218 serverWorld = this.getServerWorld();
        if (serverWorld == null) {
            return;
        }
        this.sync();
        this.provider.method_12008(true);
        if (this.isEmpty()) {
            BlightChunkTrackerComponent.get(serverWorld).removeBlightedChunk(this.provider.method_12004());
        } else {
            BlightChunkTrackerComponent.get(serverWorld).addBlightedChunk(this.provider.method_12004());
        }
    }
}

