/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.implementation;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.camera.DisplacementSequence;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import org.jetbrains.annotations.NotNull;

public class DisplacementSequenceRegistryComponent
implements Component,
AutoSyncedComponent {
    public static final class_2960 KEY = NeMuelch.getId("displacement_sequence_registry");
    private final HashMap<class_2960, DisplacementSequence> entries;
    private final class_269 scoreboard;

    public DisplacementSequenceRegistryComponent(class_269 scoreboard) {
        this.scoreboard = scoreboard;
        this.entries = new HashMap();
    }

    public static DisplacementSequenceRegistryComponent get(class_269 scoreboard) {
        return (DisplacementSequenceRegistryComponent)NeMuelchComponents.DISPLACEMENT_SEQUENCES.get((Object)scoreboard);
    }

    public List<class_2960> getEntryKeys() {
        ArrayList<class_2960> keys = new ArrayList<class_2960>(this.entries.keySet());
        Collections.sort(keys);
        return Collections.unmodifiableList(keys);
    }

    public Map<class_2960, DisplacementSequence> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public void modifyEntries(boolean sync, Consumer<HashMap<class_2960, DisplacementSequence>> entries) {
        entries.accept(this.entries);
        if (sync) {
            this.sync();
        }
    }

    public void readFromNbt(class_2487 tag) {
        class_2487 entriesNbt = tag.method_10562("entries");
        this.entries.clear();
        for (String key : entriesNbt.method_10541()) {
            class_2487 entryNbt = (class_2487)entriesNbt.method_10580(key);
            class_2960 identifier = class_2960.method_12829((String)key);
            if (entryNbt == null || identifier == null) {
                String warning = "DisplacementSequence \"%s\" not readable. Skipping Entry".formatted(key);
                NeMuelch.LOGGER.warn(warning);
                continue;
            }
            this.entries.put(identifier, DisplacementSequence.fromNbt(entryNbt, identifier));
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2487 entriesNbt = new class_2487();
        for (Map.Entry<class_2960, DisplacementSequence> entry : this.entries.entrySet()) {
            class_2487 entryNbt = new class_2487();
            DisplacementSequence.toNbt(entryNbt, entry.getKey(), entry.getValue());
            entriesNbt.method_10566(entry.getKey().toString(), (class_2520)entryNbt);
        }
        tag.method_10566("entries", (class_2520)entriesNbt);
    }

    public void sync() {
        NeMuelchComponents.DISPLACEMENT_SEQUENCES.sync((Object)this.scoreboard);
    }
}

