/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.implementation;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.shirojr.nemuelch.compat.cca.NeMuelchComponents;
import net.shirojr.nemuelch.compat.cca.component.RespawnLocationsComponent;
import net.shirojr.nemuelch.compat.cca.util.RespawnLocation;
import org.jetbrains.annotations.Nullable;

public class RespawnLocationsComponentImpl
implements RespawnLocationsComponent,
AutoSyncedComponent {
    private final class_269 provider;
    @Nullable
    private final MinecraftServer server;
    private final HashMap<class_2960, RespawnLocation> locations;
    @Nullable
    private class_2960 lastLocation;

    public RespawnLocationsComponentImpl(class_269 provider, @Nullable MinecraftServer server) {
        this.provider = provider;
        this.server = server;
        this.locations = new HashMap();
        this.lastLocation = null;
    }

    @Override
    public Map<class_2960, RespawnLocation> getLocations() {
        return Collections.unmodifiableMap(this.locations);
    }

    @Override
    @Nullable
    public class_2960 getLastLocation() {
        return this.lastLocation;
    }

    @Override
    public void setLastLocation(@Nullable class_2960 lastLocation) {
        this.lastLocation = lastLocation;
    }

    @Override
    public void remove(List<class_2960> locations) {
        for (class_2960 location : locations) {
            this.locations.remove(location);
        }
        this.sync();
    }

    @Override
    public void add(boolean shouldSync, RespawnLocation ... locations) {
        for (RespawnLocation location : locations) {
            this.locations.put(location.identifier(), location);
        }
        if (shouldSync) {
            this.sync();
        }
    }

    @Override
    public void assign(RespawnLocation location, UUID target) {
        this.locations.computeIfAbsent(location.identifier(), identifier -> location).assignedEntities().add(target);
        this.sync();
    }

    @Override
    public void unassign(RespawnLocation location, UUID target) {
        RespawnLocation respawnLocation = this.locations.get(location.identifier());
        if (respawnLocation == null) {
            return;
        }
        respawnLocation.assignedEntities().remove(target);
        this.sync();
    }

    public void readFromNbt(class_2487 nbt) {
        if (nbt.method_10545("locations")) {
            this.locations.clear();
            class_2499 locationsNbtList = nbt.method_10554("locations", 10);
            for (class_2520 nbtElement : locationsNbtList) {
                class_2487 locationNbt = (class_2487)nbtElement;
                RespawnLocation respawnLocation = RespawnLocation.fromNbt(locationNbt);
                if (respawnLocation == null) continue;
                this.add(respawnLocation);
            }
        }
    }

    public void writeToNbt(class_2487 nbt) {
        class_2499 locationsNbtList = new class_2499();
        for (RespawnLocation entry : this.locations.values()) {
            class_2487 locationNbt = new class_2487();
            entry.toNbt(locationNbt);
            locationsNbtList.add((Object)locationNbt);
        }
        nbt.method_10566("locations", (class_2520)locationsNbtList);
    }

    @Override
    public void sync() {
        NeMuelchComponents.RESPAWN_LOCATIONS.sync((Object)this.provider);
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player.method_5687(2);
    }
}

