/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.cca.util;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_7485;
import net.shirojr.nemuelch.compat.cca.util.BlightAction;
import net.shirojr.nemuelch.compat.cca.util.BlightIngredients;
import org.jetbrains.annotations.Nullable;

public enum BlightType implements class_3542
{
    WITHERING(class_1294.field_5920, new BlightIngredients(class_1294.field_5920), 7561558, () -> new BlightAction(){

        @Override
        public void onBlockBroken(class_3218 world, long blightAge, class_2338 pos, class_1657 player) {
            BlightAction.super.onBlockBroken(world, blightAge, pos, player);
        }

        @Override
        public void onPickedUp(class_1309 entity, class_1542 stack, BlightType type) {
            BlightAction.super.onPickedUp(entity, stack, type);
            if (!(entity.method_37908() instanceof class_3218)) {
                return;
            }
        }
    }),
    POISONOUS(class_1294.field_5899, new BlightIngredients(class_1294.field_5899, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8635})), 8889187, () -> new BlightAction(){

        @Override
        public void onBlockBroken(class_3218 world, long blightAge, @Nullable class_2338 pos, class_1657 player) {
            BlightAction.super.onBlockBroken(world, blightAge, pos, player);
        }
    }),
    CORRUPTED(null, new BlightIngredients(), 0, () -> new BlightAction(){

        @Override
        public void onBlockBroken(class_3218 world, long blightAge, @Nullable class_2338 pos, class_1657 player) {
            BlightAction.super.onBlockBroken(world, blightAge, pos, player);
        }
    }),
    AIRBORNE(null, new BlightIngredients(class_1294.field_5902, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8153})), 0xCEFFFF, () -> new BlightAction(){

        @Override
        public void onBlockBroken(class_3218 world, long blightAge, @Nullable class_2338 pos, class_1657 player) {
            BlightAction.super.onBlockBroken(world, blightAge, pos, player);
        }
    }),
    SPREADING(null, new BlightIngredients(), 16262179, () -> new BlightAction(){

        @Override
        public void onBlockBroken(class_3218 world, long blightAge, @Nullable class_2338 pos, class_1657 player) {
            BlightAction.super.onBlockBroken(world, blightAge, pos, player);
        }
    });

    public static final class_3542.class_7292<BlightType> CODEC;
    public static final BlightType[] CACHED_VALUES;
    private static final Map<String, BlightType> BY_NAME;
    @Nullable
    private final class_1291 effect;
    private final BlightIngredients ingredients;
    private final int debugColor;
    private final Supplier<BlightAction> actions;

    private BlightType(class_1291 effect, BlightIngredients ingredients, int debugColor, Supplier<BlightAction> actions) {
        this.effect = effect;
        this.ingredients = ingredients;
        this.debugColor = debugColor;
        this.actions = actions;
    }

    @Nullable
    public class_1291 getEffect() {
        return this.effect;
    }

    public BlightIngredients getIngredients() {
        return this.ingredients;
    }

    public int getDebugColor() {
        return this.debugColor;
    }

    public Supplier<BlightAction> getActions() {
        return this.actions;
    }

    public static void applyToStack(class_1799 stack, Set<BlightType> types) {
        if (types.isEmpty()) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return;
            }
            nbt.method_10551("BlightTypes");
            return;
        }
        class_2487 nbt = stack.method_7948();
        nbt.method_10551("BlightTypes");
        class_2499 nbtList = new class_2499();
        for (BlightType type : types) {
            class_2519 entry = class_2519.method_23256((String)type.method_15434());
            nbtList.add((Object)entry);
        }
        nbt.method_10566("BlightTypes", (class_2520)nbtList);
    }

    public static EnumSet<BlightType> fromStack(class_1799 stack) {
        EnumSet<BlightType> result = EnumSet.noneOf(BlightType.class);
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return result;
        }
        class_2499 nbtList = nbt.method_10554("BlightTypes", 8);
        for (int i = 0; i < nbtList.size(); ++i) {
            String entry = nbtList.method_10608(i);
            BlightType type = BlightType.fromStringOrNull(entry);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean hasNoStackBlight(class_1799 stack) {
        return stack.method_7969() == null || !stack.method_7969().method_10545("BlightTypes");
    }

    public String method_15434() {
        return this.name().toLowerCase();
    }

    public static BlightType fromString(String name) {
        BlightType result = BlightType.fromStringOrNull(name);
        if (result == null) {
            throw new NoSuchElementException("Unknown BlightType: " + name);
        }
        return result;
    }

    public static BlightType fromStringOrNull(String name) {
        return BY_NAME.get(name);
    }

    public static EnumSet<BlightType> typesToEnumSet(BlightType ... types) {
        if (types.length == 0) {
            return EnumSet.noneOf(BlightType.class);
        }
        EnumSet<BlightType> result = EnumSet.of(types[0]);
        result.addAll(Arrays.asList(types).subList(1, types.length));
        return result;
    }

    public static List<BlightType> asOrderedList(Set<BlightType> types) {
        ArrayList<BlightType> result = new ArrayList<BlightType>();
        for (BlightType type : CACHED_VALUES) {
            if (!types.contains((Object)type)) continue;
            result.add(type);
        }
        return result;
    }

    static {
        CODEC = class_3542.method_28140(BlightType::values);
        CACHED_VALUES = BlightType.values();
        BY_NAME = Arrays.stream(CACHED_VALUES).collect(Collectors.toMap(BlightType::method_15434, Function.identity()));
    }

    public static class ArgumentType
    extends class_7485<BlightType> {
        private ArgumentType() {
            super(CODEC, BlightType::values);
        }

        public static ArgumentType blightType() {
            return new ArgumentType();
        }

        public static BlightType getBlockRotation(CommandContext<class_2168> context, String id) {
            return (BlightType)((Object)context.getArgument(id, BlightType.class));
        }
    }
}

