/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.compat.satin.shaders;

import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.shirojr.nemuelch.NeMuelch;
import net.shirojr.nemuelch.NeMuelchClient;
import net.shirojr.nemuelch.compat.iris.IrisCompat;
import net.shirojr.nemuelch.compat.satin.util.ShaderHolder;

public class FadeShaderManager
implements ShaderHolder {
    public static final float THRESHOLD = 0.001f;
    private static FadeShaderManager instance = null;
    private final class_2960 identifier;
    private final ManagedShaderEffect fadeShader;
    private static float currentFade = 0.0f;
    private static float startFade = 0.0f;
    private static float targetFade = 0.0f;
    private static int duration = 0;
    private static int frame = 0;
    private static float tickDelta;

    private FadeShaderManager(class_2960 identifier) {
        this.identifier = identifier;
        NeMuelch.LOGGER.info("Creating FadeShaderManager with identifier: {}", (Object)identifier);
        try {
            this.fadeShader = ShaderEffectManager.getInstance().manage(identifier);
            NeMuelch.LOGGER.info("Successfully created ManagedShaderEffect: {}", (Object)(this.fadeShader != null ? 1 : 0));
            if (this.fadeShader != null) {
                NeMuelch.LOGGER.info("Shader effect class: {}", (Object)this.fadeShader.getClass().getName());
            }
        }
        catch (Exception e) {
            NeMuelch.LOGGER.error("Failed to create shader effect", (Throwable)e);
            throw e;
        }
    }

    public static FadeShaderManager getInstance(class_2960 identifier) {
        if (instance == null) {
            instance = new FadeShaderManager(identifier);
        }
        return instance;
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public void fadeToBlack(int duration) {
        if (targetFade == 1.0f) {
            return;
        }
        startFade = currentFade;
        targetFade = 1.0f;
        frame = 0;
        FadeShaderManager.duration = duration;
        NeMuelch.LOGGER.info("started fading to black [duration: {}]", (Object)duration);
    }

    public void fadeFromBlack(int duration) {
        if (targetFade == 0.0f) {
            return;
        }
        startFade = currentFade;
        targetFade = 0.0f;
        frame = 0;
        FadeShaderManager.duration = duration;
        NeMuelch.LOGGER.info("started fading from black back to normal [duration: {}]", (Object)duration);
    }

    public void setFadeInstant(float normalizedFade) {
        targetFade = class_3532.method_15363((float)normalizedFade, (float)0.0f, (float)1.0f);
        FadeShaderManager.finishFade();
    }

    public void setStaticFadeAmount(float fade) {
        targetFade = fade;
        currentFade = fade;
        frame = 0;
        duration = 0;
    }

    public static float getCurrentFade() {
        return currentFade;
    }

    public static boolean isFadeRendered() {
        return currentFade > 0.001f;
    }

    public boolean isFadeTransitionActive() {
        return Math.abs(currentFade - targetFade) > 0.001f;
    }

    public boolean isIncreasingFade() {
        if (!this.isFadeTransitionActive()) {
            return false;
        }
        return currentFade < targetFade;
    }

    public boolean isDecreasingFade() {
        if (!this.isFadeTransitionActive()) {
            return false;
        }
        return currentFade > targetFade;
    }

    @Override
    public void render() {
        if (this.fadeShader == null || !FadeShaderManager.isFadeRendered()) {
            return;
        }
        this.fadeShader.findUniform1f("FadeAmount").set(currentFade);
        class_243 pos = class_310.method_1551().field_1773.method_19418().method_19326();
        this.fadeShader.findUniform3f("CameraPos").set(pos.method_46409());
        this.fadeShader.render(tickDelta);
    }

    @Override
    public ManagedShaderEffect getShader() {
        return this.fadeShader;
    }

    @Override
    public void update(float tickDelta) {
        ShaderHolder.super.update(tickDelta);
        if (!this.isFadeTransitionActive() || duration == 0) {
            if (frame != 0) {
                FadeShaderManager.finishFade();
            }
            return;
        }
        FadeShaderManager.tickDelta = tickDelta;
        NeMuelch.LOGGER.info("Updated Fade Shader - Current Fade: {}", (Object)Float.valueOf(currentFade));
        ++frame;
        if (Math.abs(currentFade - targetFade) <= 0.001f) {
            FadeShaderManager.finishFade();
            return;
        }
        float progress = class_3532.method_15363((float)((float)frame / (float)duration), (float)0.0f, (float)1.0f);
        currentFade = class_3532.method_16439((float)progress, (float)startFade, (float)targetFade);
        if (frame >= duration) {
            FadeShaderManager.finishFade();
        }
    }

    public static void finishFade() {
        currentFade = targetFade;
        frame = 0;
        duration = 0;
        tickDelta = 0.0f;
        if (NeMuelchClient.isIrisModLoaded()) {
            if (FadeShaderManager.isFadeRendered()) {
                IrisCompat.disableShaders();
            } else {
                IrisCompat.resetOriginalShaderState();
            }
        }
    }

    public static void clearFade() {
        currentFade = 0.0f;
        startFade = 0.0f;
        targetFade = 0.0f;
        frame = 0;
        duration = 0;
        tickDelta = 0.0f;
    }
}

