/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.nemuelch.datagen;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.shirojr.nemuelch.block.util.VariationHolder;
import net.shirojr.nemuelch.init.NeMuelchBlocks;
import net.shirojr.nemuelch.init.NeMuelchEnchantments;
import net.shirojr.nemuelch.init.NeMuelchEntities;
import net.shirojr.nemuelch.init.NeMuelchItems;
import net.shirojr.nemuelch.init.NeMuelchSounds;
import org.jetbrains.annotations.Nullable;

public class NemuelchTranslationGenerator
extends FabricLanguageProvider {
    public NemuelchTranslationGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        builder.add(NeMuelchEntities.POT_LAUNCHER, NemuelchTranslationGenerator.cleanString(class_7923.field_41177.method_10221(NeMuelchEntities.POT_LAUNCHER), false));
        builder.add(NeMuelchEntities.DROP_POT, NemuelchTranslationGenerator.cleanString(class_7923.field_41177.method_10221(NeMuelchEntities.DROP_POT), false));
        builder.add(NeMuelchEntities.SLIME_ITEM, "Slime");
        builder.add(NeMuelchEntities.ARKADUSCANE_PROJECTILE, NemuelchTranslationGenerator.cleanString(class_7923.field_41177.method_10221(NeMuelchEntities.ARKADUSCANE_PROJECTILE), false));
        builder.add((class_1792)NeMuelchItems.POT_LAUNCHER, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.POT_LAUNCHER), false));
        builder.add(NeMuelchItems.POT_LAUNCHER_LEGS, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.POT_LAUNCHER_LEGS), false));
        builder.add(NeMuelchItems.POT_LAUNCHER_DEEPSLATE_BASKET, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.POT_LAUNCHER_DEEPSLATE_BASKET), false));
        builder.add(NeMuelchItems.POT_LAUNCHER_LOADER, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.POT_LAUNCHER_LOADER), false));
        builder.add((class_1792)NeMuelchItems.BOOK_WRAPPER, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.BOOK_WRAPPER), false));
        builder.add(NeMuelchItems.LARD, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.LARD), false));
        builder.add((class_1792)NeMuelchItems.SOAP, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.SOAP), false));
        builder.add((class_1792)NeMuelchItems.CREATIVE_SOAP, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.CREATIVE_SOAP), false));
        builder.add((class_1792)NeMuelchItems.SOUND_TOOL, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.SOUND_TOOL), false));
        builder.add((class_1792)NeMuelchItems.MEAT_LUMP, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.MEAT_LUMP), false));
        builder.add((class_1792)NeMuelchItems.COOKED_MEAT_LUMP, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.COOKED_MEAT_LUMP), false));
        builder.add((class_1792)NeMuelchItems.ROTTEN_MEAT_LUMP, NemuelchTranslationGenerator.cleanString(class_7923.field_41178.method_10221((Object)NeMuelchItems.ROTTEN_MEAT_LUMP), false));
        builder.add(NeMuelchEnchantments.CURSE_OF_THE_BARE, NemuelchTranslationGenerator.cleanString(class_7923.field_41176.method_10221((Object)NeMuelchEnchantments.CURSE_OF_THE_BARE), false));
        builder.add((class_2248)NeMuelchBlocks.ROTTEN_MEAT, NemuelchTranslationGenerator.cleanString(class_7923.field_41175.method_10221((Object)NeMuelchBlocks.ROTTEN_MEAT), false));
        builder.add((class_2248)NeMuelchBlocks.ROTTEN_TREE_LOG, NemuelchTranslationGenerator.cleanString(class_7923.field_41175.method_10221((Object)NeMuelchBlocks.ROTTEN_TREE_LOG), false));
        builder.add((class_2248)NeMuelchBlocks.ROTTEN_TREE_SAPLING, NemuelchTranslationGenerator.cleanString(class_7923.field_41175.method_10221((Object)NeMuelchBlocks.ROTTEN_TREE_SAPLING), false));
        builder.add("sound." + NeMuelchSounds.SQUIRT.method_14833().method_42094(), "Something Squirted");
        builder.add("sound." + NeMuelchSounds.EATING_CRUNCHY.method_14833().method_42094(), "Crunchy Eating");
        builder.add("sound." + NeMuelchSounds.EATING_DIGESTION.method_14833().method_42094(), "Digestion Growled");
        builder.add("sound." + NeMuelchSounds.HUMAN_GROWL.method_14833().method_42094(), "Growl");
        builder.add("sound." + NeMuelchSounds.HIT_DEITY.method_14833().method_42094(), "Hit by something which does not exist");
        builder.add("sound." + NeMuelchSounds.ANCIENT_CREATURE_CALL_1.method_14833().method_42094(), "Something ancient called");
        for (VariationHolder variationHolder : NeMuelchBlocks.VARIATION_BLOCKS) {
            class_2960 identifier = class_7923.field_41175.method_10221((Object)variationHolder.getBlock());
            builder.add(variationHolder.getBlock(), NemuelchTranslationGenerator.cleanString(identifier, false));
        }
        try {
            Path existingFilePath = (Path)this.dataOutput.getModContainer().findPath("assets/%s/lang/en_us.existing.json".formatted("nemuelch")).orElseThrow();
            builder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public static String cleanString(@Nullable class_2960 identifier, boolean reverse) {
        if (identifier == null) {
            throw new NullPointerException("Not a valid Identifier for clean String Translation");
        }
        List<String> input = List.of(identifier.method_12832().split("/"));
        List<String> words = Arrays.asList(input.get(input.size() - 1).split("_"));
        return NemuelchTranslationGenerator.cleanMergedString(words, reverse);
    }

    public static String cleanMergedString(List<String> input, boolean reverse) {
        ArrayList<String> words = new ArrayList<String>(input);
        if (reverse) {
            Collections.reverse(words);
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            char capitalized = Character.toUpperCase(word.charAt(0));
            output.append(capitalized).append(word.substring(1));
            if (i >= words.size() - 1) continue;
            output.append(" ");
        }
        return output.toString();
    }
}

